/*************************************************************************
 *
 *  $RCSfile: preview.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: thb $ $Date: 2001/11/27 15:18:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_CLICKACTION_HPP_
#include <com/sun/star/presentation/ClickAction.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONSPEED_HPP_
#include <com/sun/star/presentation/AnimationSpeed.hpp>
#endif

#include <svx/svxids.hrc>           // SID_PRESENTATION
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#include "preview.hxx"
#include "frmview.hxx"
#include "prevchld.hxx"
#include "preview.hrc"
#include "app.hrc"
#include "sdattr.hxx"
#include "sdresid.hxx"
#include "drawview.hxx"
#include "drviewsh.hxx"
#include "drawdoc.hxx"
#include "fuslshow.hxx"
#include "sdpage.hxx"
#include "anminfo.hxx"
#include "anmdef.hxx"
#include "grdocsh.hxx"

using namespace ::com::sun::star;

SFX_IMPL_DOCKINGWINDOW( SdPreviewChildWindow, SID_PREVIEW_WIN)

#define OFFSET 4

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Preview
|*
\************************************************************************/

SdPreviewChildWindow::SdPreviewChildWindow( Window* pParent,
													 USHORT nId,
													 SfxBindings* pBindings,
													 SfxChildWinInfo* pInfo ) :
	SfxChildWindow( pParent, nId )
{
	SdPreviewWin* pPreviewWin = new SdPreviewWin( pBindings, this, pParent,
										SdResId( FLT_WIN_PREVIEW ) );
	pWindow = pPreviewWin;

	eChildAlignment = SFX_ALIGN_NOALIGNMENT;

    pPreviewWin->Initialize( pInfo );
}

/*************************************************************************
|*
|* ControllerItem fuer Preview
|*
\************************************************************************/

SdPreviewCtrlItem::SdPreviewCtrlItem( USHORT nId,
								SdPreviewWin* 	pPrevWin,
								SfxBindings*	pBindings) :
	SfxControllerItem	( nId, *pBindings ),
	pPreviewWin			( pPrevWin )
{
	pForwarder1 = new SfxStatusForwarder( SID_PREVIEW_QUALITY_COLOR, *this );
	pForwarder2 = new SfxStatusForwarder( SID_PREVIEW_QUALITY_GRAYSCALE, *this );
	pForwarder3 = new SfxStatusForwarder( SID_PREVIEW_QUALITY_BLACKWHITE, *this );
}

SdPreviewCtrlItem::~SdPreviewCtrlItem()
{
	delete pForwarder1;
	delete pForwarder2;
	delete pForwarder3;
}

// -----------------------------------------------------------------------
//
// Hier koennen Stati der Applikation ausgewertet werden
//
// -----------------------------------------------------------------------

void SdPreviewCtrlItem::StateChanged( USHORT nSId,
						SfxItemState eState, const SfxPoolItem* pItem )
{
	if( eState < SFX_ITEM_AVAILABLE )
		return;

	ULONG nNewMode = pPreviewWin->pShowWindow->GetDrawMode();

	switch(nSId)
	{
		case SID_PREVIEW_STATE:
		{
			const SfxUInt16Item* pStateItem = PTR_CAST( SfxUInt16Item, pItem );
			DBG_ASSERT( pStateItem, "SfxUInt16Item erwartet");
			UINT16 nState = pStateItem->GetValue();

			//pPreviewWin->DoSomething();
			break;
		}
		case SID_PREVIEW_QUALITY_COLOR:
		{
			const SfxBoolItem* pBoolItem = PTR_CAST( SfxBoolItem, pItem );
			DBG_ASSERT( pBoolItem, "SfxBoolItem erwartet!");

			if(pBoolItem && pBoolItem->GetValue())
				nNewMode = PREVIEW_DRAWMODE_COLOR;
			break;
		}
		case SID_PREVIEW_QUALITY_GRAYSCALE:
		{
			const SfxBoolItem* pBoolItem = PTR_CAST( SfxBoolItem, pItem );
			DBG_ASSERT( pBoolItem, "SfxBoolItem erwartet!");

			if(pBoolItem && pBoolItem->GetValue())
				nNewMode = PREVIEW_DRAWMODE_GRAYSCALE;
			break;
		}
		case SID_PREVIEW_QUALITY_BLACKWHITE:
		{
			const SfxBoolItem* pBoolItem = PTR_CAST( SfxBoolItem, pItem );
			DBG_ASSERT( pBoolItem, "SfxBoolItem erwartet!");

			if(pBoolItem && pBoolItem->GetValue())
				nNewMode = PREVIEW_DRAWMODE_BLACKWHITE;
			break;
		}
	};

	if( nNewMode != pPreviewWin->pShowWindow->GetDrawMode() )
	{
		pPreviewWin->pShowWindow->SetDrawMode(nNewMode);
		pPreviewWin->pShowWindow->Invalidate();
	}
}





/*************************************************************************
|*
|*  SdPreviewWin - FloatingWindow
|*
\************************************************************************/


/*************************************************************************
|* ctor
\************************************************************************/

SdPreviewWin::SdPreviewWin( SfxBindings* pInBindings,
				SfxChildWindow *pCW, Window* pParent, const SdResId& rSdResId ) :
		SfxDockingWindow    ( pInBindings, pCW, pParent, rSdResId ),
		pBindings			( pInBindings ),
		pDoc				( NULL ),
		pView               ( NULL ),
		pFuSlideShow        (NULL),
		pShowWindow         (NULL),
		nMagic(SDPREVIEWWIN_MAGIC)
{
	FreeResource();
	bInAnimation = FALSE;

	pControllerItem = new SdPreviewCtrlItem( SID_PREVIEW_STATE, this, pBindings );
	pShowWindow     = new SdShowWindow(this, this);

	SdViewShell*    pViewShell =  (SdViewShell*) pBindings->GetDispatcher()->GetFrame()->GetViewShell();
	FrameView*		pFrameView = pViewShell->GetFrameView();
	SdDrawDocument* pTheDoc    = pViewShell->GetDoc();
	SdPage*         pPage      = pViewShell->GetActualPage();
	USHORT          nPage      = pPage->GetPageNum();
	PageKind        ePageKind  = pPage->GetPageKind();
	pViewShell->WriteFrameViewData();

	if (pViewShell->ISA(SdDrawViewShell) &&
	   ((SdDrawViewShell*) pViewShell)->GetEditMode() == EM_MASTERPAGE)
	{
		// MasterPages sollen in der Preview nicht dargestellt werden
		for (USHORT i = 0; i < pTheDoc->GetSdPageCount(ePageKind); i++)
		{
			// Selektierte Seite suchen
			pPage = pTheDoc->GetSdPage(i, ePageKind);
			if (pPage->IsSelected())
			{
				nPage = pPage->GetPageNum();
				break;
			}
		}
	}

	nPage = (nPage - 1) / 2; // Sdr --> Sd

	SetContext(pTheDoc, nPage, pFrameView);
	pBindings->Invalidate(SID_PREVIEW_WIN);
}

/*************************************************************************
|* dtor
\************************************************************************/

SdPreviewWin::~SdPreviewWin()
{
	if ( pFuSlideShow )
		pFuSlideShow->Terminate();

	nMagic = 0L;
	delete pControllerItem;

	if( pFuSlideShow )
		pFuSlideShow->Destroy();

	delete pShowWindow;
	delete pView;
}

/*************************************************************************
|* StateChanged takes care of setting correct position
\************************************************************************/

void SdPreviewWin::StateChanged( StateChangedType nType )
{
    if ( nType == STATE_CHANGE_INITSHOW )
    {
        // calculate initial position
        SfxViewShell*   pViewShell = pBindings->GetDispatcher()->GetFrame()->GetViewShell();
        Window*         pWin = pViewShell ? pViewShell->GetWindow() : NULL;
        
        if( pWin )
        {
            Rectangle   aRect( ScreenToOutputPixel( pWin->OutputToScreenPixel( pWin->GetPosPixel() ) ), pWin->GetSizePixel() );
            Point       aPoint( aRect.TopLeft() );
            
            aPoint.X() += aRect.GetSize().Width() - GetSizePixel().Width() - 
                ( pWin->GetSettings().GetStyleSettings().GetScrollBarSize() << 1 );
            
            SetFloatingPos( aPoint );
        }
    }

    SfxDockingWindow::StateChanged( nType );
}

/*************************************************************************
|* SetContext, dem Preview-Window das aktuelle Dokument, die aktuelle Seite
|* und den View-Status bekanntgeben
\************************************************************************/

void SdPreviewWin::SetContext(SdDrawDocument* pDrawDoc, USHORT nSdPage,
							  FrameView* pFrm)
{
	// die alte Show erst loeschen, wenn die neue schon erzeugt wurde;
	// dadurch ist sichergestellt, dass die Magic Number der zerstoerten
	// Show nicht durch das Ueberschreiben mit der neuen Show wieder
	// gueltig wird
	FuSlideShow*	pOldShow = pFuSlideShow;
	SdDrawView*		pOldView = pView;

	pDoc = pDrawDoc;        // als Member merken

	// pDoc == NULL waehrend des Kontextwechsels
	if (pDoc)
	{
		SdPage* pPage = pDoc->GetSdPage(nSdPage, PK_STANDARD);

		SdDrawDocShell* pDocShell = pDoc->GetDocSh();
		pView = new SdDrawView(pDocShell, pShowWindow, NULL);

		SfxAllItemSet aSet(pDrawDoc->GetItemPool());
		{
		SfxBoolItem aItem(ATTR_PRESENT_ALL, FALSE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxStringItem aItem(ATTR_PRESENT_DIANAME, pPage->GetName());
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_ENDLESS, FALSE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_MANUEL, TRUE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_MOUSE, TRUE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_PEN, FALSE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_NAVIGATOR, FALSE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_CHANGE_PAGE, TRUE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_ALWAYS_ON_TOP, FALSE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_FULLSCREEN, FALSE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_ANIMATION_ALLOWED, TRUE);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxUInt32Item aItem(ATTR_PRESENT_PAUSE_TIMEOUT, 0);
		aSet.Put(aItem, aItem.Which());
		}
		{
		SfxBoolItem aItem(ATTR_PRESENT_SHOW_PAUSELOGO, FALSE);
		aSet.Put(aItem, aItem.Which());
		}

		SfxRequest aReq(SID_PRESENTATION, 0, aSet);

		pFuSlideShow = new FuSlideShow(NULL, NULL, pView, pDoc, aReq);
	}
	else
	{
		pFuSlideShow = NULL;
		pView = NULL;
	}

	if( pOldShow )
	{
		if( pOldShow->IsInputLocked() )
			pOldShow->Terminate();

		pOldShow->Destroy();
	}

	delete pOldView;

	if (pDoc)
	{
		pFuSlideShow->SetAnimationMode(ANIMATIONMODE_PREVIEW, pShowWindow);
		pFuSlideShow->StartShow();
	}

	pShowWindow->Invalidate();
	pShowWindow->Update();
}

/*************************************************************************
|* Resize, die Groesse hat sich geaendert
\************************************************************************/

void SdPreviewWin::Resize()
{
	Size aWinSize( GetOutputSizePixel() ); // vorher rSize im Resizing()

	if ( !IsFloatingMode() ||
		 !GetFloatingWindow()->IsRollUp() )
	{
		aWinSize.Width()  -= 2 * OFFSET;
		aWinSize.Height() -= 2 * OFFSET;
		pShowWindow->SetPosPixel(Point(OFFSET, OFFSET));
	}

	SfxDockingWindow::Resize();

	if (!bInAnimation)
	{
		if (pFuSlideShow)
			pFuSlideShow->Resize(aWinSize);
	}
	else
	{
		// waehrend ein Effekt laeuft, kann man die Show nicht resizen,
		// deshalb: die alte Show zerstoeren und durch eine neue
		// ersetzen
		SdViewShell* 	pViewShell = (SdViewShell*) pBindings->GetDispatcher()->GetFrame()->GetViewShell();
		FrameView*      pFrameView = pViewShell->GetFrameView();
		SdDrawDocument* pTheDoc    = pViewShell->GetDoc();
		SdPage*         pPage      = pViewShell->GetActualPage();
		USHORT          nPage      = (pPage->GetPageNum() - 1) / 2; // Sdr --> Sd

		SetContext(pTheDoc, nPage, pFrameView);
		pFuSlideShow->Resize(aWinSize);
	}
}

/*************************************************************************
|* Close
\************************************************************************/

BOOL SdPreviewWin::Close()
{
	SfxBoolItem aItem( SID_PREVIEW_WIN, FALSE );

	pBindings->GetDispatcher()->Execute( 
		SID_PREVIEW_WIN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );

	SfxDockingWindow::Close();

	return( TRUE );
}

/*************************************************************************
|* Paint
\************************************************************************/

void SdPreviewWin::PaintContents(const Rectangle& rRect)
{
	if( pDoc && pView->IsPresPaintAllowed() )
	{
		if( pShowWindow->GetDrawMode() & DRAWMODE_WHITEFILL )
		{
			const ULONG		nOldDrawMode = pShowWindow->GetDrawMode();
			const Wallpaper	aBack( pShowWindow->GetBackground() );

			pShowWindow->SetDrawMode( DRAWMODE_DEFAULT );
			pShowWindow->SetBackground( Color( COL_BLACK ) );
			pShowWindow->Erase( rRect );
			pShowWindow->SetBackground( aBack );
			pShowWindow->SetDrawMode( nOldDrawMode );
		}

		pView->InitRedraw(pShowWindow, Region(rRect));
	}
}

/*************************************************************************
|* KeyInputFromContents
\************************************************************************/

void SdPreviewWin::KeyInputFromContents(const KeyEvent& rKEvt)
{
}

/*************************************************************************
|* MouseMoveFromContents
\************************************************************************/

void SdPreviewWin::MouseMoveFromContents(const MouseEvent& rMEvt)
{
	if (pFuSlideShow && !bInAnimation &&
		pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS &&
		!pDoc->GetDocSh()->ISA(SdGraphicDocShell))
	{
		Pointer aPtr(POINTER_ARROW);
		Point	aPos = pShowWindow->PixelToLogic(rMEvt.GetPosPixel());

		// Objekt mit Effekt?
		SdrObject* pObject = pFuSlideShow->OverObject(aPos);

		if (pObject)
		{
			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);

			if (pInfo)
			{
				if ((pInfo->bActive &&
					 ( pInfo->eEffect != presentation::AnimationEffect_NONE ||
					   pInfo->eTextEffect != presentation::AnimationEffect_NONE)) ||
					(pInfo->eClickAction == presentation::ClickAction_VANISH ||
					 pInfo->eClickAction == presentation::ClickAction_INVISIBLE))
				{
					aPtr = Pointer(POINTER_REFHAND);
				}
			}
		}

		if (pShowWindow->GetPointer() != aPtr)
		{
			pShowWindow->SetPointer(aPtr);
		}
	}
}

/*************************************************************************
|* MouseButtonUpFromContents
\************************************************************************/

void SdPreviewWin::MouseButtonUpFromContents(const MouseEvent& rMEvt)
{
	// Position umrechnen vom ShowWindow auf Seitenkoordinaten
	Point aPos = pShowWindow->PixelToLogic(rMEvt.GetPosPixel());

	if (pFuSlideShow && !bInAnimation && aPos == aDownPos &&
		pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS &&
		!pDoc->GetDocSh()->ISA(SdGraphicDocShell))
	{
		SdrObject* pObject = pFuSlideShow->OverObject(aPos);

		if (rMEvt.IsLeft() && pObject)
		{
			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);
			if (pInfo)
			{
				if ((pInfo->bActive &&
					 ( pInfo->eEffect != presentation::AnimationEffect_NONE ||
					   pInfo->eTextEffect != presentation::AnimationEffect_NONE )) ||
					(pInfo->eClickAction == presentation::ClickAction_VANISH ||
					 pInfo->eClickAction == presentation::ClickAction_INVISIBLE))
				{
					HideAndAnimateObject(pObject);
				}
				else
				{
					AnimatePage();
				}
			}
			else
			{
				AnimatePage();
			}
		}
		else
		{
			AnimatePage();
		}
	}
}

/*************************************************************************
|* MouseButtonDownFromContents
\************************************************************************/

void SdPreviewWin::MouseButtonDownFromContents(const MouseEvent& rMEvt)
{
	// Position umrechnen vom ShowWindow auf Seitenkoordinaten und merken
	aDownPos = pShowWindow->PixelToLogic(rMEvt.GetPosPixel());
}

/*************************************************************************
|* HideAndAnimateObject, eine Objektanimation zeigen
\************************************************************************/

void SdPreviewWin::HideAndAnimateObject(SdrObject* pObject)
{
	if (pFuSlideShow && !bInAnimation &&
		pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS &&
		!pDoc->GetDocSh()->ISA(SdGraphicDocShell))
	{
		bInAnimation = TRUE;
		pView->SetAnimationEnabled(FALSE);

		pFuSlideShow->HideAndAnimateObject(pObject);

		// im Reschedule des Effekts zerstoert?
		if (nMagic != SDPREVIEWWIN_MAGIC)
		{
			return;
		}

		pView->SetAnimationEnabled(TRUE);
		bInAnimation = FALSE;
	}
}

/*************************************************************************
|* AnimatePage, die Seitenanimation zeigen
\************************************************************************/

void SdPreviewWin::AnimatePage()
{
	if (pFuSlideShow && !bInAnimation &&
		pDoc && pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS &&
		!pDoc->GetDocSh()->ISA(SdGraphicDocShell))
	{
		bInAnimation = TRUE;
		pView->SetAnimationEnabled(FALSE);

		pFuSlideShow->AnimatePage();

		// im Reschedule des Effekts zerstoert?
		if (nMagic != SDPREVIEWWIN_MAGIC)
		{
			return;
		}

		pView->SetAnimationEnabled(TRUE);
		bInAnimation = FALSE;
	}
}


