/*************************************************************************
 *
 *  $RCSfile: fuslshow.cxx,v $
 *
 *  $Revision: 1.26.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/06/01 03:12:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _SV_HELP_HXX //autogen
#include <vcl/help.hxx>
#endif
#include "drawview.hxx"
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _IPENV_HXX //autogen
#include <so3/ipenv.hxx>
#endif
#ifndef _IPCLIENT_HXX //autogen
#include <so3/ipclient.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <svx/svdoole2.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <sfx2/docfile.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFX_CLIENTSH_HXX //autogen
#include <sfx2/clientsh.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFX_TEMPLDLG_HXX
#include <sfx2/templdlg.hxx>
#endif
#ifndef _SVDITER_HXX //autogen
#include <svx/svditer.hxx>
#endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _SVX_FMSHELL_HXX
#include <svx/fmshell.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _GOODIES_IMAPOBJ_HXX //autogen
#include <svtools/imapobj.hxx>
#endif
#ifndef _SVX_TAB_HYPERLINK_HX
#include <svx/hyperdlg.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_SAVEOPT_HXX
#include <svtools/saveopt.hxx>
#endif

#include <limits.h> 					// LONG_MAX

#define FUSLIDESHOW_INTERN
#include "fuslshow.hxx"
#include <svx/svxids.hrc>
#include <svx/dialogs.hrc>              // fuer SID_REHEARSE_TIMINGS
#include <svx/gallery.hxx>
#include <svx/f3dchild.hxx>
#include <svx/imapdlg.hxx>
#include <svx/fontwork.hxx>
#include <svx/colrctrl.hxx>
#include <svx/bmpmask.hxx>
#include <svx/srchdlg.hxx>
#include <svx/xoutx.hxx>
#include <offmgr/hyprlink.hxx>
#include <offmgr/ofaids.hrc>
#include <offmgr/sba.hrc>
#include "sdattr.hxx"
#include "app.hrc"
#include "sdresid.hxx"
#include "anminfo.hxx"
#include "res_bmp.hrc"
#include "sdwindow.hxx"
#include "showview.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "sdpage.hxx"
#include "frmview.hxx"
#include "viewshel.hxx"
#include "pres.hxx"
#include "mover.hxx"
#include "fader.hxx"
#include "sdview.hxx"
#include "drviewsh.hxx"
#include "presvish.hxx"
#include "glob.hrc"
#include "pgjump.hxx"
#include "frmview.hxx"
#include "outlinfo.hxx"
#include "preview.hxx"
#include "effect.hxx"
#include "cusshow.hxx"
#include "navichld.hxx"
#include "prevchld.hxx"
#include "efctchld.hxx"
#include "slidchld.hxx"
#include "animobjs.hxx"
#include "optsitem.hxx"

using namespace ::com::sun::star;

// -----------
// - Defines -
// -----------

#define NAVIGATOR_CHILD_MASK        0x80000000UL
#define ITEMVALUE(ItemSet,Id,Cast)  ((const Cast&)(ItemSet).Get(Id)).GetValue()

// --------------------------
// - ChildWindow-Verwaltung	-
// --------------------------

typedef USHORT (*FncGetChildWindowId)();

FncGetChildWindowId aShowChilds[] =
{
	&SdAnimationChildWindow::GetChildWindowId,
	&SdPreviewChildWindow::GetChildWindowId,
	&SdEffectChildWindow::GetChildWindowId,
	&SdSlideChangeChildWindow::GetChildWindowId,
	&Svx3DChildWindow::GetChildWindowId,
	&SvxFontWorkChildWindow::GetChildWindowId,
	&SvxColorChildWindow::GetChildWindowId,
	&SvxSearchDialogWrapper::GetChildWindowId,
	&SvxBmpMaskChildWindow::GetChildWindowId,
	&SvxIMapDlgChildWindow::GetChildWindowId,
	&SvxHyperlinkDlgWrapper::GetChildWindowId,
	&SvxHlinkDlgWrapper::GetChildWindowId,
	&SfxTemplateDialogWrapper::GetChildWindowId
};

// ---------
// - Slots -
// ---------

TYPEINIT1( FuSlideShow, FuPoor );

// Slots, welche im Sfx verwaltet werden und in der SlideShow disabled
// werden sollen (muss in Reihenfolge der SIDs geordnet sein)
static USHORT __READONLY_DATA pAllowed[] =
{
    SID_OPENDOC								, //	 5501	// damit interne Spruenge klappen
	SID_JUMPTOMARK							, //	 5598
 	SID_SHOWPOPUPS							, //	 5929
    SID_NAVIGATOR							, //	10366
	SID_FM_DESIGN_MODE						, //	10629
	SID_LIVE_PRESENTATION					, //	27033
	SID_NAVIGATOR_PAGENAME					, //	27287
	SID_NAVIGATOR_STATE 					, //	27288
	SID_NAVIGATOR_INIT						, //	27289
	SID_NAVIGATOR_LIVE						, //	27290
	SID_NAVIGATOR_PEN						, //	27291
	SID_NAVIGATOR_PAGE						, //	27292
	SID_NAVIGATOR_OBJECT					  //	27293
};

static USHORT __READONLY_DATA pAllowedLive[] =
{
//  SID_QUITAPP								, //	 5300
//  SID_SETUPPRINTER						, //	 5302
//  SID_SAVEDOCS							, //	 5309
//  SID_MAIL_SENDDOC						, //	 5331
//  SID_MAIL_INBOX							, //	 5332
//  SID_NEWDOC								, //	 5500
    SID_OPENDOC								, //	 5501	// damit interne Spruenge klappen
//  SID_SAVEASDOC							, //	 5502
//  SID_CLOSEDOC							, //	 5503
//  SID_PRINTDOC							, //	 5504
//  SID_SAVEDOC								, //	 5505
//  SID_RELOAD								, //	 5508
//  SID_PICK1								, //	 5511
//  SID_PICK2								, //	 5512
//  SID_PICK3								, //	 5513
//  SID_PICK4								, //	 5514
//  SID_PICK5								, //	 5515
//  SID_PICK6								, //	 5516
//  SID_PICK7								, //	 5517
//  SID_PICK8								, //	 5518
//  SID_PICK9								, //	 5519
//  SID_DOCMANAGER							, //	 5533
//  SID_DOCINFO								, //	 5535
//  SID_NEWDOCDIRECT						, //	 5537
//  SID_DOCTEMPLATE							, //	 5538
//  SID_STYLE_DESIGNER						, //	 5539
 	SID_STYLE_FAMILY1						, //	 5541
	SID_STYLE_FAMILY2						, //	 5542
 	SID_STYLE_FAMILY3						, //	 5543
	SID_STYLE_FAMILY4						, //	 5544
 	SID_STYLE_FAMILY5						, //	 5545
	SID_STYLE_NEW							, //	 5549
 	SID_STYLE_EDIT							, //	 5550
	SID_STYLE_DELETE						, //	 5551
 	SID_STYLE_APPLY							, //	 5552
	SID_STYLE_FAMILY						, //	 5553
 	SID_STYLE_WATERCAN						, //	 5554
	SID_STYLE_NEW_BY_EXAMPLE				, //	 5555
 	SID_STYLE_UPDATE_BY_EXAMPLE				, //	 5556
//  SID_INSERT_OBJECT						, //	 5561
	SID_STYLE_MASK							, //	 5562
    SID_INSERT_FLOATINGFRAME				, //	 5563
 	SID_STYLE_NAME							, //	 5564
	SID_STYLE_DRAGHIERARCHIE				, //	 5565
 	SID_STYLE_DISABLEDRAGHIERARCHIE			, //	 5567
	SID_STYLE_DISABLENEW					, //	 5568
    SID_STYLE_CATALOG						, //	 5573
    SID_OBJECT								, //	 5575
	SID_JUMPTOMARK							, //	 5598
//  SID_CLOSEWIN							, //	 5621
//  SID_WIN_FULLSCREEN						, //	 5627
    SID_INSERT_PLUGIN						, //	 5672
    SID_INSERT_APPLET						, //	 5673
	SID_INSERT_SOUND                        , //     5676
	SID_INSERT_VIDEO                        , //     5677
    SID_REDO								, //	 5700
    SID_UNDO								, //	 5701
    SID_REPEAT								, //	 5702
    SID_CUT									, //	 5710
    SID_COPY								, //	 5711
    SID_PASTE								, //	 5712
    SID_DELETE								, //	 5713
    SID_SELECTALL							, //	 5723
    SID_CONFIG								, //	 5904
    SID_TOGGLEOBJECTBAR						, //	 5905
    SID_TOGGLETOOLBAR						, //	 5909
    SID_TOGGLEFUNCTIONBAR					, //	 5910
 	SID_TOGGLEOPTIONBAR						, //	 5911
    SID_TOGGLECOMMONTASKBAR					, //	 5928
 	SID_SHOWPOPUPS							, //	 5929
    SID_TASKBAR								, //	 5931
	SID_BASICCHOOSER						, //	 5959
//  SID_SEARCH_DLG							, //	 5961       // kein Seitenwechsel
//  SID_AUTOBROWSE							, //	 6304
//  SID_AUTOMAIL							, //	 6305
//  SID_PLUGINS_ACTIVE						, //	 6314
    SID_BROWSER								, //	 6318
//  SID_ATTR_ZOOM							, //	10000
	SID_ATTR_CHAR							, //	10006
    SID_ATTR_CHAR_FONT						, //	10007
    SID_ATTR_CHAR_POSTURE					, //	10008
    SID_ATTR_CHAR_WEIGHT					, //	10009
    SID_ATTR_CHAR_UNDERLINE					, //	10014
    SID_ATTR_CHAR_FONTHEIGHT				, //	10015
    SID_ATTR_CHAR_COLOR						, //	10017
    SID_ATTR_PARA_ADJUST_LEFT				, //	10028
    SID_ATTR_PARA_ADJUST_RIGHT				, //	10029
    SID_ATTR_PARA_ADJUST_CENTER				, //	10030
    SID_ATTR_PARA_ADJUST_BLOCK				, //	10031
    SID_ATTR_PARA_LINESPACE_10				, //	10034
    SID_ATTR_PARA_LINESPACE_15				, //	10035
    SID_ATTR_PARA_LINESPACE_20				, //	10036
    SID_ATTR_TRANSFORM						, //	10087
//	SID_ZOOM_TOOLBOX						, //	10096
	SID_DRAW_LINE							, //	10102
	SID_DRAW_XLINE							, //	10103
	SID_DRAW_RECT							, //	10104
	SID_DRAW_RECT_ROUND 					, //	10105
	SID_DRAW_RECT_MOREROUND 				, //	10106
	SID_DRAW_FULLRECT						, //	10107
	SID_DRAW_FULLRECT_ROUND 				, //	10108
	SID_DRAW_FULLRECT_MOREROUND 			, //	10109
	SID_DRAW_ELLIPSE						, //	10110
	SID_DRAW_FULLELLIPSE					, //	10111
	SID_DRAW_PIE							, //	10112
	SID_DRAW_FULLPIE						, //	10113
	SID_DRAW_ARC							, //	10114
	SID_DRAW_CIRCLECUT						, //	10115
	SID_DRAW_FULLCIRCLECUT					, //	10116
	SID_DRAW_POLYGON						, //	10117
	SID_DRAW_BEZIER_FILL					, //	10118
    SID_BEZIER_INSERT						, //	10119
    SID_BEZIER_DELETE						, //	10120
    SID_BEZIER_MOVE							, //	10121
    SID_BEZIER_CLOSE						, //	10122
    SID_BEZIER_SMOOTH						, //	10123
    SID_BEZIER_EDIT							, //	10126
    SID_BEZIER_CUTLINE						, //	10127
    SID_OBJECT_SELECT						, //	10128
	SID_OBJECT_ROTATE						, //	10129
    SID_OBJECT_ALIGN						, //	10130
    SID_OBJECT_ALIGN_LEFT					, //	10131
    SID_OBJECT_ALIGN_CENTER					, //	10132
    SID_OBJECT_ALIGN_RIGHT					, //	10133
    SID_OBJECT_ALIGN_UP						, //	10134
    SID_OBJECT_ALIGN_MIDDLE					, //	10135
    SID_OBJECT_ALIGN_DOWN					, //	10136
    SID_INSERT_DIAGRAM						, //	10140
    SID_ATTRIBUTES_AREA						, //	10142
    SID_ATTRIBUTES_LINE						, //	10143
    SID_CHOOSE_CONTROLS						, //	10144
    SID_INSERT_PUSHBUTTON                   , //    10146
    SID_INSERT_RADIOBUTTON                  , //    10147
    SID_INSERT_CHECKBOX                     , //    10148
    SID_OUTLINE_BULLET                      , //    10156
//  SID_PRESENTATION						, //	10157
//  SID_DIA									, //	10160
    SID_SHOW_BROWSER                        , //    10163
    SID_ATTR_FILL_STYLE                     , //    10164
	SID_ATTR_FILL_COLOR 					, //	10165
	SID_ATTR_FILL_GRADIENT					, //	10166
	SID_ATTR_FILL_HATCH 					, //	10167
	SID_ATTR_FILL_BITMAP					, //	10168
    SID_ATTR_LINE_STYLE						, //	10169
	SID_ATTR_LINE_DASH						, //	10170
    SID_ATTR_LINE_WIDTH						, //	10171
    SID_ATTR_LINE_COLOR						, //	10172
    SID_INSERT_FIXEDTEXT                    , //    10188
    SID_INSERT_GROUPBOX                     , //    10189
    SID_INSERT_EDIT                         , //    10190
    SID_INSERT_LISTBOX                      , //    10191
    SID_INSERT_COMBOBOX                     , //    10192
    SID_INSERT_SPINBUTTON                   , //    10193
    SID_INSERT_HSCROLLBAR                   , //    10194
    SID_INSERT_VSCROLLBAR                   , //    10195
    SID_INSERT_PREVIEW                      , //    10196
    SID_INSERT_URLBUTTON                    , //    10197
    SID_DIALOG_TESTMODE                     , //    10199
    SID_ATTR_TABLE                          , //    10217
    SID_INSERT_GRAPHIC						, //	10241
//  SID_SPELLING							, //	10243      // kein Seitenwechsel
//  SID_THESAURUS							, //	10245
	SID_DRAW_CAPTION    					, //	10254
//  SID_FONTWORK							, //	10256
    SID_FRAME_TO_TOP						, //	10286
    SID_FRAME_TO_BOTTOM						, //	10287
    SID_SET_SUPER_SCRIPT					, //	10294
    SID_SET_SUB_SCRIPT						, //	10295
    SID_CHAR_DLG							, //	10296
    SID_PARA_DLG							, //	10297
    SID_ATTR_FILL_SHADOW					, //	10299
    SID_ATTR_LINEEND_STYLE					, //	10301
//  SID_SCAN								, //	10330
//  SID_TWAIN_SELECT						, //	10331
//  SID_TWAIN_TRANSFER						, //	10332
    SID_BMPMASK								, //	10350
    SID_HYPERLINK_INSERT					, //	10360
    SID_NAVIGATOR							, //	10366
    SID_IMAP								, //	10371
    SID_SHOW_HIDDEN                         , //    10375
    SID_SHOW_FORMS                          , //    10376
    SID_DRAW_RECT_NOFILL                    , //    10378
	SID_DRAW_RECT_ROUND_NOFILL				, //	10379
	SID_DRAW_SQUARE 						, //	10380
	SID_DRAW_SQUARE_ROUND   				, //	10381
	SID_DRAW_SQUARE_NOFILL 					, //	10382
	SID_DRAW_SQUARE_ROUND_NOFILL   			, //	10383
	SID_DRAW_ELLIPSE_NOFILL					, //	10384
	SID_DRAW_CIRCLE 						, //	10385
	SID_DRAW_CIRCLE_NOFILL 					, //	10386
	SID_DRAW_PIE_NOFILL						, //	10387
	SID_DRAW_CIRCLEPIE						, //	10388
	SID_DRAW_CIRCLEPIE_NOFILL				, //	10389
	SID_DRAW_CIRCLEARC  					, //	10390
	SID_DRAW_CIRCLECUT_NOFILL				, //	10391
	SID_DRAW_ELLIPSECUT 					, //	10392
	SID_DRAW_ELLIPSECUT_NOFILL				, //	10393
	SID_DRAW_XPOLYGON  						, //	10394
	SID_DRAW_POLYGON_NOFILL  				, //	10395
	SID_DRAW_XPOLYGON_NOFILL  				, //	10396
	SID_DRAW_BEZIER_NOFILL					, //	10397
	SID_DRAWTBX_TEXT     					, //	10398
	SID_DRAWTBX_RECTANGLES  				, //	10399
	SID_DRAWTBX_ELLIPSES 					, //	10400
	SID_DRAWTBX_LINES    					, //	10401
//	SID_LIGHTING							, //	10405
//  SID_INET_DLG							, //	10416
    SID_COLOR_CONTROL						, //	10417
//  SID_SD_AUTOPILOT						, //	10425
//	SID_SD_EDITOPTIONS						, //	10434
    SID_GROUP								, //	10454
    SID_UNGROUP								, //	10455
    SID_SET_DEFAULT							, //	10456
	SID_BEZIER								, //	10458
	SID_DRAW_FREELINE						, //	10463
	SID_DRAW_FREELINE_NOFILL				, //	10464
	SID_FM_DESIGN_MODE						, //	10629
	SID_3D_WIN         						, //	10644
	SID_3D_STATE       						, //	10645
	SID_3D_INIT        						, //	10646
	SID_3D_ASSIGN      						, //	10647
    SID_CONVERT_TO_3D						, //	10648
	SID_CONVERT_TO_3D_LATHE_FAST			, //	10649
	SID_ATTR_CHAR_VERTICAL                  , //    10905
	SID_DRAW_CAPTION_VERTICAL               , //    10906
//  SID_SBA_ADDRPI							, //	12212
	FN_NUM_BULLET_ON                        , //    20138
//  SID_PAGESETUP							, //	27002
    SID_PASTE2								, //	27003
    SID_COPYOBJECTS							, //	27004
    SID_MANAGE_LINKS						, //	27005
	SID_CONVERT_TO_3D_LATHE					, //	27008
//  SID_DRAWINGMODE							, //	27009
//  SID_OUTLINEMODE							, //	27010
//  SID_DIAMODE								, //	27011
//  SID_INSERTPAGE							, //	27014
//  SID_INSERTFILE							, //	27015
    SID_BULLET								, //	27019
    SID_POSITION							, //	27022
    SID_MIRROR								, //	27023
    SID_CONVERT								, //	27024
	SID_TEXT_FITTOTEXT						, //	27025
    SID_COMBINE								, //	27026
    SID_NAME_GROUP							, //	27027
	SID_DRAWTBX_CONNECTORS					, //	27028
    SID_BEZIER_ELIMINATE_POINTS				, //	27030
    SID_MOREFRONT							, //	27031
    SID_MOREBACK							, //	27032
	SID_LIVE_PRESENTATION					, //	27033
    SID_VERTICAL							, //	27034
    SID_HORIZONTAL							, //	27035
    SID_CHANGEBEZIER						, //	27036
    SID_CHANGEPOLYGON						, //	27037
    SID_CAPTUREPOINT						, //	27038
    SID_RULER								, //	27040
//  SID_INSERTLAYER							, //	27043
//  SID_MODIFYPAGE							, //	27046
//  SID_MODIFYLAYER							, //	27048
//  SID_PAGEMODE							, //	27049
//  SID_LAYERMODE							, //	27050
	SID_DRAW_MEASURELINE					, //	27051
//  SID_MASTERPAGE							, //	27053
    SID_TOOL_CONNECTOR						, //	27058
    SID_ANIMATION_OBJECTS					, //	27062
    SID_ANIMATION_EFFECTS					, //	27063
    SID_PRESENTATION_LAYOUT					, //	27064
    SID_BEZIER_CONVERT						, //	27065
    SID_BEZIER_EDGE							, //	27066
    SID_BEZIER_SYMMTR						, //	27067
//  SID_NOTESMODE							, //	27069
//  SID_HANDOUTMODE							, //	27070
	SID_TEXTEDIT							, //	27076
//  SID_DELETE_PAGE							, //	27080
//  SID_DELETE_LAYER						, //	27081
    SID_DISMANTLE							, //	27082
	SID_OBJECT_MIRROR						, //	27085
	SID_OBJECT_CROOK_ROTATE					, //	27090
	SID_OBJECT_CROOK_SLANT					, //	27091
	SID_OBJECT_CROOK_STRETCH				, //	27092
    SID_CONNECT								, //	27093
    SID_BREAK								, //	27094
	SID_OBJECT_CHOOSE_MODE					, //	27095
    SID_ENTER_GROUP							, //	27096
    SID_LEAVE_GROUP							, //	27097
	SID_OBJECT_TRANSPARENCE					, //	27100
	SID_OBJECT_GRADIENT						, //	27101
//  SID_INSERT_IMAGE						, //	27105
    SID_INSERT_MATH							, //	27106
	SID_OBJECT_SHEAR						, //	27107
    SID_BEHIND_OBJ							, //	27116
    SID_REVERSE_ORDER						, //	27117
    SID_SDOPTIONS							, //	27118
    SID_CONNECTOR_ARROW_START				, //	27119
    SID_CONNECTOR_ARROW_END					, //	27120
    SID_CONNECTOR_ARROWS					, //	27121
    SID_CONNECTOR_CIRCLE_START				, //	27122
    SID_CONNECTOR_CIRCLE_END				, //	27123
    SID_CONNECTOR_CIRCLES					, //	27124
    SID_CONNECTOR_LINE						, //	27125
    SID_CONNECTOR_LINE_ARROW_START			, //	27126
    SID_CONNECTOR_LINE_ARROW_END			, //	27127
    SID_CONNECTOR_LINE_ARROWS				, //	27128
    SID_CONNECTOR_LINE_CIRCLE_START			, //	27129
    SID_CONNECTOR_LINE_CIRCLE_END			, //	27130
    SID_CONNECTOR_LINE_CIRCLES				, //	27131
    SID_CONNECTOR_CURVE						, //	27132
    SID_CONNECTOR_CURVE_ARROW_START			, //	27133
    SID_CONNECTOR_CURVE_ARROW_END			, //	27134
    SID_CONNECTOR_CURVE_ARROWS				, //	27135
    SID_CONNECTOR_CURVE_CIRCLE_START		, //	27136
    SID_CONNECTOR_CURVE_CIRCLE_END			, //	27137
    SID_CONNECTOR_CURVE_CIRCLES				, //	27138
    SID_CONNECTOR_LINES						, //	27139
    SID_CONNECTOR_LINES_ARROW_START			, //	27140
    SID_CONNECTOR_LINES_ARROW_END			, //	27141
    SID_CONNECTOR_LINES_ARROWS				, //	27142
    SID_CONNECTOR_LINES_CIRCLE_START		, //	27143
    SID_CONNECTOR_LINES_CIRCLE_END			, //	27144
    SID_CONNECTOR_LINES_CIRCLES				, //	27145
	SID_DRAWTBX_ARROWS						, //	27171
    SID_LINE_ARROW_START           			, //	27172
    SID_LINE_ARROW_END             			, //	27173
    SID_LINE_ARROWS                			, //	27174
    SID_LINE_ARROW_CIRCLE          			, //	27175
    SID_LINE_CIRCLE_ARROW          			, //	27176
    SID_LINE_ARROW_SQUARE          			, //	27177
    SID_LINE_SQUARE_ARROW          			, //	27178
    SID_TEXTATTR_DLG						, //	27281 //?
    SID_PUBLISH								, //	27283
	SID_TEXT_FITTOSIZE						, //	27285
	SID_TEXT_FITTOSIZE_VERTICAL				, //	27286
	SID_NAVIGATOR_PAGENAME					, //	27287
	SID_NAVIGATOR_STATE 					, //	27288
	SID_NAVIGATOR_INIT						, //	27289
	SID_NAVIGATOR_LIVE						, //	27290
	SID_NAVIGATOR_PEN						, //	27291
	SID_NAVIGATOR_PAGE						, //	27292
	SID_NAVIGATOR_OBJECT					, //	27293
	SID_DRAWTBX_3D_OBJECTS					, //	27295
	SID_3D_CUBE 							, //	27296
	SID_3D_SPHERE							, //	27297
	SID_3D_CYLINDER 						, //	27298
	SID_3D_CONE 							, //	27299
	SID_3D_PYRAMID							, //	27300
	SID_GLUE_EDITMODE						, //	27301
    SID_GLUE_INSERT_POINT					, //	27302
    SID_GLUE_PERCENT						, //	27303
    SID_GLUE_HORZALIGN_CENTER				, //	27305
    SID_GLUE_HORZALIGN_LEFT					, //	27306
    SID_GLUE_HORZALIGN_RIGHT				, //	27307
    SID_GLUE_VERTALIGN_CENTER				, //	27308
    SID_GLUE_VERTALIGN_TOP					, //	27309
    SID_GLUE_VERTALIGN_BOTTOM				, //	27310
	SID_3D_SHELL							, //	27311
	SID_3D_TORUS							, //	27312
	SID_3D_HALF_SPHERE						, //	27313
    SID_GLUE_ESCDIR_LEFT					, //	27314
    SID_GLUE_ESCDIR_RIGHT					, //	27315
    SID_GLUE_ESCDIR_TOP						, //	27316
    SID_GLUE_ESCDIR_BOTTOM					, //	27317
	SID_DRAWTBX_INSERT    					, //	27318
    SID_POLYGON_MORPHING					, //	27319 //?
    SID_MEASURE_DLG							, //	27320 //?
    SID_BEFORE_OBJ							, //	27326
	SID_PREVIEW_WIN         				, //	27327
	SID_EFFECT_WIN							, //	27328
//	SID_PREVIEW_STATE       				, //	27329
//	SID_EFFECT_STATE       					, //	27330
//	SID_EFFECT_INIT        					, //	27331
//	SID_EFFECT_ASSIGN      					, //	27332
	SID_CONNECTION_DLG 						, //	27338
//	SID_PRESENTATION_DLG 					, //	27339
//	SID_HYPHENATION      					, //	27340
	SID_CONNECTION_NEW_ROUTING  			, //	27341
//  SID_DUPLICATE_PAGE						, //	27342
    SID_LEAVE_ALL_GROUPS					  //	27345
//  SID_SLIDE_MASTERPAGE					, //	27348
//  SID_HANDOUT_MASTERPAGE					, //	27349
//  SID_NOTES_MASTERPAGE					, //	27350
//  SID_TITLE_MASTERPAGE				    , //	27351
};

// ---------------
// - FuSlideShow -
// ---------------

FuSlideShow::FuSlideShow( SdViewShell* pViewSh, SdWindow* pWin, SdView* pView, SdDrawDocument* pDoc, SfxRequest& rReq) :
    FuPoor(pViewSh, pWin, pView, pDoc, rReq),
    pShowWindow(NULL),
    pShowView(NULL),
    pFader(new Fader(pWin, this)),
    pMover(new SdBitmapMover(pWin, this)),
    pVDev(NULL),
    pAnmVDev(NULL),
    pMskVDev( NULL ),
    pTimeButton(NULL),
    pCurAnmList(new List),
    pNextAnmList(new List),
    pCurAnimGraphs(new List),
    pNextAnimGraphs(new List),
    pCurControls(new List),
    pNextControls(new List),
    pLayoutText(NULL),
    pLayoutClip(NULL),
    pLayoutBmpEx(NULL),
    pCompoundText(NULL),
    pTopLayer(NULL),
    bFullBckgnd(FALSE),
    eRandomLayout(presentation::AnimationEffect_NONE),
    pSound(NULL),
    nRestorePage(0),
    nVisibleAffectingObjects(0),
    bManual(FALSE),
    bMouseVisible(TRUE),
    bMouseAsPen(FALSE),
    bRehearseTimings(FALSE),
    nPauseTimeout(0),
    bShowPauseLogo(FALSE),
    bVDevEmpty(TRUE),
    nMouseClickSema(0UL),
    bMouseIsDrawing(FALSE),
    bAlwaysOnTop(FALSE),
    bAutoSaveSuppressed(FALSE),
    bNativeMode(TRUE),
    bInitShowStatus(FALSE),
    bLockedPages(FALSE),
    eAnimationMode(ANIMATIONMODE_SHOW),
    nIgnoreInputSmph(1),
    pTimeButtonBckgnd(NULL),
    pActualPage(NULL),
    pClientList(NULL),
    aPresSize( -1, -1 ),
    nParaPos(0L),
    pDimObject(NULL),
    pHideObject(NULL),
    bPlayFull(FALSE),
    bTimerIntercepted(FALSE),
    bDocChanged(pDoc->IsChanged()),
    pMetaFile(NULL),
    pBckgndRect(NULL),
    pLayoutClone(NULL),
    pSlowObjList(NULL),
    pDrawModeWindows(NULL),
    pOldActiveWindow(NULL),
    bGridVisible(FALSE),
    bFullScreen(TRUE),
    pNewAttr(NULL),
    nMagic(SLIDESHOW_MAGIC),
    bSetOnlineSpelling(FALSE),
    bTerminated(FALSE),
    nShellLockCount( 0UL ),
    nPushCount( 0UL ),
    pOutlInfo(new OutlinerInfo()),
    nStartShowEvt( 0UL ),
    nResizeEvt( 0UL ),
    nMasterPageCacheMode(SDR_MASTERPAGECACHE_FULL),
    nChildMask( 0UL ),
    bDestroyed(FALSE),
    bReadyForNextInput(TRUE)
{
    // Argumente fuer Auswertung in StartShow() aufbewahren
    if( rReq.GetArgs() && rReq.GetArgs()->Count() )
	{
	    pNewAttr = new SfxItemSet( pDoc->GetPool(), ATTR_PRESENT_START, ATTR_PRESENT_END );
        pNewAttr->Put( *rReq.GetArgs() );
		
        if( pNewAttr->Count() != ( ( ( ATTR_PRESENT_END ) - ( ATTR_PRESENT_START ) ) - 1 ) )
    		delete pNewAttr, pNewAttr = NULL;
    }

    if( pViewSh )
        pOldActiveWindow = pViewSh->GetActiveWindow();
}

// -----------------------------------------------------------------------------

FuSlideShow::~FuSlideShow()
{
	Destroy( FALSE );
}

// -----------------------------------------------------------------------------

void FuSlideShow::Destroy( BOOL bDelete )
{
	if( !bDestroyed )
	{
		// Falls noch Events in der Queue haengen, diese abwuergen
		if( nStartShowEvt )
			Application::RemoveUserEvent( nStartShowEvt );

		if( nResizeEvt )
			Application::RemoveUserEvent( nResizeEvt );

		nMagic = 0L;
		aTimer.Stop();

		if( pTimeButton )
			pTimeButton->Hide();

		if( pShowWindow && eAnimationMode == ANIMATIONMODE_SHOW )
			pShowWindow->Hide();

		delete pFader;
		delete pMover;

		if( pCurAnmList && pCurAnmList->Count() )
		{
			for( void* pO = pCurAnmList->First(); pO; pO = pCurAnmList->Next() )
			{
				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( (SdrObject*) pO );
				if( pInfo )
					pInfo->bShow = pInfo->bIsShown = TRUE;
			}
		}
		delete pCurAnmList;

		if( pNextAnmList && pNextAnmList->Count() )
		{
			for( void* pO = pNextAnmList->First(); pO; pO = pNextAnmList->Next() )
			{
				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( (SdrObject*) pO );
				if( pInfo )
					pInfo->bShow = pInfo->bIsShown = TRUE;
			}
		}
		delete pNextAnmList;

    	for( void* pObj = pCurAnimGraphs->First(); pObj; pObj = pCurAnimGraphs->Next() )
	    	StopTextOrGraphicAnimation( (SdrObject*) pObj, FALSE );

		delete pCurAnimGraphs;
		delete pNextAnimGraphs;
		delete pCurControls;
		delete pNextControls;
		delete pMetaFile;
		delete pLayoutClone;
		delete pLayoutClip;
		delete pLayoutBmpEx;
		delete pCompoundText;
		delete pTopLayer;

		ClearSlowObjList();
		delete pSlowObjList;

		DeleteClientList();

		delete pTimeButtonBckgnd;
		delete pVDev;
		delete pAnmVDev;
		delete pMskVDev;
		delete pShowView;
		delete pSound;
		delete pDrawModeWindows;
		delete pTimeButton;

		if (eAnimationMode == ANIMATIONMODE_SHOW)
			delete pShowWindow;

		while( nPushCount )
		{
			pShowWindow->Pop();
			nPushCount--;
		}

		if ( pViewShell && ( eAnimationMode == ANIMATIONMODE_SHOW ) )
		{
			// auf vor dem Start sichtbare Seite zurueckschalten
			( (SdDrawViewShell*) pViewShell )->SwitchPage( nRestorePage );

			// Damit der Praesentations-Button nach einer Show wieder heraus kommt
			// und die Zeit nach einer Praesentation mit Zeitnahme upgedated wird
			pViewShell->Invalidate();

			SdWindow* pActWin = pViewShell->GetActiveWindow();
			
            if (pActWin)
			{
				Size aVisSizePixel = pActWin->GetOutputSizePixel();
				Rectangle aVisAreaWin = pActWin->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
				pViewShell->VisAreaChanged(aVisAreaWin);
				pView->VisAreaChanged(pActWin);
				pActWin->GrabFocus();
			}
		}

		// an Shell wieder Eingaben ermoeglichen
		UnlockDrawViewShell( TRUE );

		if( pViewShell && pViewShell->IsStartShowWithDialog() )
		{
			pViewShell->SetStartShowWithDialog( FALSE );
			pViewShell->GetViewFrame()->GetDispatcher()->Execute( SID_CUSTOMSHOW_DLG, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
		}

		delete pNewAttr;
		delete pOutlInfo;

		// Dtor ist durchlaufen
		bTerminated = bDestroyed = TRUE;

		if( bDelete )
			Application::PostUserEvent( LINK( this, FuSlideShow, DestroyHdl ) );
	}
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideShow, DestroyHdl, void*, p )
{
	delete this;
	return 0L;
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideShow, PageTimeOutHdl, Timer *, pTimer )
{
	aAnimPageList.MakePageNumCurrent( aAnimPageList.GetNextPageNum() );

	SfxBindings& rBindings = ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings();
	rBindings.Invalidate( SID_NAVIGATOR_STATE );
	rBindings.Invalidate( SID_NAVIGATOR_PAGENAME );

	DoPageFade();

	return 0L;
}

// -----------------------------------------------------------------------------

void FuSlideShow::DoPageFade()
{
	if( !pShowWindow )
		return;

	pShowWindow->SetViewShell( pViewShell );

	// Wenn gerade ein Sound vollstaendig abgespielt werden soll, wird die Ausfuehrung dieser
	// Methode blockiert. Der Handler wird nach dem Sound durch SoundHasStoppedHdl nochmal gerufen.
	if( bPlayFull )
	{
		bTimerIntercepted = TRUE;
		return;
	}

	SfxBindings&	rBind = ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings();
	const USHORT	nCurPage = aAnimPageList.GetCurrentPageNum();
	BOOL			bAbort = FALSE;

	LockDrawViewShell();

	// stop animated graphics
	for( void* pObj = pCurAnimGraphs->First(); pObj; pObj = pCurAnimGraphs->Next() )
		StopTextOrGraphicAnimation( (SdrObject*) pObj, FALSE );

    // PlugIns ausschalten
    if( eAnimationMode == ANIMATIONMODE_SHOW )
        pViewShell->DisconnectAllClients();

	if( PAGE_NO_END == nCurPage )
		StopShow();
	else if( PAGE_NO_SOFTEND == nCurPage )
		pShowWindow->SetEndMode();
	else if( PAGE_NO_PAUSE == nCurPage )
	{
		Graphic* pGraphic = NULL;

		// falls nur eine Seite wiederholt dargestellt wird,
		// bVDevEmpty auf TRUE setzen, damit die Seite nach jeder
		// Pausenseite neu aufgebaut wird
		if( pDoc->GetSdPageCount( PK_STANDARD ) == 1 )
			bVDevEmpty = TRUE;

		if( bShowPauseLogo && nPauseTimeout )
		{
			pGraphic = new Graphic;
			if( !GalleryExplorer::GetGraphicObj( GALLERY_THEME_HTMLBUTTONS, 0, pGraphic ) )
				delete pGraphic, pGraphic = NULL;
		}

		pShowWindow->SetPauseMode( aAnimPageList.GetRealNextPageNum(), nPauseTimeout, pGraphic );
		delete pGraphic;
	}
	else
	{
		bReadyForNextInput = ( ANIMATIONMODE_SHOW != eAnimationMode );

		SdPage* pCurPage = pDoc->GetSdPage( nCurPage, PK_STANDARD );

		// Information ueber abzublendendes Objekt zuruecksetzen
		pDimObject = pHideObject = pLayoutText = NULL;
		delete pLayoutClone, pLayoutClone = NULL;
		delete pCompoundText, pCompoundText = NULL;

		pOutlInfo->Clear();

		// wenn noch nichts im virtuellen Device ist
		if( bVDevEmpty || ( aAnimPageList.GetPreparedPageNum() != nCurPage ) )
		{
			bIVDsFound = FALSE;
			nVisibleAffectingObjects = 0;
			PrepareForPage( pCurPage, TRUE );
		}

		// ShowStati fuer Masterpage-Objekte an dieser Stelle immer neu initialisieren,
		// da im ::PrepareForPage immer die alten Stati restauriert werden muessen,
		// da dort ggf. nur die naechste Seite _vorbereitet_ wird
        SdrObjListIter aMasterIter( *pCurPage->GetMasterPage( 0 ), IM_FLAT );
		for( SdrObject* pMasterO = aMasterIter.Next(); pMasterO; pMasterO = aMasterIter.Next() )
		{
            SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pMasterO );
            if( pInfo )
				InitShowStatus( pInfo );
		}

		// warten bis Seite fertig ist, dann ueberblenden
		while( !pShowView->IsRedrawReady() ) {}

		// Ueberblendeffekt einstellen
		Point	aUpperLeft( pCurPage->GetLftBorder(), pCurPage->GetUppBorder());
		Point	aLowerRight( pCurPage->GetSize().Width() - pCurPage->GetRgtBorder(), pCurPage->GetSize().Height() - pCurPage->GetLwrBorder());
		Size	aPixSize( pShowWindow->PixelToLogic( Size( 1, 1 ) ) );

		// damit die rechte und untere Borderlinie nicht sichtbar wird
		// (eigentlich muesste das Hintergrundrechteck ein Pixel hoeher und
		// breiter gezeichnet werden, aber dann wird es an anderen Stellen
		// nicht mehr erkannt, also muss die Show es hier wieder geradebiegen)
		aUpperLeft = pShowWindow->PixelToLogic( pShowWindow->LogicToPixel( aUpperLeft ) );
		aLowerRight = pShowWindow->PixelToLogic( pShowWindow->LogicToPixel( aLowerRight ) );
		aLowerRight.X() -= aPixSize.Width();
		aLowerRight.Y() -= aPixSize.Height();

		Rectangle aRect( aUpperLeft, aLowerRight );

		pFader->SetSource( aRect );
		pFader->SetTarget( aRect );
		pFader->SetEffect( pCurPage->GetFadeEffect() );
		pFader->SetSpeed( pCurPage->GetFadeSpeed() );
		pFader->SetNewVirtualDevice( pVDev );

		// vor dem Ueberblenden ggfs. Buttons verstecken
		if( bRehearseTimings )
		{
			pTimeButton->Hide();

			if( pTimeButtonBckgnd && !pTimeButtonBckgnd->IsEmpty() )
			{
				pShowWindow->DrawBitmap( pShowWindow->PixelToLogic( pTimeButton->GetPosPixel() ), *pTimeButtonBckgnd );
				delete pTimeButtonBckgnd, pTimeButtonBckgnd = NULL;
			}
		}

		// falls noch ein Sound spielt
		pSound->Stop();
		pSound->SetSoundName( String() );

		// Sound beim Ueberblenden
		if( pCurPage->IsSoundOn() )
			StartSound( pCurPage->GetSoundFile() );

		// aktuelle Seite setzen
		pActualPage = pCurPage;

		// Seite in der DrawView anzeigen, alle dabei anfallenden Paints unterdruecken
		((SdDrawView*)pView)->AllowPresPaint( FALSE );
		pView->HideAllPages();
		pView->ShowPage( pCurPage, Point() );

		SdrPageView* pPageView2 = pView->GetPageView( pActualPage );
	    SdViewShell* pViewSh = GetDrawViewShellForShow();

		if( pViewSh && pPageView2 )
			pPageView2->SetVisibleLayers( pViewSh->GetFrameView()->GetVisibleLayers() );

		// Client-Liste loeschen und neu anlegen
		DeleteClientList();
		pClientList = new SvInPlaceClientMemberList;

		// falls der Benutzer den Bildschirm vollgeschmiert hat ...
		if( bMouseAsPen )
		{
			PolyPolygon aClip;
			Rectangle	aScreen(pShowWindow->PixelToLogic( Point() ), pShowWindow->GetOutputSize() );
			Rectangle	aInner(pShowWindow->LogicToPixel(aRect));

			// jeweils ein Pixel nach aussen
			aRect.Left() -= 1;
			aRect.Top() -= 1;
			aRect.Right() += 1;
			aRect.Bottom() += 1;
			aInner = pShowWindow->PixelToLogic(aInner);
			aClip.Insert(aScreen);
			aClip.Insert(aInner);
			pShowWindow->SetClipRegion(aClip);
			pShowWindow->SetFillColor(Color(COL_BLACK));
			pShowWindow->SetLineColor();
			pShowWindow->DrawRect(aScreen);
			pShowWindow->SetClipRegion();
		}

		// Ueberblenden; in der Show blenden wir ggf. den Navigator aus, um keine
		// Repaintfehler durch das Scrollen ohne eigentliche ::Paint-Methode zu bekommen
		const BOOL bNavigatorIsVisibleInShow = ( eAnimationMode == ANIMATIONMODE_SHOW ) &&
											   ( ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->
											     GetChildWindow( SID_NAVIGATOR ) != NULL );

		if( bNavigatorIsVisibleInShow )
			pViewShell->GetViewFrame()->ShowChildWindow( SID_NAVIGATOR, FALSE );

		// Seiten ueberblenden, da zwischendurch Paints hereinkommen koennen, die das bisher dargestellte
		// uebermalen, wird der Hintergrund waehrend des Fadeeffektes temporaer transparent gemacht
		const Wallpaper	aOldShowBack( pShowWindow->GetBackground() );
		pShowWindow->SetBackground();
        pShowWindow->Update();

		pFader->Fade();

		// remember the time this page faded in
		nFadeInTime = Time::GetSystemTicks();

		// Navigator wieder eischalten
		if( bNavigatorIsVisibleInShow )
			( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->ShowChildWindow( SID_NAVIGATOR, TRUE );

        // im Reschedule des Effekts zerstoert?
        if( nMagic != SLIDESHOW_MAGIC )
		{
			bReadyForNextInput = TRUE;
			rBind.Invalidate( SID_PRESENTATION );
			rBind.Invalidate( SID_REHEARSE_TIMINGS );
			return;
		}

		pShowWindow->SetBackground( aOldShowBack );

		// jetzt wieder erlaubt
		((SdDrawView*)pView)->AllowPresPaint(TRUE);

		// falls ein Animationsobjekt initial sichtbar ist, aber per
		// ClickAction verschwinden soll, den reinen Hintergrund ins
		// VDev zeichnen
		if( bIVDsFound )
			RepaintVDev( pActualPage, TRUE );

		// im virtuellen Device ist jetzt nicht mehr die (vermutlich) nachste Seite
		bVDevEmpty = TRUE;

		// nach dem Ueberblenden ggfs. Buttons anzeigen
		if( bRehearseTimings )
		{
			if( !pTimeButtonBckgnd )
				pTimeButtonBckgnd = new Bitmap;

			const Point	aPoint( pShowWindow->PixelToLogic( pTimeButton->GetPosPixel() ) );
			const Size	aSize( pShowWindow->PixelToLogic( pTimeButton->GetSizePixel() ) );

			*pTimeButtonBckgnd = pShowWindow->GetBitmap( aPoint, aSize );
			aSlideVisibleSince = Time();
			TimeButtonTimeOutHdl( &aTimer );
			pTimeButton->Show();
			pTimeButton->Disable();
			aTimer.Stop();
		}

		// aus dem Zeichenmodus raus
		if( bMouseAsPen )
			bMouseIsDrawing = FALSE;

		if( !bAbort )
		{
			// im Livemodus ggf. die Preview aktualisieren
			if( !bNativeMode && ( eAnimationMode != ANIMATIONMODE_PREVIEW ) )
			{
				// ggfs. Preview den neuen Kontext mitteilen
				SfxChildWindow* pPrevChild = ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->
											 GetChildWindow( SdPreviewChildWindow::GetChildWindowId() );

				if( pPrevChild )
				{
					SdPreviewWin* pPrevWin = (SdPreviewWin*) pPrevChild->GetWindow();

					if ( pPrevWin && pPrevWin->GetDoc() == pDoc && pViewShell->ISA( SdDrawViewShell ) )
						pPrevWin->SetContext( pDoc, aAnimPageList.GetCurrentPageNum(), pViewShell->GetFrameView() );
				}
			}

			// die Liste der Animationsobjekte der vorbereiteten Seite wird zur aktuellen Animationsliste,
			// die ehemals aktuelle Liste wird beim Vorbereiten der naechsten Seite benutzt
			List* pTempList = pCurAnmList;
			pCurAnmList	= pNextAnmList;
			pNextAnmList = pTempList;

			// ebenso fuer die Listen der animierten Grafiken
			pTempList = pCurAnimGraphs;
			pCurAnimGraphs = pNextAnimGraphs;
			pNextAnimGraphs = pTempList;

			// ebenso fuer die Listen der animierten Grafiken
			pTempList = pCurControls;
			pCurControls = pNextControls;
			pNextControls = pTempList;

			// Falls nichts mehr animiert wird, kann die vorraussichtlich
			// naechste Seite aufbereitet werden (folgende Seite)
			const USHORT nNextPage = aAnimPageList.CalcNextPageNum( TRUE );

			if( nNextPage < PAGE_NO_FIRSTDEF && nNextPage != nCurPage && !pCurAnmList->Count() && !bIVDsFound )
			{
				pShowView->HideAllPages();
                PrepareForPage( pDoc->GetSdPage( nNextPage, PK_STANDARD ), TRUE );
				bVDevEmpty = FALSE;
			}

            // fuer das korrekte connecten braucht der SFx das echte ShowWindow und keinen NULL-Pointer
            if( eAnimationMode == ANIMATIONMODE_SHOW )
                ShowPlugIns();

			// show animations
        	for( void* pAnimGrf = pCurAnimGraphs->First(); pAnimGrf; pAnimGrf = pCurAnimGraphs->Next() )
		        DrawOrStartAnimation( (SdrObject*) pAnimGrf, pShowWindow, bAnimationAllowed, TRUE );

			// show controls
        	for( void* pCtrlObj = pCurControls->First(); pCtrlObj; pCtrlObj = pCurControls->Next() )
    		    ( (SdrObject*) pCtrlObj )->SendRepaintBroadcast();

			// bei automatischem Diawechsel oder Zeitnahme muss die Objektanimation automatisch laufen
			if( ( ( pActualPage->GetPresChange() != PRESCHANGE_MANUAL ) && !bManual ) || bRehearseTimings )
				aTimer.SetTimeoutHdl( LINK( this, FuSlideShow, ObjectTimeOutHdl ) );
			else
				aTimer.SetTimeoutHdl( LINK( this, FuSlideShow, ReadyForNextInputHdl ) );

			aTimer.SetTimeout( 20 );
			aTimer.Start();
		}
		else
		{
			bReadyForNextInput = TRUE;
			StopShow();
		}
	}

	UnlockDrawViewShell( FALSE );

	rBind.Invalidate( SID_PRESENTATION );
	rBind.Invalidate( SID_REHEARSE_TIMINGS );
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideShow, TimeButtonTimeOutHdl, Timer *, pTimer )
{
	Application::GetSolarMutex( ).acquire();

	Time aNow;
	aNow -= aSlideVisibleSince;
	String aStr;
	String aTemp;

	aTemp = String::CreateFromInt32(aNow.GetHour());
	if (aTemp.Len() < 2) aStr.Append( sal_Unicode('0') );
	aStr.Append( aTemp );

	aStr.Append( sal_Unicode(':') );

	aTemp = String::CreateFromInt32(aNow.GetMin());
	if (aTemp.Len() < 2) aStr.Append( sal_Unicode('0') );
	aStr.Append( aTemp );

	aStr.Append( sal_Unicode(':') );

	aTemp = String::CreateFromInt32(aNow.GetSec());
	if (aTemp.Len() < 2) aStr.Append( sal_Unicode('0') );
	aStr.Append( aTemp );

	pTimeButton->SetText( aStr );
	aTimer.Start();

	Application::GetSolarMutex().release();

	return 0;
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideShow, TimeButtonHdl, Button *, pButton )
{
	Time aNow;

	aNow -= aSlideVisibleSince;

	const ULONG	nSeconds = aNow.GetSec() + aNow.GetMin() * 60 + aNow.GetHour() * 3600;
	SdPage*		pPage = pDoc->GetSdPage( aAnimPageList.GetCurrentPageNum(), PK_STANDARD );

	pPage->SetTime( nSeconds );
	pPage->SetPresChange( PRESCHANGE_AUTO );
	pShowWindow->GrabFocus();
	aAnimPageList.MakePageNumCurrent( aAnimPageList.GetNextPageNum() );
	DoPageFade();

	return 0L;
}

// -----------------------------------------------------------------------------

void FuSlideShow::StartShow()
{
	// aktuelle Fenster ausblenden
    if( eAnimationMode == ANIMATIONMODE_SHOW )
		( (SdDrawViewShell*) pViewShell )->ShowUIControls( sal_False );

	// evtl. schon vorhandenes Event herausnehmen
	if( nStartShowEvt )
		Application::RemoveUserEvent( nStartShowEvt );

	// neues Event erzeugen und merken
	nStartShowEvt = Application::PostUserEvent( LINK( this, FuSlideShow, StartShowHdl ) );
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideShow, StartShowHdl, void*, p )
{
	// Event wird abgearbeitet
	nStartShowEvt = 0UL;

	if( nMagic != SLIDESHOW_MAGIC )
		return 0L;

	String	aPresPage;
	SdPage* pStartPage = pViewShell ? pViewShell->GetActualPage() : NULL;
    BOOL	bAll = TRUE;
    BOOL	bStartPresWithNavigator;
	BOOL	bAbort = FALSE;
    BOOL	bStartWithActualPage = ( ANIMATIONMODE_SHOW == eAnimationMode ) ? SD_MOD()->GetSdOptions( pDoc->GetDocumentType() )->IsStartWithActualPage() : FALSE;

	// sollen Zeiten gestoppt werden?
	if( GetSlotID() == SID_REHEARSE_TIMINGS )
	{
		aAnimPageList.SetEndlessMode( FALSE );
		aAnimPageList.SetPauseMode( FALSE );
		aAnimPageList.SetSoftendMode( FALSE );

		aPresPage = pDoc->GetPresPage();
        bRehearseTimings = TRUE;
		bAll = pDoc->GetPresAll();
        bManual = TRUE;
		bMouseVisible = TRUE;
        bMouseAsPen = FALSE;
        bStartPresWithNavigator = FALSE;
		bAlwaysOnTop = pDoc->GetPresAlwaysOnTop();
		bFullScreen = pDoc->GetPresFullScreen();
		bAnimationAllowed = pDoc->IsAnimationAllowed();
		nPauseTimeout = 0;
		bShowPauseLogo = FALSE;
	}
    else if( pNewAttr )
	{
		// uebergebene Einstellungen benutzen
		aAnimPageList.SetEndlessMode( ITEMVALUE( *pNewAttr, ATTR_PRESENT_ENDLESS, SfxBoolItem ) );
		aAnimPageList.SetPauseMode( TRUE );
		aAnimPageList.SetSoftendMode( TRUE );

		aPresPage = ITEMVALUE( *pNewAttr, ATTR_PRESENT_DIANAME, SfxStringItem );
		bAll = ITEMVALUE( *pNewAttr, ATTR_PRESENT_ALL, SfxBoolItem );
		bManual = ITEMVALUE( *pNewAttr, ATTR_PRESENT_MANUEL, SfxBoolItem );
		bMouseVisible = ITEMVALUE( *pNewAttr, ATTR_PRESENT_MOUSE, SfxBoolItem );
		bMouseAsPen = ITEMVALUE( *pNewAttr, ATTR_PRESENT_PEN, SfxBoolItem );
		bLockedPages = !ITEMVALUE( *pNewAttr, ATTR_PRESENT_CHANGE_PAGE, SfxBoolItem );
		bStartPresWithNavigator = ITEMVALUE( *pNewAttr, ATTR_PRESENT_NAVIGATOR, SfxBoolItem );
		bAlwaysOnTop = ITEMVALUE( *pNewAttr, ATTR_PRESENT_ALWAYS_ON_TOP, SfxBoolItem );
		bFullScreen = ITEMVALUE( *pNewAttr, ATTR_PRESENT_FULLSCREEN, SfxBoolItem );
		bAnimationAllowed = ITEMVALUE( *pNewAttr, ATTR_PRESENT_ANIMATION_ALLOWED, SfxBoolItem );
		nPauseTimeout = ITEMVALUE( *pNewAttr, ATTR_PRESENT_PAUSE_TIMEOUT, SfxUInt32Item );
		bShowPauseLogo = ITEMVALUE( *pNewAttr, ATTR_PRESENT_SHOW_PAUSELOGO, SfxBoolItem );
    }
	else
	{
		// Einstellungen vom Doc holen
		aAnimPageList.SetEndlessMode( pDoc->GetPresEndless() );
		aAnimPageList.SetPauseMode( TRUE );
		aAnimPageList.SetSoftendMode( TRUE );

		aPresPage = pDoc->GetPresPage();
		bAll = pDoc->GetPresAll();
		bManual = pDoc->GetPresManual();
		bMouseVisible = pDoc->GetPresMouseVisible();
		bMouseAsPen = pDoc->GetPresMouseAsPen();
		bLockedPages = pDoc->GetPresLockedPages();
		bStartPresWithNavigator = pDoc->GetStartPresWithNavigator();
		bAlwaysOnTop = pDoc->GetPresAlwaysOnTop();
		bFullScreen = pDoc->GetPresFullScreen();
		bAnimationAllowed = pDoc->IsAnimationAllowed();
		nPauseTimeout = pDoc->GetPresPause();
		bShowPauseLogo = pDoc->IsPresShowLogo();
	}

    delete pNewAttr, pNewAttr = NULL;

	if( ( bStartWithActualPage || ( eAnimationMode != ANIMATIONMODE_SHOW ) ) && pStartPage )
	{
		if( pStartPage->GetPageKind() == PK_NOTES )
		{
			// we are in notes page mode, so get
			// the corresponding draw page
			const USHORT nPgNum = ( pStartPage->GetPageNum() - 2 ) / 2;
			SdPage* pPage = pDoc->GetSdPage( nPgNum, PK_STANDARD );
			if( pPage )
				aPresPage = pPage->GetName();
			bAll = FALSE;
		}
		else if( pStartPage->GetPageKind() == PK_STANDARD )
		{
			aPresPage = pStartPage->GetName();
			bAll = FALSE;
		}
		else
		{
			// we have no actual page to show
			bStartWithActualPage = FALSE;
		}
	}

	// Seitenliste aufbauen
	CreatePageList( bAll, bStartWithActualPage, aPresPage );

    if( eAnimationMode == ANIMATIONMODE_SHOW )
    {
		// Seitenummer, von der die Show gestartet wurde, merken
		if( pStartPage )
			nRestorePage = ( pStartPage->GetPageNum() - 1 ) / 2;

		// ChildWindows sichtbar/unsichtbar schalten
		nChildMask = HideChildWindows();
		pViewShell->GetViewFrame()->SetChildWindow( SID_NAVIGATOR, bStartPresWithNavigator );

		SfxBoolItem		aDesignModeItem( SID_FM_DESIGN_MODE, FALSE );
		FmFormShell*	pFormShell = pViewShell->GetFormShell();
		SfxDispatcher*	pDispatcher = pViewShell->GetViewFrame()->GetDispatcher();

		bDesignMode = pFormShell ? pFormShell->IsDesignMode() : TRUE;
		pDispatcher->Execute( SID_FM_DESIGN_MODE, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aDesignModeItem, 0L);

        // OnlineSpelling ausschalten (wird in StopShow() wieder eingeschaltet)
        bSetOnlineSpelling = pDoc->GetOnlineSpell();
        pDoc->SetOnlineSpell( FALSE );

		pViewShell->WriteFrameViewData();

		// if it is a full screen presentation, select the correct page number,
        // because a async call to ::DoActivate at this shell calls ::SwitchPage with
        // the selectect page number (#91777)
        if( pViewShell->ISA( SdPresViewShell ) )
		  pViewShell->GetFrameView()->SetSelectedPage( aAnimPageList.GetCurrentPageNum() );

		pShowWindow = new SdShowWindow( &pViewShell->GetViewFrame()->GetWindow() );
		pViewShell->SetActiveWindow( pShowWindow );

        // diese Slots sind in anderen Views auf dieses Dokument verboten
        pDocSh->SetSlotFilter( TRUE, sizeof( pAllowed ) / sizeof( USHORT ), pAllowed );
        pDocSh->ApplySlotFilter();

		Help::DisableContextHelp();
		Help::DisableExtHelp();
    }

	pFader->SetWindow( pShowWindow );
	pMover->SetWindow( pShowWindow );
    pTimeButton = new PushButton( pShowWindow, SdResId( RID_TIME_BUTTON ) );
	((SdDrawView*)pView)->AllowPresPaint(FALSE);
    aPencil = Pointer( POINTER_PEN );

	pVDev = new VirtualDevice( *pShowWindow );
	pVDev->SetMapMode( pShowWindow->GetMapMode() );
	
	pAnmVDev = new VirtualDevice( *pShowWindow );
	pAnmVDev->SetMapMode( pShowWindow->GetMapMode() );

	pSound = new Sound;
	pDrawModeWindows = new List;
	pTimeButton->Hide();

	// Sonst versucht die DrawingEngine beim HideAllPages() in PageTimeOutHdl()
	// Selektionsmarken zu loeschen, die auf dem ShowWindow gar nicht da sind.
	// Darum deselektieren, solange es noch nicht sichtbar ist.
	pView->UnmarkAll();

	// MasterPage-Caching ausschalten (z.B. das der DrawView)
    if( eAnimationMode == ANIMATIONMODE_SHOW )
        pViewShell->GetView()->ReleaseMasterPagePaintCache();

    if( bFullScreen )
    {
        // StarBASICErrorHdl auf Null setzen, damit die BASIC-IDE nicht hochkommt
        aStarBASICGlobalErrorHdl = StarBASIC::GetGlobalErrorHdl();
        StarBASIC::SetGlobalErrorHdl( Link() );
    }
    
	pShowWindow->SetBackground( Color( COL_BLACK ) );

    // call resize handler if resize has not been called yet
    if( aPresSize.Width() < 0 || aPresSize.Height() < 0 )
    {
        aPresSize = pShowWindow->GetParent()->GetOutputSizePixel();
    
        if( ( eAnimationMode != ANIMATIONMODE_VIEW ) && aPresSize.Width() && aPresSize.Height() )
		    ResizeHdl( NULL );
    }

    // force black background
    pShowWindow->Erase();

	if( bAbort )
	{
		HandleError( STR_NOT_ENOUGH_MEMORY );
		StopShow();
	}
	else
	{
        pShowView = new ShowView( pDoc, pVDev, pViewShell, pShowWindow );

		// Daten der ShowView in die DrawView schreiben
		SetPaintModes( pShowView, pView, NULL, NULL );

		// erst nach diesem Uebertragen der Einstellungen Animationen in der
		// ShowView abschalten (die Animationen, die NICHT Animationsobjekt
		// sind, werden nach der Seitenueberblendung gestartet)
		pShowView->SetAnimationEnabled(FALSE);

        // in einer normalen Praesentation sollen die AnimatedGIFs nicht von
        // allein starten, in einer Preview aber doch
		pView->SetAnimationEnabled( eAnimationMode != ANIMATIONMODE_SHOW );

        // Raster ausschalten
        bGridVisible = pView->IsGridVisible();
        pView->SetGridVisible( FALSE );

		// Hide replacements
		pView->SetHideGrafDraft( TRUE );

		if ( bRehearseTimings )
		{
			Size  aButtonSizePixel( pTimeButton->GetSizePixel() );
			Point aButtonPosPixel( aButtonSizePixel.Width() >> 1, pShowWindow->GetSizePixel().Height() - aButtonSizePixel.Height() * 5 / 2);

			pTimeButton->SetPosPixel( aButtonPosPixel );
			aTimer.SetTimeoutHdl( LINK( this,FuSlideShow, TimeButtonTimeOutHdl ) );
			pTimeButton->SetClickHdl( LINK( this, FuSlideShow, TimeButtonHdl ) );
		}
		else
			aTimer.SetTimeoutHdl( LINK( this,FuSlideShow, PageTimeOutHdl ) );

		if ( bMouseAsPen )
		{
			aOldPointer = pShowWindow->GetPointer();
			pShowWindow->SetPointer( aPencil );
		}

		// der DrawView die alten Fenster wegnehmen und ihr dafuer das Fenster
		// der Praesentation geben
		for (USHORT nWin = 0, nWinCount = pView->GetWinCount(); nWin < nWinCount; nWin++)
		{
			SdWindow* pWin = (SdWindow*) pView->GetWin( 0 );

            if( pWin )
            {
                pView->DelWin( pWin );
                pDrawModeWindows->Insert( pWin, LIST_APPEND );
            }
		}

		pView->AddWin( pShowWindow );
		pShowWindow->Update();

        // das Fenster der Diashow ist erschienen: Input- und Paint-Handler
		// aktivieren
		if( nIgnoreInputSmph )
			nIgnoreInputSmph--;

        ((SdDrawView*)pView)->AllowPresPaint(TRUE);

        // Im Preview-Mode wird der PageTimeOutHdl erst bei Mausklick gerufen.
        // Damit die Seite trotzdem sofort zu sehen ist, wird sie schon hier
        // in der View angemeldet.
        if( eAnimationMode != ANIMATIONMODE_SHOW )
        {
            pView->HideAllPages();

            SdPage* pPage = pDoc->GetSdPage( aAnimPageList.GetCurrentPageNum(), PK_STANDARD );
            pView->ShowPage( pPage, Point() );
            SdrPageView* pPageView2 = pView->GetPageView(pPage);
		    SdViewShell* pViewSh = GetDrawViewShellForShow();

			if( pViewSh && pPageView2 )
			{
				pPageView2->SetVisibleLayers( pViewSh->GetFrameView()->GetVisibleLayers());

				// Einstellungen des Zeichtisches uebernehmen
				if( eAnimationMode == ANIMATIONMODE_VIEW )
					pViewSh->ReadFrameViewData( pViewSh->GetFrameView() );
			}
        }
        else
        {
			// keine Preview:
			// Den PageTimeOutHdl ASYNCHRON aufrufen, damit das SetWindow(NULL)
			// (s.o.) noch wirkt, wenn der SFx dem Fenster ein Show() schickt.
			// Im PageTimeOutHdl() wird dem SFx dann wieder vor ShowPlugIns()
			// das richtige Fenster (pShowWindow) gesetzt.
            aTimer.SetTimeoutHdl(LINK(this, FuSlideShow, PageTimeOutHdl));
            aTimer.SetTimeout( 50 );      // 50 Millisekunden
            aTimer.Start();

            aEscapeTimer.SetTimeoutHdl( LINK( this, FuSlideShow, EscapeHdl ) );
            aEscapeTimer.SetTimeout( 500 );
        }
	}

	if( eAnimationMode == ANIMATIONMODE_SHOW )
		pShowWindow->GrabFocus();

	pShowWindow->ShowPointer( bMouseVisible );

	SfxBindings& rBindings = ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings();
	rBindings.Invalidate( SID_PRESENTATION );
	rBindings.Invalidate( SID_REHEARSE_TIMINGS );

	return 0L;
}

// -----------------------------------------------------------------------------

void FuSlideShow::StopShow()
{
	// falls Objekte fuer die Show geaendert wurden,
	// diese Aenderungen jetzt wieder rueckgaengig machen
	for( SdChangedObj* pChg = (SdChangedObj*) aChangedList.First(); pChg; pChg = (SdChangedObj*) aChangedList.Next() )
	{
		if( pChg->pObject && !pChg->bDeleted )
		{
			pChg->pObject->RemoveListener( *pChg );

			if( pChg->bPosChanged )
				pChg->pObject->NbcMove( Size( -pChg->aMove.Width(), -pChg->aMove.Height() ) );

/* PathObject wieder sichtbar machen
			if( pChg->bLayerChanged )
				pChg->pObject->NbcSetLayer( pChg->nLayer );
*/
		}

		delete pChg;
	}
	aChangedList.Clear();

	// aktuelle Fenster wieder einblenden
    if( pViewShell && ( eAnimationMode == ANIMATIONMODE_SHOW ) && !pViewShell->ISA( SdPresViewShell ) )
	    ( (SdDrawViewShell*) pViewShell )->ShowUIControls( sal_True );

	// waehrend des Beendens koennen keine Ereignisse bearbeitet werden
	nIgnoreInputSmph++;

	// Hide replacements
	pView->SetHideGrafDraft( FALSE );

	// Raster ggf. einschalten
	pView->SetGridVisible(bGridVisible);

	if (bMouseAsPen)
		pShowWindow->SetPointer( aOldPointer );

	pShowWindow->ShowPointer( TRUE );

	pView->UnmarkAll();
	aTimer.Stop();
	DeleteClientList();

    // damit Resize()-Aufrufe ab jetzt kein zeitintensives PrepareForPage() rufen
    pActualPage = NULL;

	// Sound nicht mehr blockieren, damit er auf dem Diatisch gespielt
	// werden kann
	if( pSound )
	{
		pSound->Stop();
		pSound->SetSoundName( String() );
	}

	// der DrawView das Praesentationfenster wegnehmen und ihr dafuer ihre alten Fenster wiedergeben
    if( eAnimationMode == ANIMATIONMODE_SHOW )
    {
        pView->DelWin( pShowWindow );

        for (USHORT nWin = 0, nWinCount = (USHORT) pDrawModeWindows->Count(); nWin < nWinCount; nWin++)
        {
            SdWindow* pWin = (SdWindow*) pDrawModeWindows->GetObject( nWin );

            if( pWin )
                pView->AddWin(pWin);
        }

        pViewShell->SetActiveWindow(pOldActiveWindow);
        pShowWindow->SetViewShell( NULL );
        pView->HideAllPages();
        pView->SetAnimationEnabled( TRUE );
        pView->SetAnimationPause( FALSE );
        pView->ShowPage(((SdDrawViewShell*)pViewShell)->GetActualPage(), Point());
        pViewShell->ReadFrameViewData(pViewShell->GetFrameView());
        pView->InvalidateAllWin();
	}

    if( bFullScreen )
    {
        // StarBASICErrorHdl restaurieren
        StarBASIC::SetGlobalErrorHdl(aStarBASICGlobalErrorHdl);
        aStarBASICGlobalErrorHdl = Link();
    }
    else
        pShowWindow->Hide();

    if( eAnimationMode == ANIMATIONMODE_SHOW )
    {
		// falls waehrend einer Praesentation im Fenster das Fenster eine neu
		// Groesse bekommen hat, haben die Fenster des Zeichentisches das nicht
		// mit bekommen: jetzt nachholen
		if( !bFullScreen )
			( (SdDrawViewShell*) pViewShell )->OuterResizePixel( pShowWindow->GetPosPixel(), pShowWindow->GetSizePixel() );

        pDocSh->SetSlotFilter();
        pDocSh->ApplySlotFilter();

		Help::EnableContextHelp();
		Help::EnableExtHelp();

        // das Modified-Flag am Dokument setzen; falls waehrend des Live-Modus der
        // Show Aenderungen vorgenommen wurden, sind sie in bDocChanged eingeflossen
        pDoc->SetChanged( bDocChanged );

		// falls diese Show nicht als Preview laeuft, muessen die
		// Sichtbarkeitsstati aller Animationsobjekte der aktuellen Seite
		// auf 'sichtbar' gesetzt werden
        SdPage*			pPage = ( (SdDrawViewShell*) pViewShell )->GetActualPage();
        SdrObjListIter	aMasterIter( *pPage->GetMasterPage( 0 ), IM_FLAT );
        SdrObjListIter	aIter( *pPage, IM_FLAT );

		for( SdrObject* pMasterO = aMasterIter.Next(); pMasterO; pMasterO = aMasterIter.Next() )
		{
            SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pMasterO );
            if( pInfo )
                pInfo->bShow = pInfo->bIsShown = TRUE;
		}

		for( SdrObject* pO = aIter.Next(); pO; pO = aIter.Next() )
		{
            SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pO );
            if( pInfo )
                pInfo->bShow = pInfo->bIsShown = TRUE;
		}

		SfxBoolItem aDesignModeItem( SID_FM_DESIGN_MODE, bDesignMode );
		pViewShell->GetViewFrame()->GetDispatcher()->Execute( SID_FM_DESIGN_MODE, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aDesignModeItem, 0L );
		
        ShowChildWindows( nChildMask );
		nChildMask = 0UL;
        
        pViewShell->GetViewFrame()->GetDispatcher()->Execute( SID_PRESENTATION_END, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
    }

    if( bSetOnlineSpelling )
        pDoc->SetOnlineSpell( TRUE );
}

// -----------------------------------------------------------------------------

ULONG FuSlideShow::HideChildWindows()
{
	ULONG nMask = 0UL;

	long nDummy = 0;

	if( ANIMATIONMODE_SHOW == eAnimationMode )
	{


		if( ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetChildWindow( SID_NAVIGATOR ) != NULL )
			nMask |= NAVIGATOR_CHILD_MASK;

		if( !bFullScreen )
		{
			for( ULONG i = 0, nCount = sizeof( aShowChilds ) / sizeof( FncGetChildWindowId ); i < nCount; i++ )
			{
				const USHORT nId = ( *aShowChilds[ i ] )();

				if( ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetChildWindow( nId ) )
				{
					( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->SetChildWindow( nId, FALSE );
					nMask |= 1 << i;
				}
			}
		}
	}

	return nMask;
}

// -----------------------------------------------------------------------------

void FuSlideShow::ShowChildWindows( ULONG nMask )
{
	if( ANIMATIONMODE_SHOW == eAnimationMode )
	{


		if( nMask & NAVIGATOR_CHILD_MASK )
			( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->SetChildWindow( SID_NAVIGATOR, TRUE );

		if( !bFullScreen )
		{
			for( ULONG i = 0, nCount = sizeof( aShowChilds ) / sizeof( FncGetChildWindowId ); i < nCount; i++ )
			{
				if( nMask & ( 1 << i ) )
					( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->SetChildWindow( ( *aShowChilds[ i ] )(), TRUE );
			}
		}
	}
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::MouseButtonDown(const MouseEvent& rMEvt)
{
	BOOL bResult = FALSE;

	nMouseClickSema++;

	if( !bReadyForNextInput )
		bResult = TRUE;
	else if( !IsInputLocked() && pActualPage && ( ANIMATIONMODE_SHOW == eAnimationMode ) )
	{
		// ggfs. an aktuelle Funktion weiterleiten
        if( !bNativeMode )
		{
			FuPoor* pFu = pViewShell->GetActualFunction();
			return pFu ? pFu->MouseButtonDown(rMEvt) : FALSE;
		}

		BOOL bDone = FALSE;

		LockDrawViewShell();

		// Position umrechnen vom ShowWindow auf Seitenkoordinaten und merken
		Point aPos = pShowWindow->PixelToLogic(rMEvt.GetPosPixel());
		aDownPos = aPos;

		if( ( pActualPage->GetPresChange() == PRESCHANGE_MANUAL ) || bManual )
		{
			SdrObject* pObj = NULL;
			SdrPageView* pDummy  = NULL;
            pView->PickObj(aPos, pObj, pDummy, SDRSEARCH_PICKMACRO);
		}

		if (!bDone)
		{
			if( bMouseAsPen && rMEvt.IsLeft() && ( 1 == nMouseClickSema ) )
			{
				bMouseIsDrawing = TRUE;
				pShowWindow->SetLineColor( Color( COL_LIGHTGREEN ) );
				aLastPos = aPos;
			}

			bResult = bDone = TRUE;
		}

		UnlockDrawViewShell( FALSE );
	}

	return bResult;
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::MouseMove(const MouseEvent& rMEvt)
{
	BOOL bResult = FALSE;

	if( !bReadyForNextInput )
		bResult = TRUE;
	else if( !IsInputLocked() && pActualPage && ( ANIMATIONMODE_SHOW == eAnimationMode ) )
	{
		// ggfs. an aktuelle Funktion weiterleiten
        if( !bNativeMode )
		{
			FuPoor* pFu = pViewShell->GetActualFunction();
			return pFu ? pFu->MouseMove(rMEvt) : FALSE;
		}

		Point	aPos = pShowWindow->PixelToLogic(rMEvt.GetPosPixel());
		BOOL	bDone = FALSE;

		LockDrawViewShell();

		if( ( pActualPage->GetPresChange() == PRESCHANGE_MANUAL ) || bManual )
		{
			SdrObject* pObj = NULL;

			// MacroObjekt getroffen? (Interessiert
			// uns aber nur, wenn die Maus nicht gerade malt)
			if( !bMouseIsDrawing )
			{
				SdrPageView* pDummy  = NULL;
                pView->PickObj(aPos, pObj, pDummy, SDRSEARCH_PICKMACRO);
			}
		}

		if( !bDone )
		{
			if( rMEvt.GetButtons() == MOUSE_LEFT && bMouseIsDrawing )
			{
				pShowWindow->DrawLine( aLastPos, aPos );
				aLastPos = aPos;
			}

			bResult = bDone = TRUE;
		}

		// Mauszeiger umschalten, wenn er ueber einem Objekt mit ClickAction
		// oder einem Control steht
		if( bMouseVisible )
		{
			BOOL bHand = FALSE;

			// Objekt mit ClickAction?
			SdrObject* pObject = OverObject(aPos);
			if (pObject && HasAction(pObject) ||
				pObject && pDoc->GetHitIMapObject(pObject, aPos, *pShowWindow))
			{
				bHand = TRUE;
			}
			else
			{
				//	MacroObjekt getroffen?
				SdrPageView* pDummy = NULL;
                pView->PickObj(aPos, pObject, pDummy, SDRSEARCH_PICKMACRO);

                if (pObject)
					bHand = TRUE;
			}

			Pointer aPtr;

			if (bHand)
				aPtr = Pointer( POINTER_REFHAND );
			else if( bMouseAsPen )
				aPtr = aPencil;
			else
				aPtr = Pointer( POINTER_ARROW );

			if (pShowWindow->GetPointer() != aPtr)
				pShowWindow->SetPointer(aPtr);
		}

		UnlockDrawViewShell( FALSE );
	}
	return bResult;
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::MouseButtonUp(const MouseEvent& rMEvt)
{
	SfxInPlaceClient*	pClient = pViewShell ? pViewShell->GetUIActiveClient() : NULL;
	BOOL				bResult = FALSE;

	if( nMouseClickSema )
		nMouseClickSema--;

	if( !bReadyForNextInput )
		bResult = TRUE;
	else if( pClient )
	{
		pClient->DoDisconnect();
		( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings().InvalidateAll( TRUE );
		bResult = TRUE;
	}
	else if( !IsInputLocked() && pActualPage && ( ANIMATIONMODE_SHOW == eAnimationMode ) )
	{
		// ggfs. an aktuelle Funktion weiterleiten
        if (!bNativeMode)
		{
			FuPoor* pFu = pViewShell->GetActualFunction();
			return pFu ? pFu->MouseButtonUp(rMEvt) : FALSE;
		}

		Point	aPos( pShowWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
		BOOL	bDone = FALSE;
		BOOL	bTryToPrepare = FALSE;	// Seitenvorbereitung versuchen

		LockDrawViewShell();

		// Maus im Zeichenmodus?
		if( !nMouseClickSema && bMouseIsDrawing )
		{
			bMouseIsDrawing = FALSE;

			if( aPos != aDownPos )
				bResult = bDone = TRUE;
		}

		// Control getroffen?
		if ( !bDone && ( ( pActualPage->GetPresChange() == PRESCHANGE_MANUAL ) || bManual ) )
		{
			SdrObject* pObj = NULL;

			//	MacroObjekt getroffen?
			SdrPageView* pDummy = NULL;
            pView->PickObj(aPos, pObj, pDummy, SDRSEARCH_PICKMACRO);
		}


		// Objekt mit ImageMap getroffen?
		SdrObject* pHitObject = OverObject(aPos);

		if( pHitObject )
		{
			IMapObject* pIMapObject = pDoc->GetHitIMapObject(pHitObject, aPos,
															 *pShowWindow);
			if (pIMapObject)
			{
				String      aURL(pIMapObject->GetURL());
                BOOL        bIsMasterPage;
                USHORT	    nPgNum = pDoc->GetPageByName( aURL, bIsMasterPage );
				SdrObject*  pObj   = NULL;

                if (nPgNum == SDRPAGE_NOTFOUND)
				{
					// Ist das Bookmark ein Objekt?
					pObj = pDoc->GetObj(aURL);
					if (pObj)
						nPgNum = pObj->GetPage()->GetPageNum();
				}

				if (nPgNum != SDRPAGE_NOTFOUND)
				{
					SfxStringItem aItem(SID_NAVIGATOR_OBJECT, aURL);
					( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->
					Execute(SID_NAVIGATOR_OBJECT, SFX_CALLMODE_SLOT |
							SFX_CALLMODE_RECORD, &aItem, 0L);

					bResult = bDone = TRUE;
				}
			}
		}

		// Objektaktion ausfuehren?
		SdrObject* pActionObject = OverObject( aPos );

		if( !bDone && aPos == aDownPos && pActionObject && HasAction( pActionObject ))
		{
			bDone = TRUE;

			// rechter Mausklick auf Objekt mit Aktion wird "verschluckt",
			// sonst wechselt womoeglich das Dia
			if (rMEvt.IsLeft())
				bResult = PerformAction(pActionObject);
			else
				bResult = FALSE;

			bTryToPrepare = TRUE;
		}

		// OLE-Objekt getroffen?
		if (!bDone &&
			aPos == aDownPos && rMEvt.IsLeft() &&
			( ( pActualPage->GetPresChange() == PRESCHANGE_MANUAL ) || bManual ) )
		{
/* #88210#: not available anymore (KA 15.06.2001)
			SdrObject* pObject = NULL;

			// Position umrechnen vom ShowWindow auf Seitenkoordinaten
			Point aPosOnPage = aPos - aPageOrigin;

            SdrPageView* pDummy = NULL;
            pView->PickObj(aPosOnPage, pObject, pDummy);

			// OLE-Objekt getroffen?
            if (pObject && pObject->GetObjInventor() == SdrInventor &&
                           pObject->GetObjIdentifier() == OBJ_OLE2)
			{
				if( DoVerb(pObject, 0) )
					bResult = bDone = TRUE;
			}
*/
		}

		// Objekt abblenden?
		if (!bDone && pDimObject && IsAdvanceEvent(aPos, aDownPos) && rMEvt.IsLeft())
		{
			// Gliederungsabsatz
			if(pDimObject->GetObjInventor() == SdrInventor &&
			   pDimObject->GetObjIdentifier() == OBJ_OUTLINETEXT)
			{
				DimLayoutParagraph();
				nDimPos = nParaPos;
			}
			else
				Dim((SdrAttrObj*)pDimObject, aDimRect.TopLeft(), aDimColor);

			// Ist das Objekt durch die Abblendung fuer die Darstellung zu
			// langsam geworden? Wenn ja, dann eine Ersatzdarstellung erzeugen.
			if( IsSlowObj( (SdrAttrObj*) pDimObject ) )
			{
				SdSlowObjRecord* pRec = GetSlowObjRecord((SdrAttrObj*)pDimObject);

				if( pRec )
				{
					pSlowObjList->Remove( (void*) pRec );
					delete pRec;
				}

				// falls das Objekt bis jetzt kein SlowObj war: Start- und Endlabel im Metafile aktualisieren
				if( CreateSlowObjRecord( (SdrAttrObj*) pDimObject ) && !pRec )
				{
					pMetaFile->ReplaceMarker( OBJ_START( pDimObject, FALSE ), OBJ_START( pDimObject, TRUE ) );
					pMetaFile->ReplaceMarker( OBJ_END( pDimObject, FALSE ), OBJ_END( pDimObject, TRUE ) );
				}
			}
			pDimObject = NULL;
			bResult = bDone = bTryToPrepare = TRUE;
		}

		// Objekt verstecken?
		if( !bDone && pHideObject && IsAdvanceEvent(aPos, aDownPos) && rMEvt.IsLeft() )
		{
			HideOrVanishObject( pHideObject, TRUE );
			pHideObject = NULL;
			bResult = bDone = bTryToPrepare = TRUE;
		}

		// Objektanimation?
		if( !bDone && IsAdvanceEvent( aPos, aDownPos ) && rMEvt.IsLeft() && pCurAnmList->Count() > 0 )
		{
			SdrObject* pObject = (SdrObject*) pCurAnmList->First();
			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);

			// Object verstecken ueber Effekt?
			if( presentation::AnimationEffect_HIDE == pInfo->eEffect )
				HideOrVanishObject( pObject, TRUE );
			else
			{
				// ansonsten einblenden ueber Effekt
				pInfo->bShow = TRUE;
				AnimateObject();
				pInfo->bIsShown = TRUE;

				if( AffectsOwnPage( pObject ) )
					nVisibleAffectingObjects++;
			}

			bResult = bDone = bTryToPrepare = TRUE;
		}

		// Diawechsel?
		if( !bDone && IsAdvanceEvent( aPos, aDownPos ) && !bLockedPages )
		{
			JumpToPage( aAnimPageList.CalcNextPageNum( !rMEvt.IsRight() ) );
			bResult = bDone = TRUE;
		}

		// Falls noch nicht geschehen und alle Animationen gelaufen sind:
		// die vermutlich naechste Seite im virtuellen Device vorbereiten
		if( bTryToPrepare && bVDevEmpty && !pCurAnmList->Count() &&
			!pDimObject && !pHideObject && !nVisibleAffectingObjects )
		{
			// remember the time we finished with animations
			nFadeInTime = Time::GetSystemTicks();

			const USHORT nNextPage = aAnimPageList.CalcNextPageNum( TRUE );

			if( nNextPage != aAnimPageList.GetCurrentPageNum() )
			{
				pShowView->HideAllPages();
				PrepareForPage( pDoc->GetSdPage( nNextPage, PK_STANDARD ), TRUE );
				bVDevEmpty = FALSE;
			}
		}

		UnlockDrawViewShell( FALSE );
	}

	return bResult;
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::KeyInput(const KeyEvent& rKEvt)
{
 	SfxInPlaceClient*	pClient = pViewShell ? pViewShell->GetUIActiveClient() : NULL;
	BOOL				bReturn = FALSE;

	if( !bReadyForNextInput )
		bReturn = TRUE;
	else if( pClient )
	{
		pClient->DoDisconnect();
		( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings().InvalidateAll( TRUE );
		bReturn = TRUE;
	}
	else if( !IsInputLocked() && pActualPage )
	{
		// ggfs. an aktuelle Funktion weiterleiten
		if( !bNativeMode )
		{
			FuPoor* pFu = pViewShell->GetActualFunction();
			return pFu ? pFu->KeyInput(rKEvt) : FALSE;
		}

		USHORT nPage = 0;
		USHORT nPageCount = pDoc->GetSdPageCount(PK_STANDARD);
		BOOL   bTrySlideChange = FALSE;

		LockDrawViewShell();

		switch( rKEvt.GetKeyCode().GetCode() )
		{
			// Show abbrechen
			case KEY_ESCAPE:
			{
				bReturn = TRUE;
				JumpToPage( PAGE_NO_END );
			}
			break;

			// Leertaste: naechste Objektanimation bzw. Diawechsel
			case KEY_SPACE:
			{
				bReturn = TRUE;

				// abblenden?
				if (pDimObject)
				{
					// Gliederungsabsatz
					if(pDimObject->GetObjInventor() == SdrInventor &&
					   pDimObject->GetObjIdentifier() == OBJ_OUTLINETEXT)
					{
						DimLayoutParagraph();
						nDimPos = nParaPos;
					}
					else
						Dim((SdrAttrObj*)pDimObject, aDimRect.TopLeft(), aDimColor);

					// Ist das Objekt durch die Abblendung fuer die Darstellung
					// zu langsam geworden? Wenn ja, dann eine
					// Ersatzdarstellung erzeugen.
					if( IsSlowObj( (SdrAttrObj*) pDimObject ) )
					{
						SdSlowObjRecord* pRec = GetSlowObjRecord( (SdrAttrObj*) pDimObject );

						if( pRec )
						{
                            pSlowObjList->Remove((void*)pRec);
							delete pRec;
						}

						// falls das Objekt bis jetzt kein SlowObj war, Start- und Endlabel im Metafile aktualisieren
						if( CreateSlowObjRecord( (SdrAttrObj*) pDimObject ) && !pRec )
						{
							pMetaFile->ReplaceMarker( OBJ_START( pDimObject, FALSE ), OBJ_START( pDimObject, TRUE ) );
							pMetaFile->ReplaceMarker( OBJ_END( pDimObject, FALSE ), OBJ_END( pDimObject, TRUE ) );
						}
					}

					pDimObject = NULL;
				}
				else if( pHideObject )
				{
					HideOrVanishObject( pHideObject, TRUE );
					pHideObject = NULL;
				}
				else if (pCurAnmList->Count() > 0)
				{
					// gibt's was zu animieren?
					SdrObject* pObject = (SdrObject*)pCurAnmList->First();
					SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);

					// Object verstecken ueber Effekt?
					if( presentation::AnimationEffect_HIDE == pInfo->eEffect )
						HideOrVanishObject( pObject, TRUE );
					else
					{
						// ansonsten einblenden ueber Effekt
						pInfo->bShow = TRUE;
						AnimateObject();
						pInfo->bIsShown = TRUE;
					}
				}
				else
				{
					// Diawechsel
					nPage = aAnimPageList.CalcNextPageNum( TRUE );
					bTrySlideChange = TRUE;
				}
			}
			break;

			// Puffer auswerten
			case KEY_RETURN:
			{
				USHORT nPageCount = pDoc->GetSdPageCount( PK_STANDARD );

				bReturn = TRUE;
				nPage = (USHORT) aCharBuffer.ToInt32();

				/* We use here a ByteString to be able to ask the string
				   wether he is a ASCII-number or not. If we use real
				   Unicode we have to think about a solution to ask for
				   a number, independed on the current charset */
				ByteString aStrTmp( aCharBuffer, RTL_TEXTENCODING_ASCII_US );

				// if it is a number choose this page
				if( aStrTmp.Len() && aStrTmp.IsNumericAscii() && aAnimPageList.IsPageNumIncluded( nPage - 1 ) )
					nPage--;
				else
					nPage = aAnimPageList.CalcNextPageNum( TRUE );

				aCharBuffer.Erase();
				bTrySlideChange = TRUE;
			}
			break;

			// Ziffer: in den Puffer schreiben
			case KEY_0:
			case KEY_1:
			case KEY_2:
			case KEY_3:
			case KEY_4:
			case KEY_5:
			case KEY_6:
			case KEY_7:
			case KEY_8:
			case KEY_9:
			{
				bReturn 	 = TRUE;
				aCharBuffer.Append( rKEvt.GetCharCode() );
			}
			break;

			case KEY_PAGEUP:
			case KEY_LEFT:
			{
				bReturn = TRUE;
				nPage = aAnimPageList.CalcNextPageNum( FALSE );
				bTrySlideChange = TRUE;
			}
			break;

			case KEY_PAGEDOWN:
			case KEY_RIGHT:
			{
				bReturn = TRUE;
				nPage = aAnimPageList.CalcNextPageNum( TRUE );
				bTrySlideChange = TRUE;
			}
			break;

			case KEY_HOME:
			{
				bReturn = TRUE;
				nPage = aAnimPageList.GetFirstPageNum();
				bTrySlideChange = TRUE;
			}
			break;

			case KEY_END:
			{
				bReturn = TRUE;
				nPage = aAnimPageList.GetLastPageNum();
				bTrySlideChange = TRUE;
			}
			break;

			default:
			break;
		}

		if( bTrySlideChange )
			JumpToPage( nPage );

		UnlockDrawViewShell( FALSE );
	}
	else if ( rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE )
		aEscapeTimer.Start();

	return bReturn;
}

// -----------------------------------------------------------------------------

void FuSlideShow::Activate()
{
	FuPoor::Activate();

    // wenn es kein ShowWindow gibt, wurde im Dialog 'Abbrechen' gewaehlt;
    // dann brauchen wir hier nichts tun
    if( pShowWindow && eAnimationMode == ANIMATIONMODE_SHOW )
    {
		SvtSaveOptions	aOptions;
		SfxDispatcher*	pDispatcher = ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher();

        pViewShell->Invalidate(SID_OBJECT_ALIGN);
        pViewShell->Invalidate(SID_ZOOM_TOOLBOX);
        pViewShell->Invalidate(SID_OBJECT_CHOOSE_MODE);
        pViewShell->Invalidate(SID_POSITION);
        pViewShell->Invalidate(SID_DRAWTBX_TEXT);
        pViewShell->Invalidate(SID_DRAWTBX_RECTANGLES);
        pViewShell->Invalidate(SID_DRAWTBX_ELLIPSES);
        pViewShell->Invalidate(SID_DRAWTBX_LINES);
        pViewShell->Invalidate(SID_DRAWTBX_ARROWS);
        pViewShell->Invalidate(SID_DRAWTBX_3D_OBJECTS);
        pViewShell->Invalidate(SID_DRAWTBX_CONNECTORS);
        pViewShell->Invalidate(SID_DRAWTBX_INSERT);

        // kein Autosave-Dialog in der Diashow
		if( aOptions.IsAutoSave() )
        {
            aOptions.SetAutoSave( FALSE );
			bAutoSaveSuppressed = TRUE;
        }

        // Slots, die in der SlideShow disabled werden sollen
        if( bNativeMode )
        {
	        // alle Popups bis auf den Navigator verstecken
			SfxBoolItem		aBoolItem( SID_SHOWPOPUPS, FALSE );
			SfxUInt16Item	aUInt16Item( SID_CONFIGITEMID, SID_NAVIGATOR );

			pDispatcher->Execute( SID_SHOWPOPUPS, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
								  &aBoolItem, &aUInt16Item, 0L );

            pDispatcher->SetSlotFilter( TRUE, sizeof(pAllowed) / sizeof(USHORT), pAllowed );
        }
        else
            pDispatcher->SetSlotFilter( TRUE, sizeof(pAllowedLive) / sizeof(USHORT), pAllowedLive );

        ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings().InvalidateAll(TRUE);
        pShowWindow->GrabFocus();
    }
}

// -----------------------------------------------------------------------------

void FuSlideShow::Deactivate()
{
	FuPoor::Deactivate();

    // wenn es kein ShowWindow gibt, wurde im Dialog 'Abbrechen' gewaehlt;
    // dann brauchen wir hier nichts tun
    if (pShowWindow && eAnimationMode == ANIMATIONMODE_SHOW)
    {
        // wenn Autosave unterdrueckt, dann wieder einschalten
        if (bAutoSaveSuppressed)
        {
            SvtSaveOptions aOptions;

		    aOptions.SetAutoSave( TRUE );
            bAutoSaveSuppressed = FALSE;
        }

		if( bNativeMode )
		{
	        SfxBoolItem	aBoolItem( SID_SHOWPOPUPS, TRUE );

			// Popups wieder einschalten
			( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->
				Execute( SID_SHOWPOPUPS, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
						 &aBoolItem, 0L );
		}
    }
}

// -----------------------------------------------------------------------------

void FuSlideShow::Paint(const Rectangle& rRect, SdWindow* pWin)
{
}

// -----------------------------------------------------------------------------

void FuSlideShow::JumpToPage( USHORT nNewPage )
{
	if( nNewPage != aAnimPageList.GetCurrentPageNum() )
	{
		if( !aAnimPageList.IsPageNumIncluded( nNewPage ) && ( nNewPage < PAGE_NO_FIRSTDEF ) )
			nNewPage = aAnimPageList.GetLastPageNum();
	}
	else
		bVDevEmpty = TRUE;

	aAnimPageList.MakePageNumCurrent( nNewPage );
	DoPageFade();

	SfxBindings& rBindings = ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings();
	rBindings.Invalidate( SID_NAVIGATOR_STATE );
	rBindings.Invalidate( SID_NAVIGATOR_PAGENAME );
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideShow, ObjectTimeOutHdl, Timer *, pTimer )
{
	bReadyForNextInput = TRUE;
	aTimer.Stop();

	if( bNativeMode )
	{
		// gibt's noch was zu animieren oder abzublenden?
		// dann noch einen Event schicken
		if( pCurAnmList->Count() > 0 || pDimObject || pHideObject )
		{
			// wir schicken uns zwei Event
			static Point aDefPoint;
			MouseEvent aMEvt(aDefPoint, 1, 0, MOUSE_LEFT, 0);
			MouseButtonDown(aMEvt);
			MouseButtonUp(aMEvt);

			// und dann nochmal versuchen
			aTimer.SetTimeout(50);		 // 50 Millisekunden
			aTimer.SetTimeoutHdl(LINK(this,FuSlideShow, ObjectTimeOutHdl));
			aTimer.Start();
		}

		// nein, laeuft Zeitnahme?
		else if( bRehearseTimings )
		{
			// wenn noch ein Sound vollstaendig abgespielt werden muss, spaeter
			// nochmal versuchen
			if (bPlayFull)
			{
				aTimer.SetTimeout(100); 	  // 100 Millisekunden
				aTimer.SetTimeoutHdl(LINK(this,FuSlideShow, ObjectTimeOutHdl));
				aTimer.Start();
			}
			else
			{
				// die Zeitnahme starten
				aSlideVisibleSince = Time();
				aTimer.SetTimeout(1000);		// 1 sec.
				aTimer.SetTimeoutHdl(LINK(this,FuSlideShow, TimeButtonTimeOutHdl));
				pTimeButton->Enable();				 // ab jetzt darf geklickt werden
				TimeButtonTimeOutHdl(&aTimer);
			}
		}
		else if( pActualPage->GetPresChange() == PRESCHANGE_AUTO )
		{
			ULONG nPrepareTime = Time::GetSystemTicks() - nFadeInTime;
			ULONG nTime = pActualPage->GetTime() * 1000;
			if( nTime <= nPrepareTime )
				nTime = 100;
			else
				nTime -= nPrepareTime;

			aTimer.SetTimeout( nTime );
			aTimer.SetTimeoutHdl( LINK( this,FuSlideShow, PageTimeOutHdl ) );
			aTimer.Start();
		}
	}

	return 0L;
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideShow, ReadyForNextInputHdl, void*, p )
{
   	aTimer.Stop();
	bReadyForNextInput = TRUE;

	return 0L;
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::IsAdvanceEvent(const Point& rDown, const Point& rUp) const
{
	const Point aDown( pShowWindow->LogicToPixel(rDown) );
	const Point aUp( pShowWindow->LogicToPixel(rUp) );
	BOOL		bResult;

	// wenn die Maus malen darf, muss auf dem gleichen Pixel geklickt werden
	// (sonst wird ja gemalt)
	if (bMouseAsPen)
		bResult = aDown == aUp;

	// wenn nicht, goennen wir unseren aelteren Usern einen Tatterkreis
	else
	{
		long nXQuad = aDown.X() - aUp.X();
		nXQuad *= nXQuad;
		long nYQuad = aDown.Y() - aUp.Y();
		nYQuad *= nYQuad;
		bResult = (nXQuad + nYQuad) < 400;
	}
	return bResult;
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::DoVerb(SdrObject* pObject, USHORT nVerb)
{
	DBG_ASSERT(pObject, "kein Objekt");

	// koennte ja auch ein Metafile sein
	SdrOle2Obj* pOleObject = PTR_CAST(SdrOle2Obj, pObject);
	BOOL		bRet = FALSE;

	if (pOleObject)
	{
		pViewShell->ActivateObject(pOleObject, nVerb);
		bRet = TRUE;
		return bRet;


//		Frueher, als OLE-Inplace noch funktionierte:
//
//		SvInPlaceObjectRef xIPObj = (pOleObject)->GetObjRef();
//		if ( xIPObj.Is() )
//		{
//			SvInPlaceClientRef xClient;
//			if (pClientList->Count())
//			{
//				for (USHORT n=0; n < pClientList->Count(); n++)
//				{
//					xClient = pClientList->GetObject(n);
//					if( !xClient->GetProtocol().IsOpen() )
//					{
//						break;
//					}
//				}
//			}
//
//
//            if (!xClient.Is())
//			{
//                xClient = new SfxInPlaceClient(pViewShell, pShowWindow);
//
//				if (xClient->GetEnv())
//					xClient->GetEnv()->SetDefaultUIAction(FALSE);
//
//				pClientList->Append(xClient);
//			}
//
//			if (!xIPObj->IsLink())
//				xIPObj->DoConnect(xClient);
//
//			if ( xIPObj->GetMiscStatus() & SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE )
//			{
//				Rectangle aRect = pOleObject->GetLogicRect();
//				MapMode aMapMode = pShowWindow->GetMapMode();
//
//				// Offset im Fenster und Raender beruecksichtigen
//				Point aTemp (aRect.TopLeft());
//				aTemp.X() += aPageOrigin.X() - pActualPage->GetLftBorder();
//				aTemp.Y() += aPageOrigin.Y() - pActualPage->GetUppBorder();
//				aRect.SetPos(aTemp);
//
//				if (xClient->GetEnv())
//					xClient->GetEnv()->SetObjArea(aRect);
//
//				bRet = ( xIPObj->DoVerb(nVerb) == ERRCODE_NONE );
//			}
//		}
	}

	return bRet;
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::Command(const CommandEvent& rCEvt)
{
	// ggfs. an aktuelle Funktion weiterleiten
    if ( !bNativeMode && ( eAnimationMode == ANIMATIONMODE_SHOW ) )
	{
		FuPoor* pFu = pViewShell->GetActualFunction();
		return pFu ? pFu->Command(rCEvt) : FALSE;
	}

	return FuPoor::Command( rCEvt );
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::RequestHelp(const HelpEvent& rHEvt)
{
	// ggfs. an aktuelle Funktion weiterleiten
    if ( !bNativeMode && ( eAnimationMode == ANIMATIONMODE_SHOW ) )
	{
		FuPoor* pFu = pViewShell->GetActualFunction();
		return pFu ? pFu->RequestHelp(rHEvt) : FALSE;
	}

	return FuPoor::RequestHelp(rHEvt);
}

// -----------------------------------------------------------------------------

void FuSlideShow::ReceiveRequest(SfxRequest& rReq)
{
	// Zuerst Basisklasse rufen
	FuPoor::ReceiveRequest(rReq);

	const SfxItemSet* pArgs 	 = rReq.GetArgs();
	USHORT			  nPageCount = pDoc->GetSdPageCount(PK_STANDARD);

	SfxViewFrame* pFrame = ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() );
	SfxFrameItem aFrameItem(SID_DOCFRAME, pFrame);

	switch ( rReq.GetSlot() )
	{
		case SID_NAVIGATOR_PEN:
			bMouseAsPen = !bMouseAsPen;
		break;

		case SID_NAVIGATOR_PAGE:
		{
			PageJump	eJump = (PageJump)((SfxAllEnumItem&) pArgs->Get(SID_NAVIGATOR_PAGE)).GetValue();
			USHORT		nPage;

			switch( eJump )
			{
				case PAGE_FIRST:
					nPage = aAnimPageList.GetFirstPageNum();
				break;

				case PAGE_LAST:
					nPage = aAnimPageList.GetLastPageNum();
				break;

				case PAGE_NEXT:
					nPage = aAnimPageList.CalcNextPageNum( TRUE );
				break;

				case PAGE_PREVIOUS:
					nPage = aAnimPageList.CalcNextPageNum( FALSE );
				break;

				default:
					nPage = aAnimPageList.GetCurrentPageNum();
				break;
			}

			JumpToPage( nPage );
		}
		break;

		case SID_NAVIGATOR_OBJECT:
		{
			String aBookmarkStr;
			aBookmarkStr += sal_Unicode('#');
			String aTarget = ((SfxStringItem&) pArgs->
								Get(SID_NAVIGATOR_OBJECT)).GetValue();
			aBookmarkStr.Append( aTarget );
			SfxStringItem aStrItem(SID_FILE_NAME, aBookmarkStr);
			SfxStringItem aReferer(SID_REFERER, pDocSh->GetMedium()->GetName());
			SfxFrameItem aFrameItem(SID_DOCFRAME, pFrame);
			SfxBoolItem aBrowseItem(SID_BROWSE, TRUE);
					//das sollte in FuSlideShow::JumpToBookmark enden
			pFrame->GetDispatcher()->
			Execute(SID_OPENDOC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
					&aStrItem, &aFrameItem, &aBrowseItem, &aReferer, 0L);
		}
		break;

		case SID_LIVE_PRESENTATION:
		{
			bNativeMode = !bNativeMode;

			// falls das Dokument bereits als geaendert gilt, diesen
			// Zustand merken, den gleich wird er zurueckgesetzt
			bDocChanged |= pDoc->IsChanged();

			// Raus aus dem Live-Modus
			if (bNativeMode)
			{
				// Texteingabe beenden und Selektion zuruecksetzen
				pView->EndTextEdit();
				pView->UnmarkAll();

				SetAnimationOwnerState( pView, TRUE );
				pView->SetAnimationEnabled(FALSE);

				// alle Popups bis auf den Navigator verstecken
				SfxBoolItem		aBoolItem(SID_SHOWPOPUPS, FALSE);
				SfxBoolItem		aDesignModeItem( SID_FM_DESIGN_MODE, FALSE );
				SfxUInt16Item	aUInt16Item(SID_CONFIGITEMID, SID_NAVIGATOR);
				SfxDispatcher*	pDispatcher = pFrame->GetDispatcher();

				pDispatcher->Execute(SID_SHOWPOPUPS, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
					&aBoolItem, &aUInt16Item, 0L);

				pDispatcher->Execute(SID_FM_DESIGN_MODE, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
					&aDesignModeItem, 0L);

				// falls im Live-Modus etwas veraendert wurde ...
				if( pActualPage && pDoc->IsChanged() )
				{
					SdPage* pMaster = (SdPage*) pActualPage->GetMasterPage( 0 );

					if( pMaster )
						pBckgndRect = pMaster->GetPresObj( PRESOBJ_BACKGROUND );

					pDocSh->SetWaitCursor( TRUE );
					CreateMarkerMetaFile( pActualPage );
					pCurAnmList->Remove( pLayoutText );
					pDimObject = NULL;
					pHideObject = NULL;
					RepaintVDev( pActualPage, FALSE );
					bVDevEmpty = TRUE;
					pDocSh->SetWaitCursor( FALSE );
				}

                // Slots, die in der SlideShow disabled werden sollen
                pDispatcher->SetSlotFilter(TRUE, sizeof(pAllowed) / sizeof(USHORT), pAllowed);
                ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings().InvalidateAll(TRUE);

				// automatischen Diawechsel ggf. wieder einschalten
				if( pActualPage && pActualPage->GetPresChange() == PRESCHANGE_AUTO )
				{
					ULONG nPrepareTime = Time::GetSystemTicks() - nFadeInTime;
					ULONG nTime = pActualPage->GetTime() * 1000;
					if( nTime <= nPrepareTime )
						nTime = 100;
					else
						nTime -= nPrepareTime;

					aTimer.SetTimeout( nTime );
					aTimer.SetTimeoutHdl( LINK( this,FuSlideShow, PageTimeOutHdl ) );
					aTimer.Start();
				}
			}
			// Rein in den Live-Modus
			else
			{
				// Hier wird analog zu drawdoc2.cxx ein MasterSlot umgemapped,
				// um einige nicht erlaubte Slots im Live-Modus zu unterbinden
				if( pViewShell->ISA( SdDrawViewShell) )
				{
					USHORT* pSlotArray = ( (SdDrawViewShell*) pViewShell )->GetSlotArray();
					pSlotArray[ 17 ] = SID_INSERT_DIAGRAM; // SID_DRAWTBX_INSERT;
				}

				SetAnimationOwnerState( pView, FALSE );
				pView->SetAnimationMode( bAnimationAllowed ? SDR_ANIMATION_ANIMATE : SDR_ANIMATION_DONT_ANIMATE );

                // damit keine 'verbotenen' Aktionen per Undo/Redo
                // ausgefuehrt werden koennen
                pDocSh->GetUndoManager()->Clear();

				// Selektionsdarstellung einblenden
				if (!pView->IsShownXorVisible(pShowWindow))
					pView->ShowShownXor(pShowWindow);

				// Popups einschalten
				SfxBoolItem		aBoolItem(SID_SHOWPOPUPS, TRUE);
				SfxBoolItem		aDesignModeItem( SID_FM_DESIGN_MODE, bDesignMode );
				SfxUInt16Item	aUInt16Item(SID_CONFIGITEMID, SID_NAVIGATOR);
				SfxDispatcher*	pDispatcher = pFrame->GetDispatcher();

				pDispatcher->Execute(SID_SHOWPOPUPS, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
					&aBoolItem, &aUInt16Item, 0L);

				pDispatcher->Execute(SID_FM_DESIGN_MODE, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
					&aDesignModeItem, 0L);

                // Slots, die im Live-Mode der SlideShow disabled werden sollen
                pDispatcher->SetSlotFilter(TRUE, sizeof(pAllowedLive) / sizeof(USHORT), pAllowedLive);
                ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings().InvalidateAll(TRUE);

				// automatischen Diawechsel ausschalten
				aTimer.Stop();
            }

			// das Modified-Flag zuruecksetzen, damit nach dem naechsten
			// Aufruf des Live-Modus entschieden werden kann, ob
			// Metafile, VDev usw. aktualisiert werden muessen
			pDoc->SetChanged(FALSE);

			// Damit der Live-Button auch upgedated wird
			( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings().Invalidate( SID_NAVIGATOR_STATE );

            pViewShell->Invalidate(SID_OBJECT_ALIGN);
            pViewShell->Invalidate(SID_ZOOM_TOOLBOX);
            pViewShell->Invalidate(SID_OBJECT_CHOOSE_MODE);
            pViewShell->Invalidate(SID_DRAWTBX_TEXT);
            pViewShell->Invalidate(SID_DRAWTBX_RECTANGLES);
            pViewShell->Invalidate(SID_DRAWTBX_ELLIPSES);
            pViewShell->Invalidate(SID_DRAWTBX_LINES);
            pViewShell->Invalidate(SID_DRAWTBX_ARROWS);
            pViewShell->Invalidate(SID_DRAWTBX_3D_OBJECTS);
            pViewShell->Invalidate(SID_DRAWTBX_CONNECTORS);
            pViewShell->Invalidate(SID_DRAWTBX_INSERT);
        }
		break;
	}
}
