/*************************************************************************
 *
 *  $RCSfile: fuslshw4.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: ka $ $Date: 2001/05/28 11:23:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#if defined( WIN ) || defined( WNT )
#include <tools/svwin.h>
#endif

#include <stdlib.h>
#include <math.h>
#include <svx/svditer.hxx>
#include <svx/xoutx.hxx>
#include <svx/outliner.hxx>
#ifndef _SVDOATTR_HXX //autogen
#include <svx/svdoattr.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include <svx/svdotext.hxx>
#endif

#define FUSLIDESHOW_INTERN
#include "fuslshow.hxx"
#include "mover.hxx"
#include "fader.hxx"
#include "strings.hrc"
#include "drawdoc.hxx"
#include "frmview.hxx"
#include "drviewsh.hxx"
#include "sdpage.hxx"
#include "docshell.hxx"
#include "sdresid.hxx"
#include "glob.hrc"
#include <svx/svxids.hrc>
#include "anminfo.hxx"
#include "cusshow.hxx"

#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#include "showview.hxx"
#include "drawview.hxx"

#ifndef _SVDVIEW_HXX //autogen
#include <svx/svdview.hxx>
#endif


/*************************************************************************
|*
|*    Vergleichsfkt. fuer QSort
|*
\************************************************************************/

struct SortStruct
{
	SdrObject*	pObj;
	ULONG		nOrder;
};

typedef SortStruct	SORT;
typedef SORT*		PSORT;

extern "C" int __LOADONCALLAPI SortFunc( const void* p1, const void* p2 )
{
	const PSORT pCmp1 = (const PSORT) p1;
	const PSORT pCmp2 = (const PSORT) p2;

	return ( pCmp1->nOrder < pCmp2->nOrder ? -1 : pCmp1->nOrder > pCmp2->nOrder ? 1 : 0 );
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::EnableFontSmoothing()
{
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::DisableFontSmoothing()
{
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::HandleError( const USHORT nStringId )
{
	ErrorBox( pShowWindow, WB_OK, String( SdResId( nStringId ) ) ).Execute();
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::Terminate()
{
	nMagic = 0;

	UnlockDrawViewShell( TRUE );
	pFader->Terminate();
	pMover->Terminate();
	bTerminated = TRUE;
	aTimer.Stop();

	while( nPushCount )
	{
		pShowWindow->Pop();
		nPushCount--;
	}

	JumpToPage( PAGE_NO_END );
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::InitPageModify()
{
	for( void* pObj = pCurAnimGraphs->First(); pObj; pObj = pCurAnimGraphs->Next() )
		StopTextOrGraphicAnimation( (SdrObject*) pObj, FALSE );

	pCurAnimGraphs->Clear(); 
	pNextAnimGraphs->Clear(); 
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::LockDrawViewShell()
{
	nIgnoreInputSmph++;

	if ( !bTerminated )
	{
		SdDrawViewShell* pShell = PTR_CAST( SdDrawViewShell, pDoc->GetDocSh()->GetViewShell() );

		if( pShell )
		{
			pShell->LockInput();
			nShellLockCount++;
		}
	}

	SfxBindings& rBind = ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetBindings();
		
	rBind.Invalidate( SID_CLOSEDOC );
	rBind.Invalidate( SID_PRESENTATION );
	rBind.Invalidate( SID_REHEARSE_TIMINGS );
	rBind.Update( SID_CLOSEDOC );
	rBind.Update( SID_PRESENTATION );
	rBind.Update( SID_REHEARSE_TIMINGS );
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::UnlockDrawViewShell( BOOL bUnlockFull )
{
	if( bUnlockFull )
		nIgnoreInputSmph = 0;
	else if( nIgnoreInputSmph )
		nIgnoreInputSmph--;

	if ( !bTerminated && pDoc && pDoc->GetDocSh() )
	{
		SdDrawViewShell* pShell = PTR_CAST( SdDrawViewShell, pDoc->GetDocSh()->GetViewShell() );

		if( pShell )
		{
			if( bUnlockFull )
			{
				for( ULONG i = 0UL; i < nShellLockCount; i++ )
					pShell->UnlockInput();

				nShellLockCount = 0UL;
			}
			else
			{
				pShell->UnlockInput();

				if( nShellLockCount )
					nShellLockCount--;
			}
		}
	}

	if( !nIgnoreInputSmph )
	{
        SfxViewFrame* pViewFrame = pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current();

        if( pViewFrame )
        {
		    SfxBindings& rBind = pViewFrame->GetBindings();

		    rBind.Invalidate( SID_CLOSEDOC );
		    rBind.Invalidate( SID_PRESENTATION );
		    rBind.Invalidate( SID_REHEARSE_TIMINGS );
	        rBind.Update( SID_CLOSEDOC );
	        rBind.Update( SID_PRESENTATION );
	        rBind.Update( SID_REHEARSE_TIMINGS );
        }
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::CreatePageList( BOOL bAll, BOOL bStartWithActualPage, const String& rPresPage )
{
	const long nPageCount = pDoc->GetSdPageCount( PK_STANDARD );

	if( nPageCount )
	{
		SdCustomShow*	pCustomShow;

		if( !bStartWithActualPage && pDoc->GetCustomShowList() && pDoc->IsCustomShow() )
			pCustomShow = (SdCustomShow*) pDoc->GetCustomShowList()->GetCurObject();
		else
			pCustomShow = NULL;

		if( !pCustomShow || !pCustomShow->Count() )
		{
			USHORT nFirstPage = 0;

			// normale Prsentation
			if( !bAll )
			{
				String aFirstName( rPresPage );

				if( aFirstName.Len() )
				{
					long nPage;
					BOOL bTakeNextAvailable = FALSE;

					for( nPage = 0, nFirstPage = 0xffff; ( nPage < nPageCount ) && ( 0xffff == nFirstPage ); nPage++ )
					{
						SdPage* pTestPage = pDoc->GetSdPage( (USHORT) nPage, PK_STANDARD );

						if( pTestPage->GetName() == aFirstName )
						{
							if( pTestPage->IsExcluded() )
								bTakeNextAvailable = TRUE;
							else
								nFirstPage = (USHORT) nPage;
						}
						else if( bTakeNextAvailable && !pTestPage->IsExcluded() )
							nFirstPage = (USHORT) nPage;
					}

					// wenn nicht gefunden (z. B. bei "Seite3")
					if( 0xffff == nFirstPage )
						nFirstPage = 0;
				}
			}

			for( USHORT i = 0; i < nPageCount; i++ )
				if( !( pDoc->GetSdPage( i, PK_STANDARD ) )->IsExcluded() || ANIMATIONMODE_PREVIEW == eAnimationMode )
					aAnimPageList.InsertPageNum( i );

			aAnimPageList.SetStartPage( nFirstPage );
		}
		else
		{
			if( eAnimationMode != ANIMATIONMODE_SHOW && rPresPage.Len() )
			{
				long nPage;

				for( nPage = 0; nPage < nPageCount; nPage++ )
					if( rPresPage == pDoc->GetSdPage( (USHORT) nPage, PK_STANDARD )->GetName() )
						break;

				if( nPage < nPageCount )
					aAnimPageList.InsertPageNum( (USHORT) nPage );
			}

			for( void* pCustomPage = pCustomShow->First(); pCustomPage; pCustomPage = pCustomShow->Next() )
			{
				const USHORT nSdPage = ( ( (SdPage*) pCustomPage )->GetPageNum() - 1 ) / 2;

				if( !( pDoc->GetSdPage( nSdPage, PK_STANDARD ) )->IsExcluded() || ANIMATIONMODE_PREVIEW == eAnimationMode )
					aAnimPageList.InsertPageNum( nSdPage );
			}
		}
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::StopTextOrGraphicAnimation( SdrObject* pObject, BOOL bAll )
{
	// Grafikanimation waehrend des Effekts unterbinden
	if ( OBJIS_GRAFANIM( pObject ) )
	{
		( (SdrGrafObj*) pObject )->StopAnimation( pShowWindow, (long) pObject );

		if ( bAll )
			( (SdrGrafObj*) pObject )->StopAnimation( pShowWindow );
	}

	// Textanimation waehrend des Effekts unterbinden
	if ( OBJIS_TEXTANIM( pObject ) )
	{
		( (SdrTextObj*) pObject )->StopTextAnimation( pShowWindow, (long) pObject );

		if ( bAll )
			( (SdrTextObj*) pObject )->StopTextAnimation( pShowWindow );
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::ResortAnmList( List& rAnmList )
{
	const ULONG nCount = rAnmList.Count();

	if ( nCount )
	{
		PSORT	pSort = new SORT[ nCount ];
		ULONG	nOrderIndex = 0UL;
		ULONG	nAppendIndex = LIST_APPEND - nCount;

		for( SdrObject* pObj = (SdrObject*) rAnmList.First(); pObj; pObj = (SdrObject*) rAnmList.Next() )
		{
			const SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pObj );
			PSORT					pSortTmp = &pSort[ nOrderIndex++ ];

			pSortTmp->pObj = pObj;
			pSortTmp->nOrder = ( pInfo->nPresOrder != LIST_APPEND ) ? pInfo->nPresOrder : nAppendIndex++;
		}

		// Liste loeschen, die Information steckt jetzt im Array
		rAnmList.Clear();

		// Array nach Ordnungsnummern sortieren
		qsort( pSort, nCount, sizeof( SORT ), SortFunc );

		// Animationliste neu aufbauen
		for( ULONG i = 0UL; i < nCount; i++ )
			rAnmList.Insert( pSort[ i ].pObj, LIST_APPEND );

		delete[] pSort;
	}
}


/*************************************************************************
|*
|* Time Out Handler fuer Escape
|*
\************************************************************************/

IMPL_LINK( FuSlideShow, EscapeHdl, Timer*, pTimer )
{
	pTimer->Stop();
	Terminate();

	return 0L;
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::SetAnimationOwnerState( SdrView* pOwnerView, BOOL bShowIsOwner )
{
	SdrPageView* pPageView = pOwnerView->GetPageView( pActualPage );

	if( pPageView )
	{
		SdrObjListIter	aMasterIter( *pActualPage->GetMasterPage( 0 ), IM_DEEPWITHGROUPS );
		SdrObjListIter	aIter( *pActualPage, IM_DEEPWITHGROUPS );

		for( SdrObject* pMasterO = aMasterIter.Next(); pMasterO; pMasterO = aMasterIter.Next() )
		{
			if( OBJIS_GRAFANIM( pMasterO ) )
				( (SdrGrafObj*) pMasterO )->SetAnimationSupervisor( pShowWindow, !bShowIsOwner );

			if( OBJIS_TEXTANIM( pMasterO ) )
				( (SdrTextObj*) pMasterO )->SetTextAnimationSupervisor( pShowWindow, !bShowIsOwner );
		}

		for( SdrObject* pO = aIter.Next(); pO; pO = aIter.Next() )
		{
			if( OBJIS_GRAFANIM( pO ) )
				( (SdrGrafObj*) pO )->SetAnimationSupervisor( pShowWindow, !bShowIsOwner );

			if( OBJIS_TEXTANIM( pO ) )
				( (SdrTextObj*) pO )->SetTextAnimationSupervisor( pShowWindow, !bShowIsOwner );
		}
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::UpdateVDevWithAnimations()
{
	SdrPageView* pPageView = pView->GetPageView( pActualPage );

	if ( pPageView )
	{
		SdrObjListIter	aMasterIter( *pActualPage->GetMasterPage( 0 ), IM_DEEPWITHGROUPS );
		SdrObjListIter	aIter( *pActualPage, IM_DEEPWITHGROUPS );

		for( SdrObject* pMasterO = aMasterIter.Next(); pMasterO; pMasterO = aMasterIter.Next() )
		{
			if( OBJIS_GRAFANIM( pMasterO ) )
			{
				const Rectangle aRect( ( (SdrGrafObj*) pMasterO )->GetAnimationRect( pShowWindow ) );
				pVDev->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
								   aRect.TopLeft(), aRect.GetSize(), *pShowWindow );
			}
		}

		for( SdrObject* pO = aIter.Next(); pO; pO = aIter.Next() )
		{
			if( OBJIS_GRAFANIM( pO ) )
			{
				const Rectangle aRect( ( (SdrGrafObj*) pO )->GetAnimationRect( pShowWindow ) );
				pVDev->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
								   aRect.TopLeft(), aRect.GetSize(), *pShowWindow );
			}
		}
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::DrawOrStartAnimation( SdrObject* pObj, OutputDevice* pOut,
										BOOL bStart, BOOL bTextObjs )
{
	if( bStart )
	{
		if( OBJIS_GRAFANIM( pObj ) )
		{
			const Rectangle	aRect( ( ( SdrGrafObj*) pObj )->GetAnimationRect( pOut ) );
			( (SdrGrafObj*) pObj )->StartAnimation( pOut, aRect.TopLeft(), aRect.GetSize(), (long) pObj );
		}

		if( bTextObjs && OBJIS_TEXTANIM( pObj ) )
			((SdrTextObj*)pObj)->StartTextAnimation( pShowWindow, Point(), (long) pObj );
	}
	else
	{
		ExtOutputDevice aOut( pOut );
		SdrPaintInfoRec aPaintInfoRec;
		const ULONG		nOldDrawMode = pOut->GetDrawMode();
		SdrObject*		pClone = pObj->Clone();

		SetPaintModes( (SdrView*) pView, NULL, &aOut, &aPaintInfoRec );

		if( OBJIS_GRAFANIM( pObj ) )
			( (SdrGrafObj*) pClone )->SetGraphic( ( (SdrGrafObj*) pObj )->GetTransformedGraphic().GetBitmapEx() );

		if( OBJIS_TEXTANIM( pObj ) )
		{
			SfxItemSet aTempAttr( pDoc->GetPool(), SDRATTR_TEXT_ANIKIND, SDRATTR_TEXT_ANIKIND );

			aTempAttr.Put(pClone->GetItemSet());

			aTempAttr.Put( SdrTextAniKindItem() );

			pClone->SetItemSet(aTempAttr);
		}

		pOut->SetDrawMode( pShowWindow->GetDrawMode() );
		pClone->Paint( aOut, aPaintInfoRec );
		pOut->SetDrawMode( nOldDrawMode );
		delete pClone;
	}


}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void FuSlideShow::RepaintVDev( SdrPage* pRepaintPage, BOOL bOnlyMaster )
{
	const ULONG nOldDrawMode = pVDev->GetDrawMode();
	FASTBOOL	bCached = FALSE;

	pVDev->SetDrawMode( DRAWMODE_DEFAULT );
	pVDev->Erase();
	pVDev->SetDrawMode( nOldDrawMode );

	if( pShowView->IsMasterPagePaintCaching() && ( nMasterPageCacheMode == SDR_MASTERPAGECACHE_FULL ) )
	{
		ExtOutputDevice	aOut( pVDev );
		SdrPaintInfoRec	aInfoRec;
		SdrPageView*	pPageView = pShowView->GetPageView( pRepaintPage );

		if( pPageView )
		{
			aInfoRec.aPaintLayer = pRepaintPage->GetMasterPageVisibleLayers( 0 );
			aInfoRec.aDirtyRect = Rectangle( aPageOrigin, aPageSize );
			aInfoRec.pPV = pPageView;
			aInfoRec.nPaintMode = SDRPAINTMODE_MASTERPAGE;
			bCached = pPageView->DoCachedMasterPaint((SdPage*) pRepaintPage->GetMasterPage( 0 ),aOut,aInfoRec);
		}
	}

	if( bOnlyMaster )
	{
		if( !bCached )
			pMetaFile->Play( pVDev, MTF_START, FIRST_START );
	}
	else
	{
		if( bCached )
			pMetaFile->Play( pVDev, FIRST_START, MTF_END );
		else
			pMetaFile->Play( pVDev, MTF_START, MTF_END );
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

SdViewShell* FuSlideShow::GetDrawViewShellForShow() const
{
	SfxViewShell*	pShell = SfxViewShell::Current();
	SdViewShell*	pViewSh = PTR_CAST( SdViewShell, pShell );

	if ( !pViewSh && pDocSh )
		pViewSh = pDocSh->GetViewShell();

	return pViewSh;
}

