/*************************************************************************
 *
 *  $RCSfile: TemplateThread.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: af $ $Date: 2001/05/17 13:37:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef	_TEMPLATE_THREAD_HXX
#define	_TEMPLATE_THREAD_HXX

#ifndef _UCBHELPER_CONTENT_HXX 
#include <ucbhelper/content.hxx>
#endif

#ifndef _COM_SUN_STAR_FRAME_XDOCUMENTTEMPLATES_HPP_
#include <com/sun/star/frame/XDocumentTemplates.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_ 
#include <com/sun/star/ucb/XContentAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_ 
#include <com/sun/star/sdbc/XRow.hpp>
#endif

#ifndef _THREAD_HXX_
#include <osl/thread.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#include <vector>


/**	@descr	Representation of a template or layout file.
*/
class TemplateEntry
{
public:
	TemplateEntry	(const String& rTitle, const String& rPath)
		:	m_aTitle (rTitle), m_aPath  (rPath)	{}

	String m_aTitle;
	String m_aPath;
};



/**	@descr	Representation of a template or layout folder.
*/
class TemplateDir
{
public:
	TemplateDir	(const String & rRegion, const String & rUrl )
		:	m_aRegion(rRegion), m_aUrl(rUrl)	{}

	String						m_aRegion;
	String						m_aUrl;
	std::vector<TemplateEntry*>	m_aEntries;
};




/**	@descr	This thread scans the template folders for impress templates
		and puts them into listboxes.  After the scan is finished it
		calls a callback function to inform its caller of that.
*/
class	TemplateThread	
	:	public	::osl::Thread
{
public:
	/**	@descr	Creation of a new thread.  Note that the destructor is declared
    		private!
		@param	aFolderList	The data structure to fill with information about
			the template folders.
		@param	pCallback	A pointer to the callback function that is called
			after finishing reading the template and history files.
		@param	pData		Data that is passed to the callback.  This can
			be for instance an object pointer, so that the callback function
			can call an apropriate method of that object.
	*/
	TemplateThread	(std::vector<TemplateDir*> & aFolderList,
					void (*pCallback)(void*data),
					void * pData);

    /**	@descr	A call to this method detaches a thread from it's creator.
    		Any firther call to the thread is an error.  The thread will
            kill itself eventually.
    */
	void SAL_CALL	detach	(void);

protected:
	/**	@descr	Set the member mxTemplateRoot to the XContent that 
			represents the root of the template tree.
	*/
	void	ScanFolders		(void);

	/**	@descr	Scan the given template folder for impress templates and insert
		them into the given list.
		@param	rRoot	specifies the folder to search.
		@param	pDir	The list into which the entries for the impress
			templates are to be inserted.
	*/
	void	ScanEntries		(::ucb::Content & rRoot, TemplateDir * pDir);
	
	/**	@descr	Obtain the root folder of the template folder hierarchy.
			The result is stored in mxTemplateRoot for later use.
	*/
	void	GetTemplateRoot	(void);
	
	/**	@descr	This virutal method is called (among others?) from the inherted
			create method and acts as the main function of this thread.
	*/
	virtual void SAL_CALL	run	(void);

    /**	@descr	Called after the thread is terminated via the terminate method.
    		Used to kill the thread by calling delete on this.
    */	
    virtual void SAL_CALL	onTerminated	(void);

private:
	/**	@descr	The destructor is declared private so that only the thread 
    		is able to delete itself.  Use detach instead.
    */
	virtual	~TemplateThread	(void);

	/**	@descr	A reference to the data structure that is to be filled 
			with information about the template files.
	*/
	std::vector<TemplateDir*>	&	maFolderList;
	
	/**	@descr	The root folder of the template folders.
	*/
	com::sun::star::uno::Reference<com::sun::star::ucb::XContent>	
		mxTemplateRoot;
	
	/**	@descr	A pointer to the function that is called after the completion
			of the template scanning.
	*/
	void	(*mpCallback)	(void*);
	
	/**	@descr	The data passed to the callback function.  Typically an object
			pointer.
	*/
	void	*	mpData;
    
    /**	@descr	Mutex guarding the two following flags mbIsDetached and 
    		mbIsterminated.
    */
	::osl::Mutex	maMutex;
    
    /**	@descr	Flag that indicates if this thread has been detached and may
    		delete itself.
    */
	BOOL	mbIsDetached;
    
    /**	@descr	Flag that indicates wether the onTerminated method has been
    		already called.  If so then a subsequent call to detach deletes
            the thread. 
    */
	BOOL	mbIsTerminated;
};

#endif
