/*************************************************************************
 *
 *  $RCSfile: basemodel.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/18 15:40:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SD_BASEMODEL_HXX_
#define _SD_BASEMODEL_HXX_

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include <com/sun/star/container/XChild.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif

#ifndef	 _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif

#ifndef  _COM_SUN_STAR_DOCUMENT_XDOCUMENTINFO_HPP_
#include <com/sun/star/document/XDocumentInfo.hpp>
#endif

#ifndef  _COM_SUN_STAR_DOCUMENT_XDOCUMENTINFOSUPPLIER_HPP_
#include <com/sun/star/document/XDocumentInfoSupplier.hpp>
#endif

#ifndef  _COM_SUN_STAR_DOCUMENT_XEVENTBROADCASTER_HPP_
#include <com/sun/star/document/XEventBroadcaster.hpp>
#endif

#ifndef  _COM_SUN_STAR_DOCUMENT_XEVENTLISTENER_HPP_
#include <com/sun/star/document/XEventListener.hpp>
#endif

#ifndef  _COM_SUN_STAR_DOCUMENT_XEVENTSSUPPLIER_HPP_
#include <com/sun/star/document/XEventsSupplier.hpp>
#endif

#ifndef  _COM_SUN_STAR_DOCUMENT_EVENTOBJECT_HPP_
#include <com/sun/star/document/EventObject.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFYLISTENER_HPP_
#include <com/sun/star/util/XModifyListener.hpp>
#endif

#ifndef _COM_SUN_STAR_VIEW_XPRINTABLE_HPP_
#include <com/sun/star/view/XPrintable.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_EVENTOBJECT_HPP_
#include <com/sun/star/lang/EventObject.hpp>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

#ifndef _COM_SUN_STAR_SCRIPT_XSTARBASICACCESS_HPP_
#include <com/sun/star/script/XStarBasicAccess.hpp>
#endif

#ifndef	_OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

//________________________________________________________________________________________________________
//	include of my own project
//________________________________________________________________________________________________________

#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif

//________________________________________________________________________________________________________
//	defines
//________________________________________________________________________________________________________

// Some defines to write better code :-)
#define	XCHILD					::com::sun::star::container::XChild
#define	XNAMECONTAINER			::com::sun::star::container::XNameContainer
#define	XCONTROLLER				::com::sun::star::frame::XController
#define	XEVENTLISTENER			::com::sun::star::lang::XEventListener
#define	XINTERFACE				::com::sun::star::uno::XInterface
#define XCOMPONENT              ::com::sun::star::lang::XComponent
#define	XMODEL					::com::sun::star::frame::XModel
#define	XMODIFIABLE				::com::sun::star::util::XModifiable
#define	XMODIFIABLE				::com::sun::star::util::XModifiable
#define XMODIFYBROADCASTER      ::com::sun::star::util::XModifyBroadcaster
#define	XMODIFYLISTENER			::com::sun::star::util::XModifyListener
#define	XPRINTABLE				::com::sun::star::view::XPrintable
#define	XSTORABLE				::com::sun::star::frame::XStorable
#define	XTYPEPROVIDER			::com::sun::star::lang::XTypeProvider
#define	XSTARBASICACCESS		::com::sun::star::script::XStarBasicAccess
#define	NOSUCHELEMENTEXCEPTION	::com::sun::star::container::NoSuchElementException
#define	ELEMENTEXISTEXCEPTION	::com::sun::star::container::ElementExistException
#define XNAMEREPLACE			::com::sun::star::container::XNameReplace

#define	DOCEVENTOBJECT			::com::sun::star::document::EventObject
#define	XDOCEVENTLISTENER		::com::sun::star::document::XEventListener
#define	XDOCUMENTINFO			::com::sun::star::document::XDocumentInfo
#define	XDOCUMENTINFOSUPPLIER	::com::sun::star::document::XDocumentInfoSupplier
#define	XEVENTBROADCASTER		::com::sun::star::document::XEventBroadcaster
#define	XEVENTSSUPPLIER			::com::sun::star::document::XEventsSupplier

#define	NOSUPPORTEXCEPTION		::com::sun::star::lang::NoSupportException
#define	RUNTIMEEXCEPTION		::com::sun::star::uno::RuntimeException
#define	PROPERTYVETOEXCEPTION		::com::sun::star::beans::PropertyVetoException

#define	ANY						::com::sun::star::uno::Any
#define	EVENTOBJECT				::com::sun::star::lang::EventObject
#define	PROPERTYVALUE			::com::sun::star::beans::PropertyValue
#define	REFERENCE				::com::sun::star::uno::Reference
#define	SEQUENCE				::com::sun::star::uno::Sequence
#define	MUTEX					::osl::Mutex
#define	OUSTRING				::rtl::OUString
#define	OWEAKOBJECT				::cppu::OWeakObject
#define	UNOTYPE					::com::sun::star::uno::Type

//________________________________________________________________________________________________________
//	class declarations
//________________________________________________________________________________________________________

class SdDrawDocShell;
struct IMPL_SdBaseModel_DataContainer;

struct IMPL_SdBaseModel_MutexContainer
{
	MUTEX m_aMutex ;
} ;

class SdBaseModel	:	public XTYPEPROVIDER
					,	public XCHILD
					,	public XDOCUMENTINFOSUPPLIER
					,	public XEVENTBROADCASTER
					,	public XEVENTLISTENER
					,	public XEVENTSSUPPLIER
					,	public XMODEL
					,	public XMODIFIABLE
					,	public XSTARBASICACCESS
					,	public IMPL_SdBaseModel_MutexContainer
					,	public SfxListener
					,	public OWEAKOBJECT
{
public:

	SdBaseModel( SdDrawDocShell *pObjektShell = NULL ) ;
	virtual ~SdBaseModel() ;

	// XInterface
	virtual ANY SAL_CALL queryInterface( const UNOTYPE& rType ) throw( RUNTIMEEXCEPTION ) ;
    virtual void SAL_CALL acquire() throw() ;
    virtual void SAL_CALL release() throw() ;

	// XTypeProvider
	virtual SEQUENCE< UNOTYPE > SAL_CALL getTypes() throw( RUNTIMEEXCEPTION ) ;
	virtual SEQUENCE< sal_Int8 > SAL_CALL getImplementationId() throw( RUNTIMEEXCEPTION ) ;

	// XStarBasicAccess
    virtual REFERENCE< XNAMECONTAINER > SAL_CALL getLibraryContainer() throw( RUNTIMEEXCEPTION );
    virtual void SAL_CALL createLibrary( const OUSTRING& LibName, const OUSTRING& Password, const OUSTRING& ExternalSourceURL, const OUSTRING& LinkTargetURL ) throw(ELEMENTEXISTEXCEPTION, RUNTIMEEXCEPTION);
    virtual void SAL_CALL addModule( const OUSTRING& LibraryName, const OUSTRING& ModuleName, const OUSTRING& Language, const OUSTRING& Source ) throw( NOSUCHELEMENTEXCEPTION, RUNTIMEEXCEPTION);
    virtual void SAL_CALL addDialog( const OUSTRING& LibraryName, const OUSTRING& DialogName, const ::com::sun::star::uno::Sequence< sal_Int8 >& Data ) throw(NOSUCHELEMENTEXCEPTION, RUNTIMEEXCEPTION);

	// XChild
    virtual REFERENCE< XINTERFACE > SAL_CALL getParent() throw( RUNTIMEEXCEPTION ) ;
    virtual void SAL_CALL setParent( const REFERENCE< XINTERFACE >& xParent ) throw( NOSUPPORTEXCEPTION, RUNTIMEEXCEPTION );

	// XComponent
	virtual void SAL_CALL dispose() throw (RUNTIMEEXCEPTION);
	virtual void SAL_CALL addEventListener(const REFERENCE< XEVENTLISTENER >& aListener) throw (RUNTIMEEXCEPTION);
	virtual void SAL_CALL removeEventListener(const REFERENCE< XEVENTLISTENER >& aListener ) throw (RUNTIMEEXCEPTION);

	// XDocumentInfoSupplier
	virtual REFERENCE< XDOCUMENTINFO > SAL_CALL getDocumentInfo() throw (RUNTIMEEXCEPTION);

	// XEventListener
	virtual void SAL_CALL disposing( const EVENTOBJECT& aEvent ) throw (RUNTIMEEXCEPTION);
	virtual sal_Bool SAL_CALL attachResource( const	OUSTRING& sURL, const SEQUENCE< PROPERTYVALUE >& aArgs ) throw (RUNTIMEEXCEPTION);
	virtual OUSTRING SAL_CALL getURL() throw (RUNTIMEEXCEPTION);
	virtual SEQUENCE< PROPERTYVALUE > SAL_CALL getArgs() throw (RUNTIMEEXCEPTION);
	virtual void SAL_CALL connectController( const REFERENCE< XCONTROLLER >& xController ) throw (RUNTIMEEXCEPTION);
	virtual void SAL_CALL disconnectController( const REFERENCE< XCONTROLLER >& xController ) throw (RUNTIMEEXCEPTION);
	virtual void SAL_CALL lockControllers() throw (RUNTIMEEXCEPTION);
	virtual void SAL_CALL unlockControllers() throw (RUNTIMEEXCEPTION);
	virtual sal_Bool SAL_CALL hasControllersLocked() throw (RUNTIMEEXCEPTION);
	virtual REFERENCE< XCONTROLLER > SAL_CALL getCurrentController() throw (RUNTIMEEXCEPTION);
	virtual void SAL_CALL setCurrentController( const REFERENCE< XCONTROLLER >& xController ) throw (NOSUCHELEMENTEXCEPTION, RUNTIMEEXCEPTION);
	virtual REFERENCE< XINTERFACE > SAL_CALL getCurrentSelection() throw (RUNTIMEEXCEPTION);

	// XModifiable
	virtual sal_Bool SAL_CALL isModified() throw (RUNTIMEEXCEPTION);
	virtual void SAL_CALL setModified( sal_Bool bModified ) throw (PROPERTYVETOEXCEPTION, RUNTIMEEXCEPTION);
    virtual void SAL_CALL addModifyListener( const REFERENCE< XMODIFYLISTENER >& xListener ) throw( RUNTIMEEXCEPTION );
    virtual void SAL_CALL removeModifyListener(const REFERENCE< XMODIFYLISTENER > & xListener) throw( RUNTIMEEXCEPTION );

	// XEventsSupplier
    virtual REFERENCE< XNAMEREPLACE > SAL_CALL getEvents() throw( RUNTIMEEXCEPTION );

	// XEventBroadcaster
    virtual void SAL_CALL addEventListener( const REFERENCE< XDOCEVENTLISTENER >& xListener ) throw( RUNTIMEEXCEPTION );
    virtual void SAL_CALL removeEventListener( const REFERENCE< XDOCEVENTLISTENER >& xListener ) throw( RUNTIMEEXCEPTION );

	//	SfxListener
	void Notify( SfxBroadcaster& aBC, const	SfxHint& aHint );

	// public IMPL?
	void changing() ;
	void impl_change() ;

	SdDrawDocShell* GetObjectShell() const ;
	sal_Bool IsDisposed() const ;

private:
//	void	postEvent_Impl( const SfxEventHint& rHint );
//	String	getEventName_Impl( long nID );

private:
	IMPL_SdBaseModel_DataContainer*	m_pData	;

};

#endif

