/*************************************************************************
 *
 *  $RCSfile: slidvish.cxx,v $
 *
 *  $Revision: 1.14.6.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/06/01 03:12:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _ZOOMITEM_HXX
#include <svx/zoomitem.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SV_SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
#ifndef _SV_POLY_HXX //autogen
#include <vcl/poly.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SD_OPTSITEM_HXX
#include "optsitem.hxx"
#endif
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SFX_TOPFRM_HXX //autogen wg. SfxTopViewFrame
#include <sfx2/topfrm.hxx>
#endif

#include "app.hrc"
#include "strings.hrc"
#include "glob.hrc"
#include "res_bmp.hrc"

#include "drawdoc.hxx"
#include "docshell.hxx"
#include "slidvish.hxx"
#include "presvish.hxx"
#include "slidview.hxx"
#include "sdwindow.hxx"
#include "fupoor.hxx"
#include "fuzoom.hxx"
#include "fuscale.hxx"
#include "fuslsel.hxx"
#include "fuslshow.hxx"
#include "fuslprms.hxx"
#include "fuslhide.hxx"
#include "fusldlg.hxx"
#include "sdpage.hxx"
#include "pres.hxx"
#include "frmview.hxx"
#include "sdresid.hxx"
#include "sdattr.hxx"
#include "diactrl.hxx"
#include "zoomlist.hxx"
#include "prevchld.hxx"
#include "preview.hxx"
#include "slidchld.hxx"
#include "fuexpand.hxx"
#include "fusumry.hxx"
#include "fucushow.hxx"
#include "sdxfer.hxx"

using namespace ::com::sun::star;

//==================================================================

SFX_DECL_TYPE(13);

#define SdSlideViewShell
#include "sdslots.hxx"

#define MIN_ZOOM	       10       // Minimaler Zoomfaktor
#define MAX_ZOOM	       68	    // Maximaler Zoomfaktor


SFX_IMPL_INTERFACE(SdSlideViewShell, SfxViewShell, SdResId(STR_SLIDEVIEWSHELL))
{
	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_TOOLS | SFX_VISIBILITY_STANDARD |
								SFX_VISIBILITY_FULLSCREEN | SFX_VISIBILITY_SERVER,
								SdResId(RID_SLIDE_TOOLBOX) );
	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, SdResId(RID_SLIDE_OBJ_TOOLBOX) );
	SFX_CHILDWINDOW_REGISTRATION( SdSlideChangeChildWindow::GetChildWindowId() );
	SFX_CHILDWINDOW_REGISTRATION( SdPreviewChildWindow::GetChildWindowId() );
}

SFX_IMPL_VIEWFACTORY(SdSlideViewShell, SdResId(STR_SPECIALVIEW))
{
	SFX_VIEW_REGISTRATION(SdDrawDocShell);
}

TYPEINIT1( SdSlideViewShell, SdViewShell );


/*************************************************************************
|*
|* gemeinsamer Initialiserungsanteil der beiden Konstruktoren
|*
\************************************************************************/

void SdSlideViewShell::Construct(SdDrawDocument* pDoc)
{
	pSlideView = new SdSlideView(pDoc, pWindow, this);
	pView = pSlideView; 		  // Pointer der Basisklasse SdViewShell

	pWindow->SetMinZoom( MIN_ZOOM );
	pWindow->SetMaxZoom( MAX_ZOOM );

	ReadFrameViewData(pFrameView);

	SetPool( &pDoc->GetPool() );

	SetUndoManager( pDoc->GetDocSh()->GetUndoManager() );

	SetZoom(100);

	USHORT nNoOfPages	= pDoc->GetSdPageCount(PK_STANDARD);
	USHORT nPagesPerRow = pSlideView->GetPagesPerRow();
	Size   aPageSize	= pSlideView->GetPageArea(0).GetSize();
	ULONG  nGapX		= pSlideView->GetPageGap();
	ULONG  nGapY		= nGapX;

	Size aViewSize(nPagesPerRow * aPageSize.Width() +
				   (nPagesPerRow + 1) * nGapX,
				   pSlideView->CalcPagePos(nNoOfPages-1).Y() +
				   aPageSize.Height() + nGapY);
	Point aWinPos (0, 0);
	Point aViewOrigin(0, 0);

	aSlideBtn.Check(TRUE);

	InitWindows(aViewOrigin, aViewSize, aWinPos);

	String aName( RTL_CONSTASCII_USTRINGPARAM( "SlideViewShell" ));
	SetName (aName);

	SetHelpId( SD_IF_SDSLIDEVIEWSHELL );
	pWindow->SetHelpId( SD_IF_SDSLIDEVIEWSHELL );
	pWindow->SetUniqueId( SD_IF_SDSLIDEVIEWSHELL );
}

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

SdSlideViewShell::SdSlideViewShell(SfxViewFrame* pFrame, SfxViewShell* pOldShell)
  : SdViewShell(pFrame, &pFrame->GetWindow()   /*, FALSE */),
	bSetInitialZoomFactor(TRUE),
	bInitializeWinPos(TRUE)
{
	if (pOldShell)
	{
		pFrameView = ( (SdViewShell*) pOldShell)->GetFrameView();
	}
	else
	{
		pFrameView = new FrameView(pDoc);
	}

	pFrameView->Connect();

	Construct(pDoc);

	// Selektionsfunktion starten
	SfxRequest aReq(SID_OBJECT_SELECT, 0, pDoc->GetItemPool());
	FuPermanent(aReq);
}


/*************************************************************************
|*
|*	  Beschreibung		Copy-Konstruktor
|*
\************************************************************************/

SdSlideViewShell::SdSlideViewShell(SfxViewFrame* pFrame,
								   const SdSlideViewShell& rShell)
   : SdViewShell(pFrame, rShell),
	 bInitializeWinPos(TRUE)
{
	pFrameView = new FrameView(pDoc);
	pFrameView->Connect();

	Construct(pDoc);
}

/*************************************************************************
|*
|* Destruktor, setzt Mehrfachselektion der Seiten zurueck
|* auf einfache Selektion
|*
\************************************************************************/

SdSlideViewShell::~SdSlideViewShell()
{
	if (pFuActual)
	{
		if (pFuOld == pFuActual)
			pFuOld = NULL;

		pFuActual->Deactivate();
		delete pFuActual;
		pFuActual = NULL;
	}

	if (pFuOld)
	{
		delete pFuOld;
		pFuOld = NULL;
	}

	SdPage* pTestPage	   = NULL;
	USHORT	nNoOfPages	   = pDoc->GetSdPageCount(PK_STANDARD);
	BOOL	bSelectedFound = FALSE;

	for (USHORT nPage = 0; nPage < nNoOfPages; nPage++)
	{
		pTestPage = pDoc->GetSdPage(nPage, PK_STANDARD);
		if (pTestPage->IsSelected())
		{
			if (bSelectedFound)
				pDoc->SetSelected(pTestPage, FALSE);
			else
				bSelectedFound = TRUE;
		}
	}
	if (!bSelectedFound && nNoOfPages > 0)
	{
		pDoc->SetSelected( (SdPage*)pDoc->GetSdPage(0, PK_STANDARD), TRUE);
	}

	delete pSlideView;

	pFrameView->Disconnect();
}

/*************************************************************************
|*
|* Optimale Groesse zurueckgeben
|*
\************************************************************************/

Size SdSlideViewShell::GetOptimalSizePixel() const
{
	// erstmal das "optimale" SdWindow berechnen
	USHORT nNoOfPages	= pDoc->GetSdPageCount(PK_STANDARD);
	USHORT nPagesPerRow = Min(nNoOfPages, pSlideView->GetPagesPerRow());
	USHORT nRows		= nNoOfPages / nPagesPerRow;
	if (nNoOfPages % nPagesPerRow)
		nRows++;
	Size   aPageSize	= pDoc->GetSdPage(0, PK_STANDARD)->GetSize();
	long   nGap 		= pSlideView->GetPageGap();
	long   nWidth		= nPagesPerRow * aPageSize.Width() +
						   (nPagesPerRow + 1) * nGap;
	long   nHeight		= aPageSize.Height();

	// angestrebtes Hoehen-Seiten-Verhaeltnis ist 3 zu 4
	USHORT nVisibleRows = 1;
	while (nVisibleRows < nRows && (4 * nHeight < 3 * nWidth))
	{
		nVisibleRows++;
		nHeight += aPageSize.Height() + nGap;
	}

	Size aResult(nWidth, nHeight);
	aResult = pWindow->LogicToPixel(aResult);

	// und jetzt jetzt das Standardgelumpe draufaddieren
	aResult.Width()  += pVScrlArray[0]->GetSizePixel().Width();
	aResult.Height() += pHScrlArray[0]->GetSizePixel().Height();

	return aResult;
}

/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird vom Fenster pWindow an
|* die Viewshell und die aktuelle Funktion weitergeleitet
|*
\************************************************************************/

void SdSlideViewShell::Paint(const Rectangle& rRect, SdWindow* pWin)
{
	pSlideView->Paint(rRect, pWin);

	if ( pDocSh->GetActualFunction() )
	{
		pDocSh->GetActualFunction()->Paint(rRect, pWin);
	}

	if (pFuActual)
	{
		pFuActual->Paint(rRect, pWin);
	}
}

/*************************************************************************
|*
|* View-Groesse (und Position bei OLE) aendern und Scrollbars
|* entsprechend anpassen
|*
\************************************************************************/

void SdSlideViewShell::AdjustPosSizePixel(const Point &rNewPos,
										  const Size &rNewSize)
{
	SdViewShell::AdjustPosSizePixel(rNewPos, rNewSize);

	// initialen Zoomfaktor setzen?
	if (bSetInitialZoomFactor && rNewSize.Width() && rNewSize.Height())
	{
		bSetInitialZoomFactor = FALSE;	// nie wieder !!!

		Size	aPageSize	 = pSlideView->GetPageArea(0).GetSize();
		USHORT	nNoOfPages	 = pDoc->GetSdPageCount(PK_STANDARD);
		USHORT	nPagesPerRow = Min(nNoOfPages, pSlideView->GetPagesPerRow());
		long	nGapX		 = pSlideView->GetPageGap();
		long	nMinWidth	 = nPagesPerRow * aPageSize.Width() +
							   (nPagesPerRow + 1) * nGapX;
		long	nMinHeight	 = pSlideView->CalcPagePos(0).Y() +
							   pSlideView->GetPageArea(0).GetHeight();

		long nZoomX = pWindow->GetOutputSize().Width() * 100 / nMinWidth;
		long nZoomY = pWindow->GetOutputSize().Height() * 100 / nMinHeight;

		SetZoom(Min(nZoomX, nZoomY));
		pWindow->SetWinViewPos(Point(0,0));
		pWindow->UpdateMapOrigin(FALSE);
	}

	// initiale WinPos setzen?
	if (bInitializeWinPos)
	{
		bInitializeWinPos = FALSE;		   // nie wieder

		USHORT nNoOfPages	= pDoc->GetSdPageCount(PK_STANDARD);
		USHORT nPagesPerRow = pSlideView->GetPagesPerRow();
		Size   aPageSize	= pSlideView->GetPageArea(0).GetSize();
		ULONG  nGapX		= pSlideView->GetPageGap();
		ULONG  nGapY		= nGapX;

		Size aViewSizeLogic(nPagesPerRow * aPageSize.Width() +
							(nPagesPerRow + 1) * nGapX,
							pSlideView->CalcPagePos(nNoOfPages-1).Y() +
							aPageSize.Height() + nGapY);
		Size aWinSize(pWindow->GetOutputSize());
		Point aViewOrigin(0,0);
		Point aWinPos (0,0);

		// die WinPos so positionieren, dass die selektierte Seite auf
		// halber Hoehe  erscheint
		USHORT nSelected = pFrameView->GetSelectedPage();

        // #96707# Beware, might be a masterpage number and invalid for normal pages
        if ( pDoc->GetSdPage( nSelected, PK_STANDARD ) == NULL )
            nSelected = 0;

		long   nY		 = pSlideView->GetPageArea(nSelected).TopLeft().Y();
		nY += aPageSize.Height() / 2;
		aWinPos.Y() = nY -	aWinSize.Height() / 2;

		// falls die sichtbare Flaeche jetzt zu weit oben oder unten liegt,
		// entsprechend korrigieren
		if (aWinPos.Y() < 0)
			aWinPos.Y() = 0;
		else if (aWinPos.Y() + aWinSize.Height() > aViewSizeLogic.Height())
			aWinPos.Y() = aViewSizeLogic.Height() - aWinSize.Height();

		InitWindows(Point(0,0), aViewSizeLogic, aWinPos);
		SetZoomRect(Rectangle(aWinPos, aWinSize));
	}
}

/*************************************************************************
|*
|* SfxRequests fuer Controller bearbeiten
|*
\************************************************************************/

void SdSlideViewShell::ExecCtrl(SfxRequest &rReq)
{
	USHORT nSlot = rReq.GetSlot();
	switch ( nSlot )
	{
		case SID_RELOAD:
		{
			// Undo-Manager leeren
			pDocSh->GetUndoManager()->Clear();

			// Normale Weiterleitung an ViewFrame zur Ausfuehrung
			GetViewFrame()->ExecuteSlot(rReq);

			// Muss sofort beendet werden
			return;
		}
		break;

		//#49150# macht auch hier sinn, die Preview Qualitaet zu aendern
		case SID_PREVIEW_QUALITY_COLOR:
		case SID_PREVIEW_QUALITY_GRAYSCALE:
		case SID_PREVIEW_QUALITY_BLACKWHITE:
		{
			ULONG nMode;
			switch(nSlot)
			{
			case SID_PREVIEW_QUALITY_COLOR:
				nMode = PREVIEW_DRAWMODE_COLOR;
				break;
			case SID_PREVIEW_QUALITY_GRAYSCALE:
				nMode = PREVIEW_DRAWMODE_GRAYSCALE;
				break;
			default: //case SID_PREVIEW_QUALITY_BLACKWHITE:
				nMode = PREVIEW_DRAWMODE_BLACKWHITE;
				break;
			}

			pFrameView->SetPreviewDrawMode( nMode );
			SdOptions* pOptions = SD_MOD()->GetSdOptions( pDoc->GetDocumentType() );
			pOptions->SetPreviewQuality( nMode );

			Invalidate();
			rReq.Done();
			break;
		}

		case SID_MAIL_SCROLLBODY_PAGEDOWN:
		{
			if (pFuActual)
			{
				pFuActual->ScrollStart();
				ScrollLines(0, -1);
				pFuActual->ScrollEnd();
			}
			rReq.Done();
		}
		break;

		case SID_OPT_LOCALE_CHANGED:
		{
			pSlideView->UpdateAllPages();
			UpdatePreview( GetActualPage() );
			rReq.Done();
		}

		default:
		break;
	}
}

/*************************************************************************
|*
|* Status von Controller-SfxSlots setzen
|*
\************************************************************************/

void SdSlideViewShell::GetCtrlState(SfxItemSet &rSet)
{
	if (rSet.GetItemState(SID_RELOAD) != SFX_ITEM_UNKNOWN)
	{
		// "Letzte Version" vom SFx en/disablen lassen
		SfxViewFrame* pSlideViewFrame = SFX_APP()->GetViewFrame();
		DBG_ASSERT(pSlideViewFrame, "ViewFrame nicht gefunden");
		if (pSlideViewFrame->ISA(SfxTopViewFrame))
		{
			pSlideViewFrame->GetSlotState (SID_RELOAD, NULL, &rSet);
		}
		else		// MI sagt: kein MDIFrame --> disablen
		{
			rSet.DisableItem(SID_RELOAD);
		}
	}

	// #49150#: Qualitaet des Previewfensters aendern, falls vorhanden
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_COLOR ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_GRAYSCALE ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_BLACKWHITE ) )
	{
		USHORT nId = SdPreviewChildWindow::GetChildWindowId();
		if( GetViewFrame()->GetChildWindow( nId ) )
		{
			ULONG nMode = pFrameView->GetPreviewDrawMode();
			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_COLOR, (BOOL)(nMode == PREVIEW_DRAWMODE_COLOR) ) );
			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_GRAYSCALE, (BOOL)(nMode == PREVIEW_DRAWMODE_GRAYSCALE) ) );
			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_BLACKWHITE, (BOOL)(nMode == PREVIEW_DRAWMODE_BLACKWHITE) ) );
		}
		else
		{
			rSet.DisableItem( SID_PREVIEW_QUALITY_COLOR );
			rSet.DisableItem( SID_PREVIEW_QUALITY_GRAYSCALE );
			rSet.DisableItem( SID_PREVIEW_QUALITY_BLACKWHITE );
		}
	}

	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_MAIL_SCROLLBODY_PAGEDOWN) )
	{
		rSet.Put( SfxBoolItem( SID_MAIL_SCROLLBODY_PAGEDOWN, TRUE ) );
	}
}

/*************************************************************************
|*
|* SfxRequests fuer Support-Funktionen
|*
\************************************************************************/

void SdSlideViewShell::FuSupport(SfxRequest &rReq)
{
	if( rReq.GetSlot() == SID_STYLE_FAMILY && rReq.GetArgs())
		pDocSh->SetStyleFamily(((SfxUInt16Item&)rReq.GetArgs()->Get( SID_STYLE_FAMILY )).GetValue());

	switch ( rReq.GetSlot() )
	{
		case SID_CUT:
		{
			if (pFuActual)
			{
				pFuActual->DoCut();
			}
			else if (pSlideView)
			{
				pSlideView->DoCut();
			}
			rReq.Done();
		}
		break;

		case SID_COPY:
		{
			if (pFuActual)
			{
				pFuActual->DoCopy();
			}
			else if (pSlideView)
			{
				pSlideView->DoCopy();
			}
			rReq.Done();
		}
		break;

		case SID_PASTE:
		{
			if (pFuActual)
			{
				pFuActual->DoPaste();
			}
			else if (pSlideView)
			{
				pSlideView->DoPaste();
			}

			Rectangle	aZoomRect, aFullRect;
			SdPage* 	pPage;
			USHORT		nPageCnt = pDoc->GetSdPageCount(PK_STANDARD);
			USHORT		nPageNum = 0;
			BOOL		bHasSelection = FALSE;

			while( nPageNum < nPageCnt )
			{
			    const Rectangle aRect( pSlideView->GetPageArea( nPageNum ) );

				pPage = pDoc->GetSdPage(nPageNum, PK_STANDARD);

				if( pPage->IsSelected() )
				{
					bHasSelection = TRUE;
					aZoomRect.Union(aRect);
					if ( rReq.GetSlot() == SID_SIZE_PAGE )
						break;
				}

				aFullRect.Union(aRect);
				nPageNum++;
			}
			
            if( !bHasSelection )
				aZoomRect = aFullRect;

			// Sichtbarer Bereich
			Size aVisSizePixel( pWindow->GetOutputSizePixel() );
			Rectangle aVisArea( pWindow->PixelToLogic(Rectangle(Point(0,0), aVisSizePixel)) );
			Size aVisAreaSize( aVisArea.GetSize() );

			if ( !aVisArea.IsInside( aZoomRect ) )
			{
				// Objekt liegt nicht komplett im sichtbaren Bereich
				Size aLogicSize( aZoomRect.GetSize() );

				if (aLogicSize.Height() > aVisAreaSize.Height() ||
					aLogicSize.Width() > aVisAreaSize.Width())
				{
					// Objekt passt nicht in sichtbaren Bereich -> auf Objektgroesse zoomen
					SetZoomRect( aZoomRect );
				}
				else
				{
					// Objekt in sichtbaren Bereich scrollen
					Point aPos = aVisArea.TopLeft() + aZoomRect.Center() - aVisArea.Center();
					aVisArea.SetPos( aPos );
					SetZoomRect( aVisArea );
				}
			}

			Invalidate( SID_ATTR_ZOOM );
			rReq.Done();
		}
		break;

		case SID_DRAWINGMODE:
		case SID_NOTESMODE:
		case SID_HANDOUTMODE:
		{
			if (rReq.GetSlot()==SID_DRAWINGMODE)
			{
				pFrameView->SetPageKind(PK_STANDARD);
				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
			}
			else if (rReq.GetSlot()==SID_NOTESMODE)
			{
				pFrameView->SetPageKind(PK_NOTES);
				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
			}
			else if (rReq.GetSlot()==SID_HANDOUTMODE)
			{
				pFrameView->SetPageKind(PK_HANDOUT);
				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
			}
			rReq.Done();
		}
		break;

		case SID_DIAMODE:
			rReq.Done();
			break;

		case SID_OUTLINEMODE:
			GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL2,
						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
			rReq.Done();
			break;

		case SID_ZOOM_PREV:
		{
			if (pZoomList->IsPreviousPossible())
			{
				// Vorheriges ZoomRect einstellen
				SetZoomRect(pZoomList->GetPreviousZoomRect());
			}
			rReq.Done ();
		}
		break;

		case SID_ZOOM_NEXT:
		{
			if (pZoomList->IsNextPossible())
			{
				// Naechstes ZoomRect einstellen
				SetZoomRect(pZoomList->GetNextZoomRect());
			}
			rReq.Done ();
		}
		break;

		// #96090# added Undo/Redo handling
		case SID_UNDO :
		{
			ImpSidUndo(FALSE, rReq);
		}
		break;
		case SID_REDO :
		{
			ImpSidRedo(FALSE, rReq);
		}
		break;

		default:
		break;
	}

	Invalidate(SID_CUT);
	Invalidate(SID_COPY);
	Invalidate(SID_PASTE);
}

/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

void SdSlideViewShell::FuTemporary(SfxRequest& rReq)
{
	if (pFuActual)
	{
		pFuActual->Deactivate();

		if (pFuActual != pFuOld)
		{
			delete pFuActual;
		}

		pFuActual = NULL;
	}

	switch( rReq.GetSlot() )
	{
		case SID_PRESENTATION:
		case SID_REHEARSE_TIMINGS:
		{
            SFX_REQUEST_ARG( rReq, pFullScreen, SfxBoolItem, ATTR_PRESENT_FULLSCREEN, FALSE );
            const BOOL bFullScreen = ( ( SID_REHEARSE_TIMINGS != rReq.GetSlot() ) && pFullScreen ) ? pFullScreen->GetValue() : pDoc->GetPresFullScreen();

            if( bFullScreen )
            {
                SdPresViewShell::CreateFullScreenShow( this, rReq );
			    Cancel();
            }
            else
            {
			    pFrameView->SetPresentationViewShellId( SID_VIEWSHELL1 );
			    pFrameView->SetSlotId( rReq.GetSlot() );
			    pFrameView->SetPageKind( PK_STANDARD );
			    GetViewFrame()->GetDispatcher()->Execute( SID_VIEWSHELL0, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
            }

			rReq.Done();
		}
		break;

		case SID_DIA:
		{
			pFuActual =new FuSlideParameters(this,pWindow,pSlideView,pDoc,rReq);
			Cancel();
		}
		break;

		case SID_HIDE_SLIDE:
		{
			pFuActual = new FuSlideHide(this,pWindow,pSlideView,pDoc,rReq);
			Cancel();
		}
		break;

		case SID_ATTR_ZOOM:
		{
			const SfxItemSet* pArgs = rReq.GetArgs();

			if ( pArgs )
			{
				SvxZoomType eZT = ( ( const SvxZoomItem& ) pArgs->
											Get( SID_ATTR_ZOOM ) ).GetType();
				switch( eZT )
				{
					case SVX_ZOOM_PERCENT:
						SetZoom( (long) ( ( const SvxZoomItem& ) pArgs->
											Get( SID_ATTR_ZOOM ) ).GetValue() );
						break;

					/*
					case SVX_ZOOM_OPTIMAL:
						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_ALL,
									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
						break;

					case SVX_ZOOM_PAGEWIDTH:
						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE_WIDTH,
									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
						break;
					*/
					case SVX_ZOOM_WHOLEPAGE:
						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE,
									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
						break;
				}
				Invalidate( SID_ATTR_ZOOM );
				rReq.Done();
			}
			else
			{
				// hier den Zoom-Dialog oeffnen
				pFuActual = new FuScale( this, pWindow, pSlideView, pDoc, rReq );
			}
			Cancel();
		}
		break;

		case SID_ZOOM_OUT:
		{
			pFuActual = new FuZoom(this, pWindow, pSlideView, pDoc, rReq);
			// Beendet sich selbst, kein Cancel() notwendig!
			rReq.Done();
		}
		break;

		case SID_SIZE_REAL:
		{
			SetZoom( 100 );
			Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
											 pWindow->GetOutputSizePixel()) );
			pZoomList->InsertZoomRect(aVisAreaWin);
			Invalidate( SID_ATTR_ZOOM );
			Invalidate( SID_ZOOM_OUT);
			Invalidate( SID_ZOOM_IN );
			Invalidate( SID_SIZE_REAL );
			Cancel();
			rReq.Done();
		}
		break;

		case SID_ZOOM_IN:
		{
			SetZoom( Max( (long) ( pWindow->GetZoom() / 2 ), (long) pWindow->GetMinZoom() ) );
			Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
											 pWindow->GetOutputSizePixel()) );
			pZoomList->InsertZoomRect(aVisAreaWin);
			Invalidate( SID_ATTR_ZOOM );
			Invalidate( SID_ZOOM_OUT);
			Invalidate( SID_ZOOM_IN );
			Invalidate( SID_SIZE_REAL );
			Cancel();
			rReq.Done();
		}
		break;

		case SID_SIZE_ALL:
		case SID_SIZE_PAGE:
		{
			Rectangle	aZoomRect, aFullRect;
			SdPage* 	pPage;
			USHORT		nPageCnt = pDoc->GetSdPageCount(PK_STANDARD);
			USHORT		nPageNum = 0;
			BOOL		bHasSelection = FALSE;

			while ( nPageNum < nPageCnt )
			{
				const Rectangle aRect( pSlideView->GetPageArea( nPageNum ) );
				
                pPage = pDoc->GetSdPage( nPageNum, PK_STANDARD );

				if( pPage->IsSelected() )
				{
					bHasSelection = TRUE;
					aZoomRect.Union( aRect );
					
                    if( rReq.GetSlot() == SID_SIZE_PAGE )
						break;
				}
				
                aFullRect.Union( aRect );
				nPageNum++;
			}
			
            if ( !bHasSelection )
				aZoomRect = aFullRect;

			if ( !aZoomRect.IsEmpty() )
			{
				Point aPagePos = aZoomRect.Center();
				Size aPageSize = aZoomRect.GetSize();
				aPageSize.Width()  = aPageSize.Width()	* 11 / 10;
				aPageSize.Height() = aPageSize.Height() * 11 / 10;
				aPagePos.X() -= aPageSize.Width() / 2;
				aPagePos.Y() -= aPageSize.Height() / 2;

				SetZoomRect( Rectangle(aPagePos, aPageSize) );

				Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
											 pWindow->GetOutputSizePixel()) );
				pZoomList->InsertZoomRect(aVisAreaWin);
			}
			Invalidate( SID_ATTR_ZOOM );
			Cancel();
			rReq.Done();
		}
		break;

		case SID_PAGES_PER_ROW:
		{
			if( rReq.GetArgs() )
			{
				SFX_REQUEST_ARG( rReq, pPagesPerRow, SfxUInt16Item, SID_PAGES_PER_ROW, FALSE);

				if( pPagesPerRow )
				{
					SetPagesPerRow( pPagesPerRow->GetValue() );
					Invalidate( SID_ATTR_ZOOM );
				}
			}
			Cancel();
			rReq.Done();
			break;
		}

		case SID_SELECTALL:
		{
			for (USHORT i = 0; i < pDoc->GetSdPageCount(PK_STANDARD); i++)
			{
				SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
				if (!pPage->IsSelected())
				{
					pDoc->SetSelected(pPage, TRUE);
					pSlideView->DrawSelectionRect(i);
				}
			}
			SelectionHasChanged();
			Cancel();
			rReq.Done();
		}
		break;


		// Diawechsel-Window
		case SID_DIA_TIME:
		case SID_DIA_EFFECT:
		case SID_DIA_SPEED:
		case SID_DIA_AUTO:
		{
			if( !rReq.GetArgs() )
			{
				GetViewFrame()->SetChildWindow(SdSlideChangeChildWindow::GetChildWindowId(),
										  TRUE);
			}
			else if( rReq.GetSlot() == SID_DIA_AUTO )
				Invalidate( SID_DIA_TIME );
			rReq.Done();
		}
		break;

		case SID_SLIDE_CHANGE_WIN:
		{
			if ( rReq.GetArgs() )
				GetViewFrame()->SetChildWindow(SdSlideChangeChildWindow::GetChildWindowId(),
										((const SfxBoolItem&) (rReq.GetArgs()->
										Get(SID_SLIDE_CHANGE_WIN))).GetValue());
			else
				GetViewFrame()->ToggleChildWindow(SdSlideChangeChildWindow::GetChildWindowId() );

			GetViewFrame()->GetBindings().Invalidate(SID_SLIDE_CHANGE_WIN);
			Cancel();
			rReq.Ignore ();
		}
		break;

		case SID_SLIDE_CHANGE_STATE:
		{
			UpdateSlideChangeWindow();
			Cancel();
			rReq.Done();
		}
		break;

		case SID_SLIDE_CHANGE_ASSIGN:
		{
			AssignFromSlideChangeWindow();
			Cancel();
			rReq.Done();
		}
		break;

		case SID_PREVIEW_WIN:
		{
			if ( rReq.GetArgs() )
				GetViewFrame()->SetChildWindow(SdPreviewChildWindow::GetChildWindowId(),
										((const SfxBoolItem&) (rReq.GetArgs()->
										Get(SID_PREVIEW_WIN))).GetValue());
			else
				GetViewFrame()->ToggleChildWindow(SdPreviewChildWindow::GetChildWindowId() );

			SfxBindings& rBindings = GetViewFrame()->GetBindings();
			rBindings.Invalidate(SID_PREVIEW_WIN);
			rBindings.Invalidate(SID_PREVIEW_QUALITY_COLOR);
			rBindings.Invalidate(SID_PREVIEW_QUALITY_GRAYSCALE);
			rBindings.Invalidate(SID_PREVIEW_QUALITY_BLACKWHITE);

			Cancel();
			rReq.Ignore ();
		}
		break;

		case SID_PRESENTATION_DLG:
		{
			pFuActual = new FuSlideShowDlg( this, pWindow, pSlideView, pDoc, rReq );
			Cancel();
		}
		break;

		case SID_CUSTOMSHOW_DLG:
		{
			pFuActual = new FuCustomShowDlg( this, pWindow, pSlideView, pDoc, rReq );
			Cancel();
		}
		break;

		case SID_EXPAND_PAGE:
		{
			pFuActual = new FuExpandPage( this, pWindow, pSlideView, pDoc, rReq );
			Cancel();
		}
		break;

		case SID_SUMMARY_PAGE:
		{
			pFuActual = new FuSummaryPage( this, pWindow, pSlideView, pDoc, rReq );
			Cancel();
		}
		break;

		case SID_DELETE_PAGE:
		{
			 String aString(SdResId(STR_WARN_DEL_SEL_PAGES));

			if (pDoc->GetSdPageCount(PK_STANDARD) > 1 &&
				QueryBox(pWindow, WB_YES_NO, aString).Execute() == RET_YES)
			{
				pSlideView->DeleteMarked();
			}

			Cancel();
			rReq.Done();
		}
		break;

		default:
		break;
	}

	if (pFuActual)
	{
		pFuActual->Activate();
	}

	Invalidate(SID_CUT);
	Invalidate(SID_COPY);
	Invalidate(SID_PASTE);
}

/*************************************************************************
|*
|* SfxRequests fuer permanente Funktionen
|*
\************************************************************************/

void SdSlideViewShell::FuPermanent(SfxRequest &rReq)
{
	if (pFuActual)
	{
		if (pFuOld == pFuActual)
		{
			pFuOld = NULL;
		}

		pFuActual->Deactivate();
		delete pFuActual;
		pFuActual = NULL;
	}

	switch ( rReq.GetSlot() )
	{
		case SID_OBJECT_SELECT:
		{
			pFuActual = new FuSlideSelection( this, pWindow, pSlideView, pDoc,
											  rReq );
			rReq.Done();
		}
		break;

		default:
		break;
	}

	if (pFuOld)
	{
		pFuOld->Deactivate();
		delete pFuOld;
		pFuOld = NULL;
	}

	if (pFuActual)
	{
		pFuActual->Activate();
		pFuOld = pFuActual;
	}

	//! das ist nur bis das ENUM-Slots sind
	Invalidate( SID_OBJECT_SELECT );
}

/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

void SdSlideViewShell::GetMenuState( SfxItemSet &rSet )
{
	SdViewShell::GetMenuState(rSet);

	if (pDocSh->IsPreview())
	{
		aPresentationBtn.Disable();
	}
	else
	{
		aPresentationBtn.Enable();
	}

	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) )
	{
		SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
		SdPreviewWin*	pPreviewWin = (SdPreviewWin*) ( pPreviewChildWindow ? pPreviewChildWindow->GetWindow() : NULL );
		FuSlideShow*	pShow = pPreviewWin ? pPreviewWin->GetSlideShow() : NULL;

		if ( (pShow && pShow->IsInputLocked()) ||
			 pDocSh->IsPreview() )
		{
			rSet.DisableItem( SID_PRESENTATION );
			aPresentationBtn.Disable();
		}
	}

	if( pFuActual )
	{
		USHORT nSId = pFuActual->GetSlotID();

		rSet.Put( SfxBoolItem( nSId, TRUE ) );
	}
	rSet.Put( SfxBoolItem( SID_DRAWINGMODE, FALSE ) );
	rSet.Put( SfxBoolItem( SID_DIAMODE, TRUE ) );
	rSet.Put( SfxBoolItem( SID_OUTLINEMODE, FALSE ) );
	rSet.Put( SfxBoolItem( SID_NOTESMODE, FALSE ) );
	rSet.Put( SfxBoolItem( SID_HANDOUTMODE, FALSE ) );

	// Vorlagenkatalog darf nicht aufgerufen werden
	rSet.DisableItem( SID_STYLE_CATALOG );
	rSet.DisableItem(SID_SIZE_ALL);
	rSet.DisableItem(SID_SPELLING);
	rSet.DisableItem(SID_SEARCH_DLG);

	if (!pZoomList->IsNextPossible())
	{
	   rSet.DisableItem(SID_ZOOM_NEXT);
	}
	if (!pZoomList->IsPreviousPossible())
	{
	   rSet.DisableItem(SID_ZOOM_PREV);
	}

	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_IN ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_OUT ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_SIZE_REAL ) )
	{
		BOOL bUIActive = pDocSh->IsUIActive();

		if( pWindow->GetZoom() <= pWindow->GetMinZoom() || bUIActive )
			rSet.DisableItem( SID_ZOOM_IN );
		if( pWindow->GetZoom() >= pWindow->GetMaxZoom() || bUIActive )
			rSet.DisableItem( SID_ZOOM_OUT );
		if( 100 >= pWindow->GetMaxZoom() || bUIActive )
			rSet.DisableItem( SID_SIZE_REAL );
	}

	if ( pDocSh->GetActualFunction() )
	{
		rSet.ClearItem( SID_DRAWINGMODE );
		rSet.DisableItem( SID_DRAWINGMODE );
		aDrawBtn.Disable();

		rSet.ClearItem( SID_NOTESMODE );
		rSet.DisableItem( SID_NOTESMODE );
		aNotesBtn.Disable();

		rSet.ClearItem( SID_HANDOUTMODE );
		rSet.DisableItem( SID_HANDOUTMODE );
		aHandoutBtn.Disable();

		rSet.ClearItem( SID_OUTLINEMODE );
		rSet.DisableItem( SID_OUTLINEMODE );
		aOutlineBtn.Disable();

		rSet.ClearItem( SID_DIAMODE );
		rSet.DisableItem( SID_DIAMODE );
		aSlideBtn.Disable();
	}
	else
	{
		aDrawBtn.Enable();
		aNotesBtn.Enable();
		aHandoutBtn.Enable();
		aOutlineBtn.Enable();
		aSlideBtn.Enable();
	}
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_SLIDE_CHANGE_WIN ) )
	{
		USHORT nId = SdSlideChangeChildWindow::GetChildWindowId();
		rSet.Put( SfxBoolItem( SID_SLIDE_CHANGE_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
	}

	// PreviewWindow
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_WIN ) )
	{
		USHORT nId = SdPreviewChildWindow::GetChildWindowId();
		rSet.Put( SfxBoolItem( SID_PREVIEW_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
	}

	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_EXPAND_PAGE))
	{
		BOOL bDisable = TRUE;
		USHORT i = 0;
		USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);

		while (i < nCount && bDisable)
		{
			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);

			if (pPage->IsSelected())
			{
				SdrObject* pObj = pPage->GetPresObj(PRESOBJ_OUTLINE);

				if (pObj && !pObj->IsEmptyPresObj())
				{
					bDisable = FALSE;
				}
			}

			i++;
		}

		if (bDisable)
		{
			rSet.DisableItem(SID_EXPAND_PAGE);
		}
	}

	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_SUMMARY_PAGE))
	{
		BOOL bDisable = TRUE;
		USHORT i = 0;
		USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);

		while (i < nCount && bDisable)
		{
			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);

			if (pPage->IsSelected())
			{
				SdrObject* pObj = pPage->GetPresObj(PRESOBJ_TITLE);

				if (pObj && !pObj->IsEmptyPresObj())
				{
					bDisable = FALSE;
				}
			}

			i++;
		}

		if (bDisable)
		{
			rSet.DisableItem(SID_SUMMARY_PAGE);
		}
	}

	// Starten der Praesentation moeglich?
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_REHEARSE_TIMINGS ) )
	{
		BOOL bDisable = TRUE;
		USHORT nCount = pDoc->GetSdPageCount( PK_STANDARD );

		for( USHORT i = 0; i < nCount && bDisable; i++ )
		{
			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);

			if( !pPage->IsExcluded() )
				bDisable = FALSE;
		}
		if( bDisable || pDocSh->IsPreview())
		{
			rSet.DisableItem( SID_PRESENTATION );
			aPresentationBtn.Disable();
			rSet.DisableItem( SID_REHEARSE_TIMINGS );
		}
	}

	SdTransferable* pTransferClip = SD_MOD()->pTransferClip;

	// Keine eigenen Clipboard-Daten?
	if ( !pTransferClip || !pTransferClip->GetDocShell() )
    {
		rSet.DisableItem(SID_PASTE);
    }
	else
	{
		SvEmbeddedObject* pObj = pTransferClip->GetDocShell();

		if( !pObj || ( (SdDrawDocShell*) pObj)->GetDoc()->GetPageCount() <= 1 )
        {
			// Eigene Clipboard-Daten haben nur eine Seite
            rSet.DisableItem(SID_PASTE);
        }
	}

	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_CUT)  ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_COPY) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_DELETE_PAGE))
	{
		BOOL bDisable = TRUE;
		USHORT i = 0;
		USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);

		while (i < nCount && bDisable)
		{
			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);

			if (pPage->IsSelected())
			{
				bDisable = FALSE;
			}

			i++;
		}

		if (bDisable)
		{
			rSet.DisableItem(SID_CUT);
			rSet.DisableItem(SID_CUT);
			rSet.DisableItem(SID_DELETE_PAGE);
		}
		else if (pDoc->GetSdPageCount(PK_STANDARD) < 2)
		{
			rSet.DisableItem(SID_CUT);
			rSet.DisableItem(SID_DELETE_PAGE);
		}
	}

	//rSet.DisableItem( SID_PRINTDOC );
	//rSet.DisableItem( SID_PRINTDOCDIRECT );
	//rSet.DisableItem( SID_SETUPPRINTER );
}

/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

void SdSlideViewShell::GetAttrState( SfxItemSet &rSet )
{
	BOOL			bDia = FALSE;
	SfxWhichIter	aIter( rSet );
	USHORT			nWhich = aIter.FirstWhich();
/*
	SdPage* pPage	   = NULL;
	USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
	USHORT	nPage;
*/

	while ( nWhich )
	{
		USHORT nSlotId = SfxItemPool::IsWhich(nWhich)
			? GetPool().GetSlotId(nWhich)
			: nWhich;
		switch ( nSlotId )
		{
			case SID_DIA_TIME:
			{
			/*
				BOOL bManual;

				for (nPage = 0; nPage < nNoOfPages; nPage++)
				{
					pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
					if (pPage->IsSelected())
					{
						bManual = pPage->GetPresChange() == PRESCHANGE_MANUAL;
						break;
					}
				}
				if( bManual )
					rSet.DisableItem( ATTR_DIA_TIME );
				else
					rSet.Put( DiaTimeItem ( pPage->GetTime() ) );
			*/
				bDia = TRUE;
			}
			break;

			case SID_DIA_EFFECT:
			case SID_DIA_SPEED:
			case SID_DIA_AUTO:
				bDia = TRUE;
			break;

			case SID_PAGES_PER_ROW:
				rSet.Put( SfxUInt16Item( nSlotId, pSlideView->GetPagesPerRow() ) );
			break;
		}
		nWhich = aIter.NextWhich();
	}

	if( bDia )
	{
		SdPage* pPage	   = NULL;
		USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
		USHORT	nPage;

		// SfxItemSet aSet( pDoc->GetPool(), ATTR_DIA_START, ATTR_DIA_END );

		// jetzt werden die Seitenattribute "per Hand" gemerged
		BOOL bSameEffect  = TRUE;		  // Annahme: alle Seiten haben die
		BOOL bSameSpeed   = TRUE;		  // gleichen Attribute
		BOOL bSameTime	  = TRUE;
		BOOL bSameChange  = TRUE;
		//BOOL bSameSoundOn = TRUE;
		//BOOL bSoundFile	= TRUE;

		presentation::FadeEffect eLastEffect;
		FadeSpeed  eLastSpeed;
		PresChange eLastChange;
		ULONG	   nLastTime;
		// BOOL    bLastSoundOn;
		// String	   bLastSound; <-- ziemlich uebel (Prefix)

		// Attribute der ersten selektierten Seite
		for (nPage = 0; nPage < nNoOfPages; nPage++)
		{
			pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
			if (pPage->IsSelected())
			{
				eLastEffect  = pPage->GetFadeEffect();
				eLastSpeed	 = pPage->GetFadeSpeed();
				nLastTime	 = pPage->GetTime();
				eLastChange	 = pPage->GetPresChange();
				// bLastSoundOn = pPage->IsSoundOn();
				break;
			}
		}

		if( nPage == nNoOfPages) // keine selektierte Seite
		{
			rSet.DisableItem( SID_DIA_EFFECT );
			rSet.DisableItem( SID_DIA_SPEED );
			rSet.DisableItem( SID_DIA_AUTO );
			rSet.DisableItem( SID_DIA_TIME );
		}
		else // mit den anderen selektierten Seiten vergleichen
		{
			for (; nPage < nNoOfPages; nPage++)
			{
				pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
				if (pPage->IsSelected())
				{
					if (eLastEffect  != pPage->GetFadeEffect()) bSameEffect  = FALSE;
					if (eLastSpeed	 != pPage->GetFadeSpeed())	bSameSpeed	 = FALSE;
					if (nLastTime	 != pPage->GetTime())		bSameTime	 = FALSE;
					if (eLastChange  != pPage->GetPresChange())	bSameChange  = FALSE;
					// if (bLastSoundOn != pPage->IsSoundOn())	bSameSoundOn = FALSE;
				}
			}

			// das Set besetzen
			//if (bSameEffect)	rSet.Put( DiaEffectItem( eLastEffect ) );
			if (bSameEffect)  rSet.Put( SfxAllEnumItem( SID_DIA_EFFECT, eLastEffect ) );
			else			  rSet.InvalidateItem( SID_DIA_EFFECT );

			// if (bSameSpeed)	 rSet.Put( DiaSpeedItem( eLastSpeed ) );
			if (bSameSpeed)   rSet.Put( SfxAllEnumItem( SID_DIA_SPEED, eLastSpeed ) );
			else			  rSet.InvalidateItem( SID_DIA_SPEED );

			// SID_DIA_TIME soll disabled werden, wenn nicht automatisch
			// ausgewaehlt wurde (also auch uneindeutig)
			if( bSameChange )
			{
				rSet.Put( SfxAllEnumItem( SID_DIA_AUTO, eLastChange ) );

				if( eLastChange != PRESCHANGE_AUTO )
					rSet.DisableItem( SID_DIA_TIME );
				else
				{
					if( bSameTime )
						rSet.Put( SfxUInt32Item( SID_DIA_TIME, nLastTime ) );
					else
						rSet.InvalidateItem( SID_DIA_TIME );
				}
			}
			else
			{
				rSet.InvalidateItem( SID_DIA_AUTO );
				rSet.DisableItem( SID_DIA_TIME );
			}
		}

		// rSet.Set( aSet );
	}

}

/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/

BOOL SdSlideViewShell::KeyInput(const KeyEvent& rKEvt, SdWindow* pWin)
{
	BOOL bReturn = FALSE;

	// vom ShowWindow der DiaShow?
	if (pWin == NULL && pFuActual)
	{
		bReturn = pFuActual->KeyInput(rKEvt);
	}

	// nein, weiterleiten an Basisklasse
	else
	{
		bReturn = SdViewShell::KeyInput(rKEvt, pWin);
	}

	return(bReturn);
}

/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/

void SdSlideViewShell::MouseButtonDown(const MouseEvent& rMEvt, SdWindow* pWin)
{
	// vom ShowWindow der DiaShow?
	if (pWin == NULL && pFuActual)
	{
		pFuActual->MouseButtonDown(rMEvt);
	}
/*
	// Popup-Menue? NEIN !!!!!
	else if ((rMEvt.GetButtons() == MOUSE_RIGHT) && rMEvt.GetClicks() == 1)
	{
		pWindow->ReleaseMouse();
		GetViewFrame()->GetDispatcher()->ExecutePopup(SdResId(RID_SLIDETABLE_POPUP));
	}
	// nein, weiterleiten an Basisklasse
	else
	{
*/
	SdViewShell::MouseButtonDown(rMEvt, pWin);
}

/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/

void SdSlideViewShell::MouseMove(const MouseEvent& rMEvt, SdWindow* pWin)
{
	// vom ShowWindow der DiaShow?
	if (pWin == NULL && pFuActual)
	{
		pFuActual->MouseMove(rMEvt);
	}

	// nein, weiterleiten an Basisklasse (wenn nicht Readonly)
	else if( !pDocSh->IsReadOnly() )
	{
		SdViewShell::MouseMove(rMEvt, pWin);
	}
}

/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/

void SdSlideViewShell::MouseButtonUp(const MouseEvent& rMEvt, SdWindow* pWin)
{
	// vom ShowWindow der DiaShow?
	if (pWin == NULL && pFuActual)
	{
		pFuActual->MouseButtonUp(rMEvt);
	}

	// nein, weiterleiten an Basisklasse
	else
	{
		SdViewShell::MouseButtonUp(rMEvt, pWin);
	}
}

/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

void SdSlideViewShell::Command(const CommandEvent& rCEvt, SdWindow* pWin)
{
	if ( rCEvt.GetCommand() == COMMAND_CONTEXTMENU )
	{
		SdPage* pPage	   = NULL;
		USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
		USHORT	nPage;
		BOOL	bFound = FALSE;
		USHORT	nPopupId = RID_SLIDE_NOSEL_POPUP;

		for( nPage = 0; nPage < nNoOfPages && !bFound; nPage++ )
		{
			pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
			if( pPage->IsSelected() )
			{
				nPopupId = RID_SLIDETABLE_POPUP;
				bFound = TRUE;
			}
		}

		pWindow->ReleaseMouse();
		GetViewFrame()->GetDispatcher()->ExecutePopup( SdResId( nPopupId ) );
	}
	else
	{
		SdViewShell::Command(rCEvt, pWin);
	}
}

/*************************************************************************
|*
|* wird gerufen, wenn sich die Selektion aendert
|*
\************************************************************************/

void SdSlideViewShell::SelectionHasChanged()
{
	Invalidate( SID_DIA_EFFECT );
	Invalidate( SID_DIA_SPEED );
	Invalidate( SID_DIA_AUTO );
	Invalidate( SID_DIA_TIME );
	Invalidate( SID_EXPAND_PAGE );
	Invalidate( SID_SUMMARY_PAGE );

	// StatusBar
	Invalidate( SID_STATUS_PAGE );
	Invalidate( SID_STATUS_LAYOUT );

	UpdateSlideChangeWindow();
	UpdatePreview( GetActualPage() );
}

/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/

void SdSlideViewShell::InnerResizePixel(const Point &rPos, const Size &rSize)
{
	AdjustPosSizePixel(rPos, rSize);
}

/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/

void SdSlideViewShell::OuterResizePixel(const Point &rPos, const Size &rSize)
{
	AdjustPosSizePixel(rPos, rSize);

}

/*************************************************************************
|*
|* Daten der FrameView auf die aktuelle View uebertragen
|*
\************************************************************************/

void SdSlideViewShell::ReadFrameViewData(FrameView* pFrameView)
{
	pSlideView->SetLineDraft( pFrameView->IsLineDraft() );
	pSlideView->SetFillDraft( pFrameView->IsFillDraft() );
	pSlideView->SetTextDraft( pFrameView->IsTextDraft() );
	pSlideView->SetGrafDraft( pFrameView->IsGrafDraft() );

	pSlideView->ChangePagesPerRow(pFrameView->GetSlidesPerRow());
	pSlideView->ArrangePages();
}

/*************************************************************************
|*
|* Daten der aktuellen View auf die FrameView uebertragen
|*
\************************************************************************/

void SdSlideViewShell::WriteFrameViewData()
{
	pFrameView->SetLineDraft( pSlideView->IsLineDraft() );
	pFrameView->SetFillDraft( pSlideView->IsFillDraft() );
	pFrameView->SetTextDraft( pSlideView->IsTextDraft() );
	pFrameView->SetGrafDraft( pSlideView->IsGrafDraft() );
	pFrameView->SetSlidesPerRow(pSlideView->GetPagesPerRow());
}

/*************************************************************************
|*
|* SfxRequests fuer StatusBar bearbeiten
|*
\************************************************************************/

void SdSlideViewShell::ExecStatusBar(SfxRequest& rReq)
{
}

/*************************************************************************
|*
|* Statuswerte der Statusbar zurueckgeben
|*
\************************************************************************/

void SdSlideViewShell::GetStatusBarState(SfxItemSet& rSet)
{
	// Zoom-Item
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ATTR_ZOOM ) )
	{
		SvxZoomItem* pZoomItem;
		UINT16 nZoom = (UINT16) pWindow->GetZoom();

		pZoomItem = new SvxZoomItem( SVX_ZOOM_PERCENT, nZoom );

		// Bereich einschraenken
		USHORT nZoomValues = SVX_ZOOM_ENABLE_ALL;
		nZoomValues &= ~SVX_ZOOM_ENABLE_OPTIMAL;
		nZoomValues &= ~SVX_ZOOM_ENABLE_PAGEWIDTH;
		nZoomValues &= ~(SVX_ZOOM_ENABLE_100|SVX_ZOOM_ENABLE_150|SVX_ZOOM_ENABLE_200);

		pZoomItem->SetValueSet( nZoomValues );
		rSet.Put( *pZoomItem );
		delete pZoomItem;
	}

	// Seitenanzeige und Layout
	/*
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_PAGE ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_LAYOUT ) )
	*/
	SdPage* pPage	   = NULL;
	SdPage* pFirstPage = NULL;
	USHORT	nPageCount = pDoc->GetSdPageCount( PK_STANDARD );
	USHORT	nPage, nFirstPage;
	USHORT	nSelectedPages = 0;
	String	aPageStr, aLayoutStr;

	for( nPage = 0; nPage < nPageCount; nPage++ )
	{
		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
		if( pPage->IsSelected() )
		{
			if( ++nSelectedPages > 1 )
				break;
			else
			{
				nFirstPage = nPage;
				pFirstPage = pPage;
			}
		}
	}

	if( nSelectedPages == 1 )
	{
		aPageStr = String(SdResId( STR_SD_PAGE ));
		aPageStr += sal_Unicode(' ');
		aPageStr += String::CreateFromInt32( nFirstPage + 1 );
		aPageStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " / " ));
		aPageStr += String::CreateFromInt32( (sal_Int32)nPageCount );

		aLayoutStr = pFirstPage->GetLayoutName();
		aLayoutStr.Erase( aLayoutStr.SearchAscii( SD_LT_SEPARATOR ) );
	}
	rSet.Put( SfxStringItem( SID_STATUS_PAGE, aPageStr ) );
	rSet.Put( SfxStringItem( SID_STATUS_LAYOUT, aLayoutStr ) );
}


/*************************************************************************
|*
|* Den Zoomfaktor in Prozent setzen. Hoechstens so weit heranzoomen, dass
|* gerade eine Seite zu sehen ist.
|*
\************************************************************************/

void SdSlideViewShell::SetZoom(long nZoom)
{
	Fraction aFrac(pWindow->GetMapMode().GetScaleX());
	long	 nCurrentZoom = aFrac.GetNumerator() * 100 /
							aFrac.GetDenominator();

	if (nZoom > nCurrentZoom)
	{
		Size aPageSize(pSlideView->GetPageArea(0).GetSize());
		Size aWinSize(pWindow->PixelToLogic(pWindow->GetOutputSizePixel()));



		// der Zoom Factor darf nicht um mehr als um diesen Faktor wachsen
		// (horizontal und vertikal sollten immer gleich skaliert sein)
		long nAllowedFactorFactor = aWinSize.Width() / aPageSize.Width();
		long nMaxFactor 		  = nCurrentZoom * nAllowedFactorFactor;

		nZoom = Min(nMaxFactor, nZoom);
	}

	SdViewShell::SetZoom(nZoom);
}

/*************************************************************************
|*
|* Zoomrechteck einstellen, nicht kleiner als eine Seite
|*
\************************************************************************/

void SdSlideViewShell::SetZoomRect(const Rectangle& rZoomRect)
{
	Size aPageSize(pSlideView->GetPageArea(0).GetSize());

	Rectangle aRect(rZoomRect);

	if (aRect.GetWidth()  < aPageSize.Width())
	{
		long nWidthDiff  = (aPageSize.Width() - aRect.GetWidth()) / 2;

		aRect.Left() -= nWidthDiff;
		aRect.Right() += nWidthDiff;

		if (aRect.Left() < 0)
		{
			aRect.SetPos(Point(0, aRect.Top()));
		}
	}

	if (aRect.GetHeight()  < aPageSize.Height())
	{
		long nHeightDiff  = (aPageSize.Height() - aRect.GetHeight()) / 2;

		aRect.Top() -= nHeightDiff;
		aRect.Bottom() += nHeightDiff;

		if (aRect.Top() < 0)
		{
			aRect.SetPos(Point(aRect.Left(), 0));
		}
	}

	SdViewShell::SetZoomRect(aRect);
}

/*************************************************************************
|*
|* Selektionsrechteck auf allen Fenster im Diasortierer
|*
\************************************************************************/

void SdSlideViewShell::DrawSelectionRect(USHORT nPage)
{
	SdPage* pPage = pDoc->GetSdPage(nPage, PK_STANDARD);

	Color aColor( pWinArray[0][0]->GetBackground().GetColor() );
	if (pPage->IsSelected())
		aColor.SetColor( COL_BLACK );

	Rectangle aRect(pSlideView->CalcPagePos(nPage), pPage->GetSize());

	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
	{
		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
		{
			if ( pWinArray[nX][nY] )
			{
				Rectangle aInner(aRect);
				aInner = pWinArray[nX][nY]->LogicToPixel(aRect);
				aInner.Left()	-= 2;
				aInner.Top()	-= 2;
				aInner.Right()	+= 2 + 1;	// Rectangle ist ja 1 Pixel zu klein
				aInner.Bottom() += 2 + 1;
				Rectangle aOuter(aInner);
				aOuter.Left()	-= 2;
				aOuter.Top()	-= 2;
				aOuter.Right()	+= 2;		// hier nicht, sonst wird es rechts
				aOuter.Bottom() += 2;		// und unten 3 Pixel breit

				aInner = pWinArray[nX][nY]->PixelToLogic(aInner);
				aOuter = pWinArray[nX][nY]->PixelToLogic(aOuter);

				// KA: verbesserter Code im Vergleich zu unten !!!
				PolyPolygon aClip;
				aClip.Insert(aOuter);
				aClip.Insert(aInner);

				const Color& rOldFillColor = pWinArray[nX][nY]->GetFillColor();
				const Color& rOldLineColor = pWinArray[nX][nY]->GetLineColor();
				pWinArray[nX][nY]->SetFillColor( aColor );
				pWinArray[nX][nY]->SetLineColor();

				pWinArray[nX][nY]->DrawPolyPolygon( aClip );

				pWinArray[nX][nY]->SetLineColor( rOldLineColor );
				pWinArray[nX][nY]->SetFillColor( rOldFillColor );
			}
		}
	}
}

/*************************************************************************
|*
|* Liefert die erste selektierte Seite zurueck.
|* Wenn nichts selektiert ist, wird die erste Seite zurueckgeliefert.
|*
\************************************************************************/

SdPage* SdSlideViewShell::GetActualPage()
{
	SdPage* pPage;
	USHORT	nPageCnt = pDoc->GetSdPageCount( PK_STANDARD );
	USHORT	nPageNum = 0;

	while( nPageNum < nPageCnt )
	{
		pPage = pDoc->GetSdPage( nPageNum, PK_STANDARD );
		if( pPage->IsSelected() )
			break;
		nPageNum++;
	}
	if( !pPage->IsSelected() )
		pPage = pDoc->GetSdPage( 0, PK_STANDARD );

	return( pPage );
}

/*************************************************************************
|*
|* Liefert die selektierten Seiten als String (z.B. fuer Drucken-Dlg) zu-
|* rueck. Sind alle Seiten selektiert, wird ein Leerstring zurueckgegeben
|*
\************************************************************************/
String SdSlideViewShell::GetPageRangeString()
{
	SdPage* pPage      = NULL;
	USHORT	nPageCount = pDoc->GetSdPageCount( PK_STANDARD );
	BOOL	bFirst	   = TRUE;
	BOOL	bAll 	   = TRUE;
	String  aString;

	for( USHORT nPage = 0; nPage < nPageCount; nPage++)
	{
		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
		if( pPage->IsSelected() )
		{
			if( !bFirst )
				aString += (sal_Unicode)',';
			aString += String::CreateFromInt32( nPage + 1 );
			bFirst = FALSE;
		}
		else
			bAll = FALSE;
	}
	if( bAll )
		aString.Erase();

	return( aString );
}


/*************************************************************************
|*
|* Ist etwas selektiert?
|*
\************************************************************************/

BOOL SdSlideViewShell::HasSelection(BOOL bText) const
{
	BOOL bReturn = FALSE;

	if (!bText)
	{
		SdPage* pPage;
		USHORT  nPageCnt = pDoc->GetSdPageCount( PK_STANDARD );
		USHORT  nPageNum = 0;

		while(nPageNum < nPageCnt && !bReturn)
		{
			pPage = pDoc->GetSdPage(nPageNum, PK_STANDARD);

			if (pPage->IsSelected())
			{
				bReturn = TRUE;
			}

			nPageNum++;
		}
	}

	return bReturn;
}

void SdSlideViewShell::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
{
	WriteFrameViewData();

	SdViewShell::WriteUserDataSequence( rSequence, bBrowse );
}

void SdSlideViewShell::ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
{
	WriteFrameViewData();

	SdViewShell::ReadUserDataSequence( rSequence, bBrowse );

	ReadFrameViewData( pFrameView );

	SetPagesPerRow( pFrameView->GetSlidesPerRow() );

	GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE, SFX_CALLMODE_SYNCHRON );
}

void SdSlideViewShell::SetPagesPerRow( USHORT nPagesPerRow )
{
	USHORT nOldPagesPerRow = pSlideView->GetPagesPerRow();
	// den Wert als maximal erlaubten Wert interpretieren; wenn
	// es weniger Seiten gibt entsprechend einschraenken
	USHORT nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
	nPagesPerRow = Min(nPagesPerRow, nNoOfPages);

	pSlideView->ChangePagesPerRow(nPagesPerRow);
	pSlideView->ArrangePages();

	Size  aPageSize   = pSlideView->GetPageArea(0).GetSize();
	ULONG nGapX 	  = pSlideView->GetPageGap();
	ULONG nVisWidth   = nPagesPerRow * aPageSize.Width() + (nPagesPerRow + 1) * nGapX;

	Size aViewSize (nVisWidth,
						pSlideView->GetPageArea(nNoOfPages - 1).Bottom() + nGapX);

	SdWindow* pWin = GetActiveWindow();
	Size aWinSize(pWin->GetOutputSize());
	double fRatio = ((double)aWinSize.Height()) / aWinSize.Width();
	ULONG nVisHeight = (ULONG)(nVisWidth * fRatio);
	if (nVisHeight < aPageSize.Height() + 2 * nGapX)
		nVisHeight = aPageSize.Height() + 2 * nGapX;
	Size aVisSize(nVisWidth, nVisHeight);

	InitWindows(Point(), aViewSize, Point());
	SetZoomRect(Rectangle(Point(), aVisSize));
}
