/*************************************************************************
 *
 *  $RCSfile: compiler.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dv $ $Date: 2001/09/25 09:29:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __COMPILER_HXX
#define __COMPILER_HXX

#ifndef _REF_HXX
#include <tools/ref.hxx>
#endif

#include "parser.hxx"
#include "hashtbl.hxx"
#include "os.hxx"

DECLARE_HASHTABLE(ConstantSet,ByteString,char const*)

class SiDeclarator;
class SiCompiledScript;

class SiCompiler : public SiParser, public SvRefBase
{
private:
	SiCompiledScript*		m_pCompiledScript;
    SiDeclarator*			m_pCurrentDeclarator;
    ByteString			   	m_CurrentPropertyname;
	int				   		m_nCurrentPropertyLanguage;
	com::sun::star::setup::OSType m_eOsType;
	ConstantSet        		m_Constants;

	BOOL               		m_bSymanticError;
	BOOL					m_bOpenRefs;
	BOOL					m_bIgnoreError;

	BOOL					m_bWebbasedMode;
	BOOL					m_bScpMode;

	ByteString 				m_aDefDefaultLanguage;
	ByteString 				m_aDefLanguages;

	ByteString 				m_aSuiteName;
	ByteString 				m_aProductName;
	ByteString 				m_aProductVersion;

    ByteString 				m_aVendorName;
	ByteString 				m_aVendorVersion;

	friend class SiDeclarator;
    friend class SiCompiledScript;

    void	SymanticError(ByteString const&);
	void    Warning(ByteString const&);

	SiDeclarator* CheckLanguage();
	com::sun::star::setup::OSType GetOsType() const { return m_eOsType; }

	void	AddSystemObjectsTo(SiCompiledScript *);

protected:
    virtual void OnDeclaration    (SiLexemType,SiIdentifier const&);
    virtual void OnDeclarationEnd ();
    virtual void OnProperty       (ByteString const&, int nLanguage);
    virtual void OnSingleValue    (sal_Int32);
    virtual void OnSingleValue    (sal_uInt32);
    virtual void OnSingleValue    (ByteString const&);
    virtual void OnSingleValue    (SiIdentifier const&);
    virtual void OnListValue      (sal_Int32);
    virtual void OnListValue      (ByteString const&);
    virtual void OnListValue      (SiIdentifier const&);

	virtual void DisplayError(int nLine, ByteString const& ErrorType,
									ByteString const& Message) const;

public:
	    SiCompiler( SvStream& aStream, com::sun::star::setup::OSType eOsType = OS::GetType(), int nLanguage = 0 );
    	~SiCompiler();

    BOOL				CompileTo( SiCompiledScript*, int nMaxErrors = 1 );

	void				SetIgnoreError(BOOL bNew) 							{ m_bIgnoreError = bNew; }
	void				SetScpZipMode(BOOL bNew) 							{ m_bScpMode = bNew; }
	BOOL 				SecondLevelCompile( SiCompiledScript* );
	void 				SetDefDefaultLanguage(const ByteString& rNew)		{ m_aDefDefaultLanguage = rNew; }
	void 				SetDefLanguages(const ByteString& rNew)				{ m_aDefLanguages = rNew; }

	SiCompiledScript*	GetCScript() const									{ return m_pCompiledScript; }
};

SV_DECL_IMPL_REF( SiCompiler );

#endif // __COMPILER_HXX
