/*************************************************************************
 *
 *  $RCSfile: respfile.hxx,v $
 *
 *  $Revision: 1.5.22.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:46:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _RESPFILE_HXX
#define _RESPFILE_HXX

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

class SiEnvironment;
class SiCompiledScript;
class SimpleProcedureAction;

extern const char RESPSEC_MODULE_SPECIFY[];

enum InstallationMode
{
	INSTALL_NORMAL,
	INSTALL_NETWORK,
	INSTALL_SERVER,
	INSTALL_WORKSTATION,
	DEINSTALL,
	REPAIR,
	REINSTALL,
	RESPONSE_ONLY,
    PATCH
};

enum InstallationType
{
	STANDARD,
	SPECIFY,
	MINIMUM,
	WORKSTATION
};

DECLARE_LIST(ProcedureList, SimpleProcedureAction*)

class ResponseFile
{
	SiEnvironment*			pEnv;
	SiCompiledScript*		pCScript;

	ProcedureList			aProcedureList;

	// environment
	InstallationMode 		eMode;
	InstallationType 		eType;

	ByteString				aDestinationPath;
	ByteString				aLogFile;
	ByteString				aStartProcedure;
	ByteString				aEndProcedure;
	BOOL 					bPreModuleSet;

	void						ReadInstalltionMode( const ByteString& rValue );
	void 						ReadInstalltionType( const ByteString& rValue );

	// procedures
	void						ReadProcedureSection( const ByteString& rFilename );
	SimpleProcedureAction*		FindProc( const ByteString& rProcname );

	// module specify
	ByteString				aInstallModuleSet;
	ByteString				aDeInstallModuleSet;
	ByteString				aInstallProcedure;
	ByteString				aDeInstallProcedure;

public:
		ResponseFile(SiEnvironment* pE, SiCompiledScript* pC);
		~ResponseFile();

	BOOL						Read( const ByteString& rFilename );
	void 						Write( const ByteString& rFilename );


	void						SetInstallationMode( InstallationMode e )	{ eMode = e; }
	void						SetInstallationType( InstallationType e )	{ eType = e; }

	void						SetDestinationPath( const ByteString& r )	{ aDestinationPath = r; }
	const ByteString&			GetDestinationPath() const 					{ return aDestinationPath; }

	ByteString					GetStrInstalltionMode();
	ByteString					GetStrInstalltionType();

	void						SetPreModuleSet(BOOL b)						{ bPreModuleSet = b; }
	USHORT						ProcessEvents();
	void						ExecStartProcedure();
	void						ExecEndProcedure();
};

#endif
