/*************************************************************************
 *
 *  $RCSfile: webaction.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: ok $ $Date: 2001/09/07 11:58:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SETUP_WEBACTION_HXX
#define SETUP_WEBACTION_HXX

#include "action.hxx"

#ifndef _COM_SUN_STAR_SETUP_ACTIONTYPE_HPP_
#include <com/sun/star/setup/ActionType.hpp>
#endif

using namespace com::sun::star::setup;
using namespace com::sun::star::uno;

//////////////////////////////////////////////////////////////////////////

class SiWebAction : public SiAction
{
	ActionType		eSiType;
public:
		SiWebAction( SiAgenda* pAgenda, ActionType eTyp ) :
			SiAction( pAgenda, AT_UNKNOWN ) { eSiType = eTyp; }

	BOOL			Execute( SiEnvironment&)	{ return TRUE; }
	ActionType 		GetType()					{ return eSiType; }
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_DOWNLOADACTION_HPP_
#include <com/sun/star/setup/DownloadAction.hpp>
#endif

class SiWebDownloadAction : public DownloadAction, public SiWebAction
{
public:
			SiWebDownloadAction( SiAgenda* pAgenda,
				const UniString& aFilename );

				void 						SetSize(sal_Int32 sz)	{ nSizeKB = sz; }
				void 						SetCRC(sal_uInt32 crc)	{ nCRC = crc; }
	virtual 	DownloadAction&				GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_MAKEDIRACTION_HPP_
#include <com/sun/star/setup/MakeDirAction.hpp>
#endif

class SiWebMakeDirAction : public MakeDirAction, public SiWebAction
{
public:
			SiWebMakeDirAction( SiAgenda* pAgenda,
				const UniString& name,
				sal_Int32 rights );

	virtual 	MakeDirAction&				GetWebAction();

		 		UniString					GetDirname() const { return strDirname; }

				BOOL 				operator < 	(const SiWebMakeDirAction&);
				BOOL				operator == (const SiWebMakeDirAction&);
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_UNZIPACTION_HPP_
#include <com/sun/star/setup/UnzipAction.hpp>
#endif

class SiWebUnzipAction : public UnzipAction, public SiWebAction
{
public:
			SiWebUnzipAction( SiAgenda* pAgenda,
				const UniString& source,
				const UniString& destination,
				const UniString& pattern,
				com::sun::star::util::DateTime& datetime,
				sal_Int32 rights,
				BOOL unocomponent,
				BOOL activex );

	virtual 	UnzipAction&				GetWebAction();
				void						AddSubFile( const UniString& rFilename );

				void 						SetOverwrite( BOOL b)
											{ bOverwrite = b; }
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_COPYFILEACTION_HPP_
#include <com/sun/star/setup/CopyFileAction.hpp>
#endif

class SiWebCopyFileAction : public CopyFileAction, public SiWebAction
{
public:
			SiWebCopyFileAction( SiAgenda* pAgenda,
				const UniString& source,
				const UniString& destination,
				com::sun::star::util::DateTime& datetime,
				sal_Int32 rights,
				BOOL unocomponent,
				BOOL activex );

	virtual 	CopyFileAction&				GetWebAction();

				void 						SetOverwrite( BOOL b)
											{ bOverwrite = b; }
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_PROFILEITEMACTION_HPP_
#include <com/sun/star/setup/ProfileItemAction.hpp>
#endif

class SiWebProfileItemAction : public ProfileItemAction, public SiWebAction
{
	USHORT 		nOrder;	                // order flag to sort agenda
public:
			SiWebProfileItemAction( SiAgenda* pAgenda,
				const UniString& filename,
				const UniString& section,
				const UniString& key,
				const UniString& value,
				USHORT order,
				BOOL create );

	USHORT 									GetOrder() const { return nOrder; }
	virtual 	ProfileItemAction&			GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_FONTACTION_HPP_
#include <com/sun/star/setup/FontAction.hpp>
#endif

class SiWebFontAction : public FontAction, public SiWebAction
{
public:
			SiWebFontAction( SiAgenda* pAgenda,
				const UniString& fontfilename,
				const UniString& fontname,
				BOOL create );

	virtual 	FontAction&					GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_WINDOWSREGISTRYACTION_HPP_
#include <com/sun/star/setup/WindowsRegistryAction.hpp>
#endif

class SiWebWindowsRegistryAction : public WindowsRegistryAction, public SiWebAction
{
public:
			SiWebWindowsRegistryAction( SiAgenda* pAgenda,
				const UniString& key,
				const UniString& subkey,
				const UniString& name,
				const UniString& value,
				BOOL create,
				BOOL hex,
				BOOL deleteall );

	virtual 	WindowsRegistryAction&	 	GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_MAKEFOLDERACTION_HPP_
#include <com/sun/star/setup/MakeFolderAction.hpp>
#endif

class SiWebMakeFolderAction : public MakeFolderAction, public SiWebAction
{
public:
			SiWebMakeFolderAction( SiAgenda* pAgenda,
				const UniString& name,
				BOOL user );

	virtual 	MakeFolderAction&		 	GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_MAKEFOLDERITEMACTION_HPP_
#include <com/sun/star/setup/MakeFolderItemAction.hpp>
#endif

class SiWebMakeFolderItemAction : public MakeFolderItemAction, public SiWebAction
{
public:
			SiWebMakeFolderItemAction( SiAgenda* pAgenda,
				const UniString& foldername,
				const UniString& itemname,
				const UniString& destinationpath,
				const UniString& destinationexecutable,
				const UniString& parameter );

	virtual 	MakeFolderItemAction&	   	GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_DELETEFILEACTION_HPP_
#include <com/sun/star/setup/DeleteFileAction.hpp>
#endif

class SiWebDeleteFileAction : public DeleteFileAction, public SiWebAction
{
public:
			SiWebDeleteFileAction( SiAgenda* pAgenda,
				const UniString& path,
				const UniString& pattern,
				BOOL unocomponent,
				BOOL activex,
				BOOL testdate,
				com::sun::star::util::DateTime& datetime );

	virtual 	DeleteFileAction&	   	GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_DELETEDIRACTION_HPP_
#include <com/sun/star/setup/DeleteDirAction.hpp>
#endif

class SiWebDeleteDirAction : public DeleteDirAction, public SiWebAction
{
public:
			SiWebDeleteDirAction( SiAgenda* pAgenda,
				const UniString& path );

	virtual 	DeleteDirAction&	   	GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_MAKESHORTCUTACTION_HPP_
#include <com/sun/star/setup/MakeShortcutAction.hpp>
#endif

class SiWebMakeShortcutAction : public MakeShortcutAction, public SiWebAction
{
public:
			SiWebMakeShortcutAction( SiAgenda* pAgenda,
				const UniString& source,
				const UniString& destination,
				const UniString& path,
				const UniString& description );

	virtual 	MakeShortcutAction&		GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_DELETEFOLDERACTION_HPP_
#include <com/sun/star/setup/DeleteFolderAction.hpp>
#endif

class SiWebDeleteFolderAction : public DeleteFolderAction, public SiWebAction
{
public:
			SiWebDeleteFolderAction( SiAgenda* pAgenda,
				const UniString& foldername );

	virtual 	DeleteFolderAction&		GetWebAction();
};

//////////////////////////////////////////////////////////////////////////

#ifndef _COM_SUN_STAR_SETUP_DELETEFOLDERITEMACTION_HPP_
#include <com/sun/star/setup/DeleteFolderItemAction.hpp>
#endif

class SiWebDeleteFolderItemAction : public DeleteFolderItemAction, public SiWebAction
{
public:
			SiWebDeleteFolderItemAction( SiAgenda* pAgenda,
				const UniString& foldername,
				const UniString& itemname );

	virtual 	DeleteFolderItemAction& GetWebAction();
};


#endif

