/*************************************************************************
 *
 *  $RCSfile: nwinos.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: iha $ $Date: 2001/09/18 21:37:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _NWINOS_HXX
#define _NWINOS_HXX

#ifndef _JSNATIVE_HXX
#include "jsnative.hxx"
#endif

class WinOS : public OS
{
private:
		char*   m_cCleanupAfterRebootFile;
		HANDLE	hThread;
public:
				WinOS(int argc, char* argv[]);

		int 					Startup(int argc, char* argv[]);
		void					Terminate();
		void					ping();

		// installation
		void					GetSVersion( char* buf, int len );
		BOOL					makeDir( char* path, int rights );
		BOOL					removeDir( char* path );
		void					setDateTime(char* filename, int hour, int min, int sec,
									int day, int month, int year );
		void					setRights(char* filename, int rights);

		unsigned long 			GetFreeDriveSize( char* _cDrive );
		unsigned long			GetClusterSize( char* _cDrive );

		void					getOSDir(char* buf);
		void  					getOSSystemDir(char* buf);
		void  					getOSsystemFontDir(char* buf);
		void					getHomeDir(char* buf);
		void					getConfigDir(char* buf);
		void					getServiceDir(char* buf);
		void					getOSShellnewDir(char* buf);
		void					getAutoStart(char* buf);
		void					getOSDesktopDir(char* buf);
		void					getBookmarkDir(char* buf);
		void					getPersonalDir(char* buf);
		void					getIEPluginDir(char* buf, BOOL bPlugin = TRUE);
		void					getIEDir(char* buf);
		void					getNSPluginDir(char* buf);
		void					getNS6PluginDir(char* buf);

 		void					createShortcut(char* source, char* destination, char* path, char* description, char* parameters);
		void					createProgramFolder(char* name, BOOL user);
		void					createProgramFolderItem(char* foldername, char* itemname, char* destpath,
									char* destexec, char* param, BOOL user );
		void					removeProgramFolder(char* name, BOOL user);
		void					removeProgramFolderItem(char* foldername, char* itemname, BOOL user);

		void					winRegistry(char* key, char* subkey, char* name, char* value,
									BOOL create, BOOL hex, BOOL deleteall, BOOL expand, BOOL bKeyOnly = FALSE );

		void					addFont(char* fontfile, char* fontname);
		void					removeFont(char* fontfile, char* fontname);
		BOOL					deleteFile(char* path, char* pattern, BOOL testdate,
									int hour, int min, int sec, int day, int month, int year );
		BOOL					copyFile(char* source, char* destination);

		BOOL					unzipFile(char* source, char* pattern, char* destination);

		void					getDriveList(char* buf);
		void		   			moveFileAfterReboot(char* source, char* destination);
		
		// windows only
		void 			ShowCMDWindow();
		void			getUserProgramFilesFolder(char* buf);
		void			registerActiveX(char* path, BOOL bregister);
		
		void			prepareCleanupAfterReboot( char* sourceLocationOfExecuteable, char* destinationWorkingDirectory );
		void			removeCleanupAfterRebootPreparation( char* destinationWorkingDirectory );
		BOOL			isStartedForCleanupAfterReboot( int argc, char* argv[] );
		int				cleanupAfterReboot( int argc, char* argv[] );
		BOOL			isFileRegisteredForRemoveAfterReboot( char* filename );
		void			removeLineFromAfterRebootList( char* line );
		//
		
private:
		void			addToCleanupAfterRebootList( char* sourcefile, char* targetfile );
};

#endif
