#!/bin/sh
#*************************************************************************
#
#   $RCSfile: serverstartup.sh,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: svesik $ $Date: 2001/05/07 18:56:37 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

sd_platform=`uname -s`
case $sd_platform in
        SCO_SV) test=/bin/test     ;;
        NetBSD) test=/bin/test     ;;
        FreeBSD) test=/bin/test     ;;
        *)      test=/usr/bin/test ;;
esac

if $test -L "$0" ; then
        sd_basename=`basename $0`
        sd_script=`ls -l $0 | sed "s/.*${sd_basename} -> //g"`
else
        sd_script="$0"
fi

case $sd_platform in
  SunOS)
         SAL_IGNOREXERRORS=1
         export SAL_IGNOREXERRORS
         LD_LIBRARY_PATH=.:/usr/openwin/lib:../lib
         export LD_LIBRARY_PATH
         ;;
  Linux)
         LD_LIBRARY_PATH=.:../lib:$LD_LIBRARY_PATH
         export LD_LIBRARY_PATH
         ;;
  NetBSD)
         LD_LIBRARY_PATH=.:../lib:$LD_LIBRARY_PATH
         export LD_LIBRARY_PATH
         ;;
  FreeBSD)
         LD_LIBRARY_PATH=.:../lib:$LD_LIBRARY_PATH
         export LD_LIBRARY_PATH
         ;;
      *)
         ;;
esac

cd "`dirname "$sd_script"`"

current_path=`pwd`
sd_libset=`ls libset?????.so`

rcfile=`pwd`/../etc/setupserverrc
port=`grep port= $rcfile | awk -F= '{print $2;}'`

set -x

$current_path/uno -c com.sun.star.comp.setup.Setup -l ./$sd_libset -r ./applicat.rdb -r ./myreg.rdb -u "uno:socket,host=localhost,port=$port;urp;SetupServer"

