/*************************************************************************
 *
 *  $RCSfile: sifolder.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: lla $ $Date: 2001/11/20 12:37:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"

TYPEINIT1(SiFolder,SiDeclarator)
TYPEINIT1(SiFolderItem,SiDeclarator)

///////////////////////////////////////////////////////////////////////////////
//
//		SiFolder
//

SiFolder::SiFolder( SiIdentifier const& ID, SiCompiler* pCompiler, BOOL  bSystemObject ) :
	SiDeclarator( ID, pCompiler, bSystemObject )
{
	INIT_MULTI_LANG_MEMBER(	aName			);
	INIT_MULTI_LANG_MEMBER(	anOs2ID			);
	INIT_MULTI_LANG_MEMBER(	pOs2OpenIcon	);
	INIT_MULTI_LANG_MEMBER(	pOs2CloseIcon	);
	INIT_MULTI_LANG_MEMBER(	nItemCount		);
	INIT_MULTI_LANG_MEMBER(	bPredefined		);

	m_pOs2OpenIcon  = NULL;
	m_pOs2CloseIcon = NULL;
	m_nItemCount	= 0;
	m_bPredefined	= FALSE;
}

// ----------------------------------------------------------------------------

void SiFolder::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiFolder* pParent = (SiFolder*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER(	aName			);
	JOIN_MULTI_LANG_MEMBER(	anOs2ID			);
	JOIN_MULTI_LANG_MEMBER(	pOs2OpenIcon	);
	JOIN_MULTI_LANG_MEMBER(	pOs2CloseIcon	);
	JOIN_MULTI_LANG_MEMBER(	nItemCount		);
	JOIN_MULTI_LANG_MEMBER(	bPredefined		);
}

// ----------------------------------------------------------------------------
BOOL SiFolder::SetUniProperty(ByteString const& _sProperty, UniString const& _suValue )
{
	if( _sProperty == PROPERTY_NAME )
	{
		SET_MULTI_LANG_MEMBER( aName, _suValue );
		return TRUE;
	}
	else
	{
		OSL_ENSURE(false, "No other Properties allowed");
	}
	return FALSE;
}
// -----------------------------------------------------------------------------

BOOL SiFolder::SetProperty( ByteString const& aProperty, ByteString const& aValue )
{
	if( aProperty == PROPERTY_NAME )
	{
		UniString suValue(aValue, osl_getThreadTextEncoding());
		SET_MULTI_LANG_MEMBER( aName, suValue );
		return TRUE;
	}

	if( aProperty == PROPERTY_OS2_ID )
	{
		if( IsOs2() )
		{
			SET_MULTI_LANG_MEMBER( anOs2ID, aValue );
		}
		else
			OsWarning(aProperty.GetBuffer());
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiFolder::SetProperty(ByteString const& aProperty, long lValue)
{
	if( aProperty == PROPERTY_ITEMCOUNT )
	{
		SET_MULTI_LANG_MEMBER( nItemCount, (int)lValue );
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,lValue);
}

// ----------------------------------------------------------------------------

BOOL SiFolder::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_OS2_OPENICON )
	{
		if( IsOs2() )
		{
			m_pOs2OpenIcon = PTR_CAST(SiFile,aValue);

			if (m_pOs2OpenIcon == NULL)
			{
				ByteString aMsg( aValue->GetID() );
				aMsg += " is not a file";
				Error( aMsg );

				return FALSE;
			}
		}
		else
			OsWarning(aProperty.GetBuffer());
		m_IspOs2OpenIcon = TRUE;
		return TRUE;
	}

	if( aProperty == PROPERTY_OS2_CLOSEICON )
	{
		if( IsOs2() )
		{
			m_pOs2CloseIcon = PTR_CAST(SiFile,aValue);

			if (m_pOs2CloseIcon == NULL)
			{
				ByteString aMsg( aValue->GetID() );
				aMsg += " is not a file";
				Error( aMsg );
				return FALSE;
			}
		}
		else
			OsWarning(aProperty.GetBuffer());
		m_IspOs2CloseIcon = TRUE;
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiFolder::Check()
{
	BOOL bOk = TRUE;

	bOk = bOk && CheckField( m_aName, PROPERTY_NAME );

	if( IsOs2() )
	{
		bOk = bOk && CheckField(m_anOs2ID, PROPERTY_OS2_ID);
	}

	return bOk ? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiFolder::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Folder", this);

	// PROPERTY_NAME
	// WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, aName );
	aStream.WriteProperty( PROPERTY_NAME, ByteString(m_aName, osl_getThreadTextEncoding()), m_nLanguage );

	// PROPERTY_OS2_ID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_ID, anOs2ID );

	// PROPERTY_OS2_OPENICON
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_OPENICON, pOs2OpenIcon );

	// PROPERTY_OS2_CLOSEICON
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_CLOSEICON, pOs2CloseIcon );

	// PROPERTY_ITEMCOUNT
	WRITE_MULTI_LANG_MEMBER( PROPERTY_ITEMCOUNT, nItemCount );

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiFolder* pFolder = (SiFolder*) m_aLangRefs.GetObject(nIdx);
		pFolder->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiFolder::GetNaturalID() const
{
#ifdef OS2
	ByteString aNatID( m_anOs2ID );
#else
	ByteString aNatID( m_aName, osl_getThreadTextEncoding() );
#endif
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

// ----------------------------------------------------------------------------

void SiFolder::AddItemCount( int n )
{
	m_nItemCount += n;
	if( m_nItemCount < 0 )
	{
		if( !IsSystemObject() )
		{
			DBG_ERROR("SiFolder::AddItemCount() less than zero");
		}
		m_nItemCount = 0;
	}
	if( m_nItemCount )
		m_IsnItemCount = TRUE;
	else
		m_IsnItemCount = FALSE;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiFolderItem
//

SiFolderItem::SiFolderItem( SiIdentifier const& ID, SiCompiler *pCompiler ) :
		SiDeclarator( ID,pCompiler )
{
	INIT_MULTI_LANG_MEMBER(	pModule			);
	INIT_MULTI_LANG_MEMBER(	aName			);
	INIT_MULTI_LANG_MEMBER(	pFolder			);
	INIT_MULTI_LANG_MEMBER(	pFile			);
	INIT_MULTI_LANG_MEMBER(	aParameter		);
	INIT_MULTI_LANG_MEMBER(	anOs2ID			);
	INIT_MULTI_LANG_MEMBER(	pOs2Class		);
	INIT_MULTI_LANG_MEMBER(	pOs2Creator		);
	INIT_MULTI_LANG_MEMBER(	anOs2Filters	);
	INIT_MULTI_LANG_MEMBER(	pOs2Reference	);
	INIT_MULTI_LANG_MEMBER(	bNoWeb			);
	INIT_MULTI_LANG_MEMBER(	bWebOnly	 	);

	m_bNoWeb		= FALSE;
	m_bWebOnly		= FALSE;

	m_pModule		= NULL;
	m_pFolder		= NULL;
	m_pFile			= NULL;

	m_pOs2Class     = NULL;
	m_pOs2Creator   = NULL;
	m_pOs2Reference = NULL;
}

// ----------------------------------------------------------------------------

void SiFolderItem::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiFolderItem* pParent = (SiFolderItem*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER(	pModule			);
	JOIN_MULTI_LANG_MEMBER(	aName			);
	JOIN_MULTI_LANG_MEMBER(	pFolder			);
	JOIN_MULTI_LANG_MEMBER(	pFile			);
	JOIN_MULTI_LANG_MEMBER(	aParameter		);
	JOIN_MULTI_LANG_MEMBER(	anOs2ID			);
	JOIN_MULTI_LANG_MEMBER(	pOs2Class		);
	JOIN_MULTI_LANG_MEMBER(	pOs2Creator		);
	JOIN_MULTI_LANG_MEMBER(	anOs2Filters	);
	JOIN_MULTI_LANG_MEMBER(	pOs2Reference	);
	JOIN_MULTI_LANG_MEMBER(	bNoWeb			);
	JOIN_MULTI_LANG_MEMBER(	bWebOnly	 	);
}

// ----------------------------------------------------------------------------

BOOL SiFolderItem::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if( aProperty == PROPERTY_NAME )
	{
		SET_MULTI_LANG_MEMBER( aName, aValue );
		return TRUE;
	}

	if( aProperty == PROPERTY_PARAMETER )
	{
		SET_MULTI_LANG_MEMBER( aParameter, aValue );
		return TRUE;
	}

	if( aProperty == PROPERTY_OS2_ID )
	{
		if( IsOs2() )
		{
			SET_MULTI_LANG_MEMBER( anOs2ID, aValue );
		}
		else
			OsWarning(aProperty.GetBuffer());
		return TRUE;
	}

	if( aProperty == PROPERTY_OS2_FILTERS )
	{
		if( IsOs2() )
		{
			SET_MULTI_LANG_MEMBER( anOs2Filters, aValue );
		}
		else
			OsWarning(aProperty.GetBuffer());
		return TRUE;
	}

	if( aProperty == PROPERTY_FLAGS )
	{
		if ( aValue == VALUE_WEB_ONLY )	{ SET_MULTI_LANG_MEMBER( bWebOnly, TRUE ); return TRUE; }
		if ( aValue == VALUE_NOWEB )	{ SET_MULTI_LANG_MEMBER( bNoWeb, TRUE ); return TRUE; }

		Error("illegal value");
		return FALSE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiFolderItem::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_MODULEID )
	{
		m_pModule = PTR_CAST(SiModule,aValue);
		if( m_pModule == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a module";
			Error( aMsg );
			return FALSE;
		}
		// SiFolderItem in die Liste des Moduls haengen.
		// Achtung: Selbst wenn Check() FALSE zurueckliefert
		//          (siehe SiCompiler::OnDeclarationEnd()) mu
		//          sichergestellt werden, dass das Objekt nicht
		//          zerstoert wird.
		m_pModule->Add(this);
		m_IspModule = TRUE;
		return TRUE;
	}

	if( aProperty == PROPERTY_FOLDERID )
	{
		m_pFolder = PTR_CAST(SiFolder,aValue);
		if( m_pFolder == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a folder";
			Error( aMsg );
			return FALSE;
		}
		m_IspFolder = TRUE;
		return TRUE;
	}

	if( aProperty == PROPERTY_FILEID )
	{
		m_pFile = PTR_CAST(SiFile,aValue);

		if( m_pFile == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a file";
			Error( aMsg );
			return FALSE;
		}
		m_IspFile = TRUE;
		return TRUE;
	}

	if( aProperty == PROPERTY_OS2_CREATORID )
	{
		if( IsOs2() )
		{
			m_pOs2Creator = PTR_CAST(SiOs2Creator,aValue);
			if( m_pOs2Creator == NULL )
			{
				ByteString aMsg( aValue->GetID() );
				aMsg += " is not an OS/2 creator";
				Error( aMsg );
				return FALSE;
			}
			m_IspOs2Creator = TRUE;
		}
		else
			OsWarning(aProperty.GetBuffer());
		return TRUE;
	}

	if( aProperty == PROPERTY_OS2_CLASSID )
	{
		if( IsOs2() )
		{
			m_pOs2Class = PTR_CAST(SiOs2Class,aValue);
			if( m_pOs2Class == NULL )
			{
				ByteString aMsg( aValue->GetID() );
				aMsg += " is not an OS/2 class";
				Error( aMsg );
				return FALSE;
			}
			m_IspOs2Class = TRUE;
		}
		else
			OsWarning(aProperty.GetBuffer());
		return TRUE;
	}

	if( aProperty == PROPERTY_OS2_REFERENCEID )
	{
		if( IsOs2() )
		{
			m_pOs2Reference = PTR_CAST(SiFolderItem,aValue);
			if( m_pOs2Reference == NULL )
			{
				ByteString aMsg( aValue->GetID() );
				aMsg += " is not a folder item";
				Error( aMsg );
				return FALSE;
			}
			m_IspOs2Reference = TRUE;
		}
		else
			OsWarning(aProperty.GetBuffer());
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiFolderItem::Check()
{
	BOOL bOk = TRUE;

	bOk = bOk && CheckField(m_pModule, PROPERTY_MODULEID);
	bOk = bOk && CheckField(m_aName,   PROPERTY_NAME);

	if (!IsOs2())
	{
		bOk = bOk && CheckField(m_pFile, PROPERTY_FILEID);
	}
	else
	{
		bOk = bOk && CheckField(m_anOs2ID, PROPERTY_OS2_ID);

		if (m_pOs2Reference == NULL)
		{
			bOk = bOk && CheckField(m_pFile,		PROPERTY_FILEID);
			// Creator ist wohl optional
			// bOk = bOk && CheckField(m_pOs2Creator,  PROPERTY_OS2_CREATORID);
			bOk = bOk && CheckField(m_pOs2Class,    PROPERTY_OS2_CLASSID);
		}
		else
		{
			CheckFieldEmpty(m_pFile,		PROPERTY_FILEID);
			CheckFieldEmpty(m_pOs2Creator,	PROPERTY_OS2_CREATORID);
			CheckFieldEmpty(m_pOs2Class,	PROPERTY_OS2_CLASSID);
		}
	}

	return SiDeclarator::Check();
}

// ----------------------------------------------------------------------------

BOOL SiFolderItem::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("FolderItem", this);

	// PROPERTY_MODULEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_MODULEID, pModule );
	// PROPERTY_NAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, aName );
	// PROPERTY_FOLDERID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_FOLDERID, pFolder );
	// PROPERTY_FILEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_FILEID, pFile );
	// PROPERTY_PARAMETER
	WRITE_MULTI_LANG_MEMBER( PROPERTY_PARAMETER, aParameter );

	// PROPERTY_OS2_ID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_ID, anOs2ID );
	// PROPERTY_OS2_CLASSID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_CLASSID, pOs2Class );
	// PROPERTY_OS2_CREATORID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_CREATORID, pOs2Creator );
	// PROPERTY_OS2_FILTERS
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_FILTERS, anOs2Filters );
	// PROPERTY_OS2_REFERENCEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_REFERENCEID, pOs2Reference );

	if( m_bWebOnly || m_bNoWeb )
	{
		aStream.BeginProperty(PROPERTY_FLAGS, m_nLanguage);
		aStream.BeginList();

		if ( m_bWebOnly )	aStream.AddListValue(SiIdentifier(VALUE_WEB_ONLY));
		if ( m_bNoWeb )		aStream.AddListValue(SiIdentifier(VALUE_NOWEB));

		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiFolderItem* pFolderItem = (SiFolderItem*) m_aLangRefs.GetObject(nIdx);
		pFolderItem->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();

	return TRUE;
}

ByteString SiFolderItem::GetNaturalID() const
{
	ByteString aNatID  = GetFolder()->GetNaturalID();
		   aNatID += NSEP;

#ifdef OS2
	aNatID += m_anOs2ID;
#else
	aNatID += m_aName;
#endif

	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

