/*************************************************************************
 *
 *  $RCSfile: reg4msdocmaindlg.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tra $ $Date: 2001/11/23 15:07:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _REGISTER_HXX_
#include "register.hxx"
#endif

#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef _PVER_HXX
#include <svtools/pver.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include <rtl/ustring.hxx>

#include "reg4msdocmaindlg.hxx"
#include "main.hxx"
#include "environ.hxx"
#include "sihelp.hxx"

#include "global.hrc"
#include "pages.hrc"
#include "strings.hrc"
#include "..\..\ui\app.hrc"
#include "preg4msdoc.hrc"

#include "preg4msdoc.hxx"

//------------------------------------
//
//------------------------------------

Reg4MsDocMainDialog::Reg4MsDocMainDialog( Window* pParent, ResMgr* pMgr ) :
	SvAgentDlg	( pParent, pMgr, RC_AGENTDLG_LOGO ),
    m_bModalFlag( TRUE ),
    m_bEnableReg4MsWord( TRUE ),
    m_bEnableReg4MsExcel( TRUE ),
    m_bEnableReg4MsPowerPoint( TRUE ),
    m_bEnableReg4DefHtmlEdt( TRUE ),
    m_bReg4MsWord( TRUE ),
    m_bReg4MsExcel( TRUE ),
    m_bReg4MsPowerPoint( TRUE ),
    m_bReg4DefHtmlEdt( TRUE )
{	
	if( pParent )
	{
		Point aPnt = pParent->GetPosPixel();
		Size aSiz = GetSizePixel(),
			aWinSiz = pParent->GetSizePixel();

		long nXDelta = ( aWinSiz.Width() - aSiz.Width()  ) / 2;
		long nYDelta = ( aWinSiz.Height() - aSiz.Height()  ) / 2;

		if ( nXDelta > 0 )
			aPnt.X() += nXDelta;
		if ( nYDelta > 0 )
			aPnt.Y() += nYDelta;

		SetPosPixel( aPnt );
	}

    InsertPage( RESID_PAGE_PAGEREG4MSDOC, PageReg4MSDoc::Create, SMALL_PAGE, TRUE );                
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::DoModal()
{
	m_bModalFlag = FALSE;
	m_bModSucc   = FALSE;

	Window* pOldParent = Application::GetDefModalDialogParent();
	Application::SetDefModalDialogParent( this );

	if( Application::GetAppWindow() )
		Application::GetAppWindow()->EnableInput( FALSE, TRUE );

	while( !m_bModalFlag && IsVisible() )
		Application::Yield();

	if( Application::GetAppWindow() )
		Application::GetAppWindow()->EnableInput( TRUE, TRUE );

	Application::SetDefModalDialogParent( pOldParent );

	return m_bModSucc;
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::EndAgentDlg(BOOL bSucc)
{
    // get the checkbox results 

    m_bModSucc = bSucc;
    
    if ( !m_bModSucc )
    {
        if ( QueryBox( this, ResId(DLG_QUERYEXITBOX)).Execute() == RET_NO )
            return FALSE;
    }

    OSL_ASSERT( GetActivePage() );

    sal_Int32 retVal = GetActivePage()->GetReturnVal();

    m_bReg4MsWord       = (retVal & REG4MSWORD);
    m_bReg4MsExcel      = (retVal & REG4MSEXCEL);
    m_bReg4MsPowerPoint = (retVal & REG4MSPOWERPOINT);
    m_bReg4DefHtmlEdt   = (retVal & REG4DEFHTMLEDT);

    Hide( );

    return TRUE;
}

//------------------------------------
//
//------------------------------------

void Reg4MsDocMainDialog::EnableReg4MsWord( BOOL bEnable )
{
    m_bEnableReg4MsWord = bEnable;
}

//------------------------------------
//
//------------------------------------

void Reg4MsDocMainDialog::EnableReg4MsExcel( BOOL bEnable )
{
    m_bEnableReg4MsExcel = bEnable;
}

//------------------------------------
//
//------------------------------------

void Reg4MsDocMainDialog::EnableReg4MsPowerPoint( BOOL bEnable )
{
    m_bEnableReg4MsPowerPoint = bEnable;
}

//------------------------------------
//
//------------------------------------

void Reg4MsDocMainDialog::EnableReg4DefHtmlEdt( BOOL bEnable )
{
    m_bEnableReg4DefHtmlEdt = bEnable;
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::EnableReg4MsWord( )
{
    return m_bEnableReg4MsWord;
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::EnableReg4MsExcel( )
{
    return m_bEnableReg4MsExcel;
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::EnableReg4MsPowerPoint( )
{
    return m_bEnableReg4MsPowerPoint;
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::EnableReg4DefHtmlEdt( )
{
    return m_bEnableReg4DefHtmlEdt;
}

//------------------------------------
//
//------------------------------------
    
void Reg4MsDocMainDialog::Reg4MsWord( BOOL bCheck )
{
    m_bReg4MsWord = bCheck;
}

//------------------------------------
//
//------------------------------------

void Reg4MsDocMainDialog::Reg4MsExcel( BOOL bCheck )
{
    m_bReg4MsExcel = bCheck;
}

//------------------------------------
//
//------------------------------------

void Reg4MsDocMainDialog::Reg4MsPowerPoint( BOOL bCheck )
{
    m_bReg4MsPowerPoint = bCheck;
}

//------------------------------------
//
//------------------------------------

void Reg4MsDocMainDialog::Reg4DefHtmlEdt( BOOL bCheck )
{
    m_bReg4DefHtmlEdt = bCheck;
}

//------------------------------------
//
//------------------------------------
    
BOOL Reg4MsDocMainDialog::Reg4MsWord( )
{
    return m_bReg4MsWord;
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::Reg4MsExcel( )
{
    return m_bReg4MsExcel;
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::Reg4MsPowerPoint( )
{
    return m_bReg4MsPowerPoint;
}

//------------------------------------
//
//------------------------------------

BOOL Reg4MsDocMainDialog::Reg4DefHtmlEdt( )
{
    return m_bReg4DefHtmlEdt;
}




