/*************************************************************************
 *
 *  $RCSfile: mainwnd.cxx,v $
 *
 *  $Revision: 1.14.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:47:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#if defined(WNT)
#include <tools/svwin.h>
#endif

#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif

#ifndef _SV_SETTINGS_HXX //autogen
#include <vcl/settings.hxx>
#endif

#ifndef _SV_GRADIENT_HXX //autogen
#include <vcl/gradient.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include <tools/l2txtenc.hxx>

#include "main.hxx"
#include "mainwnd.hxx"
#include "agenda.hxx"
#include "progress.hxx"
#include "texture.hxx"
#include "decltor.hxx"
#include "environ.hxx"
#include "fader.hxx"

#include "app.hrc"
#include "strings.hrc"

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif

#ifndef _SV_OUTDEV_HXX
#include <vcl/outdev.hxx>
#endif

using namespace ::com::sun::star;

//------------------------------------------------------------------------

#define BUT_POSX					22
#define BUT_POSY 					3

// #define WALLPAPER_MODE				1
#define KNIGHT_RIDER_MODE			1
#define ANIM_STEP					12

#define HEAD_COLOR					Color(RGB_COLORDATA( 0x33, 0x33, 0x66 ))
#define HEAD_LOWER_COLOR	  		Color(RGB_COLORDATA( 0xcc, 0xcc, 0xff ))
#define HEAD_HEIGHT_PERCENT			10
#define HEAD_HEIGHT_MINPIXEL		56
#define HEAD_HEIGHT_MAXPIXEL		56

#define LEFT_COLOR					Color(RGB_COLORDATA( 0x33, 0x33, 0x66 ))
#define LEFT_RIGHT_COLOR	  		Color(RGB_COLORDATA( 0x00, 0x00, 0x00 ))
#define LEFT_WIDTH_PERCENT			20
#define LEFT_WIDTH_MINPIXEL			170
#define LEFT_WIDTH_MAXPIXEL			170
#define LEFT_SCROLL_BORDER			50

#define CONT_COLOR					Color(RGB_COLORDATA( 0x66, 0x66, 0x99 ))

#define DEF_HEADLINE_FONTSIZE_OFFSET	4
#define DEF_INFO_SPACE					10
#define DEF_PROGBAR_DIST_UPPER			20
#define DEF_TIME_DIST					10
#define DEF_TIMEOUT						500
#define DEF_LINE_DIST					2

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

SetupWindow::SetupWindow( ResMgr* pMgr ) :
		WorkWindow			( NULL, WB_APP | WB_STDWORK | WB_CLIPCHILDREN )
{
	SetBackground();

	m_pHeadWin = new HeadWin( this, 0, pMgr );
	m_pLeftWin = new LeftWin( this, 0, pMgr );
	m_pContWin = new ContWin( this, 0, pMgr );

	m_pHeadWin->Show();
	m_pLeftWin->Show();
	m_pContWin->Show();
}

SetupWindow::~SetupWindow()
{
	delete m_pHeadWin;
	delete m_pLeftWin;
	delete m_pContWin;
}

BOOL SetupWindow::Close()
{
	SiInstallSubMode eInstallSubMode = pSetupApp->GetAgenda() ?
		pSetupApp->GetAgenda()->GetInstallSubMode() : ISM_INVALID;

	if( !pSetupApp->IsResponseMode() && eInstallSubMode != ISM_DELETE )
		pSetupApp->Exit();

	return FALSE;
}

void SetupWindow::Resize()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Size aSz( GetOutputSizePixel() );

	Size aLeftSz( aSz.Width() * LEFT_WIDTH_PERCENT / 100, aSz.Height() );
	if( aLeftSz.Width() < LEFT_WIDTH_MINPIXEL )
		aLeftSz.Width() = LEFT_WIDTH_MINPIXEL;
	else if( aLeftSz.Width() > LEFT_WIDTH_MAXPIXEL )
		aLeftSz.Width() = LEFT_WIDTH_MAXPIXEL;

	Size aHeadSz( aSz.Width() - aLeftSz.Width(), aSz.Height() * HEAD_HEIGHT_PERCENT / 100 );
	if( aHeadSz.Height() < HEAD_HEIGHT_MINPIXEL )
		aHeadSz.Height() = HEAD_HEIGHT_MINPIXEL;
	else if( aHeadSz.Height() > HEAD_HEIGHT_MAXPIXEL )
		aHeadSz.Height() = HEAD_HEIGHT_MAXPIXEL;

	Size aContSz( aSz.Width() - aLeftSz.Width(), aSz.Height() - aHeadSz.Height() );

	m_pHeadWin->SetPosSizePixel( Point(aLeftSz.Width(),0), aHeadSz );
	m_pLeftWin->SetPosSizePixel( Point(0,0), aLeftSz );
	m_pContWin->SetPosSizePixel( Point(aLeftSz.Width(), aHeadSz.Height()), aContSz );

	pSetupApp->MainWindowResize();
}

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

HeadWin::HeadWin( Window* pParent, WinBits nWinBits, ResMgr* pMgr ) :
		Window				( pParent, nWinBits | WB_CLIPCHILDREN ),
		m_aRestoreBtn		( this, ResId(IMG_RESTOREBUTTON, pMgr) )
{
	SetBackground( Wallpaper(HEAD_COLOR) );

	m_aRestoreBtn.SetHelpText( String(ResId(STR_RESTOREBUTTON_HELP, pMgr)) );

	Size aButtonSize	 = m_aRestoreBtn.GetImage().GetSizePixel();
	aButtonSize.Width()  += 4;
	aButtonSize.Height() += 4;

	m_aRestoreBtn.SetOutputSizePixel( aButtonSize );
	m_aRestoreBtn.SetClickHdl( LINK(this, HeadWin, RestoreHdl) );
	SetButtonPos();

//	#if defined(UNX) || defined(OS2)
	m_aRestoreBtn.Hide();
//	#else
//	if( !pSetupApp->IsResponseMode() )
//		m_aRestoreBtn.Show();
//	else
//		m_aRestoreBtn.Hide();
//	#endif

#ifndef OS2
	m_aProductFont = Font( UniString::CreateFromAscii("Arial"), Size(0,36) );
#else
	m_aProductFont = Font( UniString::CreateFromAscii("Helv"), Size(0,36) );
#endif

	m_aProductFont.SetTransparent( TRUE );
	m_aProductFont.SetColor( Color(COL_WHITE) );
	// m_aProductFont.SetShadow( TRUE );

	m_aAniStartTimer.SetTimeout(500);
	m_aAniStartTimer.SetTimeoutHdl( LINK(this, HeadWin, AnimStartHdl) );
	m_bAnimReady = FALSE;
	m_bTextMode = TRUE;

	if( Date().GetDay() == 1 &&
		Date().GetMonth() == 4 )
	{
		m_aTextAni.SetScrollDelay( 2 );
		m_aTextAni.SetMode( TAM_ALTERNATE );
	}
	else
	{
		m_aTextAni.SetScrollDelay( 1 );
		m_aTextAni.SetLoop( 1 );
		m_aTextAni.SetMode( TAM_SLIDE );
	}

	m_aTextAni.SetFont( m_aProductFont );
	m_aTextAni.SetReadyHdl( LINK(this, HeadWin, AnimReadyHdl) );

	m_pVDev = NULL;
}

HeadWin::~HeadWin()
{
	if( m_pVDev )
		delete m_pVDev;
}

void HeadWin::DrawODev( OutputDevice* pOutDev )
{
	Size aSz( GetOutputSizePixel() );
	pOutDev->SetLineColor( HEAD_LOWER_COLOR );
	pOutDev->DrawLine( Point(0, aSz.Height()-1), Point(aSz.Width(), aSz.Height()-1) );
}

void HeadWin::Paint( const Rectangle& rRect )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if( Application::GetAppWindow()->IsMinimized() )
		return ;

	Size aSz( GetOutputSizePixel() );
	DrawODev( this );

	if( m_bTextMode )
	{
		if( m_bAnimReady )
		{
			Font aOld = GetFont();
			SetFont( m_aProductFont );
			DrawText( Point(LEFT_SCROLL_BORDER, 7), m_aProductName );
			SetFont( aOld );
		}
		else if( m_aTextAni.IsInAnimation() )
		{
			VirtualDevice* pVDev = m_aTextAni.GetFirstBackground();
			if( !pVDev )
				return ;
			SaveBackground( rRect.TopLeft(), rRect.GetSize(),
							rRect.TopLeft() - Point(LEFT_SCROLL_BORDER, 7), *pVDev );
		}
	}
	else if( m_bAnimReady )
		DrawImage( m_aAnimPoint, m_aProductBMP );

}

void HeadWin::Resize()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
	SetButtonPos();
	if( m_pVDev ) {
		delete m_pVDev;
		m_pVDev = NULL;
	}
}

void HeadWin::SetButtonPos()
{
	Size aSz( GetOutputSizePixel() );
	m_aRestoreBtn.SetPosPixel( Point(aSz.Width() - 10 -
									 m_aRestoreBtn.GetImage().GetSizePixel().Width(), 5) );
}

void HeadWin::SetProductName( const String& rNew )
{
	m_aProductName = rNew;
	if( Date().GetDay() == 1 &&
		Date().GetMonth() == 4 )
	{
		m_aProductName += UniString::CreateFromAscii(" ;-)");
	}
	m_bTextMode = TRUE;
	m_aTextAni.SetText( ByteString(m_aProductName, osl_getThreadTextEncoding()) );
	m_aAniStartTimer.Start();
}

void HeadWin::SetProductBMP( const ByteString& rNew )
{
	Bitmap		aBmp, aMask;
	SiDirEntry 	aFileName( pSetupApp->GetEnvironment()->GetStartPath() );
	aFileName += rNew;

	ByteString aAppName( pSetupApp->GetEnvironment()->GetProductName() );
	if( aAppName.ToLowerAscii().Search("suite") != STRING_NOTFOUND )
	{
		ByteString aFName( aFileName.GetBase(), osl_getThreadTextEncoding() );
		aFName += "_cjk";
		aFName += ".";
		aFName += ByteString( aFileName.GetExtension(), osl_getThreadTextEncoding() );

		DirEntry aEntry( aFileName );
		aEntry.SetName( UniString(aFName, osl_getThreadTextEncoding()) );
		if( aEntry.Exists() ) aFileName = aEntry;
	}

	if( !aFileName.Exists() ) {
		SetProductName( UniString(pSetupApp->GetEnvironment()->GetProductName(), osl_getThreadTextEncoding()) );
		return ;
	}

	rtl::OUString aFileURL;
	FileBase::getFileURLFromSystemPath( aFileName.GetFullUni(), aFileURL );

	SvFileStream aSvFileStrm( aFileURL, STREAM_READ );
	aSvFileStrm >> aBmp;

	m_aProductBMP = Image( aBmp, aBmp.CreateMask( COL_LIGHTMAGENTA, 5UL ) );
	m_bTextMode = FALSE;
	m_bAnimReady = FALSE;

	m_aAnimPoint = Point( GetSizePixel().Width(), 0 );
	m_aAniStartTimer.SetTimeout( 10 );
	m_aAniStartTimer.Start();
}

void HeadWin::RedrawVDev()
{
	if( m_pVDev ) delete m_pVDev;

	m_pVDev = new VirtualDevice( *this );
	m_pVDev->SetBackground( Wallpaper(HEAD_COLOR) );
	m_pVDev->SetOutputSizePixel( GetOutputSizePixel() );

	DrawODev( m_pVDev );
}

IMPL_LINK(HeadWin, AnimStartHdl, TextAnimation*, EMPTYARG)
{
	Size  aSz( GetSizePixel() );
	Point aBPos( m_aRestoreBtn.GetPosPixel() );
	if( m_bTextMode )
	{
		m_aTextAni.Start( this, Point(LEFT_SCROLL_BORDER, 7),
						  Size((aSz.Width() - (aSz.Width() - aBPos.X()))-LEFT_SCROLL_BORDER, 45) );
	}
	else
	{
		if( !m_pVDev ) RedrawVDev();

		if( m_aAnimPoint.X() > ANIM_STEP + LEFT_SCROLL_BORDER)
			m_aAnimPoint.X() -= ANIM_STEP;
		else
			m_aAnimPoint.X() = LEFT_SCROLL_BORDER;

		Size aImgSz( m_aProductBMP.GetSizePixel() );
		aImgSz.Width() += ANIM_STEP;

		VirtualDevice aTmpVDev;
		aTmpVDev.SetOutputSizePixel( aImgSz, FALSE );

		aTmpVDev.DrawOutDev( Point(0, 0), aImgSz, Point(m_aAnimPoint.X(), m_aAnimPoint.Y()),
							 aImgSz, *m_pVDev );
		aTmpVDev.DrawImage( Point(0, 0), m_aProductBMP );

		DrawOutDev( m_aAnimPoint, aImgSz,
					Point(0, 0), aTmpVDev.GetOutputSizePixel(), aTmpVDev );

		if( m_aAnimPoint.X() > LEFT_SCROLL_BORDER )
			m_aAniStartTimer.Start();
		else
		{
			m_bAnimReady = TRUE;
			delete m_pVDev;
			m_pVDev = NULL;
		}
	}
	return 1;
}

IMPL_LINK(HeadWin, AnimReadyHdl, TextAnimation*, EMPTYARG)
{
	m_aTextAni.Stop();
	m_bAnimReady = TRUE;
	return 1;
}

IMPL_LINK(HeadWin, RestoreHdl, Button*, EMPTYARG)
{
	if( !pSetupApp->GetAgenda() )
	{
		String aMsg( ResId(STR_EXITSETUP) );
		aMsg.SearchAndReplace( UniString::CreateFromAscii("%1"),
							   UniString::CreateFromAscii(pSetupApp->GetEnvironment()->GetProductName().GetBuffer()) );

		QueryBox aBox( this, WB_YES_NO | WB_DEF_NO, aMsg );
		if( aBox.Execute() != RET_YES )
			return 0;
	}

	SiInstallSubMode eInstallSubMode = pSetupApp->GetAgenda() ?
		pSetupApp->GetAgenda()->GetInstallSubMode() : ISM_INVALID;

	if( !pSetupApp->IsResponseMode() && eInstallSubMode != ISM_DELETE )
	{
		pSetupApp->PostUserEvent( EVT_END );
	}
	return 0;
}

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

LeftWin::LeftWin( Window* pParent, WinBits nWinBits, ResMgr* pMgr ) :
		Window	   			( pParent, nWinBits | WB_CLIPCHILDREN ),
		m_aButterFlyImg		( ResId(IMG_OPENOFFICE, pMgr) ),
		m_aClockImg			( ResId(IMG_CLOCK, pMgr) ),
		m_aFTPrepare		( this, ResId(FT_INSTINFO_PREPARE, pMgr) ),
		m_aFTMkDir	   		( this, ResId(FT_INSTINFO_MKDIR, pMgr) ),
		m_aFTCopy			( this, ResId(FT_INSTINFO_COPY, pMgr) ),
		m_aFTLocal			( this, ResId(FT_INSTINFO_LOCAL, pMgr) ),
		m_aFTRegisterUno	( this, ResId(FT_INSTINFO_REGUNOCOMPONENT, pMgr) ),
		m_aFTChange			( this, ResId(FT_INSTINFO_CHANGE, pMgr) ),
		m_aFTDelete			( this, ResId(FT_INSTINFO_DELETE, pMgr) ),
		m_aFTRmDir			( this, ResId(FT_INSTINFO_RMDIR, pMgr) ),
		m_aFTUnregister		( this, ResId(FT_INSTINFO_UNREGISTER, pMgr) ),
		m_aFTRecoverFiles	( this, ResId(FT_INSTINFO_RECOVER_FILES, pMgr) ),
		m_aFTRecoverLocal	( this, ResId(FT_INSTINFO_RECOVER_LOCAL, pMgr) ),
		m_aFTRecoverHelp	( this, ResId(FT_INSTINFO_RECOVER_HELP, pMgr) ),

		m_aAnimator(this, pMgr)
{
	SetBackground( Wallpaper(LEFT_COLOR) );

	m_pProgress = NULL;
	m_pUnknownProgress = NULL;
	m_bInProgress = FALSE;
	m_eOldActionType = AT_UNKNOWN;

	m_aTimer.SetTimeout( DEF_TIMEOUT );
	m_aTimer.SetTimeoutHdl( LINK(this, LeftWin, TimeoutHdl) );

	// m_aKnightRider.SetTimeout( 10 );
	// m_aKnightRider.SetTimeoutHdl( LINK(this, LeftWin, KnightRiderHdl) );

	SetFTColor( m_aFTPrepare, TRUE );
	SetFTColor( m_aFTMkDir );
	SetFTColor( m_aFTCopy );
	SetFTColor( m_aFTLocal );
	SetFTColor( m_aFTRegisterUno );
	SetFTColor( m_aFTChange );

	SetFTColor( m_aFTDelete	);
	SetFTColor( m_aFTRmDir );
	SetFTColor( m_aFTUnregister	);

	SetFTColor( m_aFTRecoverFiles );
	SetFTColor( m_aFTRecoverLocal );
	SetFTColor( m_aFTRecoverHelp );

	ShowInstInfo( FALSE );
}

LeftWin::~LeftWin()
{
}

void LeftWin::Resize()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Size aSz( GetSizePixel() );
	aSz.Width() -= m_aFTPrepare.GetPosPixel().X() * 2;

	if( m_bInProgress && m_pProgress )
		m_pProgress->SetSizePixel( Size(aSz.Width(), m_pProgress->GetSizePixel().Height()) );

	m_aFTLocal.SetSizePixel		( Size(aSz.Width(), m_aFTLocal.GetSizePixel().Height()) );
	m_aFTPrepare.SetSizePixel	( Size(aSz.Width(), m_aFTPrepare.GetSizePixel().Height()) );
	m_aFTMkDir.SetSizePixel		( Size(aSz.Width(), m_aFTMkDir.GetSizePixel().Height()) );
	m_aFTCopy.SetSizePixel		( Size(aSz.Width(), m_aFTCopy.GetSizePixel().Height()) );
	m_aFTRegisterUno.SetSizePixel( Size(aSz.Width(), m_aFTRegisterUno.GetSizePixel().Height()) );
	m_aFTChange.SetSizePixel  	( Size(aSz.Width(), m_aFTChange.GetSizePixel().Height()) );
	m_aFTDelete.SetSizePixel    ( Size(aSz.Width(), m_aFTDelete.GetSizePixel().Height()) );
	m_aFTRmDir.SetSizePixel     ( Size(aSz.Width(), m_aFTRmDir.GetSizePixel().Height()) );
	m_aFTUnregister.SetSizePixel( Size(aSz.Width(), m_aFTUnregister.GetSizePixel().Height()) );
	m_aFTRecoverFiles.SetSizePixel( Size(aSz.Width(), m_aFTRecoverFiles.GetSizePixel().Height()) );
	m_aFTRecoverLocal.SetSizePixel( Size(aSz.Width(), m_aFTRecoverLocal.GetSizePixel().Height()) );
	m_aFTRecoverHelp.SetSizePixel( Size(aSz.Width(), m_aFTRecoverHelp.GetSizePixel().Height()) );
}

void LeftWin::Paint( const Rectangle& rRect )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if( Application::GetAppWindow()->IsMinimized() )
		return ;

	Size aSz( GetOutputSizePixel() );
	SetupWindow* pMWin = (SetupWindow*)Application::GetAppWindow();

	SetLineColor( LEFT_RIGHT_COLOR );
	DrawLine( Point(aSz.Width()-1, pMWin->GetHeadWin()->GetOutputSizePixel().Height()-1),
			  Point(aSz.Width()-1, aSz.Height()) );

	Rectangle aButRect( Point(BUT_POSX, BUT_POSY), m_aButterFlyImg.GetSizePixel() );
	if( rRect.IsOver(aButRect) )
		DrawImage( Point(BUT_POSX, BUT_POSY), m_aButterFlyImg );

	if( m_bInProgress )
	{
		DrawTime( &m_aLastTime );
	}
	// repaint Animation
	m_aAnimator.Paint();
	//!
	// HACK: to test KnightRider
	// StartUnknownProgress();
}

void LeftWin::SetVendorBMP( const ByteString& rNew )
{
	if( !rNew.Len() ) return ;

	Bitmap		aBmp, aMask;
	SiDirEntry 	aFileName( pSetupApp->GetEnvironment()->GetStartPath() );

	aFileName += rNew;
	if( !aFileName.Exists() ) return ;

	SvFileStream aSvFileStrm( aFileName.GetFullUni(), STREAM_READ );
	aSvFileStrm >> aBmp;

	m_aButterFlyImg = Image( aBmp, aBmp.CreateMask( COL_LIGHTMAGENTA, 5UL ) );
}

void LeftWin::StartProgress()
{
	if( m_pProgress )
		delete m_pProgress;

	m_pProgress = new SiProgressBar( this );
	m_pProgress->SetPosSizePixel(
		Point(5, m_aFTLocal.GetPosPixel().Y() + m_aFTLocal.GetSizePixel().Height() +
			  DEF_PROGBAR_DIST_UPPER), Size(GetSizePixel().Width()-10, 15) );

	m_pProgress->Show();

	m_lGuess 	= 9999999;
	m_nPercent	= 0;

	m_aStopWatch.Start();
	m_aTimer.Start();
	m_bInProgress = TRUE;
}

void LeftWin::StopProgress()
{
	m_bInProgress = FALSE;

	m_aStopWatch.Stop();
	m_aTimer.Stop();

	ShowInstInfo( FALSE );
	DrawTime( NULL );

	StopUnknownProgress();
	if( m_pProgress )
		delete m_pProgress;
	m_pProgress = NULL;
}

void LeftWin::DrawTime( Time* pTime )
{
	if( !m_pProgress )
		return;

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	USHORT nY = m_pProgress->GetPosPixel().Y() + m_pProgress->GetSizePixel().Height() +
		DEF_TIME_DIST;
	if( !pTime )
	{
		Rectangle aRect( Point(0, nY), Size(GetSizePixel().Width() + 10, 30) );
		Invalidate( aRect );
//		Update();
		return;
	}


	Time aDrawTime = *pTime;
	Color aTextColor = Color(COL_WHITE);

	International aInter;
	String sTime( aInter.GetDuration(aDrawTime) );
	sTime += UniString::CreateFromAscii("     ");

	Font aOld( GetFont() );
	Font aFont( aOld );

	aFont.SetTransparent( FALSE );
	aFont.SetFillColor( LEFT_COLOR );
	aFont.SetColor( aTextColor );

	SetFont( aFont );
	DrawText( Point(40, nY + 5), sTime );
	DrawImage( Point(5, nY), m_aClockImg );
	SetFont( aOld );
//	Update();
}

void LeftWin::StartUnknownProgress()
{
	sal_Int32 nYPos = m_aFTLocal.GetPosPixel().Y() + m_aFTLocal.GetSizePixel().Height() + DEF_PROGBAR_DIST_UPPER;
	Point aPoint(3, nYPos);
	m_aAnimator.SetPos(aPoint);
	m_aAnimator.StartAnim();
/*
  if( !m_pUnknownProgress )
  {
  sal_Int32 nYPos = m_aFTLocal.GetPosPixel().Y() + m_aFTLocal.GetSizePixel().Height() + DEF_PROGBAR_DIST_UPPER;
  sal_Int32 nSize = this->GetSizePixel().Width()-10;
  if (nSize <= 0)
  nSize = 150;

  Rectangle aRect( Point(5, nYPos), Size(nSize, 20) );
  m_pUnknownProgress = new UnknownProgress(this, aRect);
  m_aKnightRider.Start();
  }
*/
}

void LeftWin::StopUnknownProgress()
{
	m_aAnimator.StopAnim();

/*
  if( m_pUnknownProgress )
  {
  Rectangle rect = m_pUnknownProgress->GetRect();

  m_aKnightRider.Stop();
  delete m_pUnknownProgress;
  m_pUnknownProgress = NULL;

  Invalidate( rect );
  Update();
  }
*/
}

void LeftWin::SetPercentage( USHORT nPercent )
{
	if( !m_pProgress )
		return ;
	m_nPercent = nPercent;
	m_pProgress->SetPercent( m_nPercent );
}

void LeftWin::ShowInstInfo( BOOL bShow, SiInstallSubMode eMode, SiEnvironment* pEnv,
							USHORT nUserProf, USHORT nMaxProf )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	eActiveMode = eMode;

	if( !bShow )
	{
		m_aFTPrepare.Hide();
		m_aFTMkDir.Hide();
		m_aFTCopy.Hide();
		m_aFTLocal.Hide();
		m_aFTRegisterUno.Hide();
		m_aFTChange.Hide();
		m_aFTRecoverFiles.Hide();
		m_aFTRecoverLocal.Hide();
		m_aFTRecoverHelp.Hide();
		m_aFTDelete.Hide();
		m_aFTRmDir.Hide();
		m_aFTUnregister.Hide();
	}
	else if( eActiveMode == ISM_ADD )
	{
		if( !pEnv || !pEnv->IsUpdateOldVersion() )
			m_aFTPrepare.Show();

		m_aFTMkDir.Show();
		m_aFTCopy.Show();
		m_aFTLocal.Show();
		m_aFTRegisterUno.Show();
	}
	else if( eActiveMode == ISM_DELETE )
	{
		m_aFTDelete.Show();
		m_aFTRmDir.Show();
		m_aFTUnregister.Show();
	}
	else if( eActiveMode == ISM_CHANGE )
	{
		m_aFTChange.Show();
		m_aFTLocal.Show();
		m_aFTRegisterUno.Show();
	}
	else if( eActiveMode == ISM_RECOVER )
	{
		m_aFTRecoverFiles.Show();
		m_aFTRecoverLocal.Show();
		m_aFTRegisterUno.Show();
	}
	else if( eActiveMode == ISM_APPSERVER_USER )
	{
		String aStr( ResId(STR_APPSERVER_USER_INSTALL, (ResMgr*)pSetupApp->GetResManager()) );
		aStr.SearchAndReplace( UniString::CreateFromAscii("%1"),
							   UniString::CreateFromInt32(nUserProf) );
		aStr.SearchAndReplace( UniString::CreateFromAscii("%2"),
							   UniString::CreateFromInt32(nMaxProf) );

		m_aFTPrepare.SetText( aStr );
		m_aFTPrepare.Show();
		m_aFTMkDir.Show();
		m_aFTCopy.Show();
		m_aFTLocal.Show();
	}
}

void LeftWin::SetActionType(SiActionType eType)
{
	if( eType == m_eOldActionType ||
		eType == AT_PROCEDURE )
		return ;

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if( eType == AT_HELP || eType == AT_REGISTER || eType == AT_REGUNO )
	{
#ifdef KNIGHT_RIDER_MODE
		if( !m_pUnknownProgress )
		{
			m_bInProgress = FALSE;
			DrawTime( NULL );

			m_aStopWatch.Stop();
			m_aTimer.Stop();

			if( m_pProgress )
				delete m_pProgress;
			m_pProgress = NULL;

			StartUnknownProgress();
		}
#else
		if( m_pProgress )
		{
			m_aStopWatch.Stop();
			m_aTimer.Stop();
			DrawTime( NULL );
			Rectangle rect( Point(5, m_aFTRegisterUno.GetPosPixel().Y() + m_aFTRegisterUno.GetSizePixel().Height() +
								  DEF_PROGBAR_DIST_UPPER), Size(m_pProgress->GetSizePixel().Width()-10, 20) );

			delete m_pProgress;
			m_pProgress = NULL;

			Invalidate( rect );
		}
#endif
	}


	if( eActiveMode == ISM_ADD || eActiveMode == ISM_APPSERVER_USER )
	{
		SetFTColor( m_aFTPrepare, eActiveMode == ISM_APPSERVER_USER? TRUE : FALSE );
		SetFTColor( m_aFTMkDir,	eType == AT_MAKEDIR ? TRUE : FALSE );
		SetFTColor( m_aFTCopy,	eType == AT_COPY || eType == AT_UNZIP ? TRUE : FALSE );
		SetFTColor( m_aFTLocal, (eType == AT_REGISTER || eType == AT_CONFIGURATION ) ? TRUE : FALSE );
		SetFTColor( m_aFTRegisterUno, eType == AT_REGUNO ? TRUE : FALSE );
	}
	else if( eActiveMode == ISM_DELETE )
	{
		SetFTColor( m_aFTDelete,	eType == AT_DELETE ? TRUE : FALSE );
		SetFTColor( m_aFTRmDir,		eType == AT_RMDIR ? TRUE : FALSE );
		SetFTColor( m_aFTUnregister,eType == AT_UNREGISTER ? TRUE : FALSE );
	}
	else if( eActiveMode == ISM_CHANGE )
	{
		SetFTColor( m_aFTChange, eType == AT_DELETE || eType == AT_COPY || eType == AT_UNZIP ? TRUE : FALSE );
		SetFTColor( m_aFTRegisterUno, eType == AT_REGUNO ? TRUE : FALSE );
		SetFTColor( m_aFTLocal, eType == (AT_REGISTER || eType == AT_CONFIGURATION ) ? TRUE : FALSE );
	}
	else if( eActiveMode == ISM_RECOVER )
	{
		SetFTColor( m_aFTRecoverFiles, eType == AT_MAKEDIR || eType == AT_COPY || eType == AT_UNZIP ? TRUE : FALSE );
		SetFTColor( m_aFTRecoverLocal, (eType == AT_REGISTER || eType == AT_CONFIGURATION)  ? TRUE : FALSE );
		SetFTColor( m_aFTRegisterUno, eType == AT_REGUNO ? TRUE : FALSE );
	}

	Update();
	m_eOldActionType = eType;
}

void LeftWin::SetFTColor( FixedText& rText, BOOL bActive )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Color			aColor( bActive? COL_WHITE : COL_LIGHTGRAY );
	AllSettings		aASettings( rText.GetSettings() );
	StyleSettings	aStyle( aASettings.GetStyleSettings() );

	Font aFont( aStyle.GetLabelFont() );
	if( bActive )
	{
#if defined(OS2)
		aFont.SetWeight( WEIGHT_NORMAL );
#else
		aFont.SetWeight( WEIGHT_BOLD );
#endif
	}
	else
	{
		aFont.SetWeight( WEIGHT_NORMAL );
	}
	aStyle.SetLabelFont( aFont );
	aStyle.SetLabelTextColor( aColor );

	aASettings.SetStyleSettings( aStyle );

	rText.SetSettings( aASettings );

	rText.Update();
	rText.Flush();
}

IMPL_LINK( LeftWin, KnightRiderHdl, void*, EMPTYARG )
{
	if( m_pUnknownProgress )
	{
		NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
		m_pUnknownProgress->TickIt();
	}
	return 0;
}

IMPL_LINK( LeftWin, TimeoutHdl, void*, EMPTYARG )
{
	if( m_nPercent > 0 )
	{
		Time	aTime = m_aStopWatch.GetDuration();
		long	lGuess = ((aTime.GetMSFromTime() / 1000) * 100) / m_nPercent;
		if( m_lGuess <= 0 )
		{
			m_lGuess = lGuess;
			return 0;
		}
		double	dDiff  = double(lGuess) / double(m_lGuess);

		if( dDiff > 0.9 && dDiff < 1.0 )
		{
			Time aNewTime;

			aNewTime.MakeTimeFromMS(1000*lGuess);
			aNewTime -= aTime;

			if( ((aNewTime.GetMSFromTime() / 1000) > 0) &&
				aNewTime < m_aLastTime )
			{
				m_aLastTime = aNewTime;
				DrawTime( &m_aLastTime );
			}
		}
		m_lGuess = lGuess;
	}
	return 0;
}

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

ContWin::ContWin( Window* pParent, WinBits nWinBits, ResMgr* pMgr ) :
		Window		(pParent, nWinBits | WB_CLIPCHILDREN ),
		m_aTextPos	( 0, 0 )
{
	SetBackground( Wallpaper(CONT_COLOR) );

#ifdef WALLPAPER_MODE
	Bitmap aBmp( ResId(STAR_TEXTURE, pMgr) );
	m_pTexture = new Texture;
	m_pTexture->SetStyle( TEXTURE_TILE );
	m_pTexture->SetBitmap( aBmp );
#else
	m_pTexture	= NULL;
#endif

	m_pActSlide = NULL;
	m_pVDev 	= NULL;
	m_bDoFade	= FALSE;
}

ContWin::~ContWin()
{
#ifdef WALLPAPER_MODE
	delete m_pTexture;
#endif

	if( m_pVDev )
		delete m_pVDev;
}

void ContWin::Resize()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	delete m_pVDev;
	m_pVDev = NULL;
	Invalidate();
}

void ContWin::Paint( const Rectangle& rRect )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if( Application::GetAppWindow()->IsMinimized() )
		return ;

	ReDrawVDev();
}

presentation::FadeEffect _StrAsFadeType(const ByteString& rStr)
{
	if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_LEFT") == COMPARE_EQUAL )			return presentation::FadeEffect_FADE_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_TOP") == COMPARE_EQUAL )		return presentation::FadeEffect_FADE_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_FADE_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_BOTTOM") == COMPARE_EQUAL )	return presentation::FadeEffect_FADE_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_TO_CENTER") == COMPARE_EQUAL )		return presentation::FadeEffect_FADE_TO_CENTER;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_CENTER") == COMPARE_EQUAL )	return presentation::FadeEffect_FADE_FROM_CENTER;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_MOVE_FROM_LEFT") == COMPARE_EQUAL )		return presentation::FadeEffect_MOVE_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_MOVE_FROM_TOP") == COMPARE_EQUAL )		return presentation::FadeEffect_MOVE_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_MOVE_FROM_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_MOVE_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_MOVE_FROM_BOTTOM") == COMPARE_EQUAL )	return presentation::FadeEffect_MOVE_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_ROLL_FROM_LEFT") == COMPARE_EQUAL )		return presentation::FadeEffect_ROLL_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_ROLL_FROM_TOP") == COMPARE_EQUAL )		return presentation::FadeEffect_ROLL_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_ROLL_FROM_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_ROLL_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_ROLL_FROM_BOTTOM") == COMPARE_EQUAL )	return presentation::FadeEffect_ROLL_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_HORIZONTAL_STRIPES") == COMPARE_EQUAL )	return presentation::FadeEffect_HORIZONTAL_STRIPES;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_VERTICAL_STRIPES") == COMPARE_EQUAL )	return presentation::FadeEffect_VERTICAL_STRIPES;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_CLOCKWISE") == COMPARE_EQUAL )			return presentation::FadeEffect_CLOCKWISE;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_COUNTERCLOCKWISE") == COMPARE_EQUAL )	return presentation::FadeEffect_COUNTERCLOCKWISE;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_UPPERLEFT") == COMPARE_EQUAL )	return presentation::FadeEffect_FADE_FROM_UPPERLEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_UPPERRIGHT") == COMPARE_EQUAL )return presentation::FadeEffect_FADE_FROM_UPPERRIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_LOWERLEFT") == COMPARE_EQUAL )	return presentation::FadeEffect_FADE_FROM_LOWERLEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_FADE_FROM_LOWERRIGHT") == COMPARE_EQUAL )return presentation::FadeEffect_FADE_FROM_LOWERRIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_CLOSE_VERTICAL") == COMPARE_EQUAL )		return presentation::FadeEffect_CLOSE_VERTICAL;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_CLOSE_HORIZONTAL") == COMPARE_EQUAL )	return presentation::FadeEffect_CLOSE_HORIZONTAL;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_OPEN_VERTICAL") == COMPARE_EQUAL )		return presentation::FadeEffect_OPEN_VERTICAL;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_OPEN_HORIZONTAL") == COMPARE_EQUAL )		return presentation::FadeEffect_OPEN_HORIZONTAL;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_SPIRALIN_LEFT") == COMPARE_EQUAL )		return presentation::FadeEffect_SPIRALIN_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_SPIRALIN_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_SPIRALIN_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_SPIRALOUT_LEFT") == COMPARE_EQUAL )		return presentation::FadeEffect_SPIRALOUT_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_SPIRALOUT_RIGHT") == COMPARE_EQUAL )		return presentation::FadeEffect_SPIRALOUT_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_DISSOLVE") == COMPARE_EQUAL )			return presentation::FadeEffect_DISSOLVE;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_WAVYLINE_FROM_LEFT") == COMPARE_EQUAL )	return presentation::FadeEffect_WAVYLINE_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_WAVYLINE_FROM_TOP") == COMPARE_EQUAL )	return presentation::FadeEffect_WAVYLINE_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_WAVYLINE_FROM_RIGHT") == COMPARE_EQUAL )	return presentation::FadeEffect_WAVYLINE_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_WAVYLINE_FROM_BOTTOM") == COMPARE_EQUAL )return presentation::FadeEffect_WAVYLINE_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_RANDOM") == COMPARE_EQUAL )				return presentation::FadeEffect_RANDOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_STRETCH_FROM_LEFT") == COMPARE_EQUAL )	return presentation::FadeEffect_STRETCH_FROM_LEFT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_STRETCH_FROM_TOP") == COMPARE_EQUAL )	return presentation::FadeEffect_STRETCH_FROM_TOP;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_STRETCH_FROM_RIGHT") == COMPARE_EQUAL )	return presentation::FadeEffect_STRETCH_FROM_RIGHT;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_STRETCH_FROM_BOTTOM") == COMPARE_EQUAL )	return presentation::FadeEffect_STRETCH_FROM_BOTTOM;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_HORIZONTAL_LINES") == COMPARE_EQUAL )	return presentation::FadeEffect_HORIZONTAL_LINES;
	else if( rStr.CompareIgnoreCaseToAscii("FadeEffect_VERTICAL_LINES") == COMPARE_EQUAL )		return presentation::FadeEffect_VERTICAL_LINES;
	return presentation::FadeEffect_NONE;
}

void ContWin::ReDrawVDev()
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
	BOOL bNormalPaint = TRUE;
	if( !m_pVDev )
	{
		m_pVDev = new VirtualDevice( *this );
		m_pVDev->SetBackground( Wallpaper(CONT_COLOR) );
		m_pVDev->SetOutputSizePixel( GetOutputSizePixel() );

#ifdef WALLPAPER_MODE
		DrawTexture( m_pVDev, *m_pTexture );
#endif

		if( m_pActSlide )
		{
			DrawSlideBitmap( m_pVDev );
			DrawSlideText( m_pVDev, FALSE );
			DrawSlideText( m_pVDev );
		}

		if( m_bDoFade )
		{
			Fader* pFader = new Fader( this );
			pFader->SetEffect( m_eFadeType );
			pFader->SetSpeed( m_eFadeSpeed );
			pFader->SetSource(Rectangle( Point(), GetOutputSizePixel()) );
			pFader->SetTarget(Rectangle( Point(), GetOutputSizePixel()) );
			pFader->SetNewVirtualDevice( m_pVDev );
			pFader->Fade();
			delete pFader;

			m_bDoFade = FALSE;
			bNormalPaint = FALSE;
		}
	}

	if( bNormalPaint )
	{
		DrawOutDev( Point(0, 0), GetOutputSizePixel(), Point(0, 0),
					m_pVDev->GetOutputSizePixel(), *m_pVDev );
	}
}

void ContWin::Reset()
{
	delete m_pVDev;
	m_pVDev = NULL;

	m_pActSlide = NULL;

	ReDrawVDev();
}

void ContWin::AnimSlide( const SiSlide* pSlide )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	m_pActSlide = NULL;

	if( pSlide->HasLangRef() )
	{
		m_pActSlide = (SiSlide*)((SiSlide*)pSlide)->GetLangRef( pSetupApp->GetLanguage() );
		if( m_pActSlide ) m_pActSlide->JoinWithParent();
	}
	if( !m_pActSlide )
		m_pActSlide = (SiSlide*)pSlide;

	Bitmap		aBmp, aMask;
	SiDirEntry 	aFileName( pSetupApp->GetEnvironment()->GetStartPath() );

	aFileName += pSlide->GetBmpFileName();
	aFileName.ToAbs();

	SvFileStream aSvFileStrm( aFileName.GetFullUni(), STREAM_READ );
	aSvFileStrm >> aBmp;

	m_aImg = Image( aBmp, aBmp.CreateMask( COL_LIGHTMAGENTA, 5UL ) );

#if defined(WNT)
	if( m_pActSlide->GetWaveFileName().Len() )
	{
		aFileName = pSetupApp->GetEnvironment()->GetStartPath();
		aFileName += m_pActSlide->GetWaveFileName();
		if( aFileName.Exists() )
			PlaySound( aFileName.GetFull().GetBuffer(), NULL, SND_ASYNC | SND_FILENAME );
	}
#endif

	if( m_pVDev )
	{
		delete m_pVDev;
		m_pVDev = NULL;
	}

	if( pSlide->GetFadeType().Len() )
	{
		m_eFadeType = _StrAsFadeType( pSlide->GetFadeType() );
		if( pSlide->GetFadeSpeed().CompareIgnoreCaseToAscii("SLOW") == COMPARE_EQUAL )
			m_eFadeSpeed = FADE_SPEED_SLOW;
		else if( pSlide->GetFadeSpeed().CompareIgnoreCaseToAscii("FAST") == COMPARE_EQUAL )
			m_eFadeSpeed = FADE_SPEED_FAST;
		else
			m_eFadeSpeed = FADE_SPEED_MEDIUM;

		m_bDoFade = TRUE;
	}
	ReDrawVDev();
}

void ContWin::DrawSlideBitmap( OutputDevice* pOutDev )
{
	if( !m_pActSlide )
		return ;

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Size  aSz( GetOutputSizePixel() );
	Size  aImgSz( m_aImg.GetSizePixel() );
	Point aPt( ((aSz.Width() - aImgSz.Width())/2),
			   ((aSz.Height() - aImgSz.Height())/2) );

	pOutDev->DrawImage(aPt, m_aImg);
}


void ContWin::DrawSlideText( OutputDevice* pOutDev, BOOL bDraw )
{
	if( !m_pActSlide )
		return ;

	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Font aFont;
	aFont = GetSettings().GetStyleSettings().GetAppFont();

	aFont.SetCharSet( Langcode2TextEncoding(pSetupApp->GetLanguage()) );
	aFont.SetTransparent( TRUE );
	aFont.SetColor( Color(COL_WHITE) );
	// aFont.SetWeight( WEIGHT_BOLD );

	Font aOld( pOutDev->GetFont() );
	pOutDev->SetFont( aFont );

	ByteString aText( m_pActSlide->GetText() );
	while( aText.Search("\\n") != STRING_NOTFOUND )
		aText.SearchAndReplace( "\\n", "\n" );

	USHORT	nLine		= 0;
	USHORT	nParts		= aText.GetTokenCount('\n');
	ULONG  	nLastY		= m_aTextPos.Y();

	for( USHORT i=0; i < nParts; i++ )
	{
		ByteString	s			( aText.GetToken(i, '\n') );
		UniString	aUniText	( s.GetBuffer(), Langcode2TextEncoding(pSetupApp->GetLanguage()) );

		USHORT c = 0;

		if( i != 0 )
			nLine++;

		if( !aUniText.Len() )
			nLine++;

		else while( c < aUniText.Len() )
		{
			USHORT j;
			// UniString aUniText( s.GetBuffer(), Langcode2TextEncoding(pSetupApp->GetLanguage()) );
			if( nLine == 0)
				j = pOutDev->GetTextBreak( aUniText, 1000, c );
			else
				j = pOutDev->GetTextBreak( aUniText, m_pActSlide->GetTextSize().Width(), c );

			if( j != (USHORT)-1 )
			{
				USHORT nLength = j-c+1;
				USHORT nGoBack = 0;

				while( nLength - nGoBack > 0 && aUniText.GetChar(j-nGoBack) != ' ' )
					nGoBack++;

				if( (nLength - nGoBack) == 0 || (nLine == 0) )
					nGoBack = 0;

				if( bDraw )
				{
					if( nLine == 0 )
					{
						aFont.SetSize( Size(0, m_pActSlide->GetFontSize() + DEF_HEADLINE_FONTSIZE_OFFSET) );
						pOutDev->SetFont(aFont);
						pOutDev->DrawText( Point(m_aTextPos.X(), nLastY), aUniText, c, nLength - nGoBack );
						ULONG nHeight = pOutDev->GetFont().GetSize().Height();
						nLastY += nHeight + nHeight / 2;
						aFont.SetSize( Size(0, m_pActSlide->GetFontSize()) );
						pOutDev->SetFont(aFont);
					}
					else
					{
						pOutDev->DrawText( Point(m_aTextPos.X(), nLastY), aUniText, c, nLength - nGoBack );
						nLastY += pOutDev->GetFont().GetSize().Height() + DEF_LINE_DIST;
					}
				}
				c = j+1-nGoBack;
				nLine++;
			}
			else
			{
				if( bDraw )
				{
					if( nLine == 0 )
					{
						aFont.SetSize( Size(0, m_pActSlide->GetFontSize() + DEF_HEADLINE_FONTSIZE_OFFSET) );
						pOutDev->SetFont(aFont);
						pOutDev->DrawText( Point(m_aTextPos.X(), nLastY), aUniText, c );

						ULONG nHeight = pOutDev->GetFont().GetSize().Height();
						nLastY += nHeight + nHeight / 2;
						aFont.SetSize( Size(0, m_pActSlide->GetFontSize()) );
						pOutDev->SetFont(aFont);
					}
					else
					{
						pOutDev->DrawText( Point(m_aTextPos.X(), nLastY), aUniText, c );
						nLastY += pOutDev->GetFont().GetSize().Height() + DEF_LINE_DIST;
					}
				}
				c = j;
			}
			nLine++;
		}
	}


	Size aMySz( GetOutputSizePixel() );
	Size aImgSz( m_aImg.GetSizePixel() );
	Point aPt( ((aMySz.Width() - aImgSz.Width())/2),
			   ((aMySz.Height() - aImgSz.Height())/2) );

	m_aTextPos = aPt;
	m_aTextPos += m_pActSlide->GetBmpPos();

	pOutDev->SetFont( aOld );
}

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

UnknownProgress::UnknownProgress(OutputDevice* pOut, const Rectangle& rRect)
{
	bUp		= TRUE;
	nStart	= 0;
	nEnd	= 255;
	pOutDev = pOut;
	aRect 	= rRect;
}

void UnknownProgress::TickIt()
{
	Color aStart( 0x00, 0x00, nStart );
	Color aEnd	( 0x00, 0x00, nEnd );

	Gradient aGradient		( GRADIENT_LINEAR );
	aGradient.SetStartColor	( aStart );
	aGradient.SetEndColor	( aEnd );
	aGradient.SetAngle		( 900 );

	pOutDev->DrawGradient( aRect, aGradient );

	if( bUp && nStart == 255 )
		bUp = FALSE;
	else if( !bUp && nStart == 0 )
		bUp = TRUE;

	if( bUp )
	{
		nStart++;
		nEnd--;
	}
	else
	{
		nStart--;
		nEnd++;
	}
}

// -----------------------------------------------------------------------------
// ---------------------------- external prototypes ----------------------------
// -----------------------------------------------------------------------------
extern BOOL ImportGIF(SvStream& rStm, Graphic& rGraphic, void* pCallerData);

////////////////////////////////////////////////////////////////////////////////
// BinaryResLoader
//

class BinaryResLoader : public Resource
{
public:
	BinaryResLoader( SvMemoryStream& rStrm, const ResId& rId );
};
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
// Due to some trouble with BinaryResLoader we(LLA, OK) have decide to insert the animation here.
// to create this, take X.exe (giftotxt.exe) and create the output.
// insert the output here.
// take a picture program and get the picture size

char pProgressAnim[1100] =
{
	"GIF89a\245\0\17\0\221\3\0\63\63f\231\231\314ff\231\377\377\377!\377\13NETSCAPE2.0\3\1\0\0\0!\371\4\5\5\0\3\0,\0\0\0\0\245\0\17\0\0\2h\214\217\251\313\355\17\243\234\264F\201\263\336\274\373\17"
	"\206\342H\226\346\11\32\31\300\266\0\12\307\362L\327\234\212\271\255\315\367\376\217\302\11t,\240\361\210\354\11\211\257\244\363\11M\5V\304\250\365\372\\V\261\334.O\253\363\212\307\301inKN\253;`\327\372\15o\357\340t\262\274X\317w\205\372\276\335\2"
	"\30(8HXhQ\0\0!\371\4\5\5\0\3\0,\16\0\2\0\7\0\13\0\0\2\7\204\217\251\313\355\377\12\0!\371\4\5\5\0\3\0,\30\0\2\0\7\0\13\0\0\2\7\204\217\251\313\355\377\12\0!\371\4\5\5\0\3\0,\4\0\2\0%\0"
	"\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,\16\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274"
	"{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,\30\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8"
	"\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,\42\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217"
	"\360\355B\5\0!\371\4\5\5\0\3\0,,\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,6"
	"\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,@\0\2\0%\0\13\0\0\2,\224/\243\313\355"
	"\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,J\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}"
	"!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,T\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333"
	"\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,^\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5"
	"\0\3\0,h\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,r\0\2\0%\0\13\0\0\2,"
	"\224/\243\313\355\12\242\4\350\274{\247\254\6{\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,|\0\2\0%\0\13\0\0\2,\224/\243\313\355\12\242\4\350\274{\247\254\6{"
	"\246E\\\362}!\305\225f8\252\336\331\272\31\233\312\17\\\333\15^\351\16\217\360\355B\5\0!\371\4\5\5\0\3\0,\206\0\2\0\7\0\13\0\0\2\7\224\217\251\313\355\377\12\0;"
};
// -----------------------------------------------------------------------------
GifAnimator::GifAnimator(Window* _pParent, ResMgr* _pResMgr)
		:m_pWindow(_pParent),
		 m_pResMgr(_pResMgr),
		 m_pFB(NULL),
		 m_pAnim(NULL),
		 m_bAnim(false)
{
	OSL_ASSERT(_pParent);
	OSL_ASSERT(_pResMgr);

	m_pFB = new FixedBitmap( m_pWindow );
	// m_pFB->SetBackground( Wallpaper(LEFT_COLOR) );
	m_pFB->SetBackground( Wallpaper(CONT_COLOR) );

	SetSize();
}

void GifAnimator::SetSize()
{
	// Size of the GIF, sorry
	Size aWinSz(165, 15);

	m_aRect.SetSize(aWinSz);

	m_pFB->SetSizePixel( aWinSz );
}

void GifAnimator::SetPos(Point const& _aPoint)
{
	m_pFB->SetPosPixel( _aPoint );
	m_aRect.SetPos(_aPoint);
}

IMPL_LINK(GifAnimator, AnimHdl, void*, pEmpty)
{
	if( !m_bAnim )
		return 1;

/* File based
	ByteString sFilename = "progressanim.gif";
	UniString suFilename(sFilename, osl_getThreadTextEncoding());

	SvFileStream aStrm(suFilename, STREAM_READ);
*/

/* Resource based, don't work today
  SvMemoryStream	aStrm;

  try {
  BinaryResLoader aLoader( aStrm, ResId(RESID_DLG_AGENT_ANIMATE_KNIGHTRIDER, m_pResMgr) );
  }
  catch (...)
  {
  volatile int dummy = 0;
  }
*/
// Hard coded
	SvMemoryStream	aStrm(pProgressAnim, 1100, STREAM_READ);

	// delete old animation
	if( m_pAnim )
		delete m_pAnim;

	// create new animation object
	m_pAnim = new Graphic;
	// aStrm.Seek( STREAM_SEEK_TO_END );
	// ULONG nBytes = aStrm.Tell();
	aStrm.Seek( STREAM_SEEK_TO_BEGIN );
	// ULONG nBytes2 = aStrm.Tell();

	BOOL bSucc = ImportGIF( aStrm, *m_pAnim, NULL );
	if( bSucc )
	{
		m_pFB->Show();
		m_pAnim->StartAnimation( m_pFB, Point(0, 0) );
	}

	return 1;
}

void GifAnimator::Paint()
{
	if( m_bAnim && m_pAnim )
	{
		m_pFB->Paint(m_aRect);
		// m_pAnim->StopAnimation();
		// m_pAnim->StartAnimation( m_pFB, Point(0, 0) );
	}
}

void GifAnimator::StartAnim()
{
	if (m_bAnim == false)
	{
		m_bAnim = true;
		m_aStartAnimTimer.SetTimeout( 5 );
		m_aStartAnimTimer.SetTimeoutHdl( LINK(this, GifAnimator, AnimHdl) );
		m_aStartAnimTimer.Start();
	}
}

void GifAnimator::StopAnim()
{
	if( !m_bAnim )
		return ;
	if( m_pAnim )
	{
		m_pFB->Hide();
		m_pAnim->StopAnimation();
		delete m_pAnim;
		m_pAnim = NULL;
	}
}
