/*************************************************************************
 *
 *  $RCSfile: pipath.cxx,v $
 *
 *  $Revision: 1.27.4.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:47:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HEADBAR_HXX //autogen
#include <svtools/headbar.hxx>
#endif

#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SVT_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif

#include "maindlg.hxx"
#include "os.hxx"
#include "script.hxx"
#include "environ.hxx"
#include "sihelp.hxx"
#include "action.hxx"

#include "maindlg.hrc"
#include "pipath.hxx"
#include "pipath.hrc"

#define HEAD_HEIGTH 16

// ============================================================================

DriveTabBox::DriveTabBox( Window* pParent, const ResId& rResId ) :
		SvTabListBox( pParent, rResId )
{
	pBtnDataProgLang = NULL;
	pBtnDataDocLang = NULL;
}

DriveTabBox::~DriveTabBox()
{
}

void DriveTabBox::InsertDrive( BOOL bNet, const ByteString& rName, const ByteString& rNeed, const ByteString& rFree, HD_Entry* pHDEntry )
{
	SvLBoxEntry* pEntry = new SvLBoxEntry;
	if( !bNet )
		pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, Image(ResId(IMG_DRIVE)), Image(ResId(IMG_DRIVE)), 0 ) );
	else
		pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, Image(ResId(IMG_NETDRIVE)), Image(ResId(IMG_NETDRIVE)), 0 ) );

	pEntry->AddItem( new SvLBoxString( pEntry, 0, String(rName, osl_getThreadTextEncoding())) );
	pEntry->AddItem( new SvLBoxString( pEntry, 0, String(rNeed, osl_getThreadTextEncoding())) );
	pEntry->AddItem( new SvLBoxString( pEntry, 0, String(rFree, osl_getThreadTextEncoding())) );

	pEntry->SetUserData( (void*)pHDEntry );
	Insert( pEntry );
}

void DriveTabBox::SetTabs()
{
	SvTabListBox::SetTabs();

	USHORT nAdjust = SV_LBOXTAB_ADJUST_RIGHT|SV_LBOXTAB_ADJUST_LEFT|SV_LBOXTAB_ADJUST_CENTER|SV_LBOXTAB_ADJUST_NUMERIC|SV_LBOXTAB_FORCE;

	SvLBoxTab* pTab = (SvLBoxTab*)aTabs.GetObject( 2 );
	pTab->nFlags &= ~nAdjust;
	pTab->nFlags |= SV_LBOXTAB_ADJUST_RIGHT;

	pTab = (SvLBoxTab*)aTabs.GetObject( 3 );
	pTab->nFlags &= ~nAdjust;
	pTab->nFlags |= SV_LBOXTAB_ADJUST_RIGHT;
}

// ============================================================================

BOOL PageInstPath::isAdabas()
{
	SiInstallation*	pInst = GETDLG()->GetCScript()->GetInstallation();
	return setup::isAdabas(pInst);
}

PageInstPath::PageInstPath( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFTInfo3		( this, ResId(FT_INFO3, rResId.GetResMgr()) ),
	aFTInfo4		( this, ResId(FT_INFO4, rResId.GetResMgr()) ),
	aFTInfo5		( this, ResId(FT_INFO5, rResId.GetResMgr()) ),
	aEDPath			( this, ResId(ED_PATH, rResId.GetResMgr()) ),
	aDriveBox		( this, ResId(TLB_DRIVEBOX, rResId.GetResMgr()) ),
	aEDResponsefile	( this, ResId(ED_RESPONSEFILE, rResId.GetResMgr()) ),
	aBtnBrowse		( this, ResId(BTN_INSTPATH_BROWSE, rResId.GetResMgr()) ),
	aVolume			( ResId(STR_VOLUME, rResId.GetResMgr()) ),
	aFree			( ResId(STR_FREE, rResId.GetResMgr()) ),
	aNeed			( ResId(STR_NEED, rResId.GetResMgr()) ),

	m_aAdabasInfo   ( this, ResId(ADABAS_INFO, rResId.GetResMgr()) )
{
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aText );
	FreeResource();

	pEnv = GETDLG()->GetEnv();

	m_lClusterSize = 0L;
	m_lClusterSizeSystem = 0L;
	pHeaderBar = NULL;

	aText = aFTInfo5.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), UniString::CreateFromAscii(pEnv->GetProductName().GetBuffer()) );
	aFTInfo5.SetText( aText );

	aText = aFTInfo1.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), UniString::CreateFromAscii(pEnv->GetProductName().GetBuffer()) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), aBtnBrowse.GetText() );
	aFTInfo1.SetText( aText );

	aBtnBrowse.SetClickHdl( LINK(this, PageInstPath, BrowseHdl) );

	if( GETDLG()->GetModelType() != MODEL_RESPONSE_WIZARD )
	{
		aFTInfo3.Hide();
		aFTInfo4.Hide();
		aFTInfo5.Hide();
		aEDResponsefile.Hide();

#ifdef WNT
		Point aPt( aDriveBox.GetPosPixel() );
		Size  aSz( aDriveBox.GetSizePixel() );
		ULONG n = (aSz.Width() - 18) / 4;
		pHeaderBar = new HeaderBar( this, WB_BUTTONSTYLE | WB_BOTTOMBORDER );
		pHeaderBar->SetPosSizePixel( Point(aPt.X(), aPt.Y()-HEAD_HEIGTH+1), Size(aSz.Width(), HEAD_HEIGTH) );

		pHeaderBar->InsertItem( 1, aVolume, n*2, HIB_LEFT | HIB_FIXED);
		pHeaderBar->InsertItem( 2, aNeed, n, HIB_CENTER | HIB_FIXED);
		pHeaderBar->InsertItem( 3, aFree, n, HIB_CENTER | HIB_FIXED );

		pHeaderBar->Show();

		long nTabs[] = { 3, 0, n*2, n*3 };
		aDriveBox.SvTabListBox::SetTabs( &nTabs[0], MAP_PIXEL );

		UpdateDriveBox();
		aDriveBox.SetDoubleClickHdl( LINK(this,PageInstPath,DblClickHdl) );
#else

		aDriveBox.Hide();
		aFTInfo2.SetPosSizePixel	( LogicToPixel(Point(0,70), MAP_APPFONT) ,
								 	  LogicToPixel(Size(205,10), MAP_APPFONT) );
		aEDPath.SetPosSizePixel		( LogicToPixel(Point(0,80), MAP_APPFONT) ,
								 	  LogicToPixel(Size(150,12), MAP_APPFONT) );
		aBtnBrowse.SetPosSizePixel	( LogicToPixel(Point(155,79), MAP_APPFONT) ,
								 	  LogicToPixel(Size(50,14), MAP_APPFONT) );
#endif
	}
	else
	{
		aEDResponsefile.SetText( UniString(pEnv->GetResponseFilename(), osl_getThreadTextEncoding()) );
		aBtnBrowse.Hide();
		aFTInfo1.Hide();
		aDriveBox.Hide();
		aFTInfo2.SetPosSizePixel	( LogicToPixel(Point(0,70), MAP_APPFONT) ,
								 	  LogicToPixel(Size(205,10), MAP_APPFONT) );
		aEDPath.SetPosSizePixel		( LogicToPixel(Point(0,80), MAP_APPFONT) ,
								 	  LogicToPixel(Size(150,12), MAP_APPFONT) );
		aBtnBrowse.SetPosSizePixel	( LogicToPixel(Point(155,79), MAP_APPFONT) ,
								 	  LogicToPixel(Size(50,14), MAP_APPFONT) );
	}

	// #100560# Special Adabas handling
	if (isAdabas())
	{
		m_aAdabasInfo.Show();
	}
	else
	{
		m_aAdabasInfo.Hide();
	}
}

PageInstPath::~PageInstPath()
{
	if( pHeaderBar ) delete pHeaderBar;
	for( ULONG i = 0; i < m_aHDEntries.Count(); i++ )
		delete m_aHDEntries.GetObject(i);
}

SvAgentPage* PageInstPath::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageInstPath( pParent, rResId );
}

BOOL PageInstPath::AllowNext()
{
	UniString aStr( aEDPath.GetText() );
	aStr.EraseLeadingAndTrailingChars();

	if( !aStr.Len()
#ifdef WNT
		|| (aStr.GetChar(1) != ':' && !(aStr.GetChar(0) == '\\' && aStr.GetChar(1) == '\\'))
#endif
	  ) {
		ErrorBox( this, WB_OK, String(ResId(STR_INVALIDPATH)) ).Execute();
		return FALSE;
	}

	SiDirEntry aPath( ByteString(aStr, osl_getThreadTextEncoding()) );
	aPath.ToAbs();

	SiDirEntry aSource( pEnv->GetSourcePath() );
	aSource.ToAbs();

	// -----------------------------------
	// Some Adabas restrictions
	// -----------------------------------
	if (isAdabas())
	{
		// We thing, we are an adabas installation
		// restrictions:
		// no space in path
		// path not longer than 40 chars
		ByteString aPathStr( aPath.GetFull() );
		sal_Int32 nMaxChar = 40;
		sal_Int32 nPathLen = aPathStr.Len();

		if ((nPathLen > nMaxChar) && aPathStr.Search(' ') != STRING_NOTFOUND)
		{
			// both problems in one string
			String aMessage(ResId(STR_ERROR_ADABAS_40CHARS_AND_SPACES));
			String aMessageTitle(ResId(STR_ERROR_ADABAS_TITLE_40CHARS_AND_SPACES));
			ErrorBox aError( this, WB_OK, aMessage );
			aError.SetText(aMessageTitle);
			aError.Execute();
			return FALSE;
		}
		
		if ((nPathLen > nMaxChar))
		{
			// Path longer than 40 characters
			String aMessage(ResId(STR_ERROR_ADABAS_40CHARS));
			String aMessageTitle(ResId(STR_ERROR_ADABAS_TITLE_40CHARS));
			ErrorBox aError( this, WB_OK, aMessage );
			aError.SetText(aMessageTitle);
			aError.Execute();
			return FALSE;
		}
		if (aPathStr.Search(' ') != STRING_NOTFOUND)
		{
			// Path contains spaces
			String aMessage(ResId(STR_ERROR_ADABAS_SPACES));
			String aMessageTitle(ResId(STR_ERROR_ADABAS_TITLE_SPACES));
			ErrorBox aError( this, WB_OK, aMessage );
			aError.SetText(aMessageTitle);
			aError.Execute();
			return FALSE;
		}
	}

	if( aPath == aSource )
	{
		ErrorBox( this, WB_OK, String(ResId(STR_PATHSAMEASSOURCE)) ).Execute();
		return FALSE;
	}

	if( !pEnv->IsResponsefileWizardMode() &&
		pEnv->DoMigration() )
	{
		SiDirEntry aMigPath( pEnv->GetMigrationPath() );
		aMigPath.ToAbs();
		if( aPath == aMigPath )
		{
			ErrorBox( this, WB_OK, String(ResId(STR_PATHSAMEASMIGRATION)) ).Execute();
			return FALSE;
		}
	}

	/* -----------------12/19/97 3:01PM------------------
	fehlerhafter Path
	 --------------------------------------------------*/
	UniString suPathStr(aPath.GetFullUni());
	ByteString aPathStr( aPath.GetFull() );

	bool bValid = aPath.IsValid();
	static sal_Unicode suQuest = L'?';
	static sal_Unicode suAsterix = L'*';

	xub_StrLen bSearch_Quest = suPathStr.Search(suQuest, 1);
	xub_StrLen bSearch_Asterix = suPathStr.Search(suAsterix, 1);

	if( !bValid)
	/*
	||
		bSearch_Quest != STRING_NOTFOUND ||
		bSearch_Asterix != STRING_NOTFOUND )
		*/
	{
		String aMessage = ResId( STR_WRONGPATH );
		aMessage.SearchAndReplace( UniString::CreateFromAscii("%1"),
				UniString(aPathStr,  osl_getThreadTextEncoding()) );

		ErrorBox( this, WB_OK, aMessage ).Execute();
		return FALSE;
	}

	/* -----------------12/19/97 3:01PM------------------
	Installation in die Root ?
	 --------------------------------------------------*/
	if( aPath.Level() == 1 )
	{
		QueryBox aBox( this, WB_YES_NO | WB_DEF_NO, String(ResId(STR_INSTALL_ON_ROOT)) );
		if( aBox.Execute() != RET_YES )
			return FALSE;
		GETDLG()->GetEnv()->SetInstallOnRoot(TRUE);
	}

	/* -----------------12/19/97 3:02PM------------------
	genug Patz? nur wenn != Userdefined
	 --------------------------------------------------*/
	if( !pEnv->IsResponsefileWizardMode() )
	{
		RecalcSize( aPath );

		SiInstallation*	pInst = GETDLG()->GetCScript()->GetInstallation();
		ByteString			aDestVol( aPath.GetFull() );
		ByteString			aGUIVol( OS::GetGUIPath() );
		aDestVol.ToLowerAscii();
		aGUIVol.ToLowerAscii();

		ULONG nIsDriveSize = OS::GetDriveSize(aPath);

		if( aDestVol.GetChar(0) != aGUIVol.GetChar(0) && pInst->GetInstallMode() != IM_NETWORK )
		{
			// Ziellaufwerk != Systemlaufwerk Pruefung aufteilen
			ULONG nUsedSize = (m_lUsedSize + m_lTempSize) - m_lSystemSize;
			if( nIsDriveSize < (nUsedSize/1024) )
			{
				ErrorBox( this, WB_OK, String(ResId(STR_FULLDRIVE)) ).Execute();
				return FALSE;
			}
			else if( OS::GetDriveSize(SiDirEntry(OS::GetSystemPath())) < (m_lSystemSize/1024) )
			{
				String aInfo( ResId( STR_FULLSYSTEMDRIVE1 ) );
				aInfo += UniString::CreateFromAscii( OS::GetSystemPath().ToUpperAscii().Copy(0, 2).GetBuffer() );
				aInfo += String( ResId( STR_FULLSYSTEMDRIVE2 ) );
				aInfo += UniString::CreateFromInt32( m_lSystemSize / 1024 );
				aInfo += String( ResId( STR_FULLSYSTEMDRIVE3 ) );

				ErrorBox( this, WB_OK, aInfo ).Execute();
				return FALSE;
			}
		}
		else
		{
			ULONG nNeedDriveSize = ((m_lUsedSize + m_lTempSize) /1024);
			if( nIsDriveSize < nNeedDriveSize )
			{
				ErrorBox( this, WB_OK, String(ResId(STR_FULLDRIVE)) ).Execute();
				return FALSE;
			}
		}
	}
	SiDirEntry aOldPath( pEnv->GetDestPath() );
	if( aOldPath != aPath && pEnv->IsDlgPrecreateDir() )
		aOldPath.Kill();

	if( !pEnv->IsResponsefileWizardMode() && !aPath.Exists() )
	{
		String aMessage = ResId( STR_PATH_NOTEXISTS );
		aMessage.SearchAndReplace( UniString::CreateFromAscii("%1"), aPath.GetFullUni() );
		QueryBox aBox( GetAgentDlg(), WB_YES_NO | WB_DEF_YES, aMessage );
		if( aBox.Execute() == RET_NO )
		{
			Sound::Beep();
			return FALSE;
		}
		if( !aPath.MakeDir() )
		{
			String aMessage(ResId(STR_ERROR_MAKEDIR));
			aMessage.SearchAndReplace( UniString::CreateFromAscii("%1"), aPath.GetFullUni() );
			ErrorBox( this, WB_OK, aMessage ).Execute();
			return FALSE;
		}
		else
			pEnv->SetDlgPrecreateDir(TRUE);
	}
	else
		pEnv->SetDlgPrecreateDir(FALSE);

	pEnv->SetDestPath( aPath.GetFull() );

	if( pEnv->IsResponsefileWizardMode() )
	{
		ByteString aFilename( aEDResponsefile.GetText(), osl_getThreadTextEncoding() );

		BOOL bValid = TRUE;
		SiDirEntry aEntry( aFilename );
		if( !aEntry.Exists() )
		{
			aEntry.GetPath().MakeDir();
			FILE *p = fopen( aEntry.GetFull().GetBuffer(), "w" );
			if( p ) { fclose( p ); aEntry.Kill(); } else bValid = FALSE;
		}

		if( !bValid )
		{
			String aMessage(ResId(STR_ERROR_NO_RESPONSEFILE));
			aMessage.SearchAndReplace( UniString::CreateFromAscii("%1"), aPath.GetFullUni() );
			ErrorBox( this, WB_OK, aMessage ).Execute();
			return FALSE;
		}

		pEnv->SetResponseFilename( aFilename );
	}

	return TRUE;
}

/*
USHORT PageInstPath::GetReturnVal()
{
	SiCompiledScript* pCS = GETDLG()->GetCScript();

	if( pEnv->GetInstallType() == IT_USERDEFINED ||
		pCS->GetInstallation()->IsOnlyCustom() )
		return RETURN_USERDEFINED;

	return RETURN_NORMAL;
}
*/

ULONG PageInstPath::GetProperty()
{
	return 1;
}

bool PageInstPath::isEnoughSpace( const SiDirEntry& _aPath )
{
	SiInstallation*	pInst = GETDLG()->GetCScript()->GetInstallation();
	ByteString aDestVol( _aPath.GetFull() );
	ByteString aGUIVol( OS::GetGUIPath() );

	ULONG nIsDriveSize = OS::GetDriveSize(_aPath);

	if( aDestVol.GetChar(0) != aGUIVol.GetChar(0) && pInst->GetInstallMode() != IM_NETWORK )
	{
		// Ziellaufwerk != Systemlaufwerk Pruefung aufteilen
		ULONG nUsedSize = (m_lUsedSize + m_lTempSize) - m_lSystemSize;
		if( nIsDriveSize < (nUsedSize/1024) )
		{
			return false;
		}
		else if( OS::GetDriveSize(SiDirEntry(OS::GetSystemPath())) < (m_lSystemSize/1024) )
		{
			return false;
		}
	}
	else
	{
		ULONG nNeedDriveSize = ((m_lUsedSize + m_lTempSize) /1024);
		if( nIsDriveSize < nNeedDriveSize )
		{
			return false;
		}
	}
	return true;
}

void PageInstPath::InitProperty(ULONG nProp)
{
/*
	if( pEnv->GetProductName() == "UpdateTest" )
	{
		SiDirEntry aEntry( pEnv->GetDestPath() );
		aEntry.ToAbs();
		pEnv->SetDestPath( aEntry.GetFull() );
		RecalcSize( pEnv->GetDestPath() );
	}
	else
	{
*/
	if( GETDLG()->GetModelType() != MODEL_RESPONSE_WIZARD )
	{
		RecalcSize( pEnv->GetDestPath() );
		if (! isEnoughSpace( pEnv->GetDestPath() ))
		{
			CorrectToFirstFree( false );
		}
	}
	//}

	// aEDPath.SetText( UniString::CreateFromAscii(pEnv->GetDestPath().GetBuffer()) );
	aEDPath.SetText( UniString(pEnv->GetDestPath(), osl_getThreadTextEncoding()));
}

// -----------------------------------------------------------------------------

void PageInstPath::UpdateDriveBox()
{
	Dir aDir( SiDirEntry( "*" ), FSYS_KIND_BLOCK);
	String sFull;

	USHORT nSysVol = 0;
#ifdef WNT
	nSysVol = ByteString(WinOS::SHGetUserProgramFilesFolder(),
			  osl_getThreadTextEncoding()).ToUpperAscii().GetChar(0) - 'A';
#endif
	for( USHORT i = 0; i < aDir.Count(); i++ )
	{
		FileStat aStat( aDir[i] );

		sFull = aDir[i].GetFull();
		sFull.ToUpperAscii();

		if( sFull.GetChar(0) != 'A'	&&
			sFull.GetChar(0) != 'B' &&
			(aStat.IsKind(FSYS_KIND_FIXED)  || aStat.IsKind(FSYS_KIND_REMOTE)) )
		{
			HD_Entry* pHDEntry = new HD_Entry;
			pHDEntry->nVol	= aDir[i].GetFull().ToUpperAscii().GetChar(0) - 'A';
			pHDEntry->nFree = (OS::GetDriveSize(aDir[i]) + /*roundvalue*/ 512) / 1024;
			pHDEntry->bSysVol = pHDEntry->nVol == nSysVol? TRUE : FALSE;

			RecalcSize(aDir[i]);
			pHDEntry->nUse = (m_lUsedSize/1024 + /*roundvalue*/ 512) / 1024;

			ByteString strDrive("(");
			strDrive += ByteString( pHDEntry->nVol + 'A' );
			strDrive += ":\\)  ";

			// #89535# Volumename
			DirEntry& rEntry = aDir[i];
			UniString aVolume = rEntry.GetVolume();
			// cut down if volume name is to long
			// its hard coded, because to get the length of a string in a given font isn't easy
			ByteString aStr(aVolume, osl_getThreadTextEncoding());
			if (aStr.Len() > 20)
			{
				aStr = aStr.Copy(0,20);
				aStr += "...";
			}
			
			strDrive += aStr;
			
			ByteString strNeed( ByteString::CreateFromInt32(pHDEntry->nUse) );
			strNeed += " MB";

			ByteString strFree( ByteString::CreateFromInt32(pHDEntry->nFree) );
			strFree += " MB";

			aDriveBox.InsertDrive( aStat.IsKind(FSYS_KIND_REMOTE)? TRUE : FALSE, strDrive, strNeed, strFree, pHDEntry );
		}
	}
}

void PageInstPath::CorrectToFirstFree( BOOL bScanRemoveableDisks )
{
#if defined(WIN) || defined(OS2) || defined(WNT)

	BOOL bFound = FALSE;
	Dir aDir( SiDirEntry( "*" ), FSYS_KIND_BLOCK);
	String sFull;

	for( USHORT i = 0; i < aDir.Count(); i++ )
	{
		FileStat	aStat( aDir[i] );

		sFull = aDir[i].GetFull();
		sFull.ToUpperAscii();

		if( sFull.GetChar(0) != 'A'	&&
			sFull.GetChar(0) != 'B' &&
			(aStat.IsKind(FSYS_KIND_FIXED)  ||
			 aStat.IsKind(FSYS_KIND_REMOTE) ||
			(aStat.IsKind(FSYS_KIND_REMOVEABLE) && bScanRemoveableDisks)) )
		{
			if( OS::GetDriveSize(aDir[i]) > ((m_lUsedSize + m_lTempSize) / 1024) )
			{
				bFound = TRUE;
				break;
			}
		}
	}

	if( bFound )
	{
//		ByteString aInstPath( pEnv->GetDestPath() );
//		aInstPath.Erase( 0, 2 );
//		aInstPath.Insert( ByteString(sFull, osl_getThreadTextEncoding()), 0 );
//		pEnv->SetDestPath( aInstPath );
		DirEntry aPath( pEnv->GetDestPath() );
		UniString aNewPath;
		aNewPath = sFull;
		aNewPath += UniString::CreateFromAscii("\\");
		aNewPath += aPath.GetName();
		pEnv->SetDestPath( ByteString(aNewPath, osl_getThreadTextEncoding()) );
	}

#endif
}

void PageInstPath::RecalcSize( const SiDirEntry& rDest )
{
	SiModule*		pRoot = GETDLG()->GetCScript()->GetRootModule();
	ULONG			lClusterSize = OS::GetClusterSize( rDest );
	BOOL 			bIsFat = FALSE;
	BOOL 			bIsSysFat = FALSE;

#ifdef OS2
	bIsFat		= Os2OS::IsFATFileSystem( rDest.GetFull() );
	bIsSysFat	= Os2OS::IsFATFileSystem( OS::GetGUIPath() );
#endif

	if( lClusterSize != m_lClusterSize )
	{
		m_lClusterSize = lClusterSize;
		m_lUsedSize    = pRoot->CalculateSize( *pEnv, SiModule::INSTALL, lClusterSize,
						 FALSE, pEnv->GetInstallType() == IT_WORKSTATION, bIsFat );
		m_lUsedSize    += pEnv->GetMigrationSize();
	}

	ULONG lClusterSizeSys = OS::GetClusterSize( SiDirEntry(OS::GetGUIPath()) );
	if( lClusterSizeSys != m_lClusterSizeSystem )
	{
		m_lClusterSizeSystem = lClusterSizeSys;
		m_lSystemSize = pRoot->CalculateSize( *pEnv, SiModule::INSTALL_SYSTEM, lClusterSizeSys,
						TRUE, pEnv->GetInstallType() == IT_WORKSTATION, bIsSysFat );
	}

	m_lTempSize = pRoot->CalculateSize( *pEnv, SiModule::TEMP, lClusterSize, FALSE,
		pEnv->GetInstallType() == IT_WORKSTATION, bIsFat );
}

IMPL_LINK( PageInstPath, BrowseHdl, Button*, pBtn )
{
	SiDirEntry aPath( aEDPath.GetText() );
	SiDirEntry aMyPath( GETDLG()->GetEnv()->GetStartPath() );

	if( aPath == aMyPath )
	{
		aPath = aPath.GetDevice();
		aPath.ToAbs();
	}
	else
	{
		while( (!aPath.Exists()) && (aPath.Level() > 1) )
		{
			aPath = aPath[1];
		}
	}

	PathDialog aDlg( GetAgentDlg() );
	aDlg.SetPath( aPath.GetFullUni() );

	if( aDlg.Execute() == RET_OK )
	{
		pEnv->SetDestPath( ByteString(aDlg.GetPath(), osl_getThreadTextEncoding()) );
		aEDPath.SetText( aDlg.GetPath() );
	}

	return 1;
}

IMPL_LINK(PageInstPath,DblClickHdl,void*,pFoo)
{
	SvLBoxEntry *pEntry  = aDriveBox.GetHdlEntry();
	HD_Entry *pHDEntry = (HD_Entry*) pEntry->GetUserData();

	DirEntry aPath( aEDPath.GetText() );
	UniString aNewPath;
#ifdef WNT
	aNewPath = createPathName( ByteString(pHDEntry->nVol + 'A') );
	aNewPath += aPath.GetName();
	aEDPath.SetText( aNewPath );
#endif
	return 1;
}
// ------------------------------------------------------
UniString PageInstPath::createPathName(ByteString const& _sPathChar)
{
	SvLBoxEntry *pEntry  = aDriveBox.GetHdlEntry();
	HD_Entry *pHDEntry = (HD_Entry*) pEntry->GetUserData();

	UniString aNewPath;
#ifdef WNT
	if( pHDEntry->bSysVol && !isAdabas())
	{
		aNewPath = WinOS::SHGetUserProgramFilesFolder();
		aNewPath += UniString::CreateFromAscii("\\");
	}
	else
	{
		aNewPath = UniString( _sPathChar, osl_getThreadTextEncoding());
		aNewPath += UniString::CreateFromAscii(":\\");
	}
#endif
	return aNewPath;
}
