/*************************************************************************
 *
 *  $RCSfile: pluginacceptthread.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mav $ $Date: 2001/05/03 09:18:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_BRIDGE_XINSTANCEPROVIDER_HPP_
#include <com/sun/star/bridge/XInstanceProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif

#ifndef _COM_SUN_STAR_CONNECTION_XACCEPTOR_HPP_
#include <com/sun/star/connection/XAcceptor.hpp>
#endif

#include <cppuhelper/implbase1.hxx>
#include <vos/thread.hxx>
#include <vos/conditn.hxx>

#include <oinstanceprovider.hxx>


class PluginAcceptThread :  public ::vos::OThread,
							public ::cppu::WeakImplHelper1< ::com::sun::star::lang::XEventListener >
{
	public:
		PluginAcceptThread( 
			const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& aLocalServiceManager,
			const ::com::sun::star::uno::Reference< ::com::sun::star::bridge::XInstanceProvider >& rInstanceProvider,
			const ::rtl::OUString& aAcceptString );
		
		virtual ~PluginAcceptThread()  {}

		static void * operator new( size_t nSize ) throw ()
			{ return ::rtl_allocateMemory( nSize ); }
		static void operator delete( void * pMem ) throw ()
			{ ::rtl_freeMemory( pMem ); }

		// XEventListener
		virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& Source ) 
			throw(::com::sun::star::uno::RuntimeException);

		virtual void SAL_CALL run();
		virtual void SAL_CALL onTerminated();

		virtual void SAL_CALL terminate();

	private:
		::com::sun::star::uno::Reference< ::com::sun::star::bridge::XInstanceProvider >		m_rInstanceProvider;
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >	m_rLocalServiceManager;
		::com::sun::star::uno::Reference< ::com::sun::star::connection::XAcceptor >			m_rAcceptor;
		::rtl::OUString																		m_aAcceptString;
		::vos::OCondition																	m_cndWaitForNextAccept;
		sal_Bool																			m_bStop;
		sal_Bool																			m_bInAccept;
		sal_Bool																			m_bPluginConnected;
};
