/*************************************************************************
 *
 *  $RCSfile: resmgr.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mba $ $Date: 2000/10/04 11:47:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
// INCLUDE ---------------------------------------------------------------

#include "resmgr.hxx"
#include "msgdescr.hxx"
#include "app.hxx"
#include "sfxtypes.hxx"
#include "segmentc.hxx"
#include "sfx.hrc"

// STATIC DATA -----------------------------------------------------------

DECLARE_TABLE(SfxMessageTable, SfxMessageDescription*)

// ------------------------------------------------------------------------
static BOOL HasColorMon_Impl()
{
    return Application::GetDefaultDevice()->GetColorCount() == 2 || !SFX_APP()->IsSVLookEnabled()?
			FALSE: TRUE;
}

// ------------------------------------------------------------------------
static USHORT FindFirstFree_Impl(SfxResMgrArr &rArr)
{
	const USHORT nCount = rArr.Count();
	for(USHORT i = 0; i < nCount; ++i) {
		if(!rArr[i])
			return i;
	}
	return nCount;
}
// ------------------------------------------------------------------------
static USHORT Register_Impl(SfxResMgrArr &rArr, ResMgr *pRes)
{
	const USHORT nPos = FindFirstFree_Impl(rArr);
	rArr.Insert(nPos, pRes);
	return nPos;
}

// ------------------------------------------------------------------------
void SfxResourceManager::ClearMsgTable()
{
	DBG_MEMTEST();
	DBG_ASSERT( nEnterCount == 0, "ClearMsgTable innerhalb von Enter");

	if(pMessageTable) {
		SfxMessageDescription *pDesc = pMessageTable->First();
		while(pDesc) {
			delete pDesc;
			pDesc = pMessageTable->Next();
		}
		pMessageTable->Clear();
		DELETEZ(pMessageTable);
	}
}

// ------------------------------------------------------------------------
SfxMessageDescription *SfxResourceManager::MakeDesc(USHORT nId)
{
	SfxMessageDescription *pDesc = 0;
	const USHORT nCount = aResMgrArr.Count();
	const ResId aResId(nId);
	aResId.SetRT(RSC_RESOURCE);

	ResMgr *pOld = Resource::GetResManager();
	for(USHORT i = 0; i < nCount; ++i) {
		if(aResMgrArr[i]->IsAvailable(aResId.GetRT(), aResId.GetId(),
											  aResId.GetpResource(), 0)) {
			Resource::SetResManager(aResMgrArr[i]);
			pDesc = new SfxMessageDescription(nId);
			Resource::SetResManager(pOld);
			return pDesc;
		}
	}

	// in der App-Resource?
	Resource::SetResManager(pOld);
	if(pOld->IsAvailable(aResId.GetRT(), aResId.GetId(), aResId.GetpResource(), 0)) {
		pDesc = new SfxMessageDescription(nId);
		return pDesc;
	}

	// nicht gefunden
	return new SfxMessageDescription(SID_UNKNOWN);
}

// ------------------------------------------------------------------------
USHORT	SfxResourceManager::RegisterResource(const	char *pFileName)
{
	DBG_MEMTEST();
	return Register_Impl(aResMgrArr, new ResMgr((char *)pFileName));
}

// ------------------------------------------------------------------------
void	SfxResourceManager::ReleaseResource( USHORT	nRegisterId	)
{
	DBG_MEMTEST();
	DBG_ASSERT( nRegisterId < aResMgrArr.Count(), "Array ueberindiziert");
	if(nRegisterId < aResMgrArr.Count()) {
		delete aResMgrArr[nRegisterId];
		aResMgrArr[nRegisterId] = 0;
	}
}

// ------------------------------------------------------------------------
USHORT	SfxResourceManager::RegisterBitmap(
						const char *pMono, const char *pColor)
{
	DBG_MEMTEST();
	const BOOL bColorMon = HasColorMon_Impl();
	const char *pFileName = bColorMon? pColor: pMono;
	return Register_Impl(aResMgrBmpArr, new ResMgr((char *)pFileName));
}

// ------------------------------------------------------------------------
USHORT	SfxResourceManager::RegisterBitmap(	const char *pSingleFile	)
{
	DBG_MEMTEST();
	return 0;
}

// ------------------------------------------------------------------------
void	SfxResourceManager::ReleaseBitmap( USHORT nRegisterId )
{
	DBG_MEMTEST();
	DBG_ASSERT( nRegisterId < aResMgrBmpArr.Count(), "BmpArray ueberindiziert");
	if(nRegisterId < aResMgrBmpArr.Count()) {
		delete aResMgrBmpArr[nRegisterId];
		aResMgrBmpArr[nRegisterId] = 0;
	}
}

// ------------------------------------------------------------------------
void	SfxResourceManager::Enter()
{
	DBG_MEMTEST();
	if(!pMessageTable)
		pMessageTable = new SfxMessageTable;
	++nEnterCount;
}

// ------------------------------------------------------------------------
void	SfxResourceManager::Leave()
{
	DBG_MEMTEST();
	DBG_ASSERT(nEnterCount >= 1, "mehr Leave als Enter");
	--nEnterCount;
	if(!nEnterCount)
		ClearMsgTable();
}

// ------------------------------------------------------------------------
SfxMessageDescription* SfxResourceManager::CreateDescription(USHORT nId)
{
	DBG_MEMTEST();
	DBG_ASSERT( pMessageTable, "Zugriff auf MessageDesc ausserhalb von Enter");
	if(!pMessageTable) pMessageTable = new SfxMessageTable;
	SfxMessageDescription *pDesc = pMessageTable->Get(nId);
	if(!pDesc) {
		pDesc = MakeDesc(nId);
		pMessageTable->Insert(nId, pDesc);
	}
	return pDesc;
}

// CTOR / DTOR -----------------------------------------------------------
// ------------------------------------------------------------------------
SfxResourceManager::SfxResourceManager()
	: nEnterCount(0),
	  pMessageTable(0)
{
	DBG_MEMTEST();
}


// ------------------------------------------------------------------------
SfxResourceManager::~SfxResourceManager()
{
	DBG_MEMTEST();
	USHORT nCount = aResMgrArr.Count();
	for(USHORT i = 0; i < nCount; ++i)
		delete aResMgrArr[i];
	nCount = aResMgrBmpArr.Count();
	for(i = 0; i < nCount; ++i)
		delete aResMgrBmpArr[i];
	ClearMsgTable();
}
