/*************************************************************************
 *
*  $RCSfile: cfgtreelstbox.hxx,v $
 *
 *  $Revision: 1.3.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 11:08:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXCFGTREELSTBOX_HXX
#define _SFXCFGTREELSTBOX_HXX

#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _SVTABBX_HXX //autogen
#include <svtools/svtabbx.hxx>
#endif
#ifndef _SVTREEBOX_HXX //autogen
#include <svtools/svtreebx.hxx>
#endif
#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif

#define _SVSTDARR_USHORTS
#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>		// SvUShorts
#include "minarray.hxx"

#define SFX_CFGGROUP_FUNCTION 1
#define SFX_CFGGROUP_BASICMGR 2
#define SFX_CFGGROUP_DOCBASICMGR 3
#define SFX_CFGGROUP_BASICLIB 4
#define SFX_CFGGROUP_BASICMOD 5
#define SFX_CFGFUNCTION_MACRO 6
#define SFX_CFGFUNCTION_SLOT  7
#define SFX_CFGFUNCTION_SEPARATOR 8
#define SFX_CFGFUNCTION_SPACE 9

#define IBX_FUNCTION_ALREADY_IN_TOOLBOX	(RID_SFX_DIALOG_START + 104 )

class SfxMacroInfoArr_Impl;
class SfxMacroInfoItem;
class SfxMacroInfo;
class SfxConfigManager;

struct SfxCfgGroupInfo_Impl
{
	USHORT 		nKind;
	USHORT 		nOrd;
	void*		pObject;
	BOOL		bWasOpened;

				SfxCfgGroupInfo_Impl( USHORT n, USHORT nr, void* pObj = 0 ) :
					nKind( n ), nOrd( nr ), pObject( pObj ), bWasOpened(FALSE) {}
};

typedef SfxCfgGroupInfo_Impl* SfxCfgGroupInfoPtr;
SV_DECL_PTRARR_DEL(SfxCfgGroupInfoArr_Impl, SfxCfgGroupInfoPtr, 5, 5);

class SfxSlotPool;
class SfxBindings;
class SfxConfigTreeListBox_Impl : public SvTreeListBox
{
	Timer							aTimer;
	SvLBoxEntry*					pCurEntry;
	SfxCfgGroupInfoArr_Impl			aArr;
	ULONG							nMode;
	String							aScriptType;
	SfxSlotPool*					pSlotPool;
	SfxBindings*					pBindings;
	BOOL							bDragInProgress;

	DECL_LINK(						TimerHdl, Timer* );
	virtual void 					MouseMove( const MouseEvent& rMEvt );

protected:
	virtual void    				RequestingChilds( SvLBoxEntry *pEntry);
	virtual BOOL    				Expand( SvLBoxEntry* pParent );

	// new d&d
	virtual DragDropMode			NotifyStartDrag( TransferDataContainer&, SvLBoxEntry* );
	virtual BOOL					NotifyAcceptDrop( SvLBoxEntry* );
	virtual sal_Int8				AcceptDrop( const AcceptDropEvent& rEvt );
	virtual sal_Int8				ExecuteDrop( const ExecuteDropEvent& rEvt );
	virtual void					DragFinished( sal_Int8 nDropAction );

public:
									SfxConfigTreeListBox_Impl ( Window* pParent,
										const ResId&, 
										SfxBindings* pBindings, 
										ULONG nConfigMode = 0 );
									~SfxConfigTreeListBox_Impl();

	void							Init( SvStringsDtor *pArr = 0, SfxSlotPool* pSlotPool = 0 );
	void							ClearAll();

	void							Open( SvLBoxEntry*, BOOL );
	void							GroupSelected();
	String							GetGroup();
	void							SetScriptType( const String& rScriptType );

	SvLBoxEntry*					GetEntry_Impl( SvLBoxEntry* pParentEntry, USHORT nId );
	SvLBoxEntry*					GetEntry_Impl( SvLBoxEntry* pParentEntry, const String& );

	SvLBoxEntry*					GetEntry_Impl( USHORT nId );
	SvLBoxEntry*					GetEntry_Impl( const String& );

	USHORT							GetId( SvLBoxEntry *pEntry );
	String							GetHelpText( SvLBoxEntry *pEntry );
	USHORT							GetCurId()
									{ return GetId( FirstSelected() ); }
	SfxMacroInfo*					GetMacroInfo();
	void							FunctionSelected();
};

struct SfxToolbarEntryInfo_Impl
{
	BOOL			bVisible;
	USHORT 			nId;
	ToolBoxItemType	nKind;
	SfxMacroInfo*	pMacroInfo;

	SfxToolbarEntryInfo_Impl( ToolBoxItemType n, USHORT nID, BOOL bVis = TRUE, SfxMacroInfo* pInfo = 0 ) : 
		nKind( n ), nId( nID ), bVisible( bVis ), pMacroInfo( pInfo ) {}
};

typedef SfxToolbarEntryInfo_Impl* SfxToolbarEntryInfoPtr;
SV_DECL_PTRARR_DEL(SfxToolbarEntryInfoArr_Impl, SfxToolbarEntryInfoPtr, 5, 5);

class SfxToolBoxManager;
class SfxBindings;
class SfxInterface;
class SfxToolbarTreeListBox_Impl : public SvTreeListBox
{
	Timer							m_aTimer;
	SvLBox*							m_pSVLBoxFunctions;
	SvLBoxEntry*					m_pCurEntry;
	SfxToolbarEntryInfoArr_Impl		m_aArr;
	SfxToolBoxManager*				m_pTbxMgr;
	SfxBindings*					m_pBindings;
	SfxInterface*					m_pIFace;
	BOOL							m_bDragSource;
	Size							m_aCheckBoxImageSizePixel;
	String							m_aSeparator;
	String							m_aSpace;
	Link							m_aChangedListener;
	SvLBoxButtonData*				m_pButtonData;

	DECL_LINK(						TimerHdl, Timer* );
	DECL_LINK(						AsyncInfoMsg, String* );

	virtual void 					MouseMove( const MouseEvent& rMEvt );
	virtual void					KeyInput( const KeyEvent& rKEvt );
	void							CommitChanges();
	USHORT							FindToolBoxPosition( const ToolBox& rToolBox, ULONG nPos );

protected:
	// new d&d
	virtual DragDropMode			NotifyStartDrag( TransferDataContainer&, SvLBoxEntry* );
	virtual BOOL					NotifyAcceptDrop( SvLBoxEntry* );
	virtual sal_Int8				AcceptDrop( const AcceptDropEvent& rEvt );
	virtual sal_Int8				ExecuteDrop( const ExecuteDropEvent& rEvt );
	virtual void					DragFinished( sal_Int8 nDropAction );
	virtual BOOL					NotifyMoving( SvLBoxEntry*  pTarget,
												  SvLBoxEntry*  pEntry,
												  SvLBoxEntry*& rpNewParent,
												  ULONG&		rNewChildPos );
	virtual BOOL					NotifyCopying( SvLBoxEntry*  pTarget,		 
												   SvLBoxEntry*  pEntry,		 
												   SvLBoxEntry*& rpNewParent,   
												   ULONG&        rNewChildPos );
	virtual void					CheckButtonHdl();
	virtual void					InitEntry( SvLBoxEntry*, const XubString&, const Image&, const Image& );
	virtual void					DataChanged( const DataChangedEvent& rDCEvt );
	void							BuildCheckBoxButtonImages( SvLBoxButtonData* );
	Image							GetSizedImage( VirtualDevice& aDev, const Size& aNewSize, const Image& aImage );

public:
									SfxToolbarTreeListBox_Impl ( Window* pParent, const ResId&, SfxBindings* pBindings );
									~SfxToolbarTreeListBox_Impl();
	
	void							Init( SfxToolBoxManager*, SfxInterface* pIFace, SfxSlotPool* pSlotPool = 0 );
	void							SetChangedListener( const Link& aChangedListener ) { m_aChangedListener = aChangedListener; }
	const Link&						GetChangedListener() const { return m_aChangedListener; }
	void							SetDragSourcePartner( SvLBox* pDragSourcePartner ) { m_pSVLBoxFunctions = pDragSourcePartner; }
	void							ClearAll();

	Size							GetCheckBoxPixelSize() const { return m_aCheckBoxImageSizePixel; }
	BOOL							RemoveItem( SvLBoxEntry* pEntry );
	BOOL							AddFunction( SvLBoxEntry* pEntry, USHORT nKind, USHORT nId, SfxMacroInfo* pMacroInfo, BOOL bFront = FALSE);
	void							AddSeparator( SvLBoxEntry* pEntry, ToolBoxItemType nType, BOOL bFront = FALSE );
	void							MoveUpCurEntry();
	void							MoveDownCurEntry();

	BOOL							GetPos( ULONG& nPos, SvLBoxEntry* pEntry );
	USHORT							GetId( SvLBoxEntry *pEntry );
	String							GetHelpText( SvLBoxEntry *pEntry );
	USHORT							GetCurId()
									{ return GetId( FirstSelected() ); }
};


#endif // _SFXCFGTREELSTBOX_HXX
