/*************************************************************************
 *
 *  $RCSfile: picklist.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: cd $ $Date: 2001/08/10 05:44:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PICKLIST_HXX
#define _PICKLIST_HXX


#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

// forwards *****************************************************************

struct SfxPickEntry_Impl;
class SfxMedium;
class SfxObjectShell;
class SfxObjectShellLock;
class INetURLObject;
class Menu;

// defines ******************************************************************

#define PICKLIST_INSERT_POSITION 0UL
#define PICKLIST_MAXSIZE  10
#define HISTORY_MAXSIZE 100
#define DOCCACHE_SIZE 5

DECLARE_LIST(SfxPickEntryList_Impl,SfxPickEntry_Impl*)
DECLARE_LIST(SfxObjectShellLockList_Impl, SfxObjectShellLock* )

//=========================================================================

struct SfxPickEntry_Impl
{
	SfxPickEntry_Impl( const SfxMedium *, const String & );
	SfxPickEntry_Impl( const String &, const String &, const String & );
	String		      aName;
	String		      aFilter;
	String		      aTitle;
	String            aOptions;
};

//=========================================================================

class MemCache_Impl : public SfxObjectShellLockList_Impl
{
public:
					~MemCache_Impl();

	void 			AddObject( SfxObjectShell *pObj );
	BOOL			RemoveObject( const SfxObjectShell *pObj );
	BOOL			IsObjectCached( const SfxObjectShell *pObj ) const;
	void            ClearToLimit( USHORT nLimit );
	SfxObjectShell* Find(
		const INetURLObject &rUrlToFind, const String& rPostString ) const;

	void 			ClearObjects();
};

//***************************************************************************
// SfxPickLis_Impl
//***************************************************************************

class SfxPickList_Impl : public SfxListener
{
	static SfxPickList_Impl* pInstance;

	SfxPickEntryList_Impl  	aHistoryPickList;
	MemCache_Impl           aMemoryCache;
	BOOL					bHistoryInitialized;
							// gibt an, ob die History schon aus dem
							// Inifile gelesen wurde

	void					LoadHistory();

							SfxPickList_Impl( const ULONG nMenuSize );
							~SfxPickList_Impl();
public:

	static SfxPickList_Impl* Get();
	static SfxPickList_Impl* GetOrCreate( const ULONG nMenuSize );
	static void 			Delete();

	void 					SavePicklist();

	SfxPickEntry_Impl*		GetHistoryPickEntry( const ULONG nPos );
	SfxPickEntry_Impl*		GetHistoryPickEntry( const String& rURL );
	SfxPickEntry_Impl*		GetHistoryPickEntryFromTitle( const String& rTitle );

	void					ClearMemCache() { aMemoryCache.ClearObjects(); }
	MemCache_Impl&			GetMemCache() { return aMemoryCache; }

	ULONG					HistoryPickEntryCount();

	void					InsertHistoryPickEntry(
									const String& rName,
									const String& rFilter,
									const String& rTitle );
							// die Methode ist NUR fuer Spruenge innerhalb
							// von Dokumenten geeignet/gedacht

	ULONG 					GetCurHistoryPos();
	SfxPickEntry_Impl*		SetCurHistoryPos( const ULONG nPos );

	BOOL					HistoryIsLoaded() const
							{
								return bHistoryInitialized;
							}

	virtual void			Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
	void					InsertToHistory( SfxObjectShell* );
};

#endif
