/*************************************************************************
 *
 *  $RCSfile: ipclient.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _IPCLIENT_HXX
#define _IPCLIENT_HXX

#include <client.hxx>

/*************************************************************************
*************************************************************************/
class  SvInPlaceClient;
class  SvInPlaceObject;
class  ImpInPlaceSite;
class  ImpInPlaceFrame;
class  ImpInPlaceUIWin;
class  MenuBar;
class  Accelerator;
class  SvInPlaceClientList;
class  SvInPlaceClient;
struct IOleInPlaceSite;
struct IOleInPlaceFrame;
struct IOleInPlaceUIWindow;
class  SvInPlaceEnvironment;
class SvContainerEnvironment;

//=========================================================================
class SvInPlaceClient : public SvEmbeddedClient
{
friend ImpInPlaceSite;
friend ImpInPlaceFrame;
friend ImpInPlaceUIWin;
friend SvInPlaceObject;
friend SvEditObjectProtocol;
friend ImplSvEditObjectProtocol;
friend SvContainerEnvironment;

	IOleInPlaceSite *       pObjI;

	BOOL            	CanInPlaceActivate() const;
protected:
						~SvInPlaceClient();

	virtual void    	Opened( BOOL bOpen );
	virtual void    	InPlaceActivate( BOOL bActivate );
	virtual void    	UIActivate( BOOL bActivate );

	virtual void		MakeViewData();
public:
						SvInPlaceClient();
						SvInPlaceClient( WorkWindow * pTopWin,
										 WorkWindow * pDocWin,
										 Window * pEditWin );
						SO2_DECL_STANDARD_CLASS_DLL(SvInPlaceClient,SOAPP)

	IOleInPlaceSite *   		GetInPlaceSite() const;

	static SvInPlaceClientList & GetIPActiveClientList();

	SvContainerEnvironment * 	GetEnv();
	virtual void    			MakeVisible();

	BOOL            			IsInPlaceActive() const
								{ return aProt.IsInPlaceActive(); }
	SvInPlaceObject * 			GetIPObj() const
								{ return aProt.GetIPObj(); }

	virtual void 				DeactivateAndUndo();
	virtual void 				DiscardUndoState();
};
#ifndef SO2_DECL_SVINPLACECLIENT_DEFINED
#define SO2_DECL_SVINPLACECLIENT_DEFINED
SO2_DECL_REF(SvInPlaceClient)
#endif
SO2_IMPL_REF(SvInPlaceClient)

#define inline
SV_DECL_REF_LIST(SvInPlaceClient,SvInPlaceClient*)
#undef inline

#endif // _IPCLIENT_HXX
