# Makefile for IRIX/mips using GNU compilers 2.95.2 for n32 ABI
ASM=
AFLAGS=

SOLAR_JAVA=TRUE
JAVADEF=-DSOLAR_JAVA

.IF "$(NO_EXCEPTIONS)"!="TRUE"
ENABLE_EXCEPTIONS=TRUE
.ENDIF


CC=			gcc
CXX=			g++ 
CFLAGS=		-c $(INCLUDE)
CDEFS+=	-D_PTHREADS -D_REENTRANT -DSTLPORT_VERSION=0x450  -D_USE_NAMESPACE=1
CFLAGSCC=	 -w 
CFLAGSCXX= 	-w -fno-for-scope -fpermissive 

# Compiler flags for compiling static object in single threaded environment with graphical user interface
CFLAGSOBJGUIST=
# Compiler flags for compiling static object in single threaded environment with character user interface
CFLAGSOBJCUIST=
# Compiler flags for compiling static object in multi threaded environment with graphical user interface
CFLAGSOBJGUIMT=
# Compiler flags for compiling static object in multi threaded environment with character user interface
CFLAGSOBJCUIMT=
# Compiler flags for compiling shared object in multi threaded environment with graphical user interface
CFLAGSSLOGUIMT=-fpic
# Compiler flags for compiling shared object in multi threaded environment with character user interface
CFLAGSSLOCUIMT=-fpic
# Compiler flags for profiling
CFLAGSPROF=
# Compiler flags for debugging
CFLAGSDEBUG=-g
CFLAGSDBGUTIL= 
# Compiler flags for enabling optimizations
CFLAGSOPT=-O2
# Compiler flags for disabling optimizations
CFLAGSNOOPT=-O0
# Compiler flags for describing the output path
CFLAGSOUTOBJ=-o
# Enable all warnings
CFLAGSWALL=-Wall
# Set the default warn level
CFLAGSDFLTWARN=-w
# exception flags
CFLAGSEXCEPTIONS=-fexceptions
CFLAGS_NO_EXCEPTIONS=-fno-exceptions


STDOBJVCL=$(L)$/salmain.o

STATIC=			-Wl,-Bstatic
DYNAMIC=		-Wl,-Bdynamic

# To use the map files, you need to have a gcc_specs file which contains:
# *linker:
# /path/to/bin/ld.sh
# where ld.sh is a wrapper script that does some conversion of the map files on the fly.

LINK=	g++
LINKFLAGS=	-L/usr/lib32 -Wl,-no_unresolved
LINKVERSIONMAPFLAG= -Wl,-exports_file

.IF "$(TARGETTHREAD)"=="MT"
LINKFLAGSAPPGUI= $(THREADLIB) -Wl,-multigot -nodefaultlibs
LINKFLAGSAPPCUI= $(THREADLIB) -Wl,-multigot -nodefaultlibs
LINKFLAGSSHLGUI= $(THREADLIB) -shared -nodefaultlibs
LINKFLAGSSHLCUI= $(THREADLIB) -shared -nodefaultlibs
.ELSE
LINKFLAGSAPPGUI= -Wl,-multigot -nodefaultlibs
LINKFLAGSAPPCUI= -Wl,-multigot -nodefaultlibs
LINKFLAGSSHLGUI= -shared -nodefaultlibs
LINKFLAGSSHLCUI= -shared -nodefaultlibs
.ENDIF

LINKFLAGSTACK=
LINKFLAGSPROF=
LINKFLAGSDEBUG= -g
LINKFLAGSOPT=

#LINKFLAGSSHLGUI += -Wl,-Bsymbolic -Wl,-soname -Wl,$(DLLPRE)$(SHL$(TNR)TARGET)$(DLLPOST) $(DYNAMIC)
#LINKFLAGSSHLCUI += -Wl,-Bsymbolic -Wl,-soname -Wl,$(DLLPRE)$(SHL$(TNR)TARGET)$(DLLPOST) $(DYNAMIC)
SONAME_SWITCH = -Wl,-soname -Wl,
APPLINKSTATIC=-Bstatic
APPLINKSHARED=-Bsymbolic

# Sequence of libraries DOES matter!
STDOBJGUI=
STDSLOGUI=
STDOBJCUI=
STDSLOCUI=
STDLIBGUIST=	$(DYNAMIC) -lX11 -lc -lm
STDLIBCUIST=	$(DYNAMIC) -lgcc -lc
STDLIBGUIMT=	$(THREADLIB) $(DYNAMIC) -lX11 -lm -lgcc -lc
STDLIBCUIMT=	$(THREADLIB) $(DYNAMIC) -lgcc -lc -lm
STDSHLGUIMT=	-L/usr/lib32 $(THREADLIB) $(DYNAMIC) -lX11 -lm -lgcc -lc
STDSHLCUIMT=	-L/usr/lib32 $(THREADLIB) $(DYNAMIC) -lm -lgcc -lc
THREADLIB=		-lpthread

LIBSTLPORT=$(DYNAMIC) -lstlport_gcc
LIBSTLPORTST=$(DYNAMIC) -lstlport_gcc $(DYNAMIC)

LIBMGR=			ar
LIBFLAGS=		-r

IMPLIB=
IMPLIBFLAGS=

MAPSYM=
MAPSYMFLAGS=

RC=				irc
RCFLAGS=		-fo$@ $(RCFILES)
RCLINK=
RCLINKFLAGS=
RCSETVERSION=

DLLPOSTFIX=im
DLLPRE=lib
DLLPOST=.so


LDUMP=c++filt

#STDLIBCPP = -lstdc++
