/*************************************************************************
 *
 *  $RCSfile: stordmon.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/13 20:59:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#define _STORE_STORDMON_CXX_ "$Revision: 1.2 $"

#ifndef __UTILITY__
#include <utility>
#endif
#ifndef __HASH_SET__
#include <hash_set>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif

#ifndef _OSL_CONDITN_HXX_
#include <osl/conditn.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _OSL_INTERLCK_H_
#include <osl/interlck.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _OSL_THREAD_HXX_
#include <osl/thread.hxx>
#endif

#ifndef _STORE_STORBASE_HXX_
#include <storbase.hxx>
#endif
#ifndef _STORE_STORDMON_HXX_
#include <stordmon.hxx>
#endif

using namespace store;

/*========================================================================
 *
 * OStorePageDaemon... internals.
 *
 *======================================================================*/
typedef OStorePageBIOS* key_type;

struct key_hash : public std::unary_function<key_type, sal_uInt32>
{
	sal_uInt32 operator() (key_type k) const { return (sal_uInt32)k; }
};

struct key_cmp : public std::binary_function<key_type, key_type, bool>
{
	bool operator() (key_type k1, key_type k2) const { return (k1 == k2); }
};

typedef std::hash_set<key_type, key_hash, key_cmp> set_type;

/*========================================================================
 *
 * OStorePageDaemon_Impl interface.
 *
 *======================================================================*/
namespace store
{

class OStorePageDaemon_Impl : public osl::Thread
{
public:
	OStorePageDaemon_Impl (void);
	virtual ~OStorePageDaemon_Impl (void);

	sal_Bool empty (void);

	sal_Bool insert (key_type k);
	sal_Bool remove (key_type k);

	void flush (void);

private:
	/** Representation.
	 */
	osl::Condition m_aCond;
	osl::Mutex     m_aMutex;
	set_type       m_aSet;

	/** Thread.
	 */
	virtual void SAL_CALL run (void);

	/** Not implemented.
	 */
	OStorePageDaemon_Impl (const OStorePageDaemon_Impl&);
	OStorePageDaemon_Impl& operator= (const OStorePageDaemon_Impl&);
};

} // namespace store

/*========================================================================
 *
 * OStorePageDaemon implementation.
 *
 *======================================================================*/
/*
 * __store_getGlobalMutex_Impl (protecting the single instance).
 */
static osl::Mutex& __store_getGlobalMutex_Impl (void)
{
	static osl::Mutex *pMutex = NULL;
	if (!pMutex)
	{
		osl::MutexGuard aGuard (osl::Mutex::getGlobalMutex());
		if (!pMutex)
		{
			static osl::Mutex g_aGlobalMutex;
			pMutex = &g_aGlobalMutex;
		}
	}
	return *pMutex;
}

/*
 * The single instance.
 */
store::OStorePageDaemon*
store::OStorePageDaemon::m_pThis = NULL;

/*
 * OStorePageDaemon.
 */
OStorePageDaemon::OStorePageDaemon (void)
	: m_pImpl     (new OStorePageDaemon_Impl()),
	  m_nRefCount (0)
{
}

/*
 * ~OStorePageDaemon.
 */
OStorePageDaemon::~OStorePageDaemon (void)
{
	delete m_pImpl;
}

/*
 * getOrCreate.
 */
sal_Bool OStorePageDaemon::getOrCreate (
	rtl::Reference<OStorePageDaemon> &rxThis)
{
	osl::MutexGuard aGuard (__store_getGlobalMutex_Impl());

	rxThis = m_pThis;
	if (!rxThis.is())
	{
		m_pThis = new OStorePageDaemon();
		rxThis  = m_pThis;
	}
	return rxThis.is();
}

/*
 * acquire.
 */
oslInterlockedCount SAL_CALL OStorePageDaemon::acquire (void)
{
	return osl_incrementInterlockedCount (&m_nRefCount);
}

/*
 * release.
 */
oslInterlockedCount SAL_CALL OStorePageDaemon::release (void)
{
	oslInterlockedCount result;

	result = osl_decrementInterlockedCount (&m_nRefCount);
	if (result == 0)
	{
		osl::MutexGuard aGuard (__store_getGlobalMutex_Impl());
		if (m_nRefCount == 0)
		{
			m_pThis = 0;
			delete this;
		}
	}
	return (result);
}

/*
 * insert.
 */
sal_Bool OStorePageDaemon::insert (key_type k)
{
	sal_Bool result = m_pImpl->insert(k);
	if (result && !m_pImpl->isRunning() && !m_pImpl->create())
	{
		// Thread creation failure. Need to flush here and now.
		m_pImpl->flush();
	}
	return result;
}

/*
 * remove.
 */
sal_Bool OStorePageDaemon::remove (key_type k)
{
	sal_Bool result = m_pImpl->remove(k);
	if (result && m_pImpl->empty())
	{
		// ...
	}
	return result;
}

/*========================================================================
 *
 * OStorePageDaemon_Impl implementation.
 *
 *======================================================================*/
/*
 * OStorePageDaemon_Impl.
 */
OStorePageDaemon_Impl::OStorePageDaemon_Impl (void)
{
	m_aCond.reset();
}

/*
 * ~OStorePageDaemon_Impl.
 */
OStorePageDaemon_Impl::~OStorePageDaemon_Impl (void)
{
	if (isRunning())
	{
		// Terminate.
		terminate();
		m_aCond.set();

		// Join.
		if (getCurrentIdentifier() != getIdentifier())
			join();
	}
}

/*
 * empty.
 */
sal_Bool OStorePageDaemon_Impl::empty (void)
{
	osl::MutexGuard aGuard (m_aMutex);
	return m_aSet.empty();
}

/*
 * insert.
 */
sal_Bool OStorePageDaemon_Impl::insert (key_type k)
{
	osl::MutexGuard aGuard (m_aMutex);
	if (k)
	{
		typedef std::pair<set_type::iterator, bool> result_t;
		result_t result = m_aSet.insert (k);
		if (!result.second)
			k = 0;
	}
	return (!!k);
}

/*
 * remove.
 */
sal_Bool OStorePageDaemon_Impl::remove (key_type k)
{
	osl::MutexGuard aGuard (m_aMutex);

	set_type::iterator it = m_aSet.find (k);
	if (it != m_aSet.end())
	{
		m_aSet.erase (it);
		return sal_True;
	}
	return sal_False;
}

/*
 * flush.
 */
void OStorePageDaemon_Impl::flush (void)
{
	m_aMutex.acquire();
	set_type aSet (m_aSet);
	m_aMutex.release();

	set_type::const_iterator first = aSet.begin();
	set_type::const_iterator last  = aSet.end();

	while (schedule() && (first != last))
	{
		key_type k = (key_type)(*first++);
		if (k)
		{
			// Verify and Acquire.
			osl::MutexGuard aGuard (m_aMutex);

			set_type::const_iterator it = m_aSet.find(k);
			if (it != m_aSet.end())
				k->acquire();
			else
				k = 0;
		}
		if (k)
		{
			// Flush and Release.
			k->flush();
			k->release();
		}
	}
}

/*
 * run.
 */
void SAL_CALL OStorePageDaemon_Impl::run (void)
{
	setPriority (osl_Thread_PriorityBelowNormal);
	while (schedule())
	{
		TimeValue tmo;
		tmo.Seconds = 10;
		tmo.Nanosec = 0;

		m_aCond.wait(&tmo);
		flush();
		m_aCond.reset();
	}
}

