/*************************************************************************
 *
 *  $RCSfile: args.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// MI: vor _ARGS_HXX, damit man _ARGS_HXX wegen CLOOKs wegdefinen kann
//typedef long SfxArgumentError;
//
//da mit diesem typedef das gesamte Sbx angezogen wird, ist dieses in die
//poolitem.hxx verschoben worden !

#ifndef _ARGS_HXX
#define _ARGS_HXX

#include <limits.h>
#ifndef _REF_HXX
#include <tools/ref.hxx>
#endif

class String;
class SbxVariable;
class SbxArray;

#ifndef SBX_ARRAY_DECL_DEFINED
#define SBX_ARRAY_DECL_DEFINED
SV_DECL_REF(SbxArray);
#endif

// ER: ja, das ist schweinisch, weil sbx.hxx erst hier in svtools
// gehedabut wird, aber wir _brauchen_ SbxArray
#include <sbx.hxx>

//------------------------------------------------------------------------

#if SUPD<311

#define SFX_ARGUMENT_ERROR( nArgNo, nCode ) ( ( (nArgNo) << 16 ) | (nCode) )

//! einordnen
#define SFX_ERR_NOT_IMPLEMENTED    1
#define SFX_ERR_INVALID_ARGUMENT   2
#define SFX_ERR_ARGUMENT_EXPECTED  3
#define SFX_ERR_TOO_MANY_ARGUMENTS 4

#else

#define SFX_ARGUMENT_ERROR( nArgNo, nCode ) (nCode)

HACK(nur zum Uebergang)
#define SFX_ERR_NOT_IMPLEMENTED    	ERRCODE_IO_NOTSUPPORTED
#define SFX_ERR_INVALID_ARGUMENT   	ERRCODE_IO_INVALIDPARAMETER
#define SFX_ERR_ARGUMENT_EXPECTED	ERRCODE_IO_INVALIDPARAMETER
#define SFX_ERR_TOO_MANY_ARGUMENTS 	ERRCODE_IO_INVALIDPARAMETER

#endif

//------------------------------------------------------------------------

class SfxArguments
{
	SbxArrayRef                 aArrayRef;
	USHORT						nFrom, nCount;

public:
								SfxArguments( BOOL bCreateArray = TRUE );
								SfxArguments( SbxArray* pArray,
											  USHORT nFrom = 1,
											  USHORT nCount = USHRT_MAX );
	virtual                     ~SfxArguments();

								// Argumente hinzufuegen
	virtual void				Append( SbxVariable *pArg );
	void						AppendEmpty( );
	void						AppendInteger( INT16 nArg );
	void						AppendLong( INT32 nArg );
	void						AppendSingle( float nArg );
	void						AppendDouble( double nArg );
	void						AppendBool( BOOL nArg );
	void						AppendString( const String& rArg );
	void                        AppendEnum( INT16 nArg );

								// Argumente abfragen
	virtual USHORT              Count() const;
	virtual const SbxVariable&	Get( USHORT nNo ) const;
	const SbxVariable&			operator[] ( USHORT nNo ) const
								{ return Get(nNo); }
};


#endif

