/*************************************************************************
 *
 *  $RCSfile: brwbox.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: fs $ $Date: 2001/09/24 14:57:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_BRWBOX_HXX
#define _SVX_BRWBOX_HXX

#include <limits.h>

#ifndef _SV_SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
#ifndef _SV_CTRL_HXX //autogen
#include <vcl/ctrl.hxx>
#endif
#ifndef _EVENT_HXX //autogen
//#include <vcl/event.hxx>
#endif

#ifndef _HEADBAR_HXX
#include <headbar.hxx>
#endif
#ifndef _TRANSFER_HXX
#include "transfer.hxx"
#endif

class BrowserColumn;
class BrowserColumns;
class BrowserDataWin;
class MultiSelection;
class BrowserHeader;

// -------------------
// - BrowseBox-Types -
// -------------------

#define BROWSER_INVALIDID           USHRT_MAX
#define BROWSER_ENDOFSELECTION      -1

typedef ULONG BrowserMode;

#define BROWSER_COLUMNSELECTION      0x0001
#define BROWSER_MULTISELECTION       0x0002
#define BROWSER_THUMBDRAGGING        0x0004
#define BROWSER_KEEPHIGHLIGHT        0x0008
#define BROWSER_KEEPSELECTION        BROWSER_KEEPHIGHLIGHT	// old, dont use!
#define BROWSER_HLINES               0x0010
#define BROWSER_VLINES               0x0020
#define BROWSER_HLINESFULL           BROWSER_HLINES // old, dont use!
#define BROWSER_VLINESFULL           BROWSER_VLINES // old, dont use!
#define BROWSER_HLINESDOTS           0x0000 // old => dont use!
#define BROWSER_VLINESDOTS           0x0000 // old => dont use!

#define BROWSER_HIDESELECT           0x0100	// old => dont use!
#define BROWSER_HIDECURSOR           0x0200

#define BROWSER_NO_HSCROLL           0x0400
#define BROWSER_NO_SCROLLBACK        0x0800

#define BROWSER_AUTO_VSCROLL	   	 0x1000
#define BROWSER_AUTO_HSCROLL	   	 0x2000

#define BROWSER_TRACKING_TIPS 	  	 0x4000

#define BROWSER_unused            	 0x8000

#define BROWSER_HIGHLIGHT_NONE       0x0100 // == BROWSER_HIDESELECT
#define BROWSER_HIGHLIGHT_TOGGLE 0x00000000 // old default => NULL, dont use!
#define BROWSER_HIGHLIGHT_AUTO   0x00010000
#define BROWSER_HIGHLIGHT_MANU   0x00020000

#define BROWSER_HEADERBAR_NEW	 0x00040000
#define BROWSER_AUTOSIZE_LASTCOL 0x00080000
#define BROWSER_OWN_DATACHANGED	 0x00100000

#define BROWSER_CURSOR_WO_FOCUS  0x00200000

typedef int BrowserColumnMode;
#define BROWSER_COLUMN_TITLEABBREVATION   1
#define BROWSER_COLUMN_STANDARD         	BROWSER_COLUMN_TITLEABBREVATION


#define BROWSER_NONE                      0
#define BROWSER_SELECT                  720
#define BROWSER_EXPANDSELECTION         721
#define BROWSER_ENHANCESELECTION        722
#define BROWSER_SELECTALL               723
#define BROWSER_SELECTDOWN              724
#define BROWSER_SELECTUP                725
#define BROWSER_CURSORDOWN              731
#define BROWSER_CURSORUP                732
#define BROWSER_CURSORLEFT              733
#define BROWSER_CURSORRIGHT             734
#define BROWSER_CURSORPAGEDOWN          735
#define BROWSER_CURSORPAGEUP            736
#define BROWSER_CURSORPAGERIGHT         735
#define BROWSER_CURSORPAGELEFT          736
#define BROWSER_CURSORENDOFFILE         741
#define BROWSER_CURSORTOPOFFILE         742
#define BROWSER_CURSORENDOFSCREEN       743
#define BROWSER_CURSORTOPOFSCREEN       744
#define BROWSER_CURSORHOME              745
#define BROWSER_CURSOREND               746
#define BROWSER_SCROLLDOWN              751
#define BROWSER_SCROLLUP                752
#define BROWSER_SELECTHOME				753
#define BROWSER_SELECTEND				754

// ---------------
// - BrowseEvent -
// ---------------

class BrowseEvent
{
	Window*             pWin;
	long                nRow;
	Rectangle           aRect;
	USHORT              nCol;
	USHORT              nColId;

public:
						BrowseEvent();
						BrowseEvent( Window* pWindow,
									 long nAbsRow,
									 USHORT nColumn, USHORT nColumnId,
									 const Rectangle& rRect );

	Window*             GetWindow() const { return pWin; }
	long                GetRow() const { return nRow; }
	USHORT              GetColumn() const { return nCol; }
	USHORT              GetColumnId() const { return nColId; }
	const Rectangle&    GetRect() const { return aRect; }
};

// ---------------------
// - BrowserMouseEvent -
// ---------------------

class BrowserMouseEvent: public MouseEvent, public BrowseEvent
{
public:
	BrowserMouseEvent();
	BrowserMouseEvent( BrowserDataWin* pWin, const MouseEvent& rEvt );
	BrowserMouseEvent( Window* pWin, const MouseEvent& rEvt,
					   long nAbsRow, USHORT nColumn, USHORT nColumnId,
					   const Rectangle& rRect );
};

// --------------------------
// - BrowserAcceptDropEvent -
// --------------------------

class BrowserAcceptDropEvent : public AcceptDropEvent, public BrowseEvent
{
public:
	BrowserAcceptDropEvent();
	BrowserAcceptDropEvent( BrowserDataWin* pWin, const AcceptDropEvent& rEvt );
};

// ---------------------------
// - BrowserExecuteDropEvent -
// ---------------------------

class BrowserExecuteDropEvent : public ExecuteDropEvent, public BrowseEvent
{
public:
	BrowserExecuteDropEvent();
	BrowserExecuteDropEvent( BrowserDataWin* pWin, const ExecuteDropEvent& rEvt );
};

// -------------
// - BrowseBox -
// -------------

class BrowseBox
		:public Control
		,public DragSourceHelper
		,public DropTargetHelper
{
	friend class BrowserDataWin;
	friend class BrowserColumn;
	friend class StringColumn;
	friend class BitmapColumn;
	friend class HandleColumn;

#ifdef DBG_MI
	friend void DoLog_Impl( const BrowseBox *pThis, const char *pWhat, const char *pWho );
#endif

#ifdef DBG_UTIL
	friend const char* BrowseBoxCheckInvariants( const void * pVoid );
#endif

	Window*         pDataWin;       // window to display data rows
	ScrollBar*      pVScroll;       // vertical scrollbar
	ScrollBar       aHScroll;       // horizontal scrollbar

	long            nDataRowHeight; // height of a single data-row
	USHORT          nTitleLines;    // number of lines in title row
	ULONG           nControlAreaWidth; // width of fixed area beneeth hscroll
	BOOL            bThumbDragging; // handle thumb dragging
	BOOL            bColumnCursor;  // single columns and fields selectable
	BOOL            bMultiSelection;// allow multiple selected rows
	BOOL            bKeepHighlight; // don't hide selection on LoseFocus

	BOOL            bHLines;        // draw lines between rows
	BOOL            bVLines;        // draw lines between columns
	BOOL            bHDots;         // draw lines between rows dotted
	BOOL            bVDots;         // draw lines between columns dotted
	Color			aLineColor;		// color for lines, default dark grey
	BOOL            bBootstrapped;  // child windows resized etc.
	BOOL            bHasBitmapHandle; // determines bitmap in handle-column
	long            nTopRow;        // no. of first visible row (0...)
	long            nCurRow;        // no. of row with cursor
	long            nRowCount;      // total number of rows in model
	USHORT          nFirstCol;      // no. of first visible scrollable column
	USHORT          nCurColId;      // column id of cursor

	BOOL			bSelecting;
	BOOL            bDrag;
	BOOL            bHit;
	BOOL            bRubber;
	Point           a1stPoint;
	Point           a2ndPoint;

	long            nResizeX;       // mouse position at start of resizing
	long            nMinResizeX;    // never drag more left
	long            nDragX;         // last dragged column (MouseMove)
	USHORT          nResizeCol;     // resize this column in MouseMove
	BOOL            bResizing;      // mouse captured for column resizing

	BOOL            bSelect;        // select or deselect
	BOOL            bSelectionIsVisible; // depending on focus
	BOOL            bScrolling;     // hidden cursor while scrolling
	BOOL            bNotToggleSel;  // set while in ToggleSelection() etc.
	BOOL            bHasFocus;      // set/unset in Get/LoseFocus
	BOOL            bHideSelect;    // hide selection (highlight)
	BOOL            bHideCursor;    // hide cursor (frame)
	Range			aSelRange;		// for selection expansion

	BrowserColumns* pCols;          // array of column-descriptions
	union
	{
		MultiSelection* pSel;       // selected rows for multi-selection
		long            nSel;       // selected row for single-selection
	}               uRow;
	MultiSelection* pColSel;        // selected column-ids

	BOOL			m_bFocusOnlyCursor;	// hide cursor if we don't have the focus
	Color			m_aCursorColor;		// special color for cursor, COL_TRANSPARENT for usual (VCL-painted) "inverted" cursor
	BrowserMode		m_nCurrentMode;		// last argument of SetMode (redundant, as our other members represent the current settings, too)

private:
#if _SOLAR__PRIVATE
	void            Construct(BrowserMode nMode);
	void            ExpandRowSelection( const BrowserMouseEvent& rEvt );
	void            ToggleSelection( BOOL bForce = FALSE );

	void            UpdateScrollbars();
	void            AutoSizeLastColumn();

	long            ImpGetDataRowHeight() const;
	Rectangle       ImplFieldRectPixel( long nRow, USHORT nColId ) const;
	USHORT          FrozenColCount() const;

	void            ColumnInserted( USHORT nPos );

	DECL_LINK( 		ScrollHdl, ScrollBar * );
	DECL_LINK( 		EndScrollHdl, ScrollBar * );
	DECL_LINK( 		StartDragHdl, HeaderBar * );

	long            GetFrozenWidth() const;
#endif

	BOOL            GoToRow(long nRow, BOOL bRowColMove, BOOL bDoNotModifySelection = FALSE );

	BOOL            GoToColumnId( USHORT nColId, BOOL bMakeVisible, BOOL bRowColMove = FALSE);
	void            SelectColumnPos( USHORT nCol, BOOL bSelect, BOOL bMakeVisible);
	void            SelectColumnId( USHORT nColId, BOOL bSelect, BOOL bMakeVisible)
						{ SelectColumnPos( GetColumnPos(nColId), bSelect, bMakeVisible); }

	void			ImplPaintData(OutputDevice& _rOut, const Rectangle& _rRect, BOOL _bForeignDevice, BOOL _bDrawSelections);

	BOOL			PaintCursorIfHiddenOnce() const { return !m_bFocusOnlyCursor && !HasFocus(); }

protected:
	USHORT          ColCount() const;

	// software plug for database access
	// Der RowCount wird jetzt intern automatisch gezaehlt
	// (ueber RowInserted und RowRemoved), daher ist das Ueberladen
	// dieser Methode ueberfluessig!
	virtual long    GetRowCount() const;

	// fuer Anzeige im VScrollBar z.B. auf "?" oder setzen
	void 			SetRealRowCount( const String &rRealRowCount );

	// Return Value muss immer TRUE sein - SeekRow *muss* klappen!
	// (sonst ASSERT) MI: wer hat das eingebaut? Das darf nicht so sein!
	virtual BOOL    SeekRow( long nRow ) = 0;
	virtual void    DrawCursor();
	virtual void	PaintRow( OutputDevice &rDev, const Rectangle &rRect );
	virtual void    PaintData( Window& rWin, const Rectangle& rRect );
	virtual void    PaintField( OutputDevice& rDev, const Rectangle& rRect,
								USHORT nColumnId ) const = 0;
	// Benachrichtigung an die abgeleitete Klasse, dass sich der sichtbare
	// Bereich von Rows geaendert hat. Aus dieser Methode heraus darf
	// die abgeleitete Klasse Aenderungen des Model mit Hilfe der Methoden
	// RowInserted und RowRemoved bekanntgeben. Mit sich daraus ergebenden
	// neuen Zustand wird anschliessend ein Paint veranlasst (und entsprechend
	// SeekRow etc. gerufen).
	//
	// Parameter: nNewTopRow: Nr. der neuen TopRow (kann von VisibleRowsChanged
	// durch Aufruf von RowInserted und RowDeleted noch veraendert werden).
	// nNumRows: Anzahl der sichtbaren Rows (auch eine teilweise sichtbare Row
	// wird mitgezaehlt).
	//
	// Moegliche Ursachen fuer die Aenderung des sichtbaren Bereiches:
	// - Vor dem sichtbaren Bereich sind Rows eingefuegt oder geloescht worden,
	//   dadurch aendert sich nur die Numerierung der sichtbaren Rows
	// - Scrollen (und daraus resultierend eine andere erste sichtbare Row)
	// - Resize des Fensters
	virtual void    VisibleRowsChanged( long nNewTopRow, USHORT nNumRows);

	// Anzahl sichtbarer Rows in dem Fenster (inkl. "angeschnittener" Rows)
	USHORT          GetVisibleRows()
						{ return (USHORT)((pDataWin->GetOutputSizePixel().Height() - 1 )/ GetDataRowHeight() + 1); }
	long            GetTopRow() { return nTopRow; }
	USHORT			GetFirstVisibleColNumber() const { return nFirstCol; }

	// Focus-Rect ein-/ausschalten
	void			DoShowCursor( const char *pWhoLog );
	void			DoHideCursor( const char *pWhoLog );
	short			GetCursorHideCount() const;

	virtual BrowserHeader*	CreateHeaderBar( BrowseBox* pParent );

	// HACK(virtuelles Create wird im Ctor nicht gerufen)
	void			SetHeaderBar( BrowserHeader* );

	long			CalcReverseZoom(long nVal);

	HeaderBar*		GetHeaderBar() const;
		// header bar access for derived classes

	inline const DataFlavorExVector&
					GetDataFlavors() const;

	sal_Bool		IsDropFormatSupported( SotFormatStringId nFormat );		// need this because the base class' IsDropFormatSupported is not const ...
	sal_Bool		IsDropFormatSupported( SotFormatStringId nFormat ) const;

	sal_Bool		IsDropFormatSupported( const ::com::sun::star::datatransfer::DataFlavor& _rFlavor );		// need this because the base class' IsDropFormatSupported is not const ...
	sal_Bool		IsDropFormatSupported( const ::com::sun::star::datatransfer::DataFlavor& _rFlavor ) const;

private:
	void*			implGetDataFlavors() const;
		// with this we can make GetDataFlavors() inline, which is strongly needed as SVTOOLS does not export
		// any sysbols containing an "_STL", so a non-inlined method would not be exported ....

public:
					BrowseBox( Window* pParent, WinBits nBits = 0,
							   BrowserMode nMode = 0 );
					BrowseBox( Window* pParent, const ResId& rId,
							   BrowserMode nMode = 0 );
					~BrowseBox();

	// ererbte ueberladene Handler
	virtual void	StateChanged( StateChangedType nStateChange );
	virtual void    MouseButtonDown( const MouseEvent& rEvt );
	virtual void    MouseMove( const MouseEvent& rEvt );
	virtual void    MouseButtonUp( const MouseEvent& rEvt );
	virtual void    KeyInput( const KeyEvent& rEvt );
	virtual void    LoseFocus();
	virtual void    GetFocus();
	virtual void    Resize();
	virtual void    Paint( const Rectangle& rRect );
	virtual void	Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );
	virtual void    Command( const CommandEvent& rEvt );
	virtual void	StartDrag( sal_Int8 _nAction, const Point& _rPosPixel );

	virtual sal_Int8 AcceptDrop( const AcceptDropEvent& rEvt );		// will forward everything got to the second AcceptDrop method
	virtual sal_Int8 ExecuteDrop( const ExecuteDropEvent& rEvt );	// will forward everything got to the second ExecuteDrop method

	virtual sal_Int8 AcceptDrop( const BrowserAcceptDropEvent& rEvt );
	virtual sal_Int8 ExecuteDrop( const BrowserExecuteDropEvent& rEvt );

	// neue Handler
	virtual void    MouseButtonDown( const BrowserMouseEvent& rEvt );
	virtual void    MouseMove( const BrowserMouseEvent& rEvt );
	virtual void    MouseButtonUp( const BrowserMouseEvent& rEvt );
	virtual void    StartScroll();
	virtual void    EndScroll();
	virtual void    Select();
	virtual void    DoubleClick( const BrowserMouseEvent& rEvt );
	virtual BOOL	IsCursorMoveAllowed( long nNewRow, USHORT nNewColId ) const;
	virtual void    CursorMoved();
	virtual void    ColumnMoved( USHORT nColId );
	virtual void    ColumnResized( USHORT nColId );
	virtual long    QueryColumnResize( USHORT nColId, long nWidth );

	// Window-Control (pass to DataWindow)
	void            SetUpdateMode( BOOL bUpdate );
	BOOL            GetUpdateMode() const;
	void            Invalidate();
	void            Invalidate( const Rectangle& rRect )
						{ Control::Invalidate( rRect ); }

	// map-mode and font control
	void            SetMapMode( const MapMode& rNewMapMode );
	void            SetFont( const Font& rNewFont );
	const Font&     GetFont() const { return pDataWin->GetFont(); }
	void            SetTitleFont( const Font& rNewFont )
						{ Control::SetFont( rNewFont ); }
	const Font&     GetTitleFont() const { return Control::GetFont(); }

	// color for line painting
	void			SetLineColor(const Color& rColor) {aLineColor = rColor;}
	const Color&	GetLineColor() const {return aLineColor;}

	// inserting, changing, removing and freezing of columns
	void            InsertHandleColumn( ULONG nWidth, BOOL bBitmap = FALSE );
	void			InsertDataColumn( USHORT nItemId, const Image& rImage,
									long nSize, HeaderBarItemBits nBits = HIB_STDSTYLE,
									USHORT nPos = HEADERBAR_APPEND );
	void			InsertDataColumn( USHORT nItemId, const XubString& rText,
									long nSize, HeaderBarItemBits nBits = HIB_STDSTYLE,
									USHORT nPos = HEADERBAR_APPEND );
	void			InsertDataColumn( USHORT nItemId,
									const Image& rImage, const XubString& rText,
									long nSize, HeaderBarItemBits nBits = HIB_STDSTYLE,
									USHORT nPos = HEADERBAR_APPEND,
									// Hilfstext bei leerem rText
									const String* pHelpText = 0 );
	void            SetColumnTitle( USHORT nColumnId, const String &rTitle );
	void            SetColumnMode( USHORT nColumnId, BrowserColumnMode nFlags );
	void            SetColumnWidth( USHORT nColumnId, ULONG nWidth );
	void            SetColumnPos( USHORT nColumnId, USHORT nPos );
	void            FreezeColumn( USHORT nColumnId, BOOL bFreeze = TRUE );
	void            UnfreezeColumns();
	void            RemoveColumn( USHORT nColumnId );
	void            RemoveColumns();

	// control of title and data row height
	void            SetDataRowHeight( long nPixel );
	long            GetDataRowHeight() const;
	void            SetTitleLines( USHORT nLines );
	USHORT          GetTitleLines() const { return nTitleLines; }
	virtual long	GetTitleHeight() const;

	// access to dynamic values of cursor row
	String          GetColumnTitle( USHORT nColumnId ) const;
	BrowserColumnMode GetColumnMode( USHORT nColumnId ) const;
	Rectangle       GetFieldRect( USHORT nColumnId ) const;
	ULONG           GetColumnWidth( USHORT nColumnId ) const;
	USHORT          GetColumnId( USHORT nPos ) const;
	USHORT          GetColumnPos( USHORT nColumnId ) const;
	BOOL            IsFrozen( USHORT nColumnId ) const;

	// movement of visible area
	void            ToTop();
	void            ToBottom();
	void            ResetScroll();
	long            ScrollColumns( long nColumns );
	long            ScrollRows( long nRows );
	long            ScrollPages( long nPagesY );
	BOOL			MakeFieldVisible( long nRow, USHORT nColId, BOOL bComplete = FALSE );

	// access and movement of cursor
	long            GetCurRow() const { return nCurRow; }
	USHORT          GetCurColumnId() const { return nCurColId; }
	BOOL            GoToRow( long nRow );
	BOOL			GoToRowAndDoNotModifySelection( long nRow );
	BOOL            GoToColumnId( USHORT nColId );
	BOOL            GoToRowColumnId( long nRow, USHORT nColId );

	// selections
	void            SetNoSelection();
	void            SelectAll();
	void            SelectRow( long nRow, BOOL bSelect = TRUE, BOOL bExpand = TRUE );
	void            SelectColumnPos( USHORT nCol, BOOL bSelect = TRUE )
						{ SelectColumnPos( nCol, bSelect, TRUE); }
	void            SelectColumnId( USHORT nColId, BOOL bSelect = TRUE )
						{ SelectColumnPos( GetColumnPos(nColId), bSelect, TRUE); }
	long            GetSelectRowCount() const;
	USHORT          GetSelectColumnCount() const;
	BOOL            IsRowSelected( long nRow ) const;
	BOOL            IsColumnSelected( USHORT nColumnId ) const;
	long            FirstSelectedRow( BOOL bInverse = FALSE );
	long            LastSelectedRow( BOOL bInverse = FALSE );
	long            PrevSelectedRow();
	long            NextSelectedRow();
	const MultiSelection* GetColumnSelection() const { return pColSel; }
	const MultiSelection* GetSelection() const
					{ return bMultiSelection ? uRow.pSel : 0; }
	void			SetSelection( const MultiSelection &rSelection );
	BOOL			IsResizing() const { return bResizing; }

	// access to positions of fields, column and rows
	Window&         GetEventWindow() const;
	Window&         GetDataWindow() const { return *pDataWin; }
	Rectangle       GetRowRectPixel( long nRow,
									 BOOL bRelToBrowser = TRUE ) const;
	Rectangle       GetFieldRectPixel( long nRow, USHORT nColId,
									   BOOL bRelToBrowser = TRUE  ) const;
	BOOL            IsFieldVisible( long nRow, USHORT nColId,
									BOOL bComplete = FALSE ) const;
	long            GetRowAtYPosPixel( long nY,
										BOOL bRelToBrowser = TRUE  ) const;
	USHORT          GetColumnAtXPosPixel( long nX,
										  BOOL bRelToBrowser = TRUE  ) const;

	// invalidations
	void            Clear();
	void            RowRemoved( long nRow, long nNumRows = 1, BOOL bDoPaint = TRUE );
	void            RowModified( long nRow, USHORT nColId = USHRT_MAX );
	void            RowInserted( long nRow, long nNumRows = 1, BOOL bDoPaint = TRUE, BOOL bKeepSelection = FALSE );

	// miscellanous
	void            ReserveControlArea( USHORT nWidth = USHRT_MAX );
	Rectangle       GetControlArea() const;
	BOOL 			ProcessKey( const KeyEvent& rEvt );
	void            Dispatch( USHORT nId );
	void            SetMode( BrowserMode nMode = 0 );
	BrowserMode		GetMode( ) const { return m_nCurrentMode; }
	BOOL			IsInCommandEvent() const;

	void			SetCursorColor(const Color& _rCol);
	Color			GetCursorColor() const { return m_aCursorColor; }
	void			ResetSelecting() { bSelecting = FALSE; }
};

//-------------------------------------------------------------------
inline const DataFlavorExVector& BrowseBox::GetDataFlavors() const
{
	return *reinterpret_cast<DataFlavorExVector*>(implGetDataFlavors());
}

#endif

