/*************************************************************************
 *
 *  $RCSfile: folderpicker.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: fs $ $Date: 2001/10/31 09:18:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef INCLUDED_SVT_FOLDERPICKER_HXX
#define INCLUDED_SVT_FOLDERPICKER_HXX

#ifndef  _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif

#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif

#ifndef  _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef  _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif

#include "svtuno.hxx"


// class SvtFolderPicker ---------------------------------------------------

class SvtFolderPicker : public ::cppu::WeakImplHelper2< ::com::sun::star::ui::dialogs::XFolderPicker,
											            ::com::sun::star::lang::XServiceInfo >
{
private:
	friend class SvtFolderPicker_Impl;

	SvtFolderPicker_Impl*			m_pImpl;

    //------------------------------------------------------------------------------------
    // misc. helpers
	//------------------------------------------------------------------------------------

    static sal_Bool                 HasSystemFolderPicker( const UNOREFERENCE < ::com::sun::star::lang::XMultiServiceFactory> xFactory );
    static sal_Bool                 UseSystemFolderPicker();

public:
                                    SvtFolderPicker( const UNOREFERENCE < ::com::sun::star::lang::XMultiServiceFactory >& xFactory );
    virtual                        ~SvtFolderPicker();

	//------------------------------------------------------------------------------------
	// XExecutableDialog functions
	//------------------------------------------------------------------------------------

	virtual void SAL_CALL 			setTitle( const UNOOUSTRING& aTitle ) throw( UNORUNTIMEEXCEPTION );
	virtual sal_Int16 SAL_CALL 		execute() throw( UNORUNTIMEEXCEPTION );

	//------------------------------------------------------------------------------------
	// XFolderPicker functions
	//------------------------------------------------------------------------------------

	virtual void SAL_CALL			setDisplayDirectory( const UNOOUSTRING& aDirectory ) throw( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION );
	virtual UNOOUSTRING SAL_CALL	getDisplayDirectory() throw( UNORUNTIMEEXCEPTION );
    virtual UNOOUSTRING SAL_CALL	getDirectory() throw( UNORUNTIMEEXCEPTION );
    virtual void SAL_CALL           setDescription( const UNOOUSTRING& aDescription ) throw ( UNORUNTIMEEXCEPTION );

	//------------------------------------------------------------------------------------
	// XServiceInfo functions
	//------------------------------------------------------------------------------------

	/* XServiceInfo */
    virtual UNOOUSTRING SAL_CALL	getImplementationName() throw( UNORUNTIMEEXCEPTION );
    virtual sal_Bool SAL_CALL		supportsService( const UNOOUSTRING& sServiceName ) throw( UNORUNTIMEEXCEPTION );
    virtual UNOSEQUENCE< UNOOUSTRING > SAL_CALL
									getSupportedServiceNames() throw( UNORUNTIMEEXCEPTION );

	/* Helper for XServiceInfo */
	static UNOSEQUENCE< UNOOUSTRING >
									impl_getStaticSupportedServiceNames();
	static UNOOUSTRING				impl_getStaticImplementationName();
	/* Helper for registry */
	static UNOREFERENCE< UNOXINTERFACE > SAL_CALL
									impl_createInstance( const UNOREFERENCE< UNOXMULTISERVICEFACTORY >& xServiceManager ) throw( UNOEXCEPTION );
};

#endif // INCLUDED_SVT_FOLDERPICKER_HXX
