/*************************************************************************
 *
 *  $RCSfile: undo.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: thb $ $Date: 2001/08/01 13:22:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _UNDO_HXX
#define _UNDO_HXX

#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

//#import BOOL
//#import String
//#import TYPEINFO
//#import USHORT
//#import UniString

//#export SfxRepeatTarget
//#export SfxUndoAction
//#export SfxLinkUndoAction
//#export SfxUndoManager

struct SfxUndoArray;
class SfxUndoActions;

//====================================================================

class SfxRepeatTarget
{
public:
						TYPEINFO();
	virtual 			~SfxRepeatTarget() = 0;
};

//====================================================================

class SfxUndoAction
{
	BOOL bLinked;
public:
							TYPEINFO();
							SfxUndoAction();
	virtual 				~SfxUndoAction();

	virtual BOOL            IsLinked();
	virtual void            SetLinked( BOOL bIsLinked = TRUE );
	virtual void			Undo();
	virtual void			Redo();
	virtual void			Repeat(SfxRepeatTarget&);
	virtual BOOL			CanRepeat(SfxRepeatTarget&) const;

	virtual BOOL			Merge( SfxUndoAction *pNextAction );

	virtual UniString			GetComment() const;
	virtual UniString			GetRepeatComment(SfxRepeatTarget&) const;
	virtual USHORT			GetId() const;

private:
	SfxUndoAction&			operator=( const SfxUndoAction& );	  // n.i.!!
};

//=========================================================================

class SfxUndoManager
{
	friend class SfxLinkUndoAction;

	SfxUndoArray 			*pUndoArray;
	SfxUndoArray			*pActUndoArray;
	SfxUndoArray			*pFatherUndoArray;


public:
							SfxUndoManager( USHORT nMaxUndoActionCount = 20 );
	virtual 				~SfxUndoManager();

	virtual void			SetMaxUndoActionCount( USHORT nMaxUndoActionCount );
	virtual USHORT			GetMaxUndoActionCount() const;
	virtual void			Clear();

	virtual void			AddUndoAction( SfxUndoAction *pAction, BOOL bTryMerg=FALSE );

	virtual USHORT			GetUndoActionCount() const;
	virtual USHORT			GetUndoActionId(USHORT nNo=0) const;
	virtual UniString			GetUndoActionComment( USHORT nNo=0 ) const;

	virtual BOOL			Undo( USHORT nCount=1 );
	virtual void			Undo( SfxUndoAction &rAction );


	virtual USHORT			GetRedoActionCount() const;
	virtual USHORT			GetRedoActionId(USHORT nNo=0) const;
	virtual UniString			GetRedoActionComment( USHORT nNo=0 ) const;

	virtual BOOL			Redo( USHORT nCount=1 );
	virtual void			Redo( SfxUndoAction &rAction );
#if SUPD>337
	virtual
#endif
			void			ClearRedo();

	virtual USHORT			GetRepeatActionCount() const;
	virtual UniString			GetRepeatActionComment( SfxRepeatTarget &rTarget, USHORT nNo = 0) const;
	virtual BOOL			Repeat( SfxRepeatTarget &rTarget, USHORT nFrom=0, USHORT nCount=1 );
	virtual void			Repeat( SfxRepeatTarget &rTarget, SfxUndoAction &rAction );
	virtual BOOL			CanRepeat( SfxRepeatTarget &rTarget, USHORT nNo = 0 ) const;
	virtual BOOL			CanRepeat( SfxRepeatTarget &rTarget, SfxUndoAction &rAction ) const;


	virtual void            EnterListAction(const UniString &rComment, const UniString& rRepeatComment, USHORT nId=0);
	virtual void 			LeaveListAction();
};

//=========================================================================

class SfxLinkUndoAction : public SfxUndoAction

/*	[Beschreibung]

	Die SfxLinkUndoAction dient zur Verbindung zweier SfxUndoManager. Die
	im ersten SfxUndoManager eingefuegten SfxUndoAction leiten ihr Undo und Redo
	an den zweiten weiter, so dass ein Undo und Redo am ersten
	SfxUndoManager wie eine am zweiten wirkt.

	Die SfxLinkUndoAction ist nach dem Einfuegen der SfxUndoAction am
	zweiten SfxUndoManager einzufuegen. Waehrend der zweite SfxUndoManager
	vom ersten ferngesteuert wird, duerfen an ihm weder Actions eingefuegt werden,
	noch darf Undo/Redo aufgerufen werden.

*/

{
public:
							TYPEINFO();
							SfxLinkUndoAction(SfxUndoManager *pManager);
							~SfxLinkUndoAction();

	virtual void			Undo();
	virtual void			Redo();
	virtual BOOL			CanRepeat(SfxRepeatTarget& r) const;

	virtual void			Repeat(SfxRepeatTarget&r);

	virtual UniString			GetComment() const;
	virtual UniString			GetRepeatComment(SfxRepeatTarget&r) const;
	virtual USHORT			GetId() const;


protected:
	SfxUndoManager			*pUndoManager;
	SfxUndoAction			*pAction;

};



#endif
