/*************************************************************************
 *
 *  $RCSfile: eaimp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: thb $ $Date: 2001/08/14 13:49:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>

#define INCL_WINWORKPLACE
#define INCL_BASE
#define INCL_DOS
#define INCL_DOSMODULEMGR

#include <tools/svpm.h>

#include <tools/fsys.hxx>
#include <tools/stream.hxx>
#include <tools/debug.hxx>
#include <tools/rc.hxx>
#include <vcl/rcid.h>
#include <vcl/sysdep.hxx>
#include <vcl/icon.hxx>

#include <extattr.hxx>

#define ulBufSize 200L

#define SV_EA_ICON			1
#define SV_EA_LONGNAME		2
#define SV_EA_FILETYPE		3
#define SV_EA_CREATOR		4
#define SV_EA_COMMENT		5
#define SV_EA_VERSION       6

static const char *pszTypeId 		= ".TYPE",
				  *pszComment		= ".COMMENTS",
				  *pszIconId		= ".ICON",
				  *pszLongName		= ".LONGNAME",
				  *pszVersion       = ".VERSION";

static const char *pLineBreak = "\r\n";

// define a .TYPE EA structure
struct ImpTypeEAList
{
	ULONG   cbList;			// length of all EAs in list
	ULONG   ulNextEa;		// offset of next EA
	BYTE	bFlags;			// EA flags
	BYTE	cbName;			// length of name
	USHORT  cbEA;			// sizeof EA
	CHAR	szName[6];		// ".TYPE"
	USHORT  usType;			// EA data type
	USHORT  cbValue;		// sizeof value
	CHAR	achValue[1];	// placeholder for EA value
};

// define a .TYPE EA structure
struct ImpVersionEAList
{
	ULONG   cbList;			// length of all EAs in list
	ULONG   ulNextEa;		// offset of next EA
	BYTE	bFlags;			// EA flags
	BYTE	cbName;			// length of name
	USHORT  cbEA;			// sizeof EA
	CHAR	szName[9];		// ".VERSION"
	USHORT  usType;			// EA data type
	USHORT  cbValue;		// sizeof value
	CHAR	achValue[1];	// placeholder for EA value
};

// define a .COMMENTS EA structure
struct ImpCommentEAList
{
	ULONG   cbList;			// length of all EAs in list
	ULONG   ulNextEa;		// offset of next EA
	BYTE	bFlags;			// EA flags
	BYTE	cbName;			// length of name
	USHORT  cbEA;			// sizeof EA
	CHAR	szName[10];		// ".COMMENTS"
	USHORT  usType;			// EA data type, hier immer multi value multi type
	USHORT  usCodePage;		// spezifische Eintraege fuer Kommentare: Codepage
	USHORT  usNum;			// Anzahl der folgenden m-m Eintraege
};

// multi value multi type entry
struct ImpMMEAEntry
{
	USHORT  usDataType;		// Datentyp des Eintrage
	USHORT  cbValue;        // sizeof value
	CHAR    aValue[1];    	// der Wert
};

// define a .ICON EA structure
struct ImpIcoEAList
{
	ULONG   cbList;			// length of all EAs in list
	ULONG   ulNextEa;		// offset of next EA
	BYTE	bFlags;			// EA flags
	BYTE	cbName;			// length of name
	USHORT  cbEA;			// sizeof EA
	CHAR	szName[6];		// ".ICON"
	USHORT  usType;			// EA data type
	USHORT  cbValue;		// sizeof value
	CHAR	achValue[1];	// placeholder for EA value
};

// define a .LONGNAME EA structure
struct ImpLongNameEAList
{
	ULONG   cbList;			// length of all EAs in list
	ULONG   ulNextEa;		// offset of next EA
	BYTE	bFlags;			// EA flags
	BYTE	cbName;			// length of name
	USHORT  cbEA;			// sizeof EA
	CHAR	szName[10];		// ".LONGNAME"
	USHORT  usType;			// EA data type
	USHORT  cbValue;		// sizeof value
	CHAR	achValue[1];	// placeholder for EA value
};

struct ImpHoldFEA
{
   ULONG   	oNextEntryOffset;
   BYTE     fEA;       		// Flag byte
   BYTE     cbName;
   USHORT   cbValue;
   CHAR     *szName;
   CHAR     *aValue;
};

class ImpEaMgr
{
	String			aFileName;
	HFILE			hFile;

public:
					ImpEaMgr( const DirEntry& rEntry );
					ImpEaMgr( const String& rFilename );
					ImpEaMgr( SvFileStream& rStream );

					~ImpEaMgr();

	BOOL			HasEa( USHORT nType );

	BOOL  			GetIcon( Icon& );
	BOOL			SetIcon( const ResId& rId );
	BOOL			SetIcon( const String& rIconFileName );

	BOOL        	GetLongName(String& );
	BOOL			SetLongName( const String& );

	BOOL			GetFileType( String& );
	BOOL			SetFileType( const String& );

	BOOL			GetVersionInfo( String& );
	BOOL			SetVersionInfo( const String& );

	BOOL			GetComment( String& );
	BOOL			SetComment( const String& );
	BOOL			Clone( const SvEaMgr& );

	BOOL			GetEA( String &rResult, USHORT nType);
};

ImpEaMgr::ImpEaMgr( const DirEntry& rEntry )
	: aFileName( rEntry.GetFull() )
{
	hFile = 0;
}

ImpEaMgr::ImpEaMgr( const String& rFileName )
	: aFileName( rFileName )
{
	hFile = 0;
}

ImpEaMgr::ImpEaMgr( SvFileStream& rStream )
{
	DBG_ASSERT(rStream.IsA()==ID_FILESTREAM,"Not a file stream");
	hFile = (HFILE)rStream.GetFileHandle(); //Sysdepen::GethFile( rStream );
}

ImpEaMgr::~ImpEaMgr()
{
}

BOOL ImpEaMgr::GetIcon( Icon& rResult )
{
	HPOINTER hIcon = WinLoadFileIcon( aFileName.GetCharStr(), FALSE ); // shared
	Icon aSvIcon;
	Sysdepen::SethIcon( aSvIcon, hIcon );
	rResult = aSvIcon;
	return TRUE;
}


BOOL ImpEaMgr::GetLongName( String& rResult )
{
	return GetEA( rResult, SV_EA_LONGNAME);
}

BOOL ImpEaMgr::SetLongName( const String& rLongName )
{
	EAOP2       eaop;           // extended attributes structure
	APIRET      rc;             // return from API
	ImpLongNameEAList *pLea = 0;
	const int nFileLen = rLongName.Len();
	const int nSize =  nFileLen - 1 + sizeof(ImpLongNameEAList);

	pLea = (ImpLongNameEAList *) new char[nSize];
	memset(pLea, 0, nSize);
	memcpy(pLea->achValue, rLongName.GetStr(), nFileLen);
	pLea->cbList = nSize;
	pLea->cbValue = nFileLen;
	pLea->usType = EAT_ASCII;
	pLea->cbEA = pLea->cbValue + sizeof(pLea->usType) + sizeof(pLea->cbValue);
	pLea->cbName = strlen(pszLongName);
	strcpy(pLea->szName, pszLongName);

	eaop.fpFEA2List = (PFEA2LIST)pLea;
	eaop.fpGEA2List = NULL;
	if( !hFile )
		rc = DosSetPathInfo((PSZ)aFileName.GetStr(),2,(PVOID)&eaop,sizeof(EAOP2),DSPI_WRTTHRU);
	else
		rc = DosSetFileInfo(hFile, 2, (PVOID)&eaop, sizeof(EAOP2) );
	delete pLea ;
	return (BOOL)rc == 0;
}

BOOL ImpEaMgr::GetFileType( String& rResult )
{
	return GetEA(rResult, SV_EA_FILETYPE);
}

BOOL ImpEaMgr::GetComment( String& rResult )
{
	return GetEA( rResult, SV_EA_COMMENT);
}

BOOL ImpEaMgr::GetVersionInfo( String& rResult )
{
	return GetEA( rResult, SV_EA_VERSION);
}

BOOL ImpEaMgr::SetComment( const String& rComment )
{
	EAOP2	eaop;		// extended attributes structure
	USHORT	cb;			// structure length
	APIRET	rc;			// return from API
	USHORT *pusPtr;
	ImpMMEAEntry *pEntry;

	USHORT nLen = rComment.Len();
	if(nLen)
	{
		USHORT nLines = 1;			// nLines ist die Anzahl der Zeilen
		USHORT nIdx = 0;
		while(nIdx < nLen)
		{
			if(rComment[nIdx] == pLineBreak[0])
			{
				++nLines;
				++nIdx;
			}
			++nIdx;
		}
		cb = sizeof(ImpCommentEAList) +
			(sizeof(USHORT) * 2 * nLines) +
			(nLen - ((nLines-1) * 2));			// Zeilentrenner fallen weg
		ImpCommentEAList *pComtea = (ImpCommentEAList *) new char[cb];
		memset(pComtea, 0 , cb);
		pComtea->usType = EAT_MVMT;
		pComtea->cbName = (BYTE) strlen(pszComment);
		memcpy(pComtea->szName, pszComment, pComtea->cbName);
		pComtea->usNum = nLines;
		pusPtr = &pComtea->usNum;
		++pusPtr;
		pEntry = (ImpMMEAEntry *)pusPtr;
		nIdx = 0;
		for(USHORT i = 0; i < nLines; ++i)
		{
			USHORT k = 0;
			char *psz = pEntry->aValue;
			pEntry->usDataType = EAT_ASCII;
			while(nIdx < nLen && rComment[nIdx] != pLineBreak[0])
			{
				*psz++ = rComment[nIdx];
				++k;
				++nIdx;
			}
			nIdx += 2;	// \r\n ueberspringen
			pEntry->cbValue = k;
			pEntry = (ImpMMEAEntry *)psz; // psz steht hinter dem letzten Zeicehen
		}
		pComtea->cbEA = sizeof(pComtea->usCodePage) +
						sizeof(pComtea->usType) +
						sizeof(pComtea->usNum) +
						(nLen - ((nLines-1) * 2)) +
						(sizeof(USHORT) * 2 * nLines);

		// point to the TYPE EA list structure
		eaop.fpFEA2List = (PFEA2LIST)pComtea;
		eaop.fpGEA2List = NULL;
		pComtea->cbList = cb;			   // structure length
		if( !hFile )
			rc = DosSetPathInfo((PSZ)aFileName.GetStr(), 2,
				(PVOID)&eaop, sizeof(EAOP2), DSPI_WRTTHRU);
		else
			rc = DosSetFileInfo(hFile, 2, (PVOID)&eaop, sizeof(EAOP2) );

		delete pComtea;
		if(rc) return FALSE;
	}
	return TRUE;
}

BOOL ImpEaMgr::SetFileType( const String& rType )
{
	EAOP2	eaop;		// extended attributes structure
	USHORT	cb;			// structure length
	APIRET	rc;			// return from API
	USHORT *pusPtr;
	ImpMMEAEntry *pEntry;

	// allocate memory for the TYPE EA list
	// -1 because the structure itself defines 1 char;

	USHORT nLen = rType.Len();
	cb = nLen - 1 + sizeof (ImpTypeEAList);
	ImpTypeEAList *ptea = (ImpTypeEAList *)new char[cb];

	// initialize the EA structures
	// fill in the EA value itself: for .TYPE it's the file type
	memcpy(ptea->achValue, rType.GetStr(), nLen );

	// fill in length of the EA value
	ptea->cbValue = nLen;

	// fill type of EA value
	ptea->usType = EAT_ASCII;		 // length-preceded ASCII

	// length of EA (includes value + type and length fields)
	ptea->cbEA = ptea->cbValue + sizeof(ptea->usType) + sizeof (ptea->cbValue);

	// fill in the EA name (it's a null terminated string so strcpy is OK)
	strcpy(ptea->szName, pszTypeId);

	// fill in EA name length
	ptea->cbName = (BYTE)strlen(pszTypeId);

	// point to the TYPE EA list structure
	eaop.fpFEA2List = (PFEA2LIST)ptea;
	eaop.fpGEA2List = NULL;
	ptea->cbList = cb;				// structure length
	ptea->ulNextEa = 0;				// no more EAs
	ptea->bFlags = 0;				// noncritical

	// attach the .TYPE extended attribute to the file
	if( !hFile )
		rc = DosSetPathInfo( (PSZ)aFileName.GetStr(), 2,
				 (PVOID)&eaop, sizeof(EAOP2), DSPI_WRTTHRU);
	else
		rc = DosSetFileInfo(hFile, 2, (PVOID)&eaop, sizeof(EAOP2) );
	delete ptea;
	if(rc) return FALSE;
	return TRUE;
}

BOOL ImpEaMgr::SetVersionInfo( const String& rInfo )
{
	EAOP2	eaop;		// extended attributes structure
	USHORT	cb;			// structure length
	APIRET	rc;			// return from API
	USHORT *pusPtr;
	ImpMMEAEntry *pEntry;

	// allocate memory for the VERSION EA list
	// -1 because the structure itself defines 1 char;

	USHORT nLen = rInfo.Len();
	cb = nLen - 1 + sizeof (ImpVersionEAList);
	ImpVersionEAList *ptea = (ImpVersionEAList *)new char[cb];

	// initialize the EA structures
	// fill in the EA value itself: for .VERSION it's the version number
	memcpy(ptea->achValue, rInfo.GetStr(), nLen );

	// fill in length of the EA value
	ptea->cbValue = nLen;

	// fill type of EA value
	ptea->usType = EAT_ASCII;		 // length-preceded ASCII

	// length of EA (includes value + type and length fields)
	ptea->cbEA = ptea->cbValue + sizeof(ptea->usType) + sizeof (ptea->cbValue);

	// fill in the EA name (it's a null terminated string so strcpy is OK)
	strcpy(ptea->szName, pszVersion);

	// fill in EA name length
	ptea->cbName = (BYTE)strlen(pszVersion);

	// point to the VERSION EA list structure
	eaop.fpFEA2List = (PFEA2LIST)ptea;
	eaop.fpGEA2List = NULL;
	ptea->cbList = cb;				// structure length
	ptea->ulNextEa = 0;				// no more EAs
	ptea->bFlags = 0;				// noncritical

	// attach the .VERSION extended attribute to the file
	if( !hFile )
		rc = DosSetPathInfo( (PSZ)aFileName.GetStr(), 2,
				 (PVOID)&eaop, sizeof(EAOP2), DSPI_WRTTHRU);
	else
		rc = DosSetFileInfo(hFile, 2, (PVOID)&eaop, sizeof(EAOP2) );
	delete ptea;
	if(rc) return FALSE;
	return TRUE;
}

#define ICON_ICON	0
#define ICON_CICN	1
#define ICON_DIB	2
struct RSICON_TYPE {
	USHORT	nSystemIcon;
	USHORT	nIconTyp;
	USHORT	nIconId;
};

class EaBla : public Resource
{
	USHORT nId;
public:
	EaBla( const ResId& rResId );
	USHORT GetId() { return nId; }
};

EaBla::EaBla( const ResId& rResId ) : Resource( rResId.SetRT( RSC_ICON ) )
{
	RSICON_TYPE *pIT;

	// Resource wird geladen
	pIT = (RSICON_TYPE *)GetClassRes();
	DBG_ASSERT(pIT->nIconId!=RC_NO_ID,"No Icon");
	if( pIT->nIconId != RC_NO_ID )
		nId = pIT->nIconId;
	// Resourcezeiger hinter die eigenen Resourcedaten setzen
	IncrementRes( (USHORT)sizeof( RSICON_TYPE ) +
				  GetStringSizeRes( (char *)(pIT + 1) ) );
}


/*
BOOL ImpEaMgr::SetIcon( const ResId& rId )
{
	USHORT nId;
	EaBla aBla( rId );
	USHORT nOs2Id = aBla.GetId();
	ResMgr* pResMgr = rId.GetResMgr();
	if( !pResMgr )
		pResMgr = Resource::GetResManager();
	if( !pResMgr )
		return FALSE;

	Icon xxxxIcon( rId );

	HMODULE hMod = Sysdepen::GethModule( *pResMgr );

	ICONINFO aIconInfo;
	memset( &aIconInfo, 0, sizeof(ICONINFO) );
	aIconInfo.cb = sizeof( ICONINFO );
	aIconInfo.fFormat = ICON_RESOURCE;
	aIconInfo.hmod = hMod;
	aIconInfo.resid = (ULONG)nOs2Id;
	HWND hWin = WinCreateWindow( HWND_OBJECT, WC_FRAME,
			"", 0,0,0,0,0, HWND_DESKTOP, HWND_BOTTOM, 0,0,0);
	HAB hAB	= WinQueryAnchorBlock( hWin );
	ULONG nLastErr = WinGetLastError( hAB );
	BOOL bSuccess = WinSetFileIcon( (PSZ)aFileName.GetStr(), &aIconInfo );
	nLastErr = WinGetLastError( hAB );
	WinDestroyWindow( hWin );
	return bSuccess;
}
*/

BOOL ImpEaMgr::SetIcon( const ResId& rId )
{
	return FALSE;
}


BOOL ImpEaMgr::SetIcon( const String& rIconFileName )
{
	if( !hFile )
	{
		ICONINFO aIconInfo;
		memset( &aIconInfo, 0, sizeof(ICONINFO) );
		aIconInfo.cb = sizeof( ICONINFO );
		aIconInfo.fFormat = ICON_FILE;
		aIconInfo.pszFileName = (PSZ)rIconFileName.GetStr();
		BOOL bSuccess = WinSetFileIcon( (PSZ)aFileName.GetStr(), &aIconInfo );
		return bSuccess;
	}

	EAOP2	eaop;		// extended attributes structure
	USHORT	cb;			// structure length
	APIRET	rc;			// return from API
	USHORT *pusPtr;
	ImpMMEAEntry *pEntry;

	SvFileStream aFile( rIconFileName, STREAM_READ );
	if( aFile.GetError() )
		return FALSE;

	ULONG lLen;
	char* pRes;
	lLen = aFile.Seek( STREAM_SEEK_TO_END );
	aFile.Seek( 0 );
	pRes = new char[ lLen ];
	aFile.Read( pRes, lLen );
	aFile.Close();
	cb = lLen + sizeof (ImpIcoEAList);
	ImpIcoEAList *pIcotea = (ImpIcoEAList *)new char[cb];

  // fill in length of the EA value
	pIcotea->cbValue = lLen;
	memcpy(pIcotea->achValue, pRes, lLen);
  // fill type of EA value
	pIcotea->usType = EAT_ICON;
  // length of EA (includes value + type and length fields)
	pIcotea->cbEA = pIcotea->cbValue + sizeof(pIcotea->usType) + sizeof (pIcotea->cbValue);
  // fill in the EA name (it's a null terminated string so strcpy is OK)
	strcpy ( pIcotea->szName, pszIconId );
  // fill in EA name length
	pIcotea->cbName = (BYTE)strlen ( pszIconId );
  // point to the TYPE EA list structure
	eaop.fpFEA2List = (PFEA2LIST)pIcotea;
	eaop.fpGEA2List = NULL;
	pIcotea->cbList = cb;			   // structure length
	pIcotea->ulNextEa = 0;			   // no more EAs
	pIcotea->bFlags = 0;			   // noncritical
  // attach the .TYPE extended attribute to the file
	rc = DosSetFileInfo(hFile, 2, (PVOID)&eaop, sizeof(EAOP2) );
	delete pIcotea;
	delete pRes;
	return (BOOL)rc == 0;
}

BOOL ImpEaMgr::Clone( const SvEaMgr &rMgr )
{
	PVOID pBuf[ulBufSize];
	ULONG ulEntryIdx = 1;
	ULONG ulEnumCount = 1;
	APIRET rc = 0;
	ImpHoldFEA *pFea = 0;
	GEA2LIST *pGeaList = 0;
	EAOP2 eaop;

	ULONG ulRefType;
	PVOID pFileRef;

	DBG_ASSERT( hFile,
				"SvEaMgr::Clone() only implemented for SvFileStream-SvEaMgr" );

	for(;;)
	{
		rc = DosEnumAttribute( ENUMEA_REFTYPE_FHANDLE, (void *)&hFile,
								ulEntryIdx, pBuf, ulBufSize, &ulEnumCount,
								ENUMEA_LEVEL_NO_VALUE);
		if( ulEnumCount != 1 )
			break;
		if ( 0 == rc )
		{
			pFea = new ImpHoldFEA;
			pFea->cbName = ( (PFEA2)pBuf )->cbName;
			pFea->cbValue = ( (PFEA2)pBuf )->cbValue;
			pFea->fEA = ( (PFEA2)pBuf )->fEA;
			pFea->szName = new char[ pFea->cbName + 1 ];
			pFea->aValue = new char[ pFea->cbValue ];
			memcpy( pFea->szName, ( (PFEA2)pBuf )->szName, pFea->cbName + 1 );
			USHORT cbAlloc =
						sizeof(FEA2LIST) + pFea->cbName + 1 + pFea->cbValue;
			char* pAlloc = new char[cbAlloc];
			memset( pAlloc, 0, cbAlloc );
			pGeaList = (GEA2LIST*)pBuf;
			pGeaList->cbList = sizeof(GEA2LIST) + pFea->cbName;
			pGeaList->list[0].oNextEntryOffset = 0L;
			pGeaList->list[0].cbName = pFea->cbName;
			strcpy( pGeaList->list[0].szName, pFea->szName );
			eaop.fpGEA2List = (GEA2LIST*)pBuf;
			eaop.fpFEA2List = (FEA2LIST*)pAlloc;
			eaop.fpFEA2List->cbList = cbAlloc;

			rc = DosQueryFileInfo( hFile, FIL_QUERYEASFROMLIST,
								   (PVOID)&eaop, sizeof(EAOP2) );

			if ( 0 == rc )
				rc = DosSetFileInfo( rMgr.pImp->hFile, 2,
									 (PVOID)&eaop, sizeof(EAOP2) );

			delete pFea->szName;
			delete pFea->aValue;
			delete pFea;
			delete pAlloc;
		}
		++ulEntryIdx;
	}
	return !rc;
}


static BOOL DoMulti(char *pMulti, String &rStr)
{
	USHORT *pusPtr = (USHORT *)pMulti;
	char *p = 0;
	USHORT lCount;

	pusPtr += 2;
	lCount = *pusPtr;

	pusPtr = (USHORT *)pMulti;
	if(*pusPtr != EAT_MVMT) return FALSE;
	pMulti += 3*sizeof(USHORT);		// FeldId, Codepage, Anzahl skippen
	pusPtr = (USHORT *)pMulti;
	ImpMMEAEntry *pEntry = (ImpMMEAEntry *)pMulti;
	for(USHORT i = 0; i < lCount; ++i)
	{
		if(pEntry->usDataType != EAT_ASCII)
		{
			return FALSE;
		}
		p = new char[pEntry->cbValue + 1];
		memset(p, 0,pEntry->cbValue + 1);
		memcpy(p, pEntry->aValue, pEntry->cbValue);
		rStr += p;
		delete p;
		p = (char *)pEntry->aValue + pEntry->cbValue;
		if(i < lCount -1)
		{
			pEntry = (ImpMMEAEntry *)p;	// hinter das zuletzt gelesen Zeichen
			rStr += pLineBreak;
		}
	}
	return TRUE;
}

BOOL ImpEaMgr::GetEA( String &rResult, USHORT nType)
{
	rResult.Erase();
	PVOID pBuf[ulBufSize];
	EAOP2 eaopGet;
	ULONG ulEntryIdx 		= 1;
	ULONG ulEnumCount		= 1;
	APIRET rc				= 0;
	ImpHoldFEA *pFea		= 0;
	GEA2LIST *pGeaList		= 0;
	const char *pQueryType	= 0;

	switch( nType )
	{
		case SV_EA_COMMENT:
			pQueryType = pszComment;
			break;
		case SV_EA_LONGNAME:
			pQueryType = pszLongName;
			break;
		case SV_EA_FILETYPE:
			pQueryType  = pszTypeId;
			break;
		case SV_EA_VERSION:
			pQueryType  = pszVersion;
			break;
		default:
			return FALSE;
	}
	ULONG ulRefType;
	PVOID pFileRef;

	if( hFile )
	{
		ulRefType = ENUMEA_REFTYPE_FHANDLE;
		pFileRef = (PVOID)&hFile;
	}
	else
	{
		ulRefType = ENUMEA_REFTYPE_PATH;
		pFileRef = (PVOID)aFileName.GetStr();
	}

	for(;;)
	{
		rc = DosEnumAttribute( ulRefType, pFileRef,
				ulEntryIdx, pBuf, ulBufSize, &ulEnumCount,
				ENUMEA_LEVEL_NO_VALUE);

		if( rc || ulEnumCount != 1 )
			break;

		PFEA2 pTemp = (PFEA2)pBuf;  // zum Debuggen
		if(strcmp(pTemp->szName, pQueryType))
		{
			++ulEntryIdx;
			continue;
		}

		pFea = new ImpHoldFEA;
		pFea->cbName = pTemp->cbName;
		pFea->cbValue = pTemp->cbValue;
		pFea->fEA = pTemp->fEA;
		pFea->szName = new char[pFea->cbName + 1];
		pFea->aValue = new char[pFea->cbValue + 1];
		memcpy(pFea->szName, pTemp->szName, pFea->cbName + 1);

		// Speicher fuer EA-Value allozieren
		USHORT cbAlloc = sizeof(FEA2LIST) + pFea->cbName + 1 + pFea->cbValue;
		char *pAlloc = new char[cbAlloc];
		memset(pAlloc, 0, cbAlloc);
		FEA2LIST* pFea2List = (FEA2LIST*)pAlloc; // zum Debuggen

		pGeaList = (GEA2LIST *)pBuf;
		pGeaList->cbList = sizeof(GEA2LIST) + pFea->cbName; // +1 ??
		pGeaList->list[0].oNextEntryOffset = 0L;
		pGeaList->list[0].cbName = pFea->cbName;
		strcpy(pGeaList->list[0].szName, pFea->szName);

		eaopGet.fpGEA2List = pGeaList;     // die abzufragenden Attribute
		eaopGet.fpFEA2List = pFea2List;    // Ergebnisse
		eaopGet.fpFEA2List->cbList = cbAlloc;

		if( !hFile )
			DosQueryPathInfo((PSZ)aFileName.GetStr(), FIL_QUERYEASFROMLIST,
				(PVOID) &eaopGet, sizeof(EAOP2));
		else
			DosQueryFileInfo( hFile,FIL_QUERYEASFROMLIST,
				(PVOID) &eaopGet,sizeof(EAOP2));

		switch( nType )
		{
			case SV_EA_COMMENT:
				DoMulti(pAlloc + sizeof(FEA2LIST) + pFea->cbName, rResult);
				break;

			case SV_EA_LONGNAME:
				memcpy(pFea->aValue,
					pAlloc + sizeof(FEA2LIST) + pFea->cbName + sizeof(int),
						pFea->cbValue);
				rResult = pFea->aValue;
				break;

			case SV_EA_FILETYPE:
				// Type kann in zwei Formaten geschrieben werden:
				// EAT_MVMT Multi Value Multi Type: (von Schablonen)
				// 	Format: EAT_MVMT Codepage #Entries [DataType Data]
				//  	     0xffdf     2        2       EAT_ASCII
				// EAT_ASCII Length preceeded Ascii
				//  Format: EAT_ASCII Length Data
				//			 0xfffd     2
				char* pValue = pAlloc + sizeof(FEA2LIST) + pFea->cbName;
				USHORT nNumberEntries = 1;
				USHORT nType = *(USHORT*)pValue;
				if( nType == EAT_MVMT )
				{
					pValue += 2*sizeof(USHORT); // skip codepage & type
					nNumberEntries = *(USHORT*)pValue;
					pValue += sizeof(USHORT); // skip #entries
				}
				// pValue zeigt jetzt auf den ersten String
				if( nNumberEntries && *(USHORT*)pValue == EAT_ASCII )
				{
					pValue += sizeof(USHORT); // skip type
					USHORT nLen = *(USHORT*)pValue;
					if( nLen < pFea->cbValue )
						nLen = pFea->cbValue; // sollte nie eintreten, aber...
					pValue += sizeof(USHORT); // skip length
					memcpy(pFea->aValue, pValue, nLen );
					*(pFea->aValue + nLen) = (char)0;  // eos
					rResult = pFea->aValue;
				}
				break;
		}
		delete pFea->szName;
		delete pFea->aValue;
		delete pFea;
		delete pAlloc;
		return TRUE;
	}
	return FALSE;
}

// *********************************************************************
// *********************************************************************
// *********************************************************************

SvEaMgr::SvEaMgr( const DirEntry& rEntry )
{
	pImp = new ImpEaMgr( rEntry );
}

SvEaMgr::SvEaMgr( const String& rFilename )
{
	pImp = new ImpEaMgr( rFilename );
}

SvEaMgr::SvEaMgr( SvFileStream& rStream )
{
	pImp = new ImpEaMgr( rStream );
}

SvEaMgr::~SvEaMgr()
{
	delete pImp;
#ifdef DBG_UTIL
	pImp = 0;
#endif
}

BOOL SvEaMgr::GetIcon( Icon& rResult ) const
{
	return pImp->GetIcon( rResult );
}

BOOL SvEaMgr::SetIcon( const ResId& rId )
{
	return pImp->SetIcon( rId );
}

BOOL SvEaMgr::SetIcon( const String& rIconFileName )
{
	return pImp->SetIcon( rIconFileName );
}

BOOL SvEaMgr::GetLongName( String& rResult ) const
{
	return pImp->GetLongName( rResult );
}

BOOL SvEaMgr::SetLongName( const String& aString )
{
	return pImp->SetLongName( aString );
}

static struct FileTypePair
{
		const char * pszOld;
		const char * pszNew;
} aFileTypeMap[] =
{
	"StarMath 5.0",           "StarMath Document",
	"StarCalc 5.0",           "StarCalc Document",
	"StarDraw 5.0",           "StarDraw Document",
	"StarChart 5.0",          "StarChart Document",
	"StarWriter 5.0",         "StarWriter Document",
	"StarImpress 5.0",        "StarImpress Document",
	"StarWriter/Web 5.0",     "StarWriter HTML Document",
	"StarWriter/Global 5.0",  "StarWriter Global Document"
};

BOOL SvEaMgr::GetFileType( String& rResult ) const
{
	String aFileType;

	if(!pImp->GetFileType(aFileType))
		return FALSE;

	for(BYTE n = 0; n < 8; n++)
		if(aFileType.Compare(aFileTypeMap[n].pszNew) == COMPARE_EQUAL)
		{
			aFileType = aFileTypeMap[n].pszOld;
			break;
		}

	rResult = aFileType;
	return TRUE;
}

BOOL SvEaMgr::SetFileType( const String& aString )
{
	String aFileType = aString;

	for(BYTE n = 0; n < 8; n++)
		if(aString.Compare(aFileTypeMap[n].pszOld) == COMPARE_EQUAL)
		{
			aFileType = aFileTypeMap[n].pszNew;
			pImp->SetVersionInfo("5.1");
			break;
		}

	if(!pImp->SetFileType( aFileType ))
		return FALSE;

	return TRUE;
}

BOOL SvEaMgr::GetCreator( String& ) const
{
	return FALSE;
}

BOOL SvEaMgr::GetAppCreator( String& )
{
	return FALSE;
}

BOOL SvEaMgr::SetCreator( const String& )
{
	return FALSE;
}

BOOL SvEaMgr::GetComment( String& rResult ) const
{
	return pImp->GetComment( rResult );
}

BOOL SvEaMgr::SetComment( const String& aString )
{
	return pImp->SetComment( aString );
}

BOOL SvEaMgr::GetVersionInfo( String& rResult) const
{
	return pImp->GetVersionInfo( rResult );
}

BOOL SvEaMgr::SetVersionInfo( const String& aString )
{
	return pImp->SetVersionInfo( aString );
}

BOOL SvEaMgr::Clone( const SvEaMgr& rMgr )
{
	return pImp->Clone( rMgr );
}


