/*************************************************************************
 *
 *  $RCSfile: cmdparse.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fs $ $Date: 2001/02/02 13:23:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_CMDPARSE_HXX
#include "cmdparse.hxx"
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

namespace svt
{

DBG_NAME(CommandParser)

const String CommandParser::aEmptyString;

//------------------------------------------------------------------
void CommandParser::AddParameter(const String & rParameterString)
{
	DBG_CHKTHIS(CommandParser,NULL);

	aParameterStringList.Insert(new String(rParameterString),LIST_APPEND);
}

//------------------------------------------------------------------
void CommandParser::SetOption(const String & rOptionName, const String & rOptionString)
{
	DBG_CHKTHIS(CommandParser,NULL);

	// Suchen, ob schon da:
	for (UINT32 i = 0; i < aOptionNameList.Count(); i++) 
	{
		if (String((*aOptionNameList.GetObject(i))).ToUpperAscii() == String(rOptionName).ToUpperAscii()) 
		{
			// Gefunden - Wert ersetzen:
			String * pOldValue = aOptionStringList.GetObject(i);
			if (pOldValue) delete pOldValue;

			aOptionStringList.Replace(new String(rOptionString),i);
			DBG_ASSERT(aOptionNameList.Count() == aOptionStringList.Count(),"CommandParser: Listen sind ungleich lang");
			return;
		}
	}

	if (! bAnyOptionAllowed) {
		// Nicht leer - neue Keywords koennen nicht mehr hinzugefuegt werden!
		aInvalidOptions += rOptionName;
		aInvalidOptions += String::CreateFromAscii(" ");
	} else {
		// Noch nichts vorhanden - Keyword und Value hinzufuegen:
		aOptionNameList.Insert(new String(rOptionName),LIST_APPEND);
		aOptionStringList.Insert(new String(rOptionString),LIST_APPEND);
	}

	DBG_ASSERT(aOptionNameList.Count() == aOptionStringList.Count(),"CommandParser: Listen sind ungleich lang");
}

//------------------------------------------------------------------
BOOL CommandParser::Exists(const String & rOptionName) const
{
	for (UINT32 i = 0; i < aOptionNameList.Count(); i++)
		if (String((*aOptionNameList.GetObject(i))).ToUpperAscii() == String(rOptionName).ToUpperAscii())
			return TRUE;

	return FALSE;
}

//------------------------------------------------------------------
void CommandParser::Parse(const String & rString)
{
	DBG_CHKTHIS(CommandParser,NULL);

	aInvalidOptions = String();
	String aArgStr,aOptionName,aOptionString;
	String aTxt = aQuoteChar;
	aTxt += aQuoteChar;
	for(xub_StrLen i=0; i < rString.GetQuotedTokenCount(aTxt,aDelimiterChar);i++)
	{
		aArgStr = rString.GetQuotedToken(i,aTxt,aDelimiterChar);
		aOptionName = aArgStr.GetQuotedToken(0,aTxt,aAssignChar);
		aOptionString = aArgStr.GetQuotedToken(1,aTxt,aAssignChar);
		if(!aOptionString.Len())
			aOptionString = String::CreateFromAscii("-1");

		// Option/Wert setzen
		SetOption(aOptionName,aOptionString);
	}
}

//------------------------------------------------------------------
void CommandParser::Parse(int argc, char * * argv)
{
	String aString;

	for (int i = 0; i < argc; i++) 
	{
		aString.AppendAscii(argv[i]);
		aString += ' ';
	}

	Parse(aString);
}

//------------------------------------------------------------------
CommandParser::CommandParser(const String & rString,
							 const char aNewDelimiter,
							 const char aNewAssign,
							 const BOOL bNewOptionsOnly,
							 const char aNewQuoteChar) :
	aDelimiterChar(aNewDelimiter),
	aAssignChar(aNewAssign),
	bOptionsOnly(bNewOptionsOnly),
	bAnyOptionAllowed(TRUE),
	aQuoteChar(aNewQuoteChar)
{
	DBG_CTOR(CommandParser,NULL);

	Parse(rString);

	bAnyOptionAllowed = FALSE;
}

//------------------------------------------------------------------
CommandParser::CommandParser(const CommandParser & rCommandParser) :
	aDelimiterChar(rCommandParser.aDelimiterChar),
	aAssignChar(rCommandParser.aAssignChar),
	bOptionsOnly(rCommandParser.bOptionsOnly),
	bAnyOptionAllowed(TRUE),
	aQuoteChar(rCommandParser.aQuoteChar)
{
	DBG_CTOR(CommandParser,NULL);
	DBG_CHKOBJ(&rCommandParser,CommandParser,NULL);

	UINT32 i;
	for (i=0; i < rCommandParser.aParameterStringList.Count(); i++) {
		String * pString = rCommandParser.aParameterStringList.GetObject(i);
		aParameterStringList.Insert(new String(*pString),LIST_APPEND);
	}
	for (i=0; i < aOptionStringList.Count(); i++) {
		String * pString = rCommandParser.aOptionStringList.GetObject(i);
		aOptionStringList.Insert(new String(*pString),LIST_APPEND);
	}
	for (i=0; i < aOptionNameList.Count(); i++) {
		String * pString = rCommandParser.aOptionNameList.GetObject(i);
		aOptionNameList.Insert(new String(*pString),LIST_APPEND);
	}

	bAnyOptionAllowed = FALSE;
}

//------------------------------------------------------------------
const CommandParser & CommandParser::operator=(const CommandParser &rCommandParser)
{
	DBG_CHKTHIS(CommandParser,NULL);
	DBG_CHKOBJ(&rCommandParser,CommandParser,NULL);

	Clear();
	UINT32 i;
	for (i=0; i < rCommandParser.aParameterStringList.Count(); i++) {
		String * pString = rCommandParser.aParameterStringList.GetObject(i);
		aParameterStringList.Insert(new String(*pString),LIST_APPEND);
	}
	for (i=0; i < rCommandParser.aOptionStringList.Count(); i++) {
		String * pString = rCommandParser.aOptionStringList.GetObject(i);
		aOptionStringList.Insert(new String(*pString),LIST_APPEND);
	}
	for (i=0; i < rCommandParser.aOptionNameList.Count(); i++) {
		String * pString = rCommandParser.aOptionNameList.GetObject(i);
		aOptionNameList.Insert(new String(*pString),LIST_APPEND);
	}

	return *this;
}

//------------------------------------------------------------------
BOOL CommandParser::operator==(const CommandParser &rCommandParser) const
{
	DBG_CHKTHIS(CommandParser,NULL);
	DBG_CHKOBJ(&rCommandParser,CommandParser,NULL);

	UINT32 i;
	for (i=0; i < rCommandParser.aParameterStringList.Count(); i++) {
		String * pString = rCommandParser.aParameterStringList.GetObject(i);
		if (*aParameterStringList.GetObject(i) != *pString) return FALSE;
	}
	for (i=0; i < aOptionStringList.Count(); i++) {
		String * pString = rCommandParser.aOptionStringList.GetObject(i);
		if (*aOptionStringList.GetObject(i) != *pString) return FALSE;
	}
	for (i=0; i < aOptionNameList.Count(); i++) {
		String * pString = rCommandParser.aOptionNameList.GetObject(i);
		if (*aOptionNameList.GetObject(i) != *pString) return FALSE;
	}

	return TRUE;
}

//------------------------------------------------------------------
void CommandParser::Clear()
{
	DBG_CHKTHIS(CommandParser,NULL);

	UINT32 i;
	for (i=0; i < aParameterStringList.Count(); i++) {
		String * pString = aParameterStringList.GetObject(i);
		if (pString != NULL) delete pString;
	}
	aParameterStringList.Clear();
	for (i=0; i < aOptionStringList.Count(); i++) {
		String * pString = aOptionStringList.GetObject(i);
		if (pString != NULL) delete pString;
	}
	aOptionStringList.Clear();
	for (i=0; i < aOptionNameList.Count(); i++) {
		String * pString = aOptionNameList.GetObject(i);
		if (pString != NULL) delete pString;
	}
	aOptionNameList.Clear();

	bAnyOptionAllowed = TRUE;
}

//------------------------------------------------------------------
CommandParser::~CommandParser()
{
	DBG_DTOR(CommandParser,NULL);

	Clear();
}

//------------------------------------------------------------------
const String & CommandParser::OptionName(const UINT32 nOptionNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	if (nOptionNumber >= aOptionNameList.Count()) {
		return aEmptyString;
	} else {
		return * aOptionNameList.GetObject(nOptionNumber);
	}
}

//------------------------------------------------------------------
String CommandParser::OptionString(const String & rOptionName) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	for (UINT32 i = 0; i < aOptionNameList.Count(); i++)
	{
		if (String((*aOptionNameList.GetObject(i))).ToUpperAscii() == String(rOptionName).ToUpperAscii())
		{
			String aTxt(*aOptionStringList.GetObject(i));
			if(aTxt.GetChar(0) == aQuoteChar && aTxt.GetChar(aTxt.Len()-1) == aQuoteChar)
			{
				aTxt.Erase(0,1);
				aTxt.Erase(aTxt.Len()-1);
			}
			return aTxt;
		}
	}

	// Nicht gefunden.
	return aEmptyString;
}

//------------------------------------------------------------------
String CommandParser::OptionString(const UINT32 nOptionNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	if (nOptionNumber >= aOptionStringList.Count()) {
		return aEmptyString;
	} else {
		String aTxt(*aOptionStringList.GetObject(nOptionNumber));
		if(aTxt.GetChar(0) == aQuoteChar && aTxt.GetChar(aTxt.Len()-1) == aQuoteChar)
		{
			aTxt.Erase(0,1);
			aTxt.Erase(aTxt.Len()-1);
		}
		return aTxt;
	}
}

//------------------------------------------------------------------
const INT32 CommandParser::OptionInt(const String & rOptionName) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(OptionString(rOptionName));
	return aString.ToInt32();
}

//------------------------------------------------------------------
const INT32 CommandParser::OptionInt(const UINT32 nOptionNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(OptionString(nOptionNumber));
	return aString.ToInt32();
}

//------------------------------------------------------------------
const UINT32 CommandParser::OptionUInt(const String & rOptionName) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(OptionString(rOptionName));
	return aString.ToInt32();
}

//------------------------------------------------------------------
const UINT32 CommandParser::OptionUInt(const UINT32 nOptionNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(OptionString(nOptionNumber));
	return aString.ToInt32();
}

//------------------------------------------------------------------
const BOOL CommandParser::OptionBool(const String & rOptionName) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(OptionString(rOptionName));
	return ! (aString.Len() == 0 || aString.ToUpperAscii() == String::CreateFromAscii("FALSE") || aString == String::CreateFromAscii("0"));
}

//------------------------------------------------------------------
const BOOL CommandParser::OptionBool(const UINT32 nOptionNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(OptionString(nOptionNumber));
	return ! (aString.Len() == 0 || aString.ToUpperAscii() == String::CreateFromAscii("FALSE") || aString == String::CreateFromAscii("0"));
}

//------------------------------------------------------------------
const String & CommandParser::ParameterString(const UINT32 nParameterNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	if (nParameterNumber >= aParameterStringList.Count()) {
		return aEmptyString;
	} else {
		return * aParameterStringList.GetObject(nParameterNumber);
	}
}

//------------------------------------------------------------------
const BOOL CommandParser::ParameterBool(const UINT32 nParameterNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(ParameterString(nParameterNumber));
	return ! (aString.Len() == 0 || aString.ToUpperAscii() == String::CreateFromAscii("FALSE") || aString == String::CreateFromAscii("0"));
}

//------------------------------------------------------------------
const INT32 CommandParser::ParameterInt(const UINT32 nParameterNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(ParameterString(nParameterNumber));
	return aString.ToInt32();
}

//------------------------------------------------------------------
const UINT32 CommandParser::ParameterUInt(const UINT32 nParameterNumber) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	String aString(ParameterString(nParameterNumber));
	return aString.ToInt32();
}

//------------------------------------------------------------------
void CommandParser::Compose(String & rString, const String & rLeaveOutOptions) const
{
	DBG_CHKTHIS(CommandParser,NULL);

	UINT32 i;

	// Parameter:
	for (i=0; i<aParameterStringList.Count(); i++) {
		String * pString = aParameterStringList.GetObject(i);

		rString += *pString;
		rString += ' ';
	}

	// Optionen:
	DBG_ASSERT(aOptionNameList.Count() == aOptionStringList.Count(),"CommandParser: Listen sind ungleich lang");
	for (i=0; i<aOptionNameList.Count(); i++) {
		String * pName = aOptionNameList.GetObject(i);
		String * pString = aOptionStringList.GetObject(i);

		// Soll diese Option weggelassen werden?
		xub_StrLen j;
		for (j=0; j < rLeaveOutOptions.GetTokenCount(aDelimiterChar) &&
						 !rLeaveOutOptions.GetToken(j,aDelimiterChar).EqualsIgnoreCaseAscii(*pName); j++) /* nop */;

		// Wenn gefunden, dann diese Option weglassen.
		if (j < rLeaveOutOptions.GetTokenCount(aDelimiterChar)) continue;

		// Optionsname:
		rString += aDelimiterChar;
		rString += *pName;

		// Wert (falls vorhanden ... "-1" steht fuer nicht vorhanden):
		if (*pString != String::CreateFromAscii("-1")) {
			rString += aAssignChar;
			rString += *pString;
		}
	}

}

}	// namespace svt

