/*************************************************************************
 *
 *  $RCSfile: folderpicker.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: fs $ $Date: 2001/10/31 09:23:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "folderpicker.hxx"
#include "iodlg.hxx"

#include <list>
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#define _SVSTDARR_STRINGSDTOR
#include "svstdarr.hxx"

#ifndef  _COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XContentEnumerationAccess.hpp>
#endif
#ifndef  _COM_SUN_STAR_CONTAINER_XSET_HPP_
#include <com/sun/star/container/XSet.hpp>
#endif
#ifndef  _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef  _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
#include <miscopt.hxx>
#endif
#ifndef SVTOOLS_PICKERHISTORYACCESS_HXX
#include "pickerhistoryaccess.hxx"
#endif

// using ----------------------------------------------------------------

using namespace     ::com::sun::star::container;
using namespace     ::com::sun::star::lang;
using namespace     ::com::sun::star::ui::dialogs;
using namespace     ::com::sun::star::uno;
using namespace     ::rtl;

//------------------------------------------------------------------------------------
// SvtFolderPicker_Impl
//------------------------------------------------------------------------------------

class SvtFolderPicker_Impl
{
public:
	SvtFileDialog*	m_pDlg;
	SvtFolderPicker*	m_pOwner;

	UNOOUSTRING			m_aTitle;
	UNOOUSTRING			m_aDisplayDirectory;
	UNOOUSTRING			m_aDescription;

public:
						SvtFolderPicker_Impl( SvtFolderPicker* pOwner );
						~SvtFolderPicker_Impl();

	sal_Int16			execute();
	void				clearOwner() { m_pOwner = NULL; }
};

//-----------------------------------------------------------------------------
SvtFolderPicker_Impl::SvtFolderPicker_Impl( SvtFolderPicker* pOwner ) :
	m_pDlg				( NULL ),
	m_pOwner			( pOwner )
{
}

//------------------------------------------------------------------------------------
SvtFolderPicker_Impl::~SvtFolderPicker_Impl()
{
	delete m_pDlg;
}

//------------------------------------------------------------------------------------
sal_Int16 SvtFolderPicker_Impl::execute()
{
    ULONG	nBits = SFXWB_PATHDIALOG;

    delete m_pDlg;

	m_pDlg = new SvtFileDialog( nBits );

	// set the title
	if ( m_aTitle.getLength() > 0 )
		m_pDlg->SetText( m_aTitle );

	// set the default directory
	if ( m_aDisplayDirectory.getLength() > 0 )
		m_pDlg->SetPath( m_aDisplayDirectory );
	else
	{
		// Default-Standard-Dir setzen
		INetURLObject aStdDirObj( SvtPathOptions().GetWorkPath() );
		m_pDlg->SetPath( aStdDirObj.GetMainURL( INetURLObject::NO_DECODE ) );
	}

	// now we are ready to execute the dialog
	sal_Int16 nRet = m_pDlg->Execute();

	return nRet;
}

//------------------------------------------------------------------------------------
// class SvtFolderPicker
//------------------------------------------------------------------------------------

SvtFolderPicker::SvtFolderPicker( const UNOREFERENCE < ::com::sun::star::lang::XMultiServiceFactory >& xFactory )
{
	m_pImpl = new SvtFolderPicker_Impl( this ); 
}

SvtFolderPicker::~SvtFolderPicker()
{
	m_pImpl->clearOwner();

	delete m_pImpl;
}

//------------------------------------------------------------------------------------
// XExecutableDialog functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFolderPicker::setTitle( const UNOOUSTRING& aTitle ) throw( UNORUNTIMEEXCEPTION )
{
	m_pImpl->m_aTitle = aTitle;
}

//------------------------------------------------------------------------------------
sal_Int16 SAL_CALL SvtFolderPicker::execute() throw( UNORUNTIMEEXCEPTION )
{
	return m_pImpl->execute();
}

//------------------------------------------------------------------------------------
// XFolderPicker functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFolderPicker::setDisplayDirectory( const UNOOUSTRING& aDirectory )
    throw( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION )
{
	m_pImpl->m_aDisplayDirectory = aDirectory;
}

//------------------------------------------------------------------------------------
UNOOUSTRING SAL_CALL SvtFolderPicker::getDisplayDirectory() throw( UNORUNTIMEEXCEPTION )
{
	UNOOUSTRING aResult;

    if ( ! m_pImpl->m_pDlg )
		return m_pImpl->m_aDisplayDirectory;

	SvStringsDtor* pPathList = m_pImpl->m_pDlg->GetPathList();

	if ( pPathList->Count() )
		aResult = UNOOUSTRING( *pPathList->GetObject( 0 ) );

	delete pPathList;

    return aResult;
}

//------------------------------------------------------------------------------------
UNOOUSTRING SAL_CALL SvtFolderPicker::getDirectory() throw( UNORUNTIMEEXCEPTION )
{
	UNOOUSTRING aResult;

    if ( ! m_pImpl->m_pDlg )
		return m_pImpl->m_aDisplayDirectory;

	SvStringsDtor* pPathList = m_pImpl->m_pDlg->GetPathList();

	if ( pPathList->Count() )
		aResult = UNOOUSTRING( *pPathList->GetObject( 0 ) );

	delete pPathList;

    return aResult;
}

//------------------------------------------------------------------------------------
void SAL_CALL SvtFolderPicker::setDescription( const UNOOUSTRING& aDescription )
    throw( UNORUNTIMEEXCEPTION )
{
	m_pImpl->m_aDescription = aDescription;
}

// ------------------------------------------------------------------------
// misc. helpers
//------------------------------------------------------------------------------------
#define SYSTEM_FOLDER_OPEN_SERVICE_NAME "com.sun.star.ui.dialogs.SystemFolderPicker"

sal_Bool SvtFolderPicker::HasSystemFolderPicker( const Reference< XMultiServiceFactory > xFactory )
{
    sal_Bool bRet = sal_False;
	
	Reference< XContentEnumerationAccess > xEnumAccess( xFactory, UNO_QUERY );
    Reference< XSet > xSet( xFactory, UNO_QUERY );

    if ( ! xEnumAccess.is() || ! xSet.is() )
        return bRet;
    
    try
    {
    	OUString aFolderService( RTL_CONSTASCII_USTRINGPARAM( SYSTEM_FOLDER_OPEN_SERVICE_NAME ) );

        Reference< XEnumeration > xEnum = xEnumAccess->createContentEnumeration( aFolderService );
        if ( xEnum.is() && xEnum->hasMoreElements() )
            bRet = sal_True;
    }

    catch( IllegalArgumentException ) {}
    catch( ElementExistException ) {}

    return bRet;
}

//------------------------------------------------------------------------------------
sal_Bool SvtFolderPicker::UseSystemFolderPicker()
{
    SvtMiscOptions aOptions;

    sal_Bool bRet = aOptions.UseSystemFileDialog();

    return bRet;
}

//------------------------------------------------------------------------------------
// XServiceInfo
//------------------------------------------------------------------------------------

/* XServiceInfo */
UNOOUSTRING SAL_CALL SvtFolderPicker::getImplementationName() throw( UNORUNTIMEEXCEPTION )
{
	return impl_getStaticImplementationName();
}

/* XServiceInfo */
sal_Bool SAL_CALL SvtFolderPicker::supportsService( const UNOOUSTRING& sServiceName ) throw( UNORUNTIMEEXCEPTION )
{
    UNOSEQUENCE< UNOOUSTRING > seqServiceNames = getSupportedServiceNames();
    const UNOOUSTRING* pArray = seqServiceNames.getConstArray();
    for ( sal_Int32 i = 0; i < seqServiceNames.getLength(); i++ )
	{
        if ( sServiceName == pArray[i] )
		{
            return sal_True ;
		}
	}
    return sal_False ;
}

/* XServiceInfo */
UNOSEQUENCE< UNOOUSTRING > SAL_CALL SvtFolderPicker::getSupportedServiceNames() throw( UNORUNTIMEEXCEPTION )
{
	return impl_getStaticSupportedServiceNames();
}

/* Helper for XServiceInfo */
UNOSEQUENCE< UNOOUSTRING > SvtFolderPicker::impl_getStaticSupportedServiceNames()
{
	UNOMUTEXGUARD aGuard( UNOMUTEX::getGlobalMutex() );
    UNOSEQUENCE< UNOOUSTRING > seqServiceNames( 1 );
    UNOOUSTRING* pArray = seqServiceNames.getArray();
    pArray[0] = UNOOUSTRING::createFromAscii( "com.sun.star.ui.dialogs.FolderPicker" );
    return seqServiceNames ;
}
/* Helper for XServiceInfo */
UNOOUSTRING SvtFolderPicker::impl_getStaticImplementationName()
{
	return UNOOUSTRING::createFromAscii( "com.sun.star.svtools.FolderOpen" );
}

/* Helper for registry */
UNOREFERENCE< UNOXINTERFACE > SAL_CALL SvtFolderPicker::impl_createInstance( const UNOREFERENCE< UNOXMULTISERVICEFACTORY >& xServiceManager )
    throw( UNOEXCEPTION )
{
    static sal_Bool bCheckedSystemFolderPicker = sal_False;
    static sal_Bool bHasSystemFolderPicker = sal_True;

    Reference< UNOXINTERFACE > xRet;
    
    if ( ! bCheckedSystemFolderPicker )
        bHasSystemFolderPicker = HasSystemFolderPicker( xServiceManager );

    if ( bHasSystemFolderPicker && UseSystemFolderPicker() )
    {
    	OUString aFolderService( RTL_CONSTASCII_USTRINGPARAM( SYSTEM_FOLDER_OPEN_SERVICE_NAME ) );
        xRet = xServiceManager->createInstance( aFolderService );
    }

    if ( !xRet.is() )
        xRet = Reference< UNOXINTERFACE >( *new SvtFolderPicker( xServiceManager ) );

	::svt::addFolderPicker( xRet );

    return xRet;
}

