/*************************************************************************
 *
 *  $RCSfile: iodlg.hxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: fs $ $Date: 2001/12/07 15:42:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _IODLGIMPL_HXX
#define _IODLGIMPL_HXX

#ifndef  _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _VCL_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_COMBOBOX_HXX
#include <vcl/combobox.hxx>
#endif
#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _INETTYPE_HXX
#include "inettype.hxx"
#endif
#ifndef _COM_SUN_STAR_BEANS_STRINGPAIR_HPP_
#include <com/sun/star/beans/StringPair.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _SVTOOLS_SVTUNO_HXX
#include "svtuno.hxx"
#endif

//*****************************************************************************

#undef FILTER_MRU_LIST
	// define this if we want to have MRU lists for the filters, again
	// did not want to remove all the stuff here ... for this, the decisions
	// in the PM (regarding our file dialog) were way too valotile in the past :)

//*****************************************************************************

class SvTabListBox;
class SvStringsDtor;
class SvtFileView;
struct ControlChain_Impl;
class SvtFileDialogFilter_Impl;

//*****************************************************************************

#define SFXWB_INSERT			( 0x04000000L | WB_OPEN )
#define SFXWB_PASSWORD			WB_PASSWORD
#define SFXWB_READONLY			WB_READONLY
#define SFXWB_PATHDIALOG		WB_PATH
#define SFXWB_CLASSPATH			( 0x08000000L | SFXWB_PATHDIALOG )
#define SFXWB_SHOWALLFOLDER		0x10000000L		// alle Ordner auch Mail/News/...
#define SFXWB_MULTISELECTION	0x20000000L		// Multiselection an
#define SFXWB_NOREMOTE          0x40000000L
#define SFXWB_SHOWVERSIONS		0x80000000L  	// Versionsauswahl anzeigen

#define SFX_EXTRA_AUTOEXTENSION     0x00000001L
#define SFX_EXTRA_FILTEROPTIONS     0x00000002L
#define SFX_EXTRA_SHOWVERSIONS      0x00000004L
#define SFX_EXTRA_INSERTASLINK      0x00000008L
#define SFX_EXTRA_SHOWPREVIEW       0x00000010L
#define SFX_EXTRA_TEMPLATES         0x00000020L
#define SFX_EXTRA_PLAYBUTTON        0x00000040L
#define SFX_EXTRA_SELECTION         0x00000080L
#define SFX_EXTRA_IMAGE_TEMPLATE    0x00000100L

#define RET_MANAGER				100

#define FILEDIALOG_FILTER_ALL	"*.*"


//*****************************************************************************
// SvtFileDialog
//*****************************************************************************

class FileNotifyHelper_Impl;
class SvtExpFileDlg_Impl;

class SvtFileDialog : public ModalDialog
{
private:
    // originally from VclFileDialog
	ControlChain_Impl*			_pUserControls;

	CheckBox*					_pCbReadOnly;
	CheckBox*                   _pCbLinkBox;
	CheckBox*                   _pCbPreviewBox;
	CheckBox*                   _pCbSelection;
    PushButton*                 _pPbPlay;
	Window*                     _pPrevWin;
	FixedBitmap*                _pPrevBmp;
	SvtFileView*				_pFileView;
	FileNotifyHelper_Impl*		_pFileNotifier;
	SvtExpFileDlg_Impl*			_pImp;
    ULONG                       _nExtraBits;
    BOOL                        _bIsInExecute   :	1;
    BOOL                        _bIgnoreSelect		:1;


	DECL_STATIC_LINK( SvtFileDialog, FilterSelectHdl_Impl, ListBox* );
	DECL_STATIC_LINK( SvtFileDialog, NewFolderHdl_Impl, PushButton* );
	DECL_STATIC_LINK( SvtFileDialog, ViewHdl_Impl, ImageButton* );
	DECL_STATIC_LINK( SvtFileDialog, OpenHdl_Impl, void* );
	DECL_STATIC_LINK( SvtFileDialog, FileNameGetFocusHdl_Impl, void* );
	DECL_STATIC_LINK( SvtFileDialog, FileNameModifiedHdl_Impl, void* );

	void						Init_Impl( ULONG nBits );
	/** find a filter with the given wildcard
	@param _rFilter
		the wildcard pattern to look for in the filter list
	@param _bMultiExt
		allow for filters with more than one extension pattern
	@param _rFilterChanged
		set to <TRUE/> if the filter changed
	@return
		the filter which has been found
	*/
	SvtFileDialogFilter_Impl*	FindFilter_Impl( const String& _rFilter,
												 sal_Bool _bMultiExt,
												 sal_Bool& _rFilterChanged
												 );
	void						ExecuteFilter();
	void						UpdateHistory_Impl();
	void						OpenMultiSelection_Impl();
	void						UpdateHistory();
	void						UpdateControls( const String& rURL );
    void                        AddControls_Impl( );

    void                        SetListboxValue( ListBox* pListbox,
                                                 sal_Int16 nCtrlAction,
                                                 const ::com::sun::star::uno::Any& rValue );
    ::com::sun::star::uno::Any  GetListboxValue( ListBox* pListbox,
                                                 sal_Int16 nCtrlAction ) const;

	DECL_LINK( SelectHdl_Impl, SvTabListBox* );
	DECL_LINK( DblClickHdl_Impl, SvTabListBox* );
	DECL_LINK( EntrySelectHdl_Impl, ComboBox* );
	DECL_LINK( OpenDoneHdl_Impl, SvtFileView* );
	DECL_LINK( LocalFileSystemHdl_Impl, PushButton* );
	DECL_LINK( AutoExtensionHdl_Impl, CheckBox* );
	DECL_LINK( ClickHdl_Impl, CheckBox* );
	DECL_LINK( PlayButtonHdl_Impl, PushButton* );

	// entfernt einen Filter mit Wildcards aus dem Path und gibt in zurck
	BOOL IsolateFilterFromPath_Impl( String& rPath, String& rFilter );

	void implArrangeControls();

protected:
	virtual long				Notify( NotifyEvent& rNEvt );
	void						EnableInternet( BOOL bInternet );

    // originally from VclFileDialog
	Link						_aOKHdl;
	Link						_aFileSelectHdl;
	Link						_aFilterSelectHdl;

	String						_aPath;
	String						_aDefExt;

	void						ReleaseOwnerShip( Window* pUserControl );

	Control*					implGetControl( sal_Int16 _nControlId, sal_Bool _bLabelControl ) const;

public:
								SvtFileDialog( ULONG nBits,
									                ULONG nExtraBits );
								SvtFileDialog( ULONG nBits );
								~SvtFileDialog();

	virtual long				OK();
	virtual short				Execute();

			void				FileSelect();
			void				FilterSelect();

	void						SetStandardDir( const String& rStdDir );
	const String&				GetStandardDir() const;
	const String&				GetViewURL() const;
	SvStringsDtor*				GetPathList() const;		// bei MultiSelektion

			void				AddFilter( const String& rFilter,
										   const String& rType );

			void				AddFilterGroup( const String& _rFilter, const UNOSEQUENCE< UNOSTRINGPAIR >& rFilters );

			void				SetCurFilter( const String& rFilter );
			String				GetCurFilter() const;
			USHORT				GetFilterCount() const;
			const String&		GetFilterName( USHORT nPos ) const;
			const String&		GetFilterType( USHORT nPos ) const;

	virtual	void				Resize();

	void						PrevLevel_Impl();
	void						OpenURL_Impl( const String& rURL );

	inline SvtFileView*			GetView() const;

	void						SetDefaultButtonText( const XubString& rText, ULONG nHelpId = 0 );
	void						DisableSaveLastDirectory();
	void                        InitSize();

	void						SetPathURL( const XubString& rPathURL );

	Image*						GetFolderImage() const;

	void						SetFileCallback( FileNotifyHelper_Impl *pNotifier ) { _pFileNotifier = pNotifier; }

    void						SetValue( sal_Int16 nId, sal_Int16 nCtrlAction, const ::com::sun::star::uno::Any &rValue );
	::com::sun::star::uno::Any  GetValue( sal_Int16 nId, sal_Int16 nCtrlAction ) const;

    void						SetLabel( sal_Int16 nId, const ::rtl::OUString &rValue );
    ::rtl::OUString             GetLabel( sal_Int16 nId ) const;

    void                        EnableControl( sal_Int16 nId, sal_Bool bEnable );

    sal_Int32                   getTargetColorDepth();
    sal_Int32                   getAvailableWidth();
    sal_Int32                   getAvailableHeight();
    void                        setImage( sal_Int16 aImageFormat, const ::com::sun::star::uno::Any& rImage );
    sal_Bool                    setShowState( sal_Bool bShowState );
    sal_Bool                    getShowState();

    // originally from VclFileDialog
	virtual BOOL				AddControl( Window* pControl, BOOL bNewLine = FALSE );

	// inline
	inline void					SetPath( const String& rNewURL );
	inline const String&		GetPath() const;
	inline void					SetDefaultExt( const String& rExt );
	inline void					EraseDefaultExt( xub_StrLen _nIndex = 0 );
	inline const String&		GetDefaultExt() const;
	inline void					SetOKHdl( const Link& rLink );
	inline const Link&			GetOKHdl() const;
	inline void					SetFileSelectHdl( const Link& rLink );
	inline const Link&			GetFileSelectHdl() const;
	inline void					SetFilterSelectHdl( const Link& rLink );
	inline const Link&			GetFilterSelectHdl() const;

private:
	SvtFileDialogFilter_Impl*	implAddFilter( const String& _rFilter, const String& _rType );

	/** updates _pUserFilter with a new filter
		<p>No checks for necessity are made.</p>
		@param _bAllowUserDefExt
			set to <TRUE/> if a filter like "*.txt" should reset the DefaultExtension to doc.
			<p>
			In a file-save-dialog this would have the following effect:<br/>
			Say that auto-extension is checked, and the user enters *.txt, while a non-txt filter is selected.<br/>
			If _bAllowUserDefExt is set to <TRUE/>, then a user input of "foo" would save a foo.txt, but in a format
			which is determined by the filter selected (which is no txt file as said above).<br/>
			If _bAllowUserDefExt is set to <FALSE/>, the default extension will be the one of the selected filter, means
			in the above scenario a file "foo.<ext>" will be saved where ext is the extension of the selected filter.
			</p>
		@return <TRUE/> if the new filter is "*.*"
	*/
	sal_Bool					createNewUserFilter( const String& _rNewFilter, sal_Bool _bAllowUserDefExt );

	sal_uInt16					adjustFilter( const String& _rFilter );
};

//***************************************************************************

inline void SvtFileDialog::SetPath( const String& rNewURL )
{
	_aPath = rNewURL;
}

//***************************************************************************

inline const String& SvtFileDialog::GetPath() const
{
	return _aPath;
}

//***************************************************************************

inline void SvtFileDialog::SetDefaultExt( const String& rExt )
{
	_aDefExt = rExt;
}

inline void SvtFileDialog::EraseDefaultExt( xub_StrLen _nIndex )
{
	_aDefExt.Erase( _nIndex );
}

inline const String& SvtFileDialog::GetDefaultExt() const
{
	return _aDefExt;
}

//*****************************************************************************

inline void SvtFileDialog::SetOKHdl
(
	const Link& rLink
)
{
	_aOKHdl = rLink;
}

//*****************************************************************************

inline const Link& SvtFileDialog::GetOKHdl() const
{
	return _aOKHdl;
}

//*****************************************************************************

inline void SvtFileDialog::SetFileSelectHdl
(
	const Link& rLink
)
{
	_aFileSelectHdl = rLink;
}

//*****************************************************************************

inline const Link& SvtFileDialog::GetFileSelectHdl() const
{
	return _aFileSelectHdl;
}

//*****************************************************************************

inline void SvtFileDialog::SetFilterSelectHdl
(
	const Link& rLink
)
{
	_aFilterSelectHdl = rLink;
}

//*****************************************************************************

inline const Link& SvtFileDialog::GetFilterSelectHdl() const
{
	return _aFilterSelectHdl;
}

//*****************************************************************************

inline SvtFileView* SvtFileDialog::GetView() const
{
	return _pFileView;
}

//*****************************************************************************
//*****************************************************************************
//*****************************************************************************

class SvtFilePicker_Impl;

#define FILE_SELECTION_CHANGED	1
#define DIRECTORY_CHANGED		2
#define HELP_REQUESTED			3
#define CTRL_STATE_CHANGED		4
#define DIALOG_SIZE_CHANGED		5

class FileNotifyHelper_Impl
{
	SvtFilePicker_Impl* 	mpParent;

public:
				FileNotifyHelper_Impl( SvtFilePicker_Impl* pParent ) : mpParent( pParent ) {}
				~FileNotifyHelper_Impl() {};

	void		Notify( short nEventId, short nControlId );
};

//-------------------------------------------------------------------------
namespace svtools {

//-------------------------------------------------------------------------
// QueryFolderNameDialog
//-------------------------------------------------------------------------

class QueryFolderNameDialog : public ModalDialog
{
private:
	FixedText		aNameText;
	Edit			aNameEdit;
	FixedLine		aNameLine;
	OKButton		aOKBtn;
	CancelButton	aCancelBtn;

	DECL_LINK( OKHdl, Button * );
	DECL_LINK( NameHdl, Edit * );

public:
					QueryFolderNameDialog(	const String& rTitle,
											const String& rDefaultText,
											String* pGroupName = NULL );
	String			GetName() const { return aNameEdit.GetText(); }
};

}

#endif // #ifndef _IODLG_HXX
