/*************************************************************************
 *
 *  $RCSfile: lingucfg.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: pb $ $Date: 2001/07/11 04:40:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
#include <com/sun/star/lang/Locale.hpp>
#endif

#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SVTOOLS_LINGUCFG_HXX_
#include <lingucfg.hxx>
#endif
#ifndef _SVTOOLS_LINGUPROPS_HXX_
#include <linguprops.hxx>
#endif

using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;

#define A2OU(x)        ::rtl::OUString::createFromAscii( x )

///////////////////////////////////////////////////////////////////////////


static Locale lcl_CreateLocale( LanguageType eLang )
{
	String aLangStr, aCtryStr;
	if ( eLang != LANGUAGE_NONE )
		ConvertLanguageToIsoNames( eLang, aLangStr, aCtryStr );

	return Locale( aLangStr, aCtryStr, OUString() );
}


static INT16 lcl_LocaleToLanguage( const Locale& rLocale )
{
	//	empty Locale -> LANGUAGE_NONE
	if ( rLocale.Language.getLength() == 0 )
		return LANGUAGE_NONE;

	//	Variant of Locale is ignored
	return ConvertIsoNamesToLanguage( rLocale.Language, rLocale.Country );
}


static BOOL lcl_SetLocale( INT16 &rLanguage, const Any &rVal )
{
	BOOL bSucc = FALSE;

	Locale	aNew;
	if (rVal >>= aNew)	// conversion successful?
	{
		INT16 nNew = lcl_LocaleToLanguage( aNew );
		if (nNew != rLanguage)
		{
			rLanguage = nNew;
			bSucc = TRUE;
		}
	}

	return bSucc;
}


static inline INT16 lcl_CfgLocaleStrToLanguage( const OUString &rCfgLocaleStr )
{
	return ConvertIsoStringToLanguage( rCfgLocaleStr );
}


static inline const OUString lcl_LanguageToCfgLocaleStr( INT16 nLanguage )
{
	return ConvertLanguageToIsoString( nLanguage );
}


static INT16 lcl_CfgAnyToLanguage( const Any &rVal )
{
	INT16 nRes = LANGUAGE_NONE;
	OUString aTmp;
	if (rVal >>= aTmp)
		nRes = ConvertIsoStringToLanguage( aTmp );
	return nRes;
}


//////////////////////////////////////////////////////////////////////

SvtLinguOptions::SvtLinguOptions()
{
	// get initial language to use (in case that it is not set later)
	nDefaultLanguage = Application::GetSettings().GetLanguage();

	nDefaultLanguage_CJK = LANGUAGE_NONE;
	nDefaultLanguage_CTL = LANGUAGE_NONE;

	// general options
	bIsGermanPreReform		= FALSE;
	bIsUseDictionaryList	=
	bIsIgnoreControlCharacters	= TRUE;

	// spelling options
	bIsSpellCapitalization	=
	bIsSpellSpecial			= TRUE;
	bIsSpellAuto			=
	bIsSpellInAllLanguages	=
	bIsSpellHideMarkings	=
	bIsSpellReverse			=
	bIsSpellWithDigits		=
	bIsSpellUpperCase		= FALSE;

	// hyphenation options
	bIsHyphSpecial			= TRUE;
	bIsHyphAuto				= FALSE;
	nHyphMinLeading			=
	nHyphMinTrailing		= 2;
	nHyphMinWordLength		= 0;
}


//////////////////////////////////////////////////////////////////////

#define NUM_PROPS   20

Sequence< OUString > SvtLinguConfigItem::GetPropertyNames()
{
    static const char * aPropNames[NUM_PROPS + 1] =
	{
		"General/DefaultLocale",						//  0
		"General/DictionaryList/ActiveDictionaries",	//  1
		"General/DictionaryList/IsUseDictionaryList",	//  2
		"General/IsIgnoreControlCharacters",			//  3
		"General/IsGermanPreReform",                    //  4
		"General/DefaultLocale_CJK",					//  5
		"General/DefaultLocale_CTL",					//  6

		"SpellChecking/IsSpellUpperCase",				//  7
		"SpellChecking/IsSpellWithDigits",				//  8
		"SpellChecking/IsSpellCapitalization",			//  9
		"SpellChecking/IsSpellAuto",					// 10
		"SpellChecking/IsSpellSpecial",					// 11
		"SpellChecking/IsSpellInAllLocales",			// 12
		"SpellChecking/IsHideMarkings",					// 13
		"SpellChecking/IsReverseDirection",				// 14

		"Hyphenation/MinLeading",                       // 15
		"Hyphenation/MinTrailing",                      // 16
		"Hyphenation/MinWordLength",                    // 17
		"Hyphenation/IsHyphSpecial",                    // 18
		"Hyphenation/IsHyphAuto",	                    // 19
		0
	};

	const char** ppPropName = aPropNames;

    Sequence< OUString > aNames( NUM_PROPS );
	OUString *pNames = aNames.getArray();
	for( INT32 i = 0; *ppPropName;  ++i, ++ppPropName )
	{
		pNames[i] = A2OU( *ppPropName );
	}
	//aNames.realloc( i );
	return aNames;
}


//////////////////////////////////////////////////////////////////////

static struct NamesToHdl
{
	char   *pPropName;
	INT32	nHdl;
} aNamesToHdl[] =
{
	UPN_IS_GERMAN_PRE_REFORM,			UPH_IS_GERMAN_PRE_REFORM,
	UPN_IS_USE_DICTIONARY_LIST,         UPH_IS_USE_DICTIONARY_LIST,
	UPN_IS_IGNORE_CONTROL_CHARACTERS,   UPH_IS_IGNORE_CONTROL_CHARACTERS,
	UPN_IS_SPELL_UPPER_CASE,            UPH_IS_SPELL_UPPER_CASE,
	UPN_IS_SPELL_WITH_DIGITS,           UPH_IS_SPELL_WITH_DIGITS,
	UPN_IS_SPELL_CAPITALIZATION,        UPH_IS_SPELL_CAPITALIZATION,
	UPN_HYPH_MIN_LEADING,               UPH_HYPH_MIN_LEADING,
	UPN_HYPH_MIN_TRAILING,              UPH_HYPH_MIN_TRAILING,
	UPN_HYPH_MIN_WORD_LENGTH,           UPH_HYPH_MIN_WORD_LENGTH,
	UPN_DEFAULT_LANGUAGE,               UPH_DEFAULT_LANGUAGE,
	UPN_DEFAULT_LOCALE,                 UPH_DEFAULT_LOCALE,
	UPN_DEFAULT_LOCALE_CJK,             UPH_DEFAULT_LOCALE_CJK,
	UPN_DEFAULT_LOCALE_CTL,             UPH_DEFAULT_LOCALE_CTL,
	UPN_IS_HYPH_AUTO,                   UPH_IS_HYPH_AUTO,
	UPN_IS_HYPH_SPECIAL,                UPH_IS_HYPH_SPECIAL,
	UPN_IS_SPELL_AUTO,                  UPH_IS_SPELL_AUTO,
	UPN_IS_SPELL_HIDE,                  UPH_IS_SPELL_HIDE,
	UPN_IS_SPELL_IN_ALL_LANGUAGES,      UPH_IS_SPELL_IN_ALL_LANGUAGES,
	UPN_IS_SPELL_SPECIAL,               UPH_IS_SPELL_SPECIAL,
	UPN_IS_WRAP_REVERSE,                UPH_IS_WRAP_REVERSE,
	UPN_ACTIVE_DICTIONARIES,			UPH_ACTIVE_DICTIONARIES,
	NULL,									-1
};


SvtLinguConfig::SvtLinguConfig()
{
	LoadConfig();
	bIsModified	= FALSE;

    aSaveTimer.SetTimeout( 500 );
	aSaveTimer.SetTimeoutHdl( LINK( this, SvtLinguConfig, TimeOut ) );
}


SvtLinguConfig::~SvtLinguConfig()
{
	SaveConfig();
}


void SvtLinguConfig::SetModified( BOOL bVal )
{
	if ((bIsModified = bVal))
		aSaveTimer.Start();
}


BOOL SvtLinguConfig::GetHdlByName( INT32 &rnHdl, const OUString &rPropertyName )
{
	NamesToHdl *pEntry = &aNamesToHdl[0];
	while (pEntry && pEntry->pPropName != NULL)
	{
		if (0 == rPropertyName.compareToAscii( pEntry->pPropName ))
		{
			rnHdl = pEntry->nHdl;
			break;
		}
		++pEntry;
	}
	return pEntry && pEntry->pPropName != NULL;
}


Any	SvtLinguConfig::GetProperty( const OUString &rPropertyName ) const
{
	INT32 nHdl;
	return GetHdlByName( nHdl, rPropertyName ) ? GetProperty( nHdl ) : Any();
}


Any	SvtLinguConfig::GetProperty( INT32 nPropertyHandle ) const
{
	Any aRes;

	const INT16 *pnVal = 0;
	const BOOL  *pbVal = 0;

	const SvtLinguOptions &rOpt = ((const SvtLinguConfig *) this)->aOpt;
	switch (nPropertyHandle)
	{
		case UPH_IS_GERMAN_PRE_REFORM :		pbVal = &rOpt.bIsGermanPreReform;	break;
		case UPH_IS_USE_DICTIONARY_LIST :	pbVal = &rOpt.bIsUseDictionaryList;	break;
		case UPH_IS_IGNORE_CONTROL_CHARACTERS :	pbVal = &rOpt.bIsIgnoreControlCharacters;	break;
		case UPH_IS_HYPH_AUTO : 			pbVal = &rOpt.bIsHyphAuto;	break;
		case UPH_IS_HYPH_SPECIAL : 			pbVal = &rOpt.bIsHyphSpecial;	break;
		case UPH_IS_SPELL_AUTO : 			pbVal = &rOpt.bIsSpellAuto;	break;
		case UPH_IS_SPELL_HIDE : 			pbVal = &rOpt.bIsSpellHideMarkings;	break;
		case UPH_IS_SPELL_IN_ALL_LANGUAGES :pbVal = &rOpt.bIsSpellInAllLanguages;	break;
		case UPH_IS_SPELL_SPECIAL : 		pbVal = &rOpt.bIsSpellSpecial;	break;
		case UPH_IS_WRAP_REVERSE : 			pbVal = &rOpt.bIsSpellReverse;	break;
		case UPH_DEFAULT_LANGUAGE :			pnVal = &rOpt.nDefaultLanguage;	break;
		case UPH_IS_SPELL_CAPITALIZATION :	pbVal = &rOpt.bIsSpellCapitalization;		break;
		case UPH_IS_SPELL_WITH_DIGITS :		pbVal = &rOpt.bIsSpellWithDigits;	break;
		case UPH_IS_SPELL_UPPER_CASE :		pbVal = &rOpt.bIsSpellUpperCase;		break;
		case UPH_HYPH_MIN_LEADING :			pnVal = &rOpt.nHyphMinLeading;		break;
		case UPH_HYPH_MIN_TRAILING :		pnVal = &rOpt.nHyphMinTrailing;	break;
		case UPH_HYPH_MIN_WORD_LENGTH :		pnVal = &rOpt.nHyphMinWordLength;	break;
		case UPH_ACTIVE_DICTIONARIES :
		{
			aRes <<= rOpt.aActiveDics;
			break;
		}
		case UPH_DEFAULT_LOCALE :
		{
			Locale aLocale( lcl_CreateLocale( rOpt.nDefaultLanguage ) );
			aRes.setValue( &aLocale, ::getCppuType((Locale*)0 ));
			break;
		}
		case UPH_DEFAULT_LOCALE_CJK :
		{
			Locale aLocale( lcl_CreateLocale( rOpt.nDefaultLanguage_CJK ) );
			aRes.setValue( &aLocale, ::getCppuType((Locale*)0 ));
			break;
		}
		case UPH_DEFAULT_LOCALE_CTL :
		{
			Locale aLocale( lcl_CreateLocale( rOpt.nDefaultLanguage_CTL ) );
			aRes.setValue( &aLocale, ::getCppuType((Locale*)0 ));
			break;
		}
		default :
			DBG_ERROR( "unexpected property handle" );
	}

	if (pbVal)
		aRes <<= *pbVal;
	if (pnVal)
		aRes <<= *pnVal;

	return aRes;
}


BOOL SvtLinguConfig::SetProperty( const OUString &rPropertyName, const Any &rValue )
{
	BOOL bSucc = FALSE;
	INT32 nHdl;
	if (GetHdlByName( nHdl, rPropertyName ))
		bSucc = SetProperty( nHdl, rValue );
	return bSucc;
}


BOOL SvtLinguConfig::SetProperty( INT32 nPropertyHandle, const Any &rValue )
{
	BOOL bSucc = FALSE;
	if (!rValue.hasValue())
		return bSucc;

	BOOL bMod = FALSE;

	INT16 *pnVal = 0;
	BOOL  *pbVal = 0;

	switch (nPropertyHandle)
	{
		case UPH_IS_GERMAN_PRE_REFORM :		pbVal = &aOpt.bIsGermanPreReform;	break;
		case UPH_IS_USE_DICTIONARY_LIST :	pbVal = &aOpt.bIsUseDictionaryList;	break;
		case UPH_IS_IGNORE_CONTROL_CHARACTERS :	pbVal = &aOpt.bIsIgnoreControlCharacters;	break;
		case UPH_IS_HYPH_AUTO : 			pbVal = &aOpt.bIsHyphAuto;	break;
		case UPH_IS_HYPH_SPECIAL : 			pbVal = &aOpt.bIsHyphSpecial;	break;
		case UPH_IS_SPELL_AUTO : 			pbVal = &aOpt.bIsSpellAuto;	break;
		case UPH_IS_SPELL_HIDE : 			pbVal = &aOpt.bIsSpellHideMarkings;	break;
		case UPH_IS_SPELL_IN_ALL_LANGUAGES :pbVal = &aOpt.bIsSpellInAllLanguages;	break;
		case UPH_IS_SPELL_SPECIAL : 		pbVal = &aOpt.bIsSpellSpecial;	break;
		case UPH_IS_WRAP_REVERSE : 			pbVal = &aOpt.bIsSpellReverse;	break;
		case UPH_DEFAULT_LANGUAGE :			pnVal = &aOpt.nDefaultLanguage;	break;
		case UPH_IS_SPELL_CAPITALIZATION :	pbVal = &aOpt.bIsSpellCapitalization;		break;
		case UPH_IS_SPELL_WITH_DIGITS :		pbVal = &aOpt.bIsSpellWithDigits;	break;
		case UPH_IS_SPELL_UPPER_CASE :		pbVal = &aOpt.bIsSpellUpperCase;		break;
		case UPH_HYPH_MIN_LEADING :			pnVal = &aOpt.nHyphMinLeading;		break;
		case UPH_HYPH_MIN_TRAILING :		pnVal = &aOpt.nHyphMinTrailing;	break;
		case UPH_HYPH_MIN_WORD_LENGTH :		pnVal = &aOpt.nHyphMinWordLength;	break;
		case UPH_ACTIVE_DICTIONARIES :
		{
			rValue >>= aOpt.aActiveDics;
			bMod = TRUE;
			break;
		}
		case UPH_DEFAULT_LOCALE :
		{
			bSucc = lcl_SetLocale( aOpt.nDefaultLanguage, rValue );
			bMod = bSucc;
			break;
		}
		case UPH_DEFAULT_LOCALE_CJK :
		{
			bSucc = lcl_SetLocale( aOpt.nDefaultLanguage_CJK, rValue );
			bMod = bSucc;
			break;
		}
		case UPH_DEFAULT_LOCALE_CTL :
		{
			bSucc = lcl_SetLocale( aOpt.nDefaultLanguage_CTL, rValue );
			bMod = bSucc;
			break;
		}
		default :
			DBG_ERROR( "unexpected property handle" );
	}

	if (pbVal)
	{
		BOOL bNew;
		if (rValue >>= bNew)
		{
			if (bNew != *pbVal)
			{
				*pbVal = bNew;
				bMod = TRUE;
			}
			bSucc = TRUE;
		}
	}
	if (pnVal)
	{
		INT16 nNew;
		if (rValue >>= nNew)
		{
			if (nNew != *pnVal)
			{
				*pnVal = nNew;
				bMod = TRUE;
			}
			bSucc = TRUE;
		}
	}

	if (bMod)
		SetModified( TRUE );

	return bSucc;
}


BOOL SvtLinguConfig::GetOptions( SvtLinguOptions &rOptions ) const
{
	rOptions = aOpt;
	return TRUE;
}


BOOL SvtLinguConfig::SetOptions( const SvtLinguOptions &rOptions )
{
	aOpt = rOptions;
	SetModified( TRUE );
	return TRUE;
}


static const char* aRootName = "Office.Linguistic";

BOOL SvtLinguConfig::LoadConfig()
{
	BOOL bRes = FALSE;

	SvtLinguConfigItem aCfg( String::CreateFromAscii( aRootName ));
	Sequence< OUString > aNames = aCfg.GetPropertyNames();
	INT32 nProps = aNames.getLength();

	const Sequence< Any > aValues = aCfg.GetProperties( aNames );

	if (nProps  &&  aValues.getLength() == nProps)
	{
		const Any *pValue = aValues.getConstArray();
		for (INT32 i = 0;  i < nProps;  ++i)
		{
			const Any &rVal = pValue[i];
			if (rVal.hasValue())
			{
				switch ( i )
				{
					case  0: aOpt.nDefaultLanguage = lcl_CfgAnyToLanguage( rVal );	break;
					case  1: rVal >>= aOpt.aActiveDics;	break;
					case  2: rVal >>= aOpt.bIsUseDictionaryList;	break;
					case  3: rVal >>= aOpt.bIsIgnoreControlCharacters;	break;
					case  4: rVal >>= aOpt.bIsGermanPreReform;	break;
					case  5: aOpt.nDefaultLanguage_CJK = lcl_CfgAnyToLanguage( rVal );	break;
					case  6: aOpt.nDefaultLanguage_CTL = lcl_CfgAnyToLanguage( rVal );	break;

					case  7: rVal >>= aOpt.bIsSpellUpperCase;	break;
					case  8: rVal >>= aOpt.bIsSpellWithDigits;	break;
					case  9: rVal >>= aOpt.bIsSpellCapitalization;	break;
					case 10: rVal >>= aOpt.bIsSpellAuto;	break;
					case 11: rVal >>= aOpt.bIsSpellSpecial;	break;
					case 12: rVal >>= aOpt.bIsSpellInAllLanguages;	break;
					case 13: rVal >>= aOpt.bIsSpellHideMarkings;	break;
					case 14: rVal >>= aOpt.bIsSpellReverse;	break;

					case 15: rVal >>= aOpt.nHyphMinLeading;	break;
					case 16: rVal >>= aOpt.nHyphMinTrailing;	break;
					case 17: rVal >>= aOpt.nHyphMinWordLength;	break;
					case 18: rVal >>= aOpt.bIsHyphSpecial;	break;
					case 19: rVal >>= aOpt.bIsHyphAuto;	break;

					default:
						DBG_ERROR( "unexpected case" );
				}
			}
		}

		bRes = TRUE;
	}
	DBG_ASSERT( bRes, "LoadConfig failed" );

	return bRes;
}


BOOL SvtLinguConfig::SaveConfig()
{
	if( !IsModified() )
		return TRUE;

	BOOL bRet = FALSE;
	const Type &rBOOL  	  = ::getBooleanCppuType();
	const Type &rINT16 	  = ::getCppuType( (INT16 *) NULL );

	SvtLinguConfigItem aCfg( String::CreateFromAscii( aRootName ));
	const Sequence< OUString > aNames = aCfg.GetPropertyNames();
	INT32 nProps = aNames.getLength();
	Sequence< Any > aValues( aNames.getLength() );
	Any *pValue = aValues.getArray();

	if (nProps  &&  aValues.getLength() == nProps)
	{
		OUString aTmp( lcl_LanguageToCfgLocaleStr( aOpt.nDefaultLanguage ) );
		*pValue++ = makeAny( aTmp );                               		//   0
		*pValue++ = makeAny( aOpt.aActiveDics );                        //   1
		pValue++->setValue( &aOpt.bIsUseDictionaryList, rBOOL );        //   2
		pValue++->setValue( &aOpt.bIsIgnoreControlCharacters, rBOOL );  //   3
		pValue++->setValue( &aOpt.bIsGermanPreReform, rBOOL );          //   4
		aTmp = lcl_LanguageToCfgLocaleStr( aOpt.nDefaultLanguage_CJK );
		*pValue++ = makeAny( aTmp );                                    //   5
		aTmp = lcl_LanguageToCfgLocaleStr( aOpt.nDefaultLanguage_CTL );
		*pValue++ = makeAny( aTmp );                                    //   6

		pValue++->setValue( &aOpt.bIsSpellUpperCase, rBOOL );			//   7
		pValue++->setValue( &aOpt.bIsSpellWithDigits, rBOOL );			//   8
		pValue++->setValue( &aOpt.bIsSpellCapitalization, rBOOL );		//   9
		pValue++->setValue( &aOpt.bIsSpellAuto, rBOOL );				//  10
		pValue++->setValue( &aOpt.bIsSpellSpecial, rBOOL );				//  11
		pValue++->setValue( &aOpt.bIsSpellInAllLanguages, rBOOL );		//  12
		pValue++->setValue( &aOpt.bIsSpellHideMarkings, rBOOL );		//  13
		pValue++->setValue( &aOpt.bIsSpellReverse, rBOOL );				//  14

		pValue++->setValue( &aOpt.nHyphMinLeading, rINT16 );			//  15
		pValue++->setValue( &aOpt.nHyphMinTrailing, rINT16 );			//  16
		pValue++->setValue( &aOpt.nHyphMinWordLength, rINT16 );			//  17
		pValue++->setValue( &aOpt.bIsHyphSpecial, rBOOL );				//  18
		pValue++->setValue( &aOpt.bIsHyphAuto, rBOOL );					//  19

		bRet |= aCfg.PutProperties( aNames, aValues );
	}

	if (bRet)
		SetModified( FALSE );

	return bRet;
}


IMPL_LINK( SvtLinguConfig, TimeOut, Timer *, p )
{
	SaveConfig();
	return 0;
}


//////////////////////////////////////////////////////////////////////

