/*************************************************************************
 *
 *  $RCSfile: productregistration.cxx,v $
 *
 *  $Revision: 1.1.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/30 11:46:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SVTOOLS_PRODUCTREGISTRATION_HXX
#include "productregistration.hxx"
#endif
#ifndef SVTOOLS_REGOPTIONS_HXX
#include "regoptions.hxx"
#endif
#ifndef SVTOOLS_REGISTRATIONDLG_HXX
#include "registrationdlg.hxx"
#endif

#ifndef _COM_SUN_STAR_SYSTEM_XSYSTEMSHELLEXECUTE_HPP_
#include <com/sun/star/system/XSystemShellExecute.hpp>
#endif
#ifndef _COM_SUN_STAR_SYSTEM_SYSTEMSHELLEXECUTEFLAGS_HPP_
#include <com/sun/star/system/SystemShellExecuteFlags.hpp>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _SVTOOLS_SVTDATA_HXX
#include "svtdata.hxx"
#endif
#ifndef _SVTOOLS_HRC
#include "svtools.hrc"
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include <algorithm>
#include <functional>

#ifdef UNX
#define SEARCH_FOR_BROWSER
#endif

#ifdef SEARCH_FOR_BROWSER
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif
#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
using namespace osl;
#endif
//........................................................................
namespace svt
{
//........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::task;
	using namespace ::com::sun::star::system;
	using namespace ::com::sun::star::beans;
    using namespace ::com::sun::star;
    //-------------------------------------------------------------------

#ifdef SEARCH_FOR_BROWSER
    class ODirectConfigItem_Impl : public utl::ConfigItem
    {
        // disallow copy-constructor and assignment-operator
        ODirectConfigItem_Impl( const ODirectConfigItem_Impl & );
        ODirectConfigItem_Impl & operator = ( const ODirectConfigItem_Impl & );

    public:
        ODirectConfigItem_Impl( const rtl::OUString &rPath ) : ConfigItem( rPath )  {}


        uno::Sequence< uno::Any > GetProperties(
                const uno::Sequence< rtl::OUString > &rNames )
            {
                return ConfigItem::GetProperties(rNames);
            }

        sal_Bool PutProperties(
                const uno::Sequence< rtl::OUString > &rNames,
                const uno::Sequence<
                    uno::Any > &rValues)
            {
                return ConfigItem::PutProperties( rNames, rValues);
            }
    };
#endif// SEARCH_FOR_BROWSER
    //--------------------------------------------------------------------
	struct EqualsOUString : public ::std::unary_function< ::rtl::OUString, sal_Bool >
	{
		const ::rtl::OUString&	m_rCompare;
		EqualsOUString( const ::rtl::OUString& _rCompare ) : m_rCompare( _rCompare ) { }

		sal_Bool operator() ( const ::rtl::OUString& _rCompare )
		{
			return m_rCompare.equals( _rCompare );
		}
	};

	//====================================================================
	//= OProductRegistration
	//====================================================================

	//--------------------------------------------------------------------
	OProductRegistration::OProductRegistration( const Reference< XMultiServiceFactory >& _rxORB )
		:m_xORB( _rxORB )
	{
	}

	//--------------------------------------------------------------------
	Reference< XInterface > OProductRegistration::Create( const Reference< XMultiServiceFactory >& _rxORB )
	{
		return static_cast< ::cppu::OWeakObject* >( new OProductRegistration( _rxORB ) );
	}

	//--------------------------------------------------------------------
	::rtl::OUString SAL_CALL OProductRegistration::getImplementationName_Static( )
	{
		return ::rtl::OUString::createFromAscii( "com.sun.star.comp.setup.OProductRegistration" );
	}

	//--------------------------------------------------------------------
	Sequence< ::rtl::OUString > SAL_CALL OProductRegistration::getSupportedServiceNames_Static(  ) throw (RuntimeException)
	{
		Sequence< ::rtl::OUString > aServiceNames( 1 );
		aServiceNames[ 0 ] = ::rtl::OUString::createFromAscii( "com.sun.star.setup.ProductRegistration" );
		return aServiceNames;
	}

	//--------------------------------------------------------------------
	::rtl::OUString SAL_CALL OProductRegistration::getImplementationName(  ) throw (RuntimeException)
	{
		return getImplementationName_Static( );
	}

	//--------------------------------------------------------------------
	sal_Bool SAL_CALL OProductRegistration::supportsService( const ::rtl::OUString& _rServiceName ) throw (RuntimeException)
	{
		Sequence< ::rtl::OUString > aServiceNames( getSupportedServiceNames( ) );
		const ::rtl::OUString* pNames = aServiceNames.getConstArray( );
		const ::rtl::OUString* pNamesEnd = aServiceNames.getConstArray( ) + aServiceNames.getLength();

		const ::rtl::OUString* pFound = ::std::find_if(
			pNames,
			pNamesEnd,
			EqualsOUString( _rServiceName )
		);
		return pFound != pNamesEnd;
	}

	//--------------------------------------------------------------------
	Sequence< ::rtl::OUString > SAL_CALL OProductRegistration::getSupportedServiceNames(  ) throw (RuntimeException)
	{
		return getSupportedServiceNames_Static( );
	}

	//--------------------------------------------------------------------
	void SAL_CALL OProductRegistration::trigger( const ::rtl::OUString& _rEvent ) throw (RuntimeException)
	{
		switch ( classify( _rEvent ) )
		{
			case etRegistrationRequired:
				doOnlineRegistration();
				break;

			default:
				OSL_ENSURE( sal_False, "OProductRegistration::trigger: invalid event!" );
				break;
		}
	}

	//--------------------------------------------------------------------
    Any SAL_CALL OProductRegistration::execute( const Sequence< NamedValue >& _rArgs ) throw (IllegalArgumentException, Exception, RuntimeException)
	{
		Any aReturn;

		static sal_Bool bFirstEncounter( sal_True );
		if ( bFirstEncounter )
		{	// during this session, this event was never triggered before ....
			bFirstEncounter = sal_False;

			sal_Bool bDeactivateJob = sal_True;

			// our config options
			RegOptions aRegOptions;
			// check them for the permissions for the dialog
			RegOptions::DialogPermission ePermission( aRegOptions.getDialogPermission() );

			if ( RegOptions::dpDisabled != ePermission )
			{	// the dialog is _not_ disabled

				// for this session, I'm no interested in the dialog registration anymore
				aRegOptions.markSessionDone( );

				if	(	( RegOptions::dpNotThisSession == ePermission )		// first trigger session not reached
					||	( RegOptions::dpRemindLater == ePermission )		// or at a later reminder date
					)
				{	// the dialog should be executed during one of the next sessions
					bDeactivateJob = sal_False;
				}
				else
				{
					// if we're here, the dialog should be executed during this session
					OSL_ENSURE( RegOptions::dpThisSession == ePermission, "OProductRegistration::execute: invalid permissions!" );

					// execute it
					RegistrationDialog aDialog( Application::GetDefDialogParent() );
					aDialog.Execute();

					switch ( aDialog.getResponse() )
					{
						case RegistrationDialog::urRegisterNow:
							// -> do the registration
							doOnlineRegistration();
							break;

						case RegistrationDialog::urRegisterLater:
							bDeactivateJob = sal_False;
							// remind again in seven days from now on ...
							aRegOptions.activateReminder( 7 );
							break;

						case RegistrationDialog::urRegisterNever:
						case RegistrationDialog::urAlreadyRegistered:
							// never register or already registered
							// -> deactivate the job, and nothing else
							break;

						default:
							OSL_ENSURE( sal_False, "OProductRegistration::execute: invalid response from the dialog!" );
					}
				}
			}

			Sequence< NamedValue > aJobResponse( 1 );
			aJobResponse[0].Name = ::rtl::OUString::createFromAscii( "Deactivate" );
			aJobResponse[0].Value <<= bDeactivateJob;
			aReturn <<= aJobResponse;
		}

		return aReturn;
	}

	//--------------------------------------------------------------------
	void OProductRegistration::doOnlineRegistration( )
	{
		sal_Bool bSuccess = sal_False;
		try
		{
			// create the Desktop component which can load components
			Reference< XSystemShellExecute > xSystemShell(
				m_xORB->createInstance( ::rtl::OUString::createFromAscii( "com.sun.star.system.SystemShellExecute" ) ),
				UNO_QUERY
			);
			OSL_ENSURE( xSystemShell.is(), "OProductRegistration::doOnlineRegistration: invalid SystemExecute component!" );

			// access the configuration to retrieve the URL we shall use for registration
			RegOptions aOptions;
			::rtl::OUString sRegistrationURL( aOptions.getRegistrationURL( ) );
			OSL_ENSURE( sRegistrationURL.getLength(), "OProductRegistration::doOnlineRegistration: invalid URL found!" );

			if ( xSystemShell.is() && sRegistrationURL.getLength() )
			{
#ifdef SEARCH_FOR_BROWSER
                //check whether a browser is already in the configuration
                ODirectConfigItem_Impl aCfgItem(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM ( "Office.Common/ExternalApps")));
                // there's no name required since the path is complete
                uno::Sequence< rtl::OUString > aNames(1);
                aNames.getArray()[0] = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM ("http"));
                uno::Sequence< uno::Any > aValues = aCfgItem.GetProperties(aNames);
                rtl::OUString sURL;
                aValues.getConstArray()[0] >>= sURL;
                if(!sURL.getLength())
                {
                    //search for a browser
                    rtl::OUString sEmpty;
                    rtl::OUString sFoundURL;
                    FileBase::RC eCode = FileBase::searchFileURL( rtl::OUString(RTL_CONSTASCII_USTRINGPARAM ( "netscape" ) ), sEmpty, sFoundURL );
                    if(eCode != FileBase::E_None)
                        eCode = FileBase::searchFileURL( rtl::OUString(RTL_CONSTASCII_USTRINGPARAM ( "mozilla" ) ), sEmpty, sFoundURL );
                    if(eCode != FileBase::E_None)
                        eCode = FileBase::searchFileURL( rtl::OUString(RTL_CONSTASCII_USTRINGPARAM ( "nautilus" ) ), sEmpty, sFoundURL );
                    //insert the entry into the configuration
                    if(eCode == FileBase::E_None)
                    {
                        aValues.getArray()[0] <<= sFoundURL;
                        aCfgItem.PutProperties(aNames, aValues);
                    }
                }
#endif
                xSystemShell->execute( sRegistrationURL, ::rtl::OUString(), SystemShellExecuteFlags::DEFAULTS );
				bSuccess = sal_True;
			}
		}
		catch( const Exception& )
		{
		}
		if ( !bSuccess )
		{
			ErrorBox aRegistrationError( Application::GetDefDialogParent(), SvtResId( ERRBOX_REG_NOSYSBROWSER ) );
			aRegistrationError.Execute();
		}
	}

	//--------------------------------------------------------------------
	OProductRegistration::EventType OProductRegistration::classify( const ::rtl::OUString& _rEventDesc )
	{
		EventType eReturn = etUnknown;
		if ( _rEventDesc.equalsAscii( "RegistrationRequired" ) )
		{
			eReturn = etRegistrationRequired;
		}
		return eReturn;
	}

//........................................................................
}	// namespace svt
//........................................................................
