/*************************************************************************
 *
 *  $RCSfile: bmpmask.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: thb $ $Date: 2001/08/16 15:41:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _BMPMASK_HXX_
#define _BMPMASK_HXX_

#ifndef _SFXCTRLITEM_HXX
#include <sfx2/ctrlitem.hxx>
#endif
#ifndef _SFXDOCKWIN_HXX
#include <sfx2/dockwin.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_GROUP_HXX
#include <vcl/group.hxx>
#endif
#ifndef _SV_GRAPH_HXX
#include <vcl/graph.hxx>
#endif

#include "dlgctrl.hxx"

/*************************************************************************
|*
|*	class SvxBmpMaskSelectItem
|*
\************************************************************************/
class SvxBmpMask;

class SvxBmpMaskSelectItem : public SfxControllerItem
{
private:
	SvxBmpMask  &rBmpMask;

protected:
	virtual void StateChanged( USHORT nSID, SfxItemState eState,
							   const SfxPoolItem* pState );

public:
	SvxBmpMaskSelectItem( USHORT nId, SvxBmpMask& rMask,
						  SfxBindings& rBindings );
};


/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als 'Beh"alter' f"ur Float
|*
\************************************************************************/

class SvxBmpMaskChildWindow : public SfxChildWindow
{
 public:
							SvxBmpMaskChildWindow( Window*,
												   USHORT, SfxBindings*,
												   SfxChildWinInfo* );

	SFX_DECL_CHILDWINDOW(SvxBmpMaskChildWindow);
};


/*************************************************************************
|*
|*  class SvxBmpMask
|*
\************************************************************************/

class MaskData;
class MaskSet;
class ColorWindow;

class SvxBmpMask : public SfxDockingWindow
{
	friend class MaskData;
	friend class MaskSet;

	Window* 			pParentWin;
	Size				aLastSize;
	ToolBox				aTbxPipette;
	ColorWindow*		pCtlPipette;
	PushButton			aBtnExec;
    FixedLine           aGrpQ;
	MaskSet*			pQSet;
	CheckBox			aCbx1;
	MetricField			aSp1;
	CheckBox			aCbx2;
	MetricField			aSp2;
	CheckBox			aCbx3;
	MetricField			aSp3;
	CheckBox			aCbx4;
	MetricField			aSp4;
	CheckBox			aCbxTrans;
	ColorLB				aLbColor1;
	ColorLB				aLbColor2;
	ColorLB				aLbColor3;
	ColorLB				aLbColor4;
	ColorLB				aLbColorTrans;
	FixedText			aFt1;
	FixedText			aFt2;
	FixedText			aFt3;
	const XColorTable* 	pColTab;
	MaskData*			pData;
	Color				aPipetteColor;
	SvxBmpMaskSelectItem aSelItem;

	virtual BOOL 		Close();


#ifdef BMPMASK_PRIVATE

	USHORT				InitColorArrays( Color* pSrcCols, Color* pDstCols,
										 ULONG* pTols );

	Bitmap 				ImpMask( const Bitmap& rBitmap );
	BitmapEx			ImpMask( const BitmapEx& rBitmapEx );
	GDIMetaFile 		ImpMask( const GDIMetaFile& rMtf );
	Animation 			ImpMask( const Animation& rAnimation );
	BitmapEx			ImpMaskTransparent( const BitmapEx& rBitmapEx,
											const Color& rColor,
											const long nTol );
	BitmapEx			ImpReplaceTransparency( const BitmapEx& rBmpEx,
												const Color& rColor );
	Animation			ImpReplaceTransparency( const Animation& rAnim,
												const Color& rColor );
	GDIMetaFile			ImpReplaceTransparency( const GDIMetaFile& rMtf,
												const Color& rColor );

#endif // BMPMASK_PRIVATE

public:

						SvxBmpMask( SfxBindings *pBindinx,
									SfxChildWindow *pCW,
									Window* pParent,
									const ResId& rResId );
						~SvxBmpMask();

	void				SetColor( const Color& rColor );
	void				PipetteClicked();

	BOOL				NeedsColorTable() const;
	void 				SetColorTable( const XColorTable* pColorTable );

	void				SetExecState( BOOL bEnable );

	Graphic 			Mask( const Graphic& rGraphic );

	BOOL				IsEyedropping() const;
};


/*************************************************************************
|*
|* Defines
|*
\************************************************************************/

#define SVXBMPMASK() ( (SvxBmpMask*) ( SfxViewFrame::Current()->GetChildWindow( 	\
					 SvxBmpMaskChildWindow::GetChildWindowId() )-> 	\
					 GetWindow() ) )


#endif // _BMPMASK_HXX_

