/*************************************************************************
 *
 *  $RCSfile: dataaccessdescriptor.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: fs $ $Date: 2001/06/22 11:00:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_DATACCESSDESCRIPTOR_HXX_
#define _SVX_DATACCESSDESCRIPTOR_HXX_

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

//........................................................................
namespace svx
{
//........................................................................

	class ODADescriptorImpl;

	//====================================================================
	//= DataAccessDescriptorProperty
	//====================================================================
	enum DataAccessDescriptorProperty
	{
		daDataSource,			/// data source name	(::rtl::OUString)
		daConnection,			/// connection			(Reference< XConnection >)

		daCommand,				/// command				(::rtl::OUString)
		daCommandType,			/// command type		(sal_Int32, see ::com::sun::star::sdb::CommandType)
		daEscapeProcessing,		/// escape processing	(sal_Bool)
		daCursor,				/// the cursor			(Reference< XResultSet >)

		daColumnName,			/// column name			(::rtl::OUString)
		daColumnObject,			/// column object		(Reference< XPropertySet >)

		daSelection			/// selection			(Sequence< Any >)
	};

	//====================================================================
	//= ODataAccessDescriptor
	//====================================================================
	class ODataAccessDescriptor
	{
	protected:
		ODADescriptorImpl*		m_pImpl;

	public:
		ODataAccessDescriptor();
		ODataAccessDescriptor( const ODataAccessDescriptor& _rSource );
		ODataAccessDescriptor( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _rValues );
		ODataAccessDescriptor( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rValues );

		const ODataAccessDescriptor& operator=(const ODataAccessDescriptor& _rSource);

		~ODataAccessDescriptor();

		/** returns the descriptor as property set
			<p>If you call this method more than once, without writing any values between both calls, the same object
			is returned. If you wrote values, a new object is returned.</p>
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >
					createPropertySet();
		/** returns the descriptor as property value sequence
			<p>If you call this method more than once, without writing any values between both calls, the same object
			is returned. If you wrote values, a new object is returned.</p>
		*/
		::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >
					createPropertyValueSequence();

		/** initialized the descriptor from the property set given
			<p>If <arg>_bClear</arg> is <TRUE/>, the descriptor will clear all it's current settings before
			initializing with the new ones.</p>
		*/
		void		initializeFrom(
						const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _rxValues,
						sal_Bool _bClear = sal_True);

		/** initialized the descriptor from the property values given
			<p>If <arg>_bClear</arg> is <TRUE/>, the descriptor will clear all it's current settings before
			initializing with the new ones.</p>
		*/
		void		initializeFrom(
						const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rValues,
						sal_Bool _bClear = sal_True);

		/// checks whether or not a given property is present in the descriptor
		sal_Bool	has(DataAccessDescriptorProperty _eWhich) const;

		/** erases the given property from the descriptor
		*/
		void		erase(DataAccessDescriptorProperty _eWhich);

		/** empties the descriptor
		*/
		void		clear();

		/// return the value of a given property
		const	::com::sun::star::uno::Any& operator [] ( DataAccessDescriptorProperty _eWhich ) const;

		/** return the (modifiable) value of a given property
			<p>This operator is not allowed to be called if the descriptor is readonly.</p>
		*/
				::com::sun::star::uno::Any& operator [] ( DataAccessDescriptorProperty _eWhich );
	};

//........................................................................
}	// namespace svx
//........................................................................

#endif // _SVX_DATACCESSDESCRIPTOR_HXX_

/*************************************************************************
 * history:
 *	$Log: dataaccessdescriptor.hxx,v $
 *	Revision 1.4  2001/06/22 11:00:39  fs
 *	#82371# +initializeFrom
 *	
 *	Revision 1.3  2001/04/24 12:09:11  vg
 *	Removed wrong comma
 *	
 *	Revision 1.2  2001/04/18 10:40:45  fs
 *	added operator=
 *	
 *	Revision 1.1  2001/04/11 12:36:57  fs
 *	initial checkin - encapsulating descriptors of data access related transferable objects
 *	
 *
 *	Revision 1.0 10.04.01 17:08:08  fs
 ************************************************************************/

