/*************************************************************************
 *
 *  $RCSfile: fillctrl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 15:01:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FILLCTRL_HXX
#define _FILLCTRL_HXX


#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXTBXCTRL_HXX //autogen
#include <sfx2/tbxctrl.hxx>
#endif
class XFillStyleItem;
class XFillColorItem;
class XFillGradientItem;
class XFillHatchItem;
class XFillBitmapItem;
class FillControl;
class SvxFillTypeBox;
class SvxFillAttrBox;
class ListBox;

/*************************************************************************
|*
|* Klassen fuer Flaechenattribute (Controls und Controller)
|*
\************************************************************************/

class SvxFillToolBoxControl: public SfxToolBoxControl, public SfxListener
{
private:
	XFillStyleItem*		pStyleItem;
	XFillColorItem*		pColorItem;
	XFillGradientItem*	pGradientItem;
	XFillHatchItem*		pHatchItem;
	XFillBitmapItem*	pBitmapItem;

	SfxStatusForwarder	aColorForwarder;
	SfxStatusForwarder	aGradientForwarder;
	SfxStatusForwarder	aHatchForwarder;
	SfxStatusForwarder	aBitmapForwarder;

	FillControl*		pFillControl;
	SvxFillTypeBox*		pFillTypeLB;
	SvxFillAttrBox*		pFillAttrLB;

	BOOL				bUpdate;
	USHORT				eLastXFS;

public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFillToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind );
	~SvxFillToolBoxControl();

	virtual void		StateChanged( USHORT nSID, SfxItemState eState,
									  const SfxPoolItem* pState );
	virtual void 		SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
								const SfxHint& rHint, const TypeId& rHintType );
	virtual Window*		CreateItemWindow( Window *pParent );
};

//========================================================================

class FillControl : public Window
{
private:
	friend class SvxFillToolBoxControl;

	SvxFillTypeBox*	pLbFillType;
	SvxFillAttrBox*	pLbFillAttr;

	Timer			aDelayTimer;

#if _SOLAR__PRIVATE
	DECL_LINK( DelayHdl, Timer * );
	DECL_LINK( SelectFillTypeHdl, ListBox * );
	DECL_LINK( SelectFillAttrHdl, ListBox * );
#endif
public:
	FillControl( Window* pParent, WinBits nStyle = 0 );
	~FillControl();

	virtual void Resize();
};

#endif		// _FILLCTRL_HXX


