/*************************************************************************
 *
 *  $RCSfile: fmfilter.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: fs $ $Date: 2001/10/25 07:47:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma hdrstop


#ifndef _COM_SUN_STAR_SDDB_XCOLUMNSSUPPLIER_HPP_
#include <com/sun/star/sdbcx/XColumnsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XSTATEMENT_HPP_
#include <com/sun/star/sdbc/XStatement.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XCOLUMN_HPP_
#include <com/sun/star/sdb/XColumn.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_SQLCONTEXT_HPP_
#include <com/sun/star/sdb/SQLContext.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_XTABLESSUPPLIER_HPP_ 
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XVCLWINDOWPEER_HPP_
#include <com/sun/star/awt/XVclWindowPeer.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XCHECKBOX_HPP_
#include <com/sun/star/awt/XCheckBox.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XRADIOBUTTON_HPP_
#include <com/sun/star/awt/XRadioButton.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XLISTBOX_HPP_
#include <com/sun/star/awt/XListBox.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_VCLWINDOWPEERATTRIBUTE_HPP_
#include <com/sun/star/awt/VclWindowPeerAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XCOMBOBOX_HPP_
#include <com/sun/star/awt/XComboBox.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_DATATYPE_HPP_
#include <com/sun/star/sdbc/DataType.hpp>
#endif

#ifndef _SVX_FMFILTER_HXX
#include "fmfilter.hxx"
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include <com/sun/star/container/XChild.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XBOUNDCOMPONENT_HPP_
#include <com/sun/star/form/XBoundComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_FORMCOMPONENTTYPE_HPP_
#include <com/sun/star/form/FormComponentType.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMED_HPP_
#include <com/sun/star/container/XNamed.hpp>
#endif

#ifndef _SV_SVAPP_HXX //autogen wg. Application
#include <vcl/svapp.hxx>
#endif

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#ifndef _SVX_DIALMGR_HXX
#include "dialmgr.hxx"
#endif

#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif

#ifndef _SVX_FMPROP_HXX
#include "fmprop.hxx"
#endif

#ifndef _SVX_FMTOOLS_HXX
#include "fmtools.hxx"
#endif

#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif
#ifndef _DBHELPER_DBCONVERSION_HXX_
#include <connectivity/dbconversion.hxx>
#endif
#ifndef _COMPHELPER_NUMBERS_HXX_
#include <comphelper/numbers.hxx>
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

#ifndef _COMPHELPER_DATETIME_HXX_
#include <comphelper/datetime.hxx>
#endif
#ifndef _DBHELPER_DBCONVERSION_HXX_
#include <connectivity/dbconversion.hxx>
#endif
#ifndef _CONNECTIVITY_SQLNODE_HXX
#include <connectivity/sqlnode.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#include <algorithm>

using namespace ::dbtools;
using namespace ::connectivity;
using namespace ::connectivity::simple;
using namespace ::svxform;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;

//------------------------------------------------------------------------------
FmXFilterControl::FmXFilterControl(const Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
								   const Reference< ::com::sun::star::beans::XPropertySet > & xSet,
								   const Reference< ::com::sun::star::beans::XPropertySet > & xField,
								   const Reference< XDatabaseMetaData > & xMetaData,
								   const Reference< ::com::sun::star::util::XNumberFormatter > & xFormatter,
								   Window* pErrorWin)
				 :OSQLParserClient(_rxORB)
				 ,m_aTextListeners( *this )
				 ,m_xField(xField)
				 ,m_xFormatter(xFormatter)
				 ,m_xMetaData(xMetaData)
				 ,m_pWindow(pErrorWin)
				 ,m_bFilterList(sal_False)
				 ,m_bMultiLine(sal_False)
				 ,m_nControlClass(::com::sun::star::form::FormComponentType::TEXTFIELD)
				 ,m_bFilterListFilled(sal_False)
				 ,m_xORB(_rxORB)
{
	if (xSet.is())
	{
		m_bFilterList = ::comphelper::hasProperty(FM_PROP_FILTERPROPOSAL, xSet) && ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_FILTERPROPOSAL));
		if (m_bFilterList)
			m_nControlClass = ::com::sun::star::form::FormComponentType::COMBOBOX;
		else
		{
			sal_Int16 nClassId = ::comphelper::getINT16(xSet->getPropertyValue(FM_PROP_CLASSID));
			switch (nClassId)
			{
				case ::com::sun::star::form::FormComponentType::CHECKBOX:
				case ::com::sun::star::form::FormComponentType::RADIOBUTTON:
				case ::com::sun::star::form::FormComponentType::LISTBOX:
				case ::com::sun::star::form::FormComponentType::COMBOBOX:
					m_nControlClass = nClassId;
					break;
				default:
					m_bMultiLine = ::comphelper::hasProperty(FM_PROP_MULTILINE, xSet) && ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_MULTILINE));
					m_nControlClass = ::com::sun::star::form::FormComponentType::TEXTFIELD;
			}
		}
	}
}
// -----------------------------------------------------------------------------
Any	SAL_CALL FmXFilterControl::queryAggregation( const Type & rType ) throw(RuntimeException)
{
	Any aRet = UnoControl::queryAggregation( rType);
	if(!aRet.hasValue())
		aRet = FmXFilterControl_BASE::queryInterface(rType);

	return aRet;
}
//----------------------------------------------------------------------------
//sal_Bool FmXFilterControl::queryAggregation( Uik aUik, Reference< XInterface > & rxInterface )
//{
//	if( aUik == ::getCppuType((const Reference< ::com::sun::star::awt::XTextComponent >*)0) )
//		rxInterface = (::com::sun::star::awt::XTextComponent*)this;
//	else if( aUik == ::getCppuType((const Reference< ::com::sun::star::awt::XFocusListener >*)0) )
//		rxInterface = (::com::sun::star::awt::XFocusListener*)this;
//	else if( aUik == ::getCppuType((const Reference< ::com::sun::star::awt::XItemListener >*)0) )
//		rxInterface = (::com::sun::star::awt::XItemListener*)this;
//	else if( aUik == XEventListener_getSmartUik())
//		rxInterface = (::com::sun::star::lang::XEventListener*) (::com::sun::star::awt::XItemListener*) this;
//	else if( aUik == ::getCppuType((const Reference< ::com::sun::star::form::XBoundComponent >*)0) &&
//		(m_nControlClass == ::com::sun::star::form::FormComponentType::TEXTFIELD || m_nControlClass == ::com::sun::star::form::FormComponentType::COMBOBOX))
//		rxInterface = (::com::sun::star::form::XBoundComponent*)this;
//	else
//		::com::sun::star::awt::UnoControl::queryAggregation( aUik, rxInterface );
//
//	return rxInterface.is();
//}

//------------------------------------------------------------------------------
//	Reference< XInterface >  FmXFilterControl_NewInstance_Impl()
//	{
	//	return (Reference< XInterface >*)new FmXFilterControl;
//	}

//------------------------------------------------------------------
//Reflection* ::getCppuType((const FmXFilterControl*)0)
//{
//	static StandardClassReflection aRefl
//	(
//		FmXFilterControl_NewInstance_Impl,
//		createStandardClass
//			( ::rtl::OUString::createFromAscii("FmXFilterControl"),
//				::com::sun::star::awt::UnoControl::GetObjectIdlClass(),
//				1,
//				::getCppuType((const ::com::sun::star::awt::XTextComponent*)0)
//			)
//	);
//	return &aRefl;
//}

//------------------------------------------------------------------
 //	generate a uniqueId
const Sequence< sal_Int8 > & FmXFilterControl::getUnoTunnelId()
{
	static Sequence< sal_Int8 > * pSeq = 0;
	if( !pSeq )
	{
		::osl::Guard< ::osl::Mutex > aGuard( ::osl::Mutex::getGlobalMutex() );
        if( !pSeq )
		{
			static Sequence< sal_Int8 > aSeq( 16 );
				rtl_createUuid( (sal_uInt8*)aSeq.getArray(), 0,sal_True );
				pSeq = &aSeq;
		}
	}
	return *pSeq;
}
// return implementation specific data
//------------------------------------------------------------------
sal_Int64 FmXFilterControl::getSomething( const Sequence< sal_Int8 > & rId )
{
	if( rId.getLength() == 16 && 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(),  rId.getConstArray(), 16 ) )
		return (sal_Int64)this;

	return 0;
}


//------------------------------------------------------------------------------
::rtl::OUString FmXFilterControl::GetComponentServiceName()
{
	::rtl::OUString aServiceName;
	switch (m_nControlClass)
	{
		case ::com::sun::star::form::FormComponentType::RADIOBUTTON:
			aServiceName = ::rtl::OUString::createFromAscii("radiobutton");
			break;
		case ::com::sun::star::form::FormComponentType::CHECKBOX:
			aServiceName = ::rtl::OUString::createFromAscii("checkbox");
			break;
		case ::com::sun::star::form::FormComponentType::COMBOBOX:
			aServiceName = ::rtl::OUString::createFromAscii("combobox");
			break;
		case ::com::sun::star::form::FormComponentType::LISTBOX:
			aServiceName = ::rtl::OUString::createFromAscii("listbox");
			break;
		default:
			if (m_bMultiLine)
				aServiceName = ::rtl::OUString::createFromAscii("MultiLineEdit");
			else
				aServiceName = ::rtl::OUString::createFromAscii("Edit");
	}
	return aServiceName;
}

// ::com::sun::star::lang::XComponent
//------------------------------------------------------------------------------
void FmXFilterControl::dispose() throw( RuntimeException  )
{
	::com::sun::star::lang::EventObject aEvt(*this);
	m_aTextListeners.disposeAndClear( aEvt );
	UnoControl::dispose();
}

//------------------------------------------------------------------------------
void FmXFilterControl::createPeer( const Reference< ::com::sun::star::awt::XToolkit > & rxToolkit, const Reference< ::com::sun::star::awt::XWindowPeer >  & rParentPeer ) throw(::com::sun::star::uno::RuntimeException)
{
	UnoControl::createPeer( rxToolkit, rParentPeer );

	Reference< ::com::sun::star::awt::XVclWindowPeer >  xVclWindow(mxPeer, UNO_QUERY);
	Any aValue;
	if (xVclWindow.is())
	{
		switch (m_nControlClass)
		{
			case ::com::sun::star::form::FormComponentType::CHECKBOX:
			{
				// checkboxes always have a tristate-mode
				sal_Bool bB(sal_True);
				aValue.setValue(&bB,::getBooleanCppuType());
				xVclWindow->setProperty(FM_PROP_TRISTATE, aValue);

				aValue <<= (sal_Int32)STATE_DONTKNOW;
				xVclWindow->setProperty(FM_PROP_STATE, aValue);

				Reference< ::com::sun::star::awt::XCheckBox >  xBox(mxPeer, UNO_QUERY);
				xBox->addItemListener(this);

			}	break;
			case ::com::sun::star::form::FormComponentType::RADIOBUTTON:
			{
				aValue <<= (sal_Int32)STATE_NOCHECK;
				xVclWindow->setProperty(FM_PROP_STATE, aValue);

				Reference< ::com::sun::star::awt::XRadioButton >  xRadio(mxPeer , UNO_QUERY);
				xRadio->addItemListener(this);
			}	break;
			case ::com::sun::star::form::FormComponentType::LISTBOX:
			{
				Reference< ::com::sun::star::awt::XListBox >  xListBox(mxPeer , UNO_QUERY);
				xListBox->addItemListener(this);
			}
			case ::com::sun::star::form::FormComponentType::COMBOBOX: // no break;
				{
					sal_Bool bB(sal_True);
					aValue.setValue(&bB,::getBooleanCppuType());
					xVclWindow->setProperty(FM_PROP_AUTOCOMPLETE, aValue);
				}
			default:	// no break;
			{
				Reference< ::com::sun::star::awt::XWindow >  xWindow(mxPeer, UNO_QUERY);
				xWindow->addFocusListener(this);

				Reference< ::com::sun::star::awt::XTextComponent >  xText(mxPeer , UNO_QUERY);
				if (xText.is())
					xText->setMaxTextLen(0);
			}	break;
		}
	}
	if (m_bFilterList)
		m_bFilterListFilled = sal_False;
}

//------------------------------------------------------------------------------
void FmXFilterControl::PrepareWindowDescriptor( ::com::sun::star::awt::WindowDescriptor& rDescr )
{
	if (m_bFilterList)
		rDescr.WindowAttributes |= ::com::sun::star::awt::VclWindowPeerAttribute::DROPDOWN;
}

//------------------------------------------------------------------------------
void FmXFilterControl::ImplSetPeerProperty( const ::rtl::OUString& rPropName, const Any& rVal )
{
	// these properties are ignored
	if (rPropName == FM_PROP_TEXT ||
		rPropName == FM_PROP_STATE)
		return;

	UnoControl::ImplSetPeerProperty( rPropName, rVal );
}

// ::com::sun::star::lang::XEventListener
//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::disposing(const ::com::sun::star::lang::EventObject& Source) throw( RuntimeException )
{
	UnoControl::disposing(Source);
}

// ::com::sun::star::awt::XItemListener
//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::itemStateChanged( const ::com::sun::star::awt::ItemEvent& rEvent ) throw(::com::sun::star::uno::RuntimeException)
{
	::rtl::OUString aText;
	switch (m_nControlClass)
	{
		case ::com::sun::star::form::FormComponentType::CHECKBOX:
		{
			switch (rEvent.Selected)
			{
				case STATE_CHECK:
					aText = ::rtl::OUString::createFromAscii("1");
					break;
				case STATE_NOCHECK:
					aText = ::rtl::OUString::createFromAscii("0");
					break;
			}
		}	break;
		case ::com::sun::star::form::FormComponentType::LISTBOX:
		{
			Sequence< ::rtl::OUString> aValueSelection;
			Reference< ::com::sun::star::beans::XPropertySet > aPropertyPointer(getModel(), UNO_QUERY);
			aPropertyPointer->getPropertyValue(FM_PROP_VALUE_SEQ) >>= aValueSelection;
			if (rEvent.Selected <= aValueSelection.getLength())
				aText = aValueSelection.getConstArray()[rEvent.Selected];
		} break;
		case ::com::sun::star::form::FormComponentType::RADIOBUTTON:
		{
			if (rEvent.Selected == STATE_CHECK)
				aText = ::comphelper::getString(Reference< ::com::sun::star::beans::XPropertySet > (getModel(), UNO_QUERY)->getPropertyValue(FM_PROP_REFVALUE));
		} break;
	}

	if (m_aText.compareTo(aText))
	{
		m_aText = aText;
		::com::sun::star::awt::TextEvent aEvt;
		aEvt.Source = *this;
		::cppu::OInterfaceIteratorHelper aIt( m_aTextListeners );
		while( aIt.hasMoreElements() )
			((::com::sun::star::awt::XTextListener *)aIt.next())->textChanged( aEvt );
	}
}

//------------------------------------------------------------------------------
void FmXFilterControl::implInitFilterList()
{
	// declare here for later disposal
	Reference< XResultSet > xListCursor;
	Reference< XStatement > xStatement;

	try
	{
		m_bFilterListFilled = sal_True;

		Reference< XPropertySet >  xSet(getModel(), UNO_QUERY);
		if (xSet.is() && m_xField.is())
		{
			::rtl::OUString sName;
			m_xField->getPropertyValue(FM_PROP_NAME) >>= sName;

			// here we need a table to which the field belongs to
			Reference< XChild > xModelAsChild( xSet, UNO_QUERY );
			Reference< XRowSet > xForm( xModelAsChild->getParent(), UNO_QUERY );
			Reference< XPropertySet > xFormAsSet( xForm, UNO_QUERY );

			// Connection holen
			Reference< XConnection > xConnection;
			if ( xForm.is() )
				xConnection = getRowsetConnection( xForm );
			Reference< XSQLQueryComposerFactory >  xFactory( xConnection, UNO_QUERY );
			OSL_ENSURE( xFactory.is() && xFormAsSet.is(), "FmXFilterControl::implInitFilterList: invalid form or invalid connection!" );
			if ( !xFactory.is() || !xFormAsSet.is() )
				return;

			// create a query composer
			Reference< XSQLQueryComposer > xComposer = xFactory->createQueryComposer();
			OSL_ENSURE( xComposer.is() , "FmXFilterControl::implInitFilterList: invalid query composer!" );
			if ( !xComposer.is() )
				return;

			// set the statement on the composer, ...
			::rtl::OUString	sStatement;
			xFormAsSet->getPropertyValue( FM_PROP_ACTIVECOMMAND ) >>= sStatement;
 			xComposer->setQuery( sStatement );

			// ... and ask it for the involved tables and queries
			Reference< XTablesSupplier > xSuppTables( xComposer, UNO_QUERY );
			Reference< XColumnsSupplier > xSuppColumns( xComposer, UNO_QUERY );

			Reference< XNameAccess > xFieldNames;
			if ( xSuppColumns.is() ) xFieldNames = xSuppColumns->getColumns();
			Reference< XNameAccess > xTablesNames;
			if ( xSuppTables.is() ) xTablesNames = xSuppTables->getTables();

			if ( !xFieldNames.is() || !xTablesNames.is() )
			{
				OSL_ENSURE( sal_False, "FmXFilterControl::implInitFilterList: invalid query composer (no fields or no tables supplied)!" );
				return;
			}

			// search the field
			Reference< XPropertySet >  xComposerFieldAsSet;
			if ( xFieldNames->hasByName( sName ) )
				xFieldNames->getByName( sName ) >>= xComposerFieldAsSet;
			
			if	(	xComposerFieldAsSet.is()
				&&	::comphelper::hasProperty( FM_PROP_TABLENAME, xComposerFieldAsSet )
				&&	::comphelper::hasProperty( FM_PROP_REALNAME, xComposerFieldAsSet )
				)
			{
				::rtl::OUString sFieldName, sTableName;
				xComposerFieldAsSet->getPropertyValue(FM_PROP_REALNAME) >>= sFieldName;
				xComposerFieldAsSet->getPropertyValue(FM_PROP_TABLENAME) >>= sTableName;

				// no possibility to create a select statement
				// looking for the complete table name
				if (!xTablesNames->hasByName(sTableName))
					return;

				// this is the tablename
				Reference< XNamed > xName;
				xTablesNames->getByName(sTableName) >>= xName;
				OSL_ENSURE(xName.is(),"No XName interface!");
				sTableName = xName->getName();

				// ein Statement aufbauen und abschicken als query
				// Access to the connection

				Reference< XColumn >  xDataField;

				Reference< XDatabaseMetaData >  xMeta = xConnection->getMetaData();
				::rtl::OUString aQuote = xMeta->getIdentifierQuoteString();
				String aStatement("SELECT DISTINCT", RTL_TEXTENCODING_ASCII_US);
				aStatement += quoteName(aQuote,sName).getStr();

				if (sFieldName.getLength() && sName != sFieldName)
				{
					aStatement.AppendAscii(" AS ");
					aStatement += quoteName(aQuote, sFieldName).getStr();
				}

				aStatement.AppendAscii(" FROM ");
				aStatement += quoteTableName(xMeta, sTableName).getStr();

				xStatement = xConnection->createStatement();
				xListCursor = xStatement->executeQuery(aStatement);

				Reference< XColumnsSupplier >  xSupplyCols(xListCursor, UNO_QUERY);
				Reference< XIndexAccess >  xFields;
				if (xSupplyCols.is())
					xFields = Reference< XIndexAccess > (xSupplyCols->getColumns(), UNO_QUERY);
				if (xFields.is())
					xFields->getByIndex(0) >>= xDataField;
				if (!xDataField.is())
					return;


				sal_Int16 i = 0;
				vector< ::rtl::OUString>	aStringList;
				aStringList.reserve(16);
				::rtl::OUString	aStr;

				util::Date aNullDate( getStandardDate() );
				sal_Int32 nFormatKey = 0;
				try
				{
					m_xFormatter->getNumberFormatsSupplier()->getNumberFormatSettings()->getPropertyValue(::rtl::OUString::createFromAscii("NullDate"))
						>>= aNullDate;
					nFormatKey = ::comphelper::getINT32(m_xField->getPropertyValue(FM_PROP_FORMATKEY));
				}
				catch(const Exception&)
				{
				}


				sal_Int16 nKeyType = ::comphelper::getNumberFormatType(m_xFormatter->getNumberFormatsSupplier()->getNumberFormats(), nFormatKey);
				while (!xListCursor->isAfterLast() && i++ < SHRT_MAX) // max anzahl eintraege
				{
					aStr = getValue(xDataField, m_xFormatter, aNullDate, nFormatKey, nKeyType);

					aStringList.push_back(aStr);
					xListCursor->next();
				}

				Sequence< ::rtl::OUString> aStringSeq(aStringList.size());
				::rtl::OUString* pustrStrings = aStringSeq.getArray();
				for (i = 0; i < (sal_Int16)aStringList.size(); ++i)
					pustrStrings[i] = aStringList[i];

				Reference< awt::XComboBox >  xComboBox(mxPeer, UNO_QUERY );
				if ( xComboBox.is() )
				{
					xComboBox->addItems(aStringSeq, 0);
					// set the drop down line count
					sal_Int16 nLineCount = ::std::min( (sal_Int16)10, (sal_Int16)aStringSeq.getLength() );
					xComboBox->setDropDownLineCount( nLineCount );
				}
			}
		}
	}
	catch( const Exception& e )
	{
		e; // make compiler happy
		OSL_ENSURE( sal_False, "FmXFilterControl::implInitFilterList: caught an exception!" );
	}

	::comphelper::disposeComponent( xListCursor );
	::comphelper::disposeComponent( xStatement );
}

// ::com::sun::star::awt::XFocusListener
//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::focusGained(const ::com::sun::star::awt::FocusEvent& e)  throw( RuntimeException  )
{
	// should we fill the combobox?
	if (m_bFilterList && !m_bFilterListFilled)
		implInitFilterList();
}

//------------------------------------------------------------------------------
sal_Bool SAL_CALL FmXFilterControl::commit() throw(::com::sun::star::uno::RuntimeException)
{
	::rtl::OUString aText;
	switch (m_nControlClass)
	{
		case ::com::sun::star::form::FormComponentType::TEXTFIELD:
		case ::com::sun::star::form::FormComponentType::COMBOBOX:
		{
			Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
			if (xText.is())
				aText = xText->getText();
		}	break;
		default:
			return sal_True;
	}
	if (m_aText.compareTo(aText))
	{
		// check the text with the SQL-Parser
		::rtl::OUString aNewText(aText);
		aNewText.trim();
		if (aNewText.getLength())
		{
			::rtl::OUString  aErrorMsg;
			::com::sun::star::lang::Locale aAppLocale = Application::GetSettings().GetUILocale();
			::rtl::Reference< ISQLParseNode > xParseNode = predicateTree(aErrorMsg, aNewText, m_xFormatter, m_xField);

			if ( !xParseNode.is() )
			{	// is it a text field ?

				// get the type
				sal_Int32 nType = DataType::OTHER;
				m_xField->getPropertyValue( FM_PROP_FIELDTYPE ) >>= nType;

				if	(	( DataType::CHAR		== nType )
					||	( DataType::VARCHAR		== nType )
					||	( DataType::LONGVARCHAR	== nType )
					)
				{	// yes -> force a quoted text and try again
					String sQuoted(aNewText);
					if	(	sQuoted.Len()
						&&	(	( sQuoted.GetChar( 0 ) != '\'' )
							||	( sQuoted.GetChar( sQuoted.Len() - 1 ) != '\'' )
							)
						)
					{
						sQuoted.SearchAndReplaceAll( '\'', String::CreateFromAscii( "''" ) );
						String sTemp( '\'' );
						( sTemp += sQuoted ) += '\'';
						sQuoted = sTemp;
					}
					xParseNode = predicateTree( aErrorMsg, sQuoted, m_xFormatter, m_xField );
				}
			}

			if (xParseNode.is())
			{
				::rtl::OUString aPreparedText;
				xParseNode->parseNodeToPredicateStr(aPreparedText,
										   m_xMetaData,
										   m_xFormatter,
										   m_xField,aAppLocale,'.');
				aNewText = aPreparedText;
			}
			else
			{
				// display the error and return sal_False
				
				SQLContext aError;
				aError.Message = String(SVX_RES(RID_STR_SYNTAXERROR));
				aError.Details = aErrorMsg;
				displayException(aError, m_pWindow);

				return sal_False;
			}
		}

		setText(aNewText);
		::com::sun::star::awt::TextEvent aEvt;
		aEvt.Source = *this;
		::cppu::OInterfaceIteratorHelper aIt( m_aTextListeners );
		while( aIt.hasMoreElements() )
			((::com::sun::star::awt::XTextListener *)aIt.next())->textChanged( aEvt );
	}
	return sal_True;
}

// ::com::sun::star::awt::XTextComponent
//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::addTextListener(const Reference< ::com::sun::star::awt::XTextListener > & l) throw(::com::sun::star::uno::RuntimeException)
{
	m_aTextListeners.addInterface( l );
}

//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::removeTextListener(const Reference< ::com::sun::star::awt::XTextListener > & l) throw(::com::sun::star::uno::RuntimeException)
{
	m_aTextListeners.removeInterface( l );
}

//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::setText( const ::rtl::OUString& aText ) throw(::com::sun::star::uno::RuntimeException)
{
	switch (m_nControlClass)
	{
		case ::com::sun::star::form::FormComponentType::CHECKBOX:
		{
			Reference< ::com::sun::star::awt::XVclWindowPeer >  xVclWindow(mxPeer, UNO_QUERY);
			if (xVclWindow.is())
			{
				Any aValue;
				if (aText.equals(::rtl::OUString::createFromAscii("1")))
					aValue <<= (sal_Int32)STATE_CHECK;
				else if (aText.compareTo(::rtl::OUString::createFromAscii("0")) == 0)
					aValue <<= (sal_Int32)STATE_NOCHECK;
				else
					aValue <<= (sal_Int32)STATE_DONTKNOW;

				m_aText = aText;
				xVclWindow->setProperty(FM_PROP_STATE, aValue);
			}
		}	break;
		case ::com::sun::star::form::FormComponentType::RADIOBUTTON:
		{
			Reference< ::com::sun::star::awt::XVclWindowPeer >  xVclWindow(mxPeer, UNO_QUERY);
			if (xVclWindow.is())
			{
				::rtl::OUString aRefText = ::comphelper::getString(com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > (getModel(), UNO_QUERY)->getPropertyValue(FM_PROP_REFVALUE));
				Any aValue;
				if (aText == aRefText)
					aValue <<= (sal_Int32)STATE_CHECK;
				else
					aValue <<= (sal_Int32)STATE_NOCHECK;
				m_aText = aText;
				xVclWindow->setProperty(FM_PROP_STATE, aValue);
			}
		}	break;
		case ::com::sun::star::form::FormComponentType::LISTBOX:
		{
			Reference< ::com::sun::star::awt::XListBox >  xListBox( mxPeer, UNO_QUERY );
			if (xListBox.is())
			{
				m_aText = aText;
				xListBox->selectItem(m_aText, sal_True);
			}
		} break;
		default:
		{
			Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
			if (xText.is())
			{
				m_aText = aText;
				xText->setText(aText);
			}
		}
	}
}

//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::insertText( const ::com::sun::star::awt::Selection& rSel, const ::rtl::OUString& aText ) throw(::com::sun::star::uno::RuntimeException)
{
	Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
	if (xText.is())
	{
		xText->insertText(rSel, aText);
		m_aText = xText->getText();
	}
}

//------------------------------------------------------------------------------
::rtl::OUString SAL_CALL FmXFilterControl::getText() throw(::com::sun::star::uno::RuntimeException)
{
	return m_aText;
}

//------------------------------------------------------------------------------
::rtl::OUString SAL_CALL FmXFilterControl::getSelectedText( void ) throw(::com::sun::star::uno::RuntimeException)
{
	::rtl::OUString aSelected;
	Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
	if (xText.is())
		aSelected = xText->getSelectedText();

	return aSelected;
}

//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::setSelection( const ::com::sun::star::awt::Selection& aSelection ) throw(::com::sun::star::uno::RuntimeException)
{
	Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
	if (xText.is())
		xText->setSelection( aSelection );
}

//------------------------------------------------------------------------------
::com::sun::star::awt::Selection SAL_CALL FmXFilterControl::getSelection( void ) throw(::com::sun::star::uno::RuntimeException)
{
	::com::sun::star::awt::Selection aSel;
	Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
	if (xText.is())
		aSel = xText->getSelection();
	return aSel;
}

//------------------------------------------------------------------------------
sal_Bool SAL_CALL FmXFilterControl::isEditable( void ) throw(::com::sun::star::uno::RuntimeException)
{
	Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
	return xText.is() && xText->isEditable();
}

//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::setEditable( sal_Bool bEditable ) throw(::com::sun::star::uno::RuntimeException)
{
	Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
	if (xText.is())
		xText->setEditable(bEditable);
}

//------------------------------------------------------------------------------
sal_Int16 SAL_CALL FmXFilterControl::getMaxTextLen() throw(::com::sun::star::uno::RuntimeException)
{
	Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
	return xText.is() ? xText->getMaxTextLen() : 0;
}

//------------------------------------------------------------------------------
void SAL_CALL FmXFilterControl::setMaxTextLen( sal_Int16 nLength ) throw(::com::sun::star::uno::RuntimeException)
{
	Reference< ::com::sun::star::awt::XTextComponent >  xText( mxPeer, UNO_QUERY );
	if (xText.is())
		xText->setMaxTextLen(nLength);
}

