/*************************************************************************
 *
 *  $RCSfile: taborder.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: hjs $ $Date: 2001/09/12 18:10:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_FMCTRLER_HXX
#include "fmctrler.hxx"
#endif

#ifndef _SVX_TABORDER_HXX
#include "taborder.hxx"
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#ifndef _WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SV_IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif
#include "taborder.hrc"

#ifndef _SVDPAGV_HXX
#include "svdpagv.hxx"
#endif

#ifndef _SVX_FMUNOPGE_HXX
#include "fmpgeimp.hxx"
#endif

#ifndef _SVX_FMPAGE_HXX
#include "fmpage.hxx"
#endif

#ifndef _SVX_FMSHELL_HXX
#include "fmshell.hxx"
#endif

#ifndef _SVX_FMTOOLS_HXX
#include "fmtools.hxx"
#endif

#ifndef _SVX_FMPROP_HXX
#include "fmprop.hxx"
#endif

#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif

#ifndef _SVX_DIALMGR_HXX //autogen
#include "dialmgr.hxx"
#endif

#ifndef _SVX_FMGLOB_HXX
#include "fmglob.hxx"
#endif

#ifndef _SVX_FMHELP_HRC
#include "fmhelp.hrc"
#endif
#ifndef _SV_SCRBAR_HXX
#include <vcl/scrbar.hxx>
#endif // _SV_SCRBAR_HXX

#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

using namespace ::svxform;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::datatransfer;

//========================================================================
// Tabcontroller zum setzen der Autoorder
class FmXTabModel :	public ::cppu::WeakImplHelper1< ::com::sun::star::awt::XTabControllerModel>
{
	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > > m_aModels;

public:
	FmXTabModel(const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > >& rModels)
		:m_aModels(rModels){}

	// ::com::sun::star::awt::XTabControllerModel
	virtual void SAL_CALL setControlModels(const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  >& rModels) throw( ::com::sun::star::uno::RuntimeException ) {m_aModels = rModels;}
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  > SAL_CALL getControlModels(void) throw( ::com::sun::star::uno::RuntimeException ) {return m_aModels;}
	virtual void SAL_CALL setGroup(const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  >& Group, const ::rtl::OUString& GroupName) throw( ::com::sun::star::uno::RuntimeException ) {}
	virtual sal_Int32 SAL_CALL getGroupCount(void) throw( ::com::sun::star::uno::RuntimeException ) {return 0;}
	virtual void SAL_CALL getGroup(sal_Int32 nGroup, ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  >& Group, ::rtl::OUString& Name) throw( ::com::sun::star::uno::RuntimeException ) {}
	virtual void SAL_CALL getGroupByName(const ::rtl::OUString& Name, ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  >& Group) throw( ::com::sun::star::uno::RuntimeException ) {}
	virtual sal_Bool SAL_CALL getGroupControl(void) throw( ::com::sun::star::uno::RuntimeException ){return sal_False;} ;
	virtual void SAL_CALL setGroupControl(sal_Bool GroupControl) throw( ::com::sun::star::uno::RuntimeException ){};
};

// class FmOrderTreeListBox
//========================================================================
DBG_NAME(FmOrderTreeListBox);
//------------------------------------------------------------------------
FmOrderTreeListBox::FmOrderTreeListBox( Window* pParent )
	:SvTreeListBox( pParent, WB_BORDER )
	,m_aFieldExchange( this )
{
	DBG_CTOR(FmOrderTreeListBox,NULL);
	// damit das AcceptDrop der Basisklasse das Scrollen am Fensterrand erledigt :
	SetDragDropMode(0xFFFF/*SV_DRAGDROP_CTRL_MOVE*/);
		// das Flag allein reicht nicht aus, um in AcceptDrop ein Scrollen zu erreichen ...
		// also auf Nummer sicher gehen ...

	SetSelectionMode( MULTIPLE_SELECTION );
}
//------------------------------------------------------------------------
FmOrderTreeListBox::FmOrderTreeListBox( Window* pParent, const ResId& rResId  )
	:SvTreeListBox( pParent, rResId  )
	,m_aFieldExchange( this )
{
	DBG_CTOR(FmOrderTreeListBox,NULL);
	SetDragDropMode(0xFFFF/*SV_DRAGDROP_CTRL_MOVE*/);
		// das Flag allein reicht nicht aus, um in AcceptDrop ein Scrollen zu erreichen ...
		// also auf Nummer sicher gehen ...

	SetSelectionMode( MULTIPLE_SELECTION );
}

//------------------------------------------------------------------------
FmOrderTreeListBox::~FmOrderTreeListBox()
{
	DBG_DTOR(FmOrderTreeListBox,NULL);
}

//------------------------------------------------------------------------
sal_Int8 FmOrderTreeListBox::ExecuteDrop( const ExecuteDropEvent& rEvt )
{
	// no drop if we're not the source ourself
	if (!m_aFieldExchange.isDragSource())
		return DND_ACTION_NONE;

	SvLBoxEntry* pDragEntry = m_aFieldExchange->focused();

	SvLBoxEntry* pDropEntry = GetEntry( rEvt.maPosPixel );
	if( !pDropEntry )
		return DND_ACTION_NONE;

	// move selection
	sal_uInt32 nDropPos = GetModel()->GetAbsPos( pDropEntry );
	sal_uInt32 nDragPos = GetModel()->GetAbsPos( pDragEntry );

	sal_uInt32 nDragDelta = nDropPos-nDragPos;
	MoveSelection( nDragDelta );

	return DND_ACTION_MOVE;
}

//------------------------------------------------------------------------
sal_Int8 FmOrderTreeListBox::AcceptDrop( const AcceptDropEvent& rEvt )
{
	// no drop if we're not the source ourself
	if (!m_aFieldExchange.isDragSource())
		return DND_ACTION_NONE;

	// no drop if we don't know the format
	if (!OControlExchange::hasFieldExchangeFormat(GetDataFlavorExVector()))
	{
		DBG_ERROR("FmOrderTreeListBox::AcceptDrop: invalid format!");
		return DND_ACTION_NONE;
	}

	// drop position
	SvLBoxEntry* pDropEntry = GetEntry( rEvt.maPosPixel );
	if( !pDropEntry )
		return DND_ACTION_NONE;

	ShowFocusRect( pDropEntry );

	// the entries which were selected when the drag started
	const ::std::vector< SvLBoxEntry* >& aSelected = m_aFieldExchange->selected();
	DBG_ASSERT(aSelected.size(), "FmOrderTreeListBox::AcceptDrop: invalid drag data!");
	if (!aSelected.size())
		return DND_ACTION_NONE;

	// Wenn Selektion durch Drag aus der Liste geschoben wird, return sal_False
	long nFirstSelPos = GetModel()->GetAbsPos( aSelected[0] );
	long nLastSelPos  = GetModel()->GetAbsPos( aSelected[aSelected.size() - 1] );
	long nDropPos	  = GetModel()->GetAbsPos( pDropEntry );
	long nDragPos     = GetModel()->GetAbsPos( m_aFieldExchange->focused() );

	long nDragDelta = nDropPos-nDragPos;

	if( (nFirstSelPos+nDragDelta) < 0 )
		return DND_ACTION_NONE;

	if( (nLastSelPos+nDragDelta) > (GetEntryCount()-1) )
		return DND_ACTION_NONE;

	long nVisibleSize = GetVScroll()->GetVisibleSize();
	long nFirstEntryInView = GetModel()->GetAbsPos( GetFirstEntryInView() );

	if((nVisibleSize+nFirstEntryInView) <= nDropPos)
		GetVScroll()->DoScrollAction(SCROLL_LINEDOWN);
	else if(nFirstEntryInView >= nDropPos)
		GetVScroll()->DoScrollAction(SCROLL_LINEUP);

	return DND_ACTION_MOVE;
}

//------------------------------------------------------------------------
void FmOrderTreeListBox::StartDrag( sal_Int8 _nAction, const Point& _rPosPixel )
{
	SvLBoxEntry* pSelected = GetEntry( _rPosPixel );
	if (!pSelected)
		return;

	m_aFieldExchange.prepareDrag();
	m_aFieldExchange->setFocusEntry( pSelected );

	pSelected = FirstSelected();
	while (pSelected)
	{
		m_aFieldExchange->addSelectedEntry( pSelected );
		pSelected = NextSelected( pSelected );
	}

	m_aFieldExchange.startDrag( DND_ACTION_MOVE );
}

//------------------------------------------------------------------------
void FmOrderTreeListBox::MoveSelection( long nRelPos )
{
	long loop = labs(nRelPos);
	UniString aSelEntryPrevText,aSelEntryNextText;
	Image  aImage;
	for (long i=0; i<labs(nRelPos); i++)
	{
		// ObButton beim Parent einschalten
		((FmTabOrderDlg*)Window::GetParent())->SetModified();

		//////////////////////////////////////////////////////////////////////
		// Eintraege verschieben
		if( nRelPos < 0 )
		{
			SvLBoxEntry* pFirstSelected = FirstSelected();
			if( !pFirstSelected ) return;
			sal_uInt32 nFirstSelPos = GetModel()->GetAbsPos( pFirstSelected );
			if( nFirstSelPos == 0 ) return;

			SvLBoxEntry* pSelEntry = pFirstSelected;
			while( pSelEntry )
			{
				sal_uInt32 nSelEntryPos = GetModel()->GetAbsPos( pSelEntry );
				SvLBoxEntry* pSelEntryPrev = GetEntry( nSelEntryPos-1 );
				aSelEntryPrevText = GetEntryText( pSelEntryPrev );
				aImage = GetExpandedEntryBmp(pSelEntryPrev);
				void*  pData = pSelEntryPrev->GetUserData();

				GetModel()->Remove( pSelEntryPrev );
				InsertEntry( aSelEntryPrevText, aImage, aImage, 0, sal_False, nSelEntryPos, pData );

				pSelEntry = NextSelected( pSelEntry );
			}
		}

		else if( nRelPos > 0 )
		{
			SvLBoxEntry* pLastSelected = LastSelected();
			if( !pLastSelected ) return;
			sal_uInt32 nLastSelPos = GetModel()->GetAbsPos( pLastSelected );

			if( (nLastSelPos + nRelPos - i) > (GetEntryCount()-1) ) return;
			sal_uInt32 nSelCount = GetSelectionCount();


			SvLBoxEntry* pSelEntry = pLastSelected;
			while( pSelEntry )
			{
				sal_uInt32 nSelEntryPos = GetModel()->GetAbsPos( pSelEntry );
				SvLBoxEntry* pSelEntryNext = GetEntry( nSelEntryPos+1 );
				void* pData = pSelEntryNext->GetUserData();

				aSelEntryNextText = GetEntryText( pSelEntryNext );
				aImage = GetExpandedEntryBmp(pSelEntryNext);

				GetModel()->Remove( pSelEntryNext );
				InsertEntry( aSelEntryNextText, aImage, aImage, 0, sal_False, nSelEntryPos, pData );

				pSelEntry = PrevSelected( pSelEntry );
			}
			long nThumbPos		= GetVScroll()->GetThumbPos();
			long nVisibleSize	= GetVScroll()->GetVisibleSize();
			long nFirstVisible = GetModel()->GetAbsPos( FirstVisible());

			if((nThumbPos+nVisibleSize+1) < (nLastSelPos+3))
				GetVScroll()->DoScrollAction(SCROLL_LINEDOWN);
			else if((nThumbPos+nVisibleSize+1) >= (nFirstVisible))
				GetVScroll()->DoScrollAction(SCROLL_LINEUP);
		}
	}
}

// class FmTabOrderDlg
//========================================================================
DBG_NAME(FmTabOrderDlg);
//------------------------------------------------------------------------
FmTabOrderDlg::FmTabOrderDlg(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >&	_xORB,
							 Window * pParent, FmFormShell* pShell )
			  :ModalDialog( pParent, SVX_RES(RID_SVXDLG_TAB_ORDER) )
			  ,aPB_OK( this, ResId(PB_OK) )
			  ,aPB_CANCEL( this, ResId(PB_CANCEL) )
			  ,aPB_HELP( this, ResId(PB_HELP) )
              ,aFT_Controls( this, SVX_RES(FT_CONTROLS) )
			  ,aPB_MoveUp( this, SVX_RES(PB_MOVE_UP) )
			  ,aPB_MoveDown( this, SVX_RES(PB_MOVE_DOWN) )
			  ,aPB_AutoOrder( this, SVX_RES(PB_AUTO_ORDER) )
			  ,aLB_Controls(this,SVX_RES(CTRL_TREE) )
			  ,pDrawModel(NULL)
			  ,pImageList(NULL)
			  ,m_xORB(_xORB)
{
	DBG_CTOR(FmTabOrderDlg,NULL);
	aPB_MoveUp.SetClickHdl( LINK( this, FmTabOrderDlg, MoveUpClickHdl ) );
	aPB_MoveDown.SetClickHdl( LINK( this, FmTabOrderDlg, MoveDownClickHdl ) );
	aPB_AutoOrder.SetClickHdl( LINK( this, FmTabOrderDlg, AutoOrderClickHdl ) );
	aPB_OK.SetClickHdl( LINK( this, FmTabOrderDlg, OKClickHdl ) );
	aPB_OK.Disable();

//	pLB_Controls = new FmOrderTreeListBox( this );
//	pLB_Controls->SetPosSizePixel( LogicToPixel(Point(12, 18),MAP_APPFONT),
//								  LogicToPixel(::com::sun::star::awt::Size(88, 132),MAP_APPFONT) );
//	pLB_Controls->Show();
//	pLB_Controls->SetHelpId(HID_TABORDER_CONTROLS);

	pImageList = new ImageList( SVX_RES(RID_SVXIMGLIST_FMEXPL) );

	if (pShell && pShell->GetCurPage() && pShell->GetFormView())
	{
		pDrawModel = pShell->GetCurPage()->GetModel();

		xModel = ::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabControllerModel > (pShell->GetCurPage()->GetImpl()->getCurForm(), ::com::sun::star::uno::UNO_QUERY);
		if (xModel.is())
			xTempModel = new FmXTabModel(xModel->getControlModels());

		SdrPageView* pPageView = pShell->GetFormView()->GetPageViewPvNum(0);
		xControlContainer	   = pPageView->GetWinList()[0].GetControlContainerRef();

		if (xTempModel.is() && xControlContainer.is())
			FillList();
	}

	if (aLB_Controls.GetEntryCount() < 2)
	{
		aPB_MoveUp.Disable();
		aPB_MoveDown.Disable();
		aPB_AutoOrder.Disable();
	}

	FreeResource();
}

//------------------------------------------------------------------------
void FmTabOrderDlg::SetModified()
{
	aPB_OK.Enable();
}

//------------------------------------------------------------------------
FmTabOrderDlg::~FmTabOrderDlg()
{
	aLB_Controls.Hide();
	//	delete pLB_Controls;
	delete pImageList;
	DBG_DTOR(FmTabOrderDlg,NULL);
}

//------------------------------------------------------------------------
Image FmTabOrderDlg::GetImage(const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & xSet) const
{
	//////////////////////////////////////////////////////////////////////
	// Default-Image
	Image aImage = pImageList->GetImage( RID_SVXIMG_CONTROL );
	if (xSet.is())
	{
		if (::comphelper::hasProperty(FM_PROP_CLASSID, xSet))
		{
			switch( ::comphelper::getINT16(xSet->getPropertyValue(FM_PROP_CLASSID)))
			{
				case ::com::sun::star::form::FormComponentType::COMMANDBUTTON:
					aImage = pImageList->GetImage( RID_SVXIMG_BUTTON );
					break;

				case ::com::sun::star::form::FormComponentType::FIXEDTEXT:
					aImage = pImageList->GetImage( RID_SVXIMG_FIXEDTEXT );
					break;

				case ::com::sun::star::form::FormComponentType::TEXTFIELD:
					aImage = pImageList->GetImage( RID_SVXIMG_EDIT );
					break;

				case ::com::sun::star::form::FormComponentType::RADIOBUTTON:
					aImage = pImageList->GetImage( RID_SVXIMG_RADIOBUTTON );
					break;

				case ::com::sun::star::form::FormComponentType::CHECKBOX:
					aImage = pImageList->GetImage( RID_SVXIMG_CHECKBOX );
					break;

				case ::com::sun::star::form::FormComponentType::LISTBOX:
					aImage = pImageList->GetImage( RID_SVXIMG_LISTBOX );
					break;

				case ::com::sun::star::form::FormComponentType::COMBOBOX:
					aImage = pImageList->GetImage( RID_SVXIMG_COMBOBOX );
					break;

				case ::com::sun::star::form::FormComponentType::GROUPBOX:
					aImage = pImageList->GetImage( RID_SVXIMG_GROUPBOX );
					break;

				case ::com::sun::star::form::FormComponentType::IMAGEBUTTON:
					aImage = pImageList->GetImage( RID_SVXIMG_IMAGEBUTTON );
					break;

				case ::com::sun::star::form::FormComponentType::FILECONTROL:
					aImage = pImageList->GetImage( RID_SVXIMG_FILECONTROL );
					break;

				case ::com::sun::star::form::FormComponentType::HIDDENCONTROL:
					aImage = pImageList->GetImage( RID_SVXIMG_HIDDEN );
					break;

				case ::com::sun::star::form::FormComponentType::DATEFIELD:
					aImage = pImageList->GetImage( RID_SVXIMG_DATEFIELD );
					break;

				case ::com::sun::star::form::FormComponentType::TIMEFIELD:
					aImage = pImageList->GetImage( RID_SVXIMG_TIMEFIELD );
					break;

				case ::com::sun::star::form::FormComponentType::NUMERICFIELD:
					aImage = pImageList->GetImage( RID_SVXIMG_NUMERICFIELD );
					break;

				case ::com::sun::star::form::FormComponentType::CURRENCYFIELD:
					aImage = pImageList->GetImage( RID_SVXIMG_CURRENCYFIELD );
					break;

				case ::com::sun::star::form::FormComponentType::PATTERNFIELD:
					aImage = pImageList->GetImage( RID_SVXIMG_PATTERNFIELD );
					break;

				case ::com::sun::star::form::FormComponentType::IMAGECONTROL:
					aImage = pImageList->GetImage( RID_SVXIMG_IMAGECONTROL );
					break;

				case ::com::sun::star::form::FormComponentType::GRIDCONTROL:
					aImage = pImageList->GetImage( RID_SVXIMG_GRID );
					break;
			}
		}
	}
	return aImage;
}


//------------------------------------------------------------------------
void FmTabOrderDlg::FillList()
{
	aLB_Controls.Clear();

	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  > aControlModelSeq(xTempModel->getControlModels());
	const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > * pControlModels = aControlModelSeq.getConstArray();

	::rtl::OUString aName;
	Image aImage;
	for (sal_Int32 i=0; i < aControlModelSeq.getLength(); i++)
	{
		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >  xSet(pControlModels[i], ::com::sun::star::uno::UNO_QUERY);
		if (xSet.is())
		{
			aName = ::comphelper::getString(xSet->getPropertyValue(FM_PROP_NAME));
			aImage = GetImage(xSet);
			aLB_Controls.InsertEntry( aName, aImage, aImage, 0, sal_False, LIST_APPEND, (::com::sun::star::beans::XPropertySet*)xSet.get() );
		}
		else
		{
			// ohne PropertySet keine Taborder
			aLB_Controls.Clear();
			break;
		}
	}

	// Ersten Eintrag auswaehlen
	SvLBoxEntry* pFirstEntry = aLB_Controls.GetEntry(0);
	if( pFirstEntry )
		aLB_Controls.Select( pFirstEntry );
}

//------------------------------------------------------------------------
IMPL_LINK( FmTabOrderDlg, MoveUpClickHdl, Button*, pButton )
{
	aLB_Controls.MoveSelection( -1 );
	return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( FmTabOrderDlg, MoveDownClickHdl, Button*, pButton )
{
	aLB_Controls.MoveSelection( 1 );
	return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( FmTabOrderDlg, AutoOrderClickHdl, Button*, pButton )
{
	//////////////////////////////////////////////////////////////////////
	// Am TabController werden alle Controls einer Seite gesetzt. Mit
	// dem TabControllerModel werden nur die Controls der aktuellen
	// ::com::sun::star::form ausgeblendet. Die WinRecs beschreiben jeweils ein Fenster,
	// mit dem die PageView angezeigt wird. (Eine ::com::sun::star::sdbcx::View kann z.B. durch
	// WinSplitting in mehreren Fenstern dargestellt werden.)
	// An einem dieser Fenster kann man sich den ControlContainer abholen.
	::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabController >  xTabController = new FmXFormController(m_xORB);
	xTabController->setModel( xTempModel );
	xTabController->setContainer( xControlContainer );
	xTabController->autoTabOrder();

	SetModified();

	FillList();

	::comphelper::disposeComponent(xTabController);
	return 0;
}

//------------------------------------------------------------------------
IMPL_LINK( FmTabOrderDlg, OKClickHdl, Button*, pButton )
{
	//////////////////////////////////////////////////////////////////////
	// ListBoxEintraege in ::com::sun::star::uno::Sequence schreiben und am TabController setzen
	sal_uInt16 nEntryCount = aLB_Controls.GetEntryCount();
	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  > aSortedControlModelSeq( nEntryCount );
	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  > aControlModelSeq( xTempModel->getControlModels());
	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > * pSortedControlModels = aSortedControlModelSeq.getArray();
	const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > * pControlModels = aControlModelSeq.getConstArray();

	for (sal_uInt16 i=0; i < nEntryCount; i++)
	{
		SvLBoxEntry* pEntry = aLB_Controls.GetEntry(i);

		// Aus der ControlModelSeq richtigen Namen holen
		for( sal_Int32 j=0; j<aControlModelSeq.getLength(); j++ )
		{
			::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >  xSet(pControlModels[j], ::com::sun::star::uno::UNO_QUERY);
			if ((::com::sun::star::beans::XPropertySet*)xSet.get() == ((::com::sun::star::beans::XPropertySet*)pEntry->GetUserData()))
			{
				pSortedControlModels[i] = pControlModels[j];
				break;
			}
		}
	}

	// UndoKlammerung
	pDrawModel->BegUndo(SVX_RES(RID_STR_UNDO_TABORDER));
	xModel->setControlModels( aSortedControlModelSeq );
	pDrawModel->EndUndo();

	EndDialog( sal_True );
	return 0;
}

