/*************************************************************************
 *
 *  $RCSfile: isbxobj.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_ISBXOBJ_HXX
#define _SVX_ISBXOBJ_HXX

// include ---------------------------------------------------------------

#ifndef _AUTO_HXX //autogen
#include <so3/auto.hxx>
#endif

//#include "svxids.hrc"
#include "tstpitem.hxx"

//-------------------------------------------------------------------------

class SvxTabStopObject_Impl: public SvDispatch

/*	[Beschreibung]

	Diese SbxObject-Subklasse kann Instanzen der Klasse <SvxTabStopsItem>
	im SBX-System recorden und wieder abspielen. Ein Item mit einem Dezimal-
	und einem Links-Tab wird wie folgt recorded (das WITH-Statement kommt
	dabei vom Sfx-Makro-Recorder, nur die Insert-Statements werden hier
	generiert):

		DIM aTabStops1 AS NEW TabStops
		WITH aTabStops1
			Insert( 2343, "D", ",", " " )
			Insert( 5343, "L", " ", "." )
		END WITH

	 Die Positionsangaben sind noch in Core-Ma\seinheiten, da ich diese
	 noch nicht kenne (also nicht umrechnen kann).

	 Desweiteren gibt es die folgenden Sbx-Methoden an diesem Objekt:

		int 	GetCount()
		long	GetPosition()
		String	GetAdjust()
		String	GetDecimalChar()
		String	GetFillChar()


	[Anmerkung]

	SbxObjects, die nur aus einfachen (keine Arrays) Properties bestehen,
	brauchen nur den Konstruktor implementieren, da die Basisklasse
	<SbxObject> Properties bereits selbst recorden kann. Notify() ist
	dann i.d.R. auch automatisch korrekt implemementiert.
*/

{
	SvxTabStopItem* 		pTabs;	// Container f"ur die TabStops
	SbxVariableRef			xVar;	// zum Benachrichtigen

private:
	char					GetAdjustChar( SvxTabAdjust eAdj );

protected:
	void					SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
									const SfxHint& rHint, const TypeId& rHintType );

public:
							TYPEINFO();
							SvxTabStopObject_Impl();
							SvxTabStopObject_Impl( SbxVariable *pVar,
												   const SvxTabStopItem &rTabs );
							~SvxTabStopObject_Impl();

	const SvxTabStopItem&	GetTabStops() const { return *pTabs; }

	virtual String 			GenerateSource( const String &rLinePrefix,
											const SbxObject *pRelativeTo );
};


#endif

