/*************************************************************************
 *
 *  $RCSfile: swbaslnk.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jp $ $Date: 2001/03/08 21:17:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SWBASLNK_HXX
#define _SWBASLNK_HXX


#ifndef _LNKBASE_HXX //autogen
#include <so3/lnkbase.hxx>
#endif

class SwNode;
class SwCntntNode;
class SwNodeIndex;

class SwBaseLink : public ::so3::SvBaseLink
{
	SwCntntNode* pCntntNode;
	BOOL bSwapIn : 1;
	BOOL bNoDataFlag : 1;
	BOOL bIgnoreDataChanged : 1;

protected:
	SwBaseLink() {}

	SwBaseLink( const String& rNm, USHORT nObjectType, ::so3::SvLinkSource* pObj,
				 SwCntntNode* pNode = 0 )
		: ::so3::SvBaseLink( rNm, nObjectType, pObj ), pCntntNode( pNode ),
		bSwapIn( FALSE ), bNoDataFlag( FALSE ), bIgnoreDataChanged( FALSE )
	{}

public:
	TYPEINFO();

	SwBaseLink( USHORT nMode, USHORT nFormat, SwCntntNode* pNode = 0 )
		: ::so3::SvBaseLink( nMode, nFormat ), pCntntNode( pNode ),
		bSwapIn( FALSE ), bNoDataFlag( FALSE ), bIgnoreDataChanged( FALSE )
	{}
	virtual ~SwBaseLink();

	virtual void DataChanged( const String& rMimeType,
								const ::com::sun::star::uno::Any & rValue );

	virtual void Closed();

	virtual const SwNode* GetAnchor() const;

	SwCntntNode *GetCntntNode() { return pCntntNode; }

	// nur fuer Grafiken
	FASTBOOL SwapIn( BOOL bWaitForData = FALSE, BOOL bNativFormat = FALSE );

	FASTBOOL IsShowQuickDrawBmp() const;				// nur fuer Grafiken

	FASTBOOL Connect() { return 0 != SvBaseLink::GetRealObject(); }

	// nur fuer Grafik-Links ( zum Umschalten zwischen DDE / Grf-Link)
	void SetObjType( USHORT nType )	{ SvBaseLink::SetObjType( nType ); }

	BOOL IsRecursion( const SwBaseLink* pChkLnk ) const;
	virtual BOOL IsInRange( ULONG nSttNd, ULONG nEndNd, xub_StrLen nStt = 0,
							xub_StrLen nEnd = STRING_NOTFOUND ) const;

	void SetNoDataFlag()	{ bNoDataFlag = TRUE; }
	BOOL ChkNoDataFlag()	{ return bNoDataFlag ? !(bNoDataFlag = FALSE) : FALSE; }
	BOOL IsNoDataFlag()	const			{ return bNoDataFlag; }
};


#endif

