/*************************************************************************
 *
 *  $RCSfile: sw3gsect.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mib $ $Date: 2001/08/01 14:00:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "core_pch.hxx"
#endif

#pragma hdrstop

#define _SVSTDARR_STRINGSDTOR
#define _SVSTDARR_STRINGS
#include <svtools/svstdarr.hxx>

#ifndef _SFXMACITEM_HXX //autogen
#include <svtools/macitem.hxx>
#endif
#ifndef _TOOLS_TENCCVT_HXX //autogen
#include <tools/tenccvt.hxx>
#endif

#include "swerror.h"
#include "sw3imp.hxx"
#include "sw3ids.hxx"
#include "sw3marks.hxx"
#include "section.hxx"


//////////////////////////////////////////////////////////////////////////////

ULONG Sw3IoImp::OpenStreamsForScan( SvStorage *pStor, BOOL bPageStyles )
{
	pOldRoot = pRoot;
	pRoot = pStor;

	USHORT nMode = STREAM_READ | STREAM_SHARE_DENYWRITE | STREAM_NOCREATE;

	Reset();

//	pCurIosys = this;

	if( !pRoot.Is() ||
		pRoot->GetError() != SVSTREAM_OK ||
		!pRoot->IsContained( N_DOC ) ||
		pRoot->IsStorage( N_DOC ) )
	{
		pRoot = pOldRoot;
		return ERR_SWG_READ_ERROR;
	}

	pContents = pRoot->OpenStream( N_DOC, nMode );
	pPageStyles = bPageStyles ? pRoot->OpenStream( N_PAGESTYLES, nMode ) : 0;

	if( pRoot->GetError() != SVSTREAM_OK ||
		!pContents.Is() || pContents->GetError() != SVSTREAM_OK ||
		( bPageStyles && (!pPageStyles.Is() ||
						  pPageStyles->GetError() != SVSTREAM_OK) ) )
	{
		pContents.Clear();
		pPageStyles.Clear();
		pRoot = pOldRoot;
		pOldRoot.Clear();
		// kein Reset, weil wir ausser pOld-Root nichts veraendert haben
		return ERR_SWG_READ_ERROR;
	}

	long nFFVersion = pRoot->GetVersion();
	ASSERT( nFFVersion == SOFFICE_FILEFORMAT_31 ||
			nFFVersion == SOFFICE_FILEFORMAT_40 ||
			nFFVersion == SOFFICE_FILEFORMAT_50,
			"Am Root-Storage ist keine FF-Version gesetzt!" );

	// eSrcSet is set to the value og gsl_getSystemSetEncoding in Reset()
	// MIB 31.07.01: Setting the charset here does not make nuch sense. 
	// However, the value set here will be replaced by the one stored in
	// the header before it is used.
	pContents->SetStreamCharSet( eSrcSet ),
	pContents->SetVersion( nFFVersion );
	if( pPageStyles.Is() )
	{
		pPageStyles->SetStreamCharSet( eSrcSet );
		pPageStyles->SetVersion( nFFVersion );
	}
	OutputMode( FALSE );

	return 0;
}

void Sw3IoImp::CloseStreamsForScan()
{
	pContents.Clear();
	pPageStyles.Clear();
	Reset();

	pRoot = pOldRoot;
	pOldRoot.Clear();
}

BOOL Sw3IoImp::InHeaderForScan( BOOL bReadRecSizes )
{
	BYTE cLen, cSet, cGUI;
	sal_Char cHdrSign[ 8 ];
	Reset2();
	OutputMode( FALSE );

	if( pStrm->Read( cHdrSign, 7 ) != 7 || !CheckHeader(cHdrSign) )
	{
		Error( ERR_SW6_NOWRITER_FILE );
		return FALSE;
	}

	*pStrm >> cLen;

	UINT32 nRecSzPos;
	ULONG nOld = pStrm->Tell();
	INT32 nDummy32;
	// nDummy8 war fuer IRIX mal unsigned char. Wenn das nicht durch
	// geht ist das ein Problem in stream.h und solar.h, aber keines hier
	INT8 nCompatVer, nDummy8;

	*pStrm >> nVersion >> nFileFlags >> nDummy32 >> nRecSzPos >> nDummy32
		   >> nDummy8 >> nDummy8 >> nDummy8 >> nCompatVer;
	if( nCompatVer > SWG_CVERSION )
	{
		Error( ERR_SWG_NEW_VERSION );
		return FALSE;
	}
	if( nFileFlags & SWGF_BAD_FILE )
	{
		Error( ERR_SWG_READ_ERROR );
		return FALSE;
	}

	pStrm->Read( cPasswd, 16L );
	*pStrm >> cSet >> cGUI >> nDate >> nTime;
	eSrcSet = GetSOLoadTextEncoding( (rtl_TextEncoding) cSet,
								  	 pStrm->GetVersion() );
	pStrm->SetStreamCharSet( eSrcSet );
	if( nFileFlags & SWGF_BLOCKNAME )
	{
		sal_Char cBuf[ 64 ];
		if( pStrm->Read( cBuf, 64 ) != 64 )
			pStrm->SetError( SVSTREAM_FILEFORMAT_ERROR );
	}
	ULONG nNew = pStrm->Tell();
	nOld += cLen;
	if( nOld != nNew )
		pStrm->Seek( nOld );

//	if( !CheckPasswd() )
//		Error( ERRCODE_SFX_WRONGPASSWORD );

	if( nRecSzPos!= 0 && bReadRecSizes && IsVersion(SWG_RECSIZES) )
		InRecSizes( nRecSzPos );

	return TRUE;
}


void Sw3IoImp::GetSectionList( SvStrings& rSectionList,
							   SvStringsDtor& rBookmarks )
{
	if( !InHeaderForScan(TRUE) )
		return;

	// Normales Lesen?
	BOOL bDone = BOOL( !Good() );
	while( !bDone )
	{
		BYTE cType = Peek();
		if( !Good() || pStrm->IsEof() )
			bDone = TRUE;
		else switch( cType )
		{
		case SWG_EOF:
			// fertig
			bDone = TRUE;
			break;
		case SWG_FLYFRAMES:
			{
				// die Seitengebundenen Rahmen durchforsten
				OpenRec( SWG_FLYFRAMES );
				while( BytesLeft() )
				{
					if( SWG_FLYFMT == Peek() )
						ScanFormat( SWG_FLYFMT, rSectionList, rBookmarks );
					else
						SkipRec();
				}
				CloseRec( SWG_FLYFRAMES );
			}
			break;
		case SWG_BOOKMARKS:
			{
				// die Bookmarks untersuchen
				OpenRec( SWG_BOOKMARKS );
				while( BytesLeft() )
				{
					String aName, aDummy;
					OpenRec( SWG_BOOKMARK );
					InString( *pStrm, aDummy );
					InString( *pStrm, aName );
					// Hier kommen noch mehr Daten, die aber
					// nicht benoetigt werden.
					CloseRec( SWG_BOOKMARK );

					// Bookmarks einfuegen, aber nicht doppelt
					for( USHORT i=0; i<rBookmarks.Count(); i++ )
						if( *(rBookmarks[i]) == aName )
							break;

					if( i==rBookmarks.Count() )
						rBookmarks.Insert( new String(aName), i );
				}
				CloseRec( SWG_BOOKMARKS );
			}
			break;
		case SWG_PAGEDESCS:
			{
				// Seitenbeschreibungen lesen
				OpenRec( SWG_PAGEDESCS );

				OpenFlagRec();
				USHORT nDesc;
				*pStrm >> nDesc;
				CloseFlagRec();

				for( USHORT i = 0; i < nDesc; i++ )
				{
					OpenRec( SWG_PAGEDESC );

					OpenFlagRec();
					// Der Inhalt des Flag-Records ist uninteressant
					CloseFlagRec();

					while( BytesLeft() )
					{
						if( SWG_ATTRSET == Peek() )
						{
							OpenRec( SWG_ATTRSET );

							while( BytesLeft() )
								ScanAttr( rSectionList, rBookmarks );

							CloseRec( SWG_ATTRSET );
						}
						else
							SkipRec();
					}
					CloseRec( SWG_PAGEDESC );
				}

				CloseRec( SWG_PAGEDESCS );
			}
			break;
		case SWG_CONTENTS:
			// den Inhalt durchkaemmen
			ScanContents( rSectionList, rBookmarks );
			break;
		default:
			// hier werden wir wohl nichts finden
			SkipRec();
		}
	}
}



void Sw3IoImp::ScanContents( SvStrings& rSectionList,
							 SvStringsDtor& rBookmarks )
{
	UINT16 nDummy16;
	String aDummy;

	OpenRec( SWG_CONTENTS );

	if( IsVersion(SWG_LAYFRAMES) )
	{
		OpenFlagRec();
		CloseFlagRec();
	}
	else
		*pStrm >> nDummy16; // nNodes

	while( BytesLeft() )
	{
		BYTE cType = Peek();
		switch( cType )
		{
		case SWG_TEXTNODE:
			{
				// Text-Nodes koennen absatz- und zeichengeb. Rahmen enthalten
				OpenRec( SWG_TEXTNODE );
				// Die Daten des Flag-Record werden automatisch ueberlesen.
				OpenFlagRec();
				CloseFlagRec();

				InString( *pStrm, aDummy );

				while( BytesLeft() )
				{
					BYTE cTypeText = Peek();
					switch( cTypeText )
					{
					case SWG_FLYFMT:
						// Absatzgebundener FlyFrame
						ScanFormat( SWG_FLYFMT, rSectionList, rBookmarks );
						break;
					case SWG_ATTRIBUTE:
						// vielleicht ein Rahmen oder eine Fussnote?
						ScanAttr( rSectionList, rBookmarks );
						break;
					case SWG_MARK:
						{
							// Hoppla, vielleicht eine Textmarke
							OpenRec( SWG_MARK );
							BYTE cType;
							USHORT nId;
							*pStrm >> cType >> nId;
							// Ab hier kommen nur noch uninterssante Daten
							CloseRec( SWG_MARK );
							if( SW3_BOOK_MARK==cType &&
								nId < rBookmarks.Count() )
							{
								// Ja, es ist noetig den String mit new
								// nochmal anzulegen, denn der Ptr in
								// rBookmarks ueberlebt den Aufruf von
								// Sw3Io::GetSectionList nicht!
								rSectionList.Insert(
									new String( *(rBookmarks[nId]) ),
											rSectionList.Count() );
							}
						}
						break;
					default:
						// woanders werden wir nichts finden
						SkipRec();
						break;
					}
				}
				CloseRec( SWG_TEXTNODE );
			}
			break;
		case SWG_TABLE:
			{
				// Tabellen enthalten natuerlich Inhalt
				OpenRec( SWG_TABLE );

				OpenFlagRec();
				CloseFlagRec();

				// optionales Rahmenformt
				if( SWG_FRAMEFMT == Peek() )
					SkipRec();

				// optionales DDE-Feld
				if( SWG_FIELDTYPE == Peek() )
					SkipRec();

				// die Zeilen scannen
				while( BytesLeft() )
					ScanTableLine( rSectionList, rBookmarks );

				CloseRec( SWG_TABLE );
			}
			break;
		case SWG_SECTION:
			{
				// Juchhu! Da haben wir ja gefunden wonach wir suchen
				OpenRec( SWG_SECTION );
				String aName;
				InString( *pStrm, aName );
				InString( *pStrm, aDummy );
				OpenFlagRec();
				UINT16 nType;
				*pStrm >> nType;
				CloseFlagRec();

				rSectionList.Insert( new String(aName), rSectionList.Count() );

				// das Format ueberlesen
				SkipRec();

				// jetzt kommt der Inhalt, wobei wir nicht an dem Inhalt
				// von gelinkten Sections interessiert sind
				if( CONTENT_SECTION == nType)
					ScanContents( rSectionList, rBookmarks );
				else
					SkipRec();
				// Ab hier kommen nur noch uninteressante Daten
				CloseRec( SWG_SECTION );
			}
			break;

		case SWG_FLYFMT:
			ScanFormat( SWG_FLYFMT, rSectionList, rBookmarks );
			break;

		default:
			// ueberall sonst werden wir nichts finden
			SkipRec();
		}
	}
	CloseRec( SWG_CONTENTS );
}



void Sw3IoImp::ScanTableLine( SvStrings& rSectionList,
							  SvStringsDtor& rBookmarks )
{
	OpenRec( SWG_TABLELINE );

	OpenFlagRec();
	CloseFlagRec();

	// optionales Frame-Format
	if( SWG_FRAMEFMT == Peek() )
		SkipRec();

	// die Zellen einlesen
	while( BytesLeft() )
	{
		OpenRec( SWG_TABLEBOX );
		OpenFlagRec();
		CloseFlagRec();

		// optionales Frame-Format
		if( SWG_FRAMEFMT == Peek() )
			SkipRec();

		if( SWG_CONTENTS == Peek() )
			// Edit-Box
			ScanContents( rSectionList, rBookmarks );
		else
		{
			// sonst die Zeilen durchsuchen
			while( BytesLeft() )
				ScanTableLine( rSectionList, rBookmarks );
		}
		CloseRec( SWG_TABLEBOX );
	}

	CloseRec( SWG_TABLELINE );
}



void Sw3IoImp::ScanFormat( BYTE cKind,
						   SvStrings& rSectionList,
						   SvStringsDtor& rBookmarks )
{
	USHORT nDummy16, nStrIdx = IDX_NO_VALUE;
	String aDummy;

	if( !OpenRec( cKind ) )
	{
		CloseRec( SWG_EOF );
		return;
	}

	BYTE cFlags = OpenFlagRec();
	*pStrm >> nDummy16 >> nDummy16;
	// 0x10 - Namensindex des Formats folgt
	// 0x20 - SdrObject-Referenz folgt
	if( cFlags & 0x10 )
		*pStrm >> nStrIdx;
	CloseFlagRec();

	if( nStrIdx == IDX_NO_VALUE )
		InString( *pStrm, aDummy );

	while( BytesLeft() )
	{
		if( SWG_ATTRSET == Peek() )
		{
			OpenRec( SWG_ATTRSET );

			while( BytesLeft() )
				ScanAttr( rSectionList, rBookmarks );

			CloseRec( SWG_ATTRSET );
		}
		else
			SkipRec();
	}

	CloseRec( cKind );
}

void Sw3IoImp::GetMacroTable( SvxMacroTableDtor& rMacroTbl )
{
	if( !InHeaderForScan(TRUE) )
		return;

	BOOL bDone = BOOL( !Good() );
	while( !bDone )
	{
		BYTE cType = Peek();
		if( !Good() || pStrm->IsEof() )
			bDone = TRUE;
		else switch( cType )
		{
		case SWG_EOF:
			bDone = TRUE;					// fertig
			break;
		case SWG_MACROTBL:
			ScanMacroTbl( rMacroTbl );
			bDone = TRUE;					// auch fertig
			break;
		default:
			// hier werden wir wohl nichts finden
			SkipRec();
		}
	}
}

void Sw3IoImp::ScanMacroTbl( SvxMacroTableDtor& rMacroTbl )
{
	OpenRec( SWG_MACROTBL );
	while( BytesLeft() )
	{
		OpenRec( SWG_MACRO );
		UINT16 nKey, nScriptType = STARBASIC;
		String aLib, aMac;
		*pStrm >> nKey;
		InString( *pStrm, aLib );
		InString( *pStrm, aMac );

		if( SWG_SVXMACROS <= nVersion )
			*pStrm >> nScriptType;
		rMacroTbl.Insert( nKey, new SvxMacro( aMac, aLib,
											  (ScriptType)nScriptType ) );
		CloseRec( SWG_MACRO );
	}
	CloseRec( SWG_MACROTBL );
}



