/*************************************************************************
 *
 *  $RCSfile: sw3npool.cxx,v $
 *
 *  $Revision: 1.9.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 13:39:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef PRECOMPILED
#include "core_pch.hxx"
#endif

#pragma hdrstop

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SFXMACITEM_HXX //autogen
#include <svtools/macitem.hxx>
#endif
#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif

#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _SWTABLE_HXX
#include <swtable.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>
#endif
#ifndef _PARATR_HXX
#include <paratr.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _CNTFRM_HXX
#include <cntfrm.hxx>
#endif
#ifndef _PAGEFRM_HXX
#include <pagefrm.hxx>
#endif
#ifndef _TXTFTN_HXX //autogen
#include <txtftn.hxx>
#endif
#ifndef _FMTFTN_HXX //autogen
#include <fmtftn.hxx>
#endif
#ifndef _FMTFLD_HXX //autogen
#include <fmtfld.hxx>
#endif
#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#ifndef _FMTCNTNT_HXX //autogen
#include <fmtcntnt.hxx>
#endif
#ifndef _FMTPDSC_HXX //autogen
#include <fmtpdsc.hxx>
#endif
#ifndef _FMTFLCNT_HXX //autogen
#include <fmtflcnt.hxx>
#endif
#ifndef _FMTRFMRK_HXX //autogen
#include <fmtrfmrk.hxx>
#endif
#ifndef _FCHRFMT_HXX //autogen
#include <fchrfmt.hxx>
#endif
#ifndef _FMTINFMT_HXX //autogen
#include <fmtinfmt.hxx>
#endif
#ifndef _FMTCNCT_HXX //autogen
#include <fmtcnct.hxx>
#endif
#ifndef _CHARFMT_HXX //autogen
#include <charfmt.hxx>
#endif
#ifndef _FTNINFO_HXX
#include <ftninfo.hxx>
#endif
#ifndef _SW3IMP_HXX
#include <sw3imp.hxx>
#endif
#ifndef _GRFATR_HXX
#include <grfatr.hxx>
#endif
#ifndef _CELLATR_HXX
#include <cellatr.hxx>
#endif
#ifndef _TOX_HXX
#include <tox.hxx>
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
#ifndef _NDINDEX_HXX
#include <ndindex.hxx>
#endif
#ifndef _FMTRUBY_HXX
#include <fmtruby.hxx>
#endif
#ifndef SW_TGRDITEM_HXX
#include <tgrditem.hxx>
#endif


#ifndef _SWERROR_H
#include <error.h>
#endif


#define URL_DECODE 	\
	, INetURLObject::WAS_ENCODED, INetURLObject::DECODE_UNAMBIGUOUS


// Diese Datei hat einige Besonderheiten:
// Die aktuelle Sw3IoImp-Instanz wird ueber Sw3IoImp::GetCurrentIo()
// angefordert. Da diese die Variable pStrm mit dem aktuellen I/O-
// Stream besetzt hat, muss dieser auf den uebergebenen Stream umgesetzt
// werden. Dabei wird angenommen, dass alle uebergebenen Streams
// SvStorageStreams sind.

////////////////////////////// Frame-Attribute ////////////////////////////

SfxPoolItem* SwFmtAnchor::Create( SvStream& rStrm, USHORT nIVer ) const
{
	BYTE cType;
	USHORT nIndex;
	rStrm >> cType;
	if( nIVer < IVER_FMTANCHOR_LONGIDX )
	{
		rStrm >> nIndex;
	}
	else
	{
		UINT32 nIndex32 = Sw3IoImp::InULong( rStrm );
		ASSERT( nIndex32 <= USHRT_MAX,
				"SwFmtAnchor: Index/Seitenzahl > USHRT_MAX" );
		nIndex = (USHORT)nIndex32;
	}
	// Dieser Anker ist fuer FLY_AT_CNTNT und FLY_IN_CNTNT
	// unvollstaendig und muss noch angepasst werden. Dies
	// geschieht nach dem Einlesen des FrmFmts in InTxtNode().
	return new SwFmtAnchor( (RndStdIds) cType, nIndex );
}

SvStream& SwFmtAnchor::Store( SvStream& rStrm, USHORT nIVer ) const
{
	const SwPosition* pPos = GetCntntAnchor();
	// Der Index hat das Offset fuer FLY_AT_CNTNT und FLY_IN_CNTNT,
	// sonst die Seitennummer.
	if( nIVer < IVER_FMTANCHOR_LONGIDX )
	{
		// Nur 3.1/4.0-Export
		ASSERT( SOFFICE_FILEFORMAT_40 >= rStrm.GetVersion(),
				"SwFmtAnchor:: FF-Version und Item-Version passen nicht" );

		Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();

		if( pIo->IsSw31Export() && pIo->pExportInfo &&
			pIo->pExportInfo->bDrwFrmFmt31 &&
			FLY_IN_CNTNT==GetAnchorId() )
		{
			// Statt der 0 koennte man auch den Node-Index rausschreiben, aber
			// wozu, wenn der eh gleich neu gesetzt wird?
			rStrm << (BYTE) FLY_AT_CNTNT // Igitt, war mal FLY_IN_CNTNT
				  << (USHORT) 0;
		}
		else if( FLY_AT_FLY == GetAnchorId() ||
				 FLY_AUTO_CNTNT == GetAnchorId() )
		{
			BYTE nAnchorId = GetAnchorId();
			USHORT nIndex;
			if( FLY_AT_FLY == nAnchorId )
			{
				nAnchorId = FLY_PAGE;
				SwNodeIndex aIdx( pPos->nNode );
				const SwNodes& rNds = aIdx.GetNodes();
				const SwCntntNode* pCNd = rNds.GoNext( &aIdx );
				const SwCntntFrm* pFrm;
				if( pCNd && 0 != ( pFrm = pCNd->GetFrm() ))
					nIndex = pFrm->FindPageFrm()->GetPhyPageNum();
				else
					nIndex = 1;
			}
			else
			{
				nAnchorId = FLY_AT_CNTNT;
				xub_StrLen nCntntIdx = pPos->nContent.GetIndex();
				nIndex = nCntntIdx <= STRING_MAXLEN52 ? nCntntIdx
													  : STRING_MAXLEN52;
			}
			rStrm << (BYTE) nAnchorId
				  << (USHORT) nIndex;
		}
		else
		{
			USHORT nIndex;
			if( pPos )
			{
				xub_StrLen nCntntIdx = pPos->nContent.GetIndex();
				nIndex = nCntntIdx <= STRING_MAXLEN52 ? nCntntIdx
													  : STRING_MAXLEN52;
			}
			else
				nIndex = GetPageNum();
			rStrm << (BYTE) GetAnchorId()
				  << (USHORT) nIndex;
		}
	}
	else
	{
		ASSERT( SOFFICE_FILEFORMAT_40 < rStrm.GetVersion(),
				"SwFmtAnchor:: FF-Version und Item-Version passen nicht" );
		ULONG nIndex = pPos ? pPos->nContent.GetIndex() : GetPageNum();
		if( nIndex > STRING_MAXLEN52 )
			nIndex = STRING_MAXLEN52;
		rStrm << (BYTE) GetAnchorId();
		Sw3IoImp::OutULong( rStrm, nIndex );
	}

	return rStrm;
}

USHORT SwFmtAnchor::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtAnchor: Gibt es ein neues Fileformat?" );
	return ( SOFFICE_FILEFORMAT_31==nFFVer ||
			 SOFFICE_FILEFORMAT_40==nFFVer ) ? 0 : IVER_FMTANCHOR_LONGIDX;
}

SfxPoolItem* SwFmtHeader::Create( SvStream& rStrm, USHORT ) const
{
	BYTE bActive;
	rStrm >> bActive;
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SvStream* p = pIo->pStrm;
	pIo->pStrm = (SvStorageStream*) &rStrm;

	USHORT eSave_StartNodeType = pIo->eStartNodeType;
	pIo->eStartNodeType = SwHeaderStartNode;

	SwFmtHeader* pAttr;
	if( pIo->Peek() == SWG_FREEFMT )
	{
		SwFrmFmt* pFmt = (SwFrmFmt*) pIo->InFormat( SWG_FREEFMT, NULL );
		if( pFmt )
		{
			pAttr = new SwFmtHeader( pFmt );
			pAttr->SetActive( BOOL( bActive ) );
		}
		else
			pIo->Error();
	}
	// Ohne Format ist das Attribut immer inaktiv!
	else pAttr = new SwFmtHeader( BOOL( FALSE ) );
	pIo->pStrm = p;
	pIo->eStartNodeType = eSave_StartNodeType;

	return pAttr;
}

SvStream& SwFmtHeader::Store( SvStream& rStrm, USHORT ) const
{
	rStrm << (BYTE) IsActive();
	const SwFrmFmt* pFmt = GetHeaderFmt();
	ASSERT( !IsActive() || pFmt, "Aktiver Header ohne Format" );
	if( pFmt )
	{
		Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
		SvStream* p = pIo->pStrm;
		pIo->pStrm = (SvStorageStream*) &rStrm;
		pIo->OutFormat( SWG_FREEFMT, *pFmt );
		pIo->pStrm = p;
	}
	return rStrm;
}

SfxPoolItem* SwFmtFooter::Create( SvStream& rStrm, USHORT ) const
{
	BYTE bActive;
	rStrm >> bActive;
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SvStream* p = pIo->pStrm;
	pIo->pStrm = (SvStorageStream*) &rStrm;

	USHORT eSave_StartNodeType = pIo->eStartNodeType;
	pIo->eStartNodeType = SwFooterStartNode;

	SwFmtFooter* pAttr;
	if( pIo->Peek() == SWG_FREEFMT )
	{
		SwFrmFmt* pFmt = (SwFrmFmt*) pIo->InFormat( SWG_FREEFMT, NULL );
		if( pFmt )
		{
			pAttr = new SwFmtFooter( pFmt );
			pAttr->SetActive( BOOL( bActive ) );
		}
		else
			pIo->Error();
	}
	// Ohne Format ist das Attribut immer inaktiv!
	else pAttr = new SwFmtFooter( BOOL( FALSE ) );
	pIo->pStrm = p;
	pIo->eStartNodeType = eSave_StartNodeType;

	return pAttr;
}

SvStream& SwFmtFooter::Store( SvStream& rStrm, USHORT ) const
{
	rStrm << (BYTE) IsActive();
	const SwFrmFmt* pFmt = GetFooterFmt();
	ASSERT( !IsActive() || pFmt, "Aktiver Footer ohne Format" );
	if( pFmt )
	{
		Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
		SvStream* p = pIo->pStrm;
		pIo->pStrm = (SvStorageStream*) &rStrm;
		pIo->OutFormat( SWG_FREEFMT, *pFmt );
		pIo->pStrm = p;
	}
	return rStrm;
}

SfxPoolItem* SwFmtCntnt::Create( SvStream& rStrm, USHORT ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SvStream* p = pIo->pStrm;
	pIo->pStrm = (SvStorageStream*) &rStrm;
	if( pIo->bInsert )
	{
		if( !pIo->pSectionDepths )
			pIo->pSectionDepths = new SvUShorts;
		pIo->pSectionDepths->Insert( (USHORT)0U, pIo->pSectionDepths->Count() );
	}
	SwStartNode* pSttNd = &pIo->InContents();
	if( pIo->bInsert )
	{
		ASSERT( pIo->pSectionDepths, "There is the section depth stack?" );
		ASSERT( pIo->pSectionDepths->Count() > 0U,
				"section depth stack is empty" );
		pIo->pSectionDepths->Remove( pIo->pSectionDepths->Count() - 1U );
	}
	pIo->pStrm = p;
	return new SwFmtCntnt( pSttNd );
}

SvStream& SwFmtCntnt::Store( SvStream& rStrm, USHORT ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SvStream* p = pIo->pStrm;
	pIo->pStrm = (SvStorageStream*) &rStrm;
	pIo->OutContents( *GetCntntIdx() );
	pIo->pStrm = p;
	return rStrm;
}

SfxPoolItem* SwFmtPageDesc::Create( SvStream& rStrm, USHORT nVersion ) const
{
	// Hier wird nur der Name im Attribut gesetzt. Spaeter wird
	// mit ConnectPageDescAttrs() die eigentliche Verbindung
	// hergestellt.
	BYTE bAuto;
	UINT16 nOff, nIdx;
	if( nVersion < IVER_FMTPAGEDESC_LONGPAGE )
	{
		if( nVersion < IVER_FMTPAGEDESC_NOAUTO )
			rStrm >> bAuto;
		rStrm >> nOff >> nIdx;
	}
	else
	{
		ULONG nOff32 = Sw3IoImp::InULong( rStrm );
		ASSERT( nOff32 <= USHRT_MAX, "SwFmtPageDesc: Seitenzahl > USHRT_MAX" );
		nOff = (USHORT)nOff32;
		rStrm >> nIdx;
	}
	SwFmtPageDesc* pAttr = new SwFmtPageDesc( 0 );
	pAttr->SetNumOffset( nOff );
	pAttr->SetDescNameIdx( nIdx );
	return pAttr;
}

USHORT SwFmtPageDesc::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtPageDesc: Gibt es ein neues Fileformat?" );
	return ( SOFFICE_FILEFORMAT_31==nFFVer ||
			 SOFFICE_FILEFORMAT_40==nFFVer ) ? 0 : IVER_FMTPAGEDESC_LONGPAGE;
}

SvStream& SwFmtPageDesc::Store( SvStream& rStrm, USHORT nVersion) const
{
	ASSERT( IVER_FMTPAGEDESC_NOAUTO != nVersion,
			"SwFmtPageDesc: Export der Item-Version wird nicht unterstuetzt" );

	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	const SwPageDesc* pDesc = GetPageDesc();
	USHORT nIdx = IDX_NO_VALUE;
	if( pDesc )
		nIdx = pIo->aStringPool.Find( pDesc->GetName(), pDesc->GetPoolFmtId() );
	USHORT nOff = GetNumOffset();
	// Eventuell das Header-Bit setzen, dass Seitennummern vorkommen
	if( nOff )
		pIo->nFileFlags |= SWGF_HAS_PGNUMS;

	if( nVersion < IVER_FMTPAGEDESC_LONGPAGE )
	{
		rStrm << (BYTE) 0x01		// nicht mehr bei IVER_..._NOAUTO
			  << (UINT16) nOff
			  << (UINT16) nIdx;
	}
	else
	{
		Sw3IoImp::OutULong( rStrm, nOff );
		rStrm << (UINT16) nIdx;
	}
	return rStrm;
}

SfxPoolItem* SwFmtFlyCnt::Create( SvStream& rStrm, USHORT ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SvStream* p = pIo->pStrm;
	pIo->pStrm = (SvStorageStream*) &rStrm;

	USHORT eSave_StartNodeType = pIo->eStartNodeType;
	pIo->eStartNodeType = SwFlyStartNode;

	SwFrmFmt* pTmpFmt = NULL;
	BYTE cKind = pIo->Peek();
	if( SWG_SDRFMT==cKind )
	{
		if( pIo->bInsIntoHdrFtr )
		{
			pIo->SkipRec();
			pIo->bDrawFmtSkipped = TRUE;
		}
		else
		{
			pTmpFmt = (SwFrmFmt*) pIo->InFormat( SWG_SDRFMT, NULL );
		}
	}
	else
	{
		pTmpFmt = (SwFrmFmt*) pIo->InFormat( SWG_FLYFMT, NULL );
	}

	pIo->pStrm = p;
	pIo->eStartNodeType = eSave_StartNodeType;

	if(	pTmpFmt )
		return new SwFmtFlyCnt( pTmpFmt );

	if( !pIo->bInsIntoHdrFtr || SWG_SDRFMT!=cKind )
		pIo->Error();
	return NULL;
}

SvStream& SwFmtFlyCnt::Store( SvStream& rStrm, USHORT ) const
{
	SwFrmFmt* pFmt = GetFrmFmt();
	if( pFmt )
	{
		Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
		SvStream* p = pIo->pStrm;
		pIo->pStrm = (SvStorageStream*) &rStrm;
		if( RES_DRAWFRMFMT == pFmt->Which() )
			pIo->OutFormat( SWG_SDRFMT, *pFmt );
		else
			pIo->OutFormat( SWG_FLYFMT, *pFmt );
		pIo->pStrm = p;
	}
	return rStrm;
}

//////////////////////////////// Text-Attribute ////////////////////////////

SfxPoolItem* SwFmtRefMark::Create( SvStream& rStrm, USHORT ) const
{
	String aName;
	rStrm.ReadByteString( aName, rStrm.GetStreamCharSet() );
	return new SwFmtRefMark( aName );
}

SvStream& SwFmtRefMark::Store( SvStream& rStrm, USHORT ) const
{
	return rStrm.WriteByteString( GetRefName(), rStrm.GetStreamCharSet() );
}

SfxPoolItem* SwFmtCharFmt::Create( SvStream& rStrm, USHORT ) const
{
	UINT16 nIdx;
	rStrm >> nIdx;
	if( nIdx == IDX_NO_VALUE )
		return NULL;
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SwCharFmt* pChFmt = (SwCharFmt*) pIo->FindFmt( nIdx, SWG_CHARFMT );
	return new SwFmtCharFmt( pChFmt );
}

SvStream& SwFmtCharFmt::Store( SvStream& rStrm, USHORT ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SwCharFmt* pFmt = (SwCharFmt*) GetRegisteredIn();
	return rStrm << (UINT16) pIo->aStringPool.Find( pFmt->GetName(),
													pFmt->GetPoolFmtId() );
}

SfxPoolItem* SwFmtINetFmt::Create( SvStream& rStrm, USHORT nIVer ) const
{
	UINT16 nId1, nId2;
	String aURL, aTarget;
	rStrm.ReadByteString( aURL, rStrm.GetStreamCharSet() );
	rStrm.ReadByteString( aTarget, rStrm.GetStreamCharSet() );
	rStrm >> nId1 >> nId2;

	aURL = URIHelper::SmartRelToAbs( aURL );
	SwFmtINetFmt *pNew = new SwFmtINetFmt( aURL, aTarget );
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	if( nId1 != IDX_NO_VALUE )
	{
		SwCharFmt* pChFmt = (SwCharFmt*) pIo->FindFmt( nId1, SWG_CHARFMT );
		if( pChFmt )
		{
			pNew->aINetFmt = pChFmt->GetName();
			pNew->nINetId = pChFmt->GetPoolFmtId();
		}
	}
	if( nId2 != IDX_NO_VALUE )
	{
		SwCharFmt* pChFmt = (SwCharFmt*) pIo->FindFmt( nId2, SWG_CHARFMT );
		if( pChFmt )
		{
			pNew->aVisitedFmt = pChFmt->GetName();
			pNew->nVisitedId = pChFmt->GetPoolFmtId();
		}
	}
	USHORT nCnt;
	rStrm >> nCnt;
	while( nCnt-- )
	{
		USHORT nCurKey;
		String aLibName, aMacName;
		rStrm >> nCurKey;
		rStrm.ReadByteString( aLibName, rStrm.GetStreamCharSet() );
		rStrm.ReadByteString( aMacName, rStrm.GetStreamCharSet() );
		pNew->SetMacro( nCurKey, SvxMacro( aMacName, aLibName, STARBASIC ) );
	}
	if( nIVer >= 1 )
	{
		String aName;
		rStrm.ReadByteString( aName, rStrm.GetStreamCharSet() );;
		pNew->SetName( aName );
	}
	if( nIVer >= 2 )
	{
		rStrm >> nCnt;
		while( nCnt-- )
		{
			USHORT nCurKey, nScriptType;
			String aLibName, aMacName;
			rStrm >> nCurKey;
			rStrm.ReadByteString( aLibName, rStrm.GetStreamCharSet() );
			rStrm.ReadByteString( aMacName, rStrm.GetStreamCharSet() );
			rStrm >> nScriptType;
			pNew->SetMacro( nCurKey, SvxMacro( aMacName, aLibName,
										(ScriptType)nScriptType ) );
		}
	}

	return pNew;
}

SvStream& SwFmtINetFmt::Store( SvStream& rStrm, USHORT nIVer ) const
{
	ASSERT( nIVer != USHRT_MAX,
			"SwFmtINetFmt: Wer faengt da Version USHRT_MAX nicht ab?" );

	UINT16 nId1 = IDX_NO_VALUE;
	UINT16 nId2 = IDX_NO_VALUE;
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	if( aINetFmt.Len() )
		nId1 = (UINT16) pIo->aStringPool.Find( aINetFmt, nINetId );
	if( aVisitedFmt.Len() )
		nId2 = (UINT16) pIo->aStringPool.Find( aVisitedFmt, nVisitedId );
	String aURL( GetValue() );
	lcl_sw3io__ConvertMarkToOutline( aURL );
	rStrm.WriteByteString( INetURLObject::AbsToRel( aURL URL_DECODE ),
						   rStrm.GetStreamCharSet() );
  	rStrm.WriteByteString( aTargetFrame, rStrm.GetStreamCharSet() );
	rStrm << nId1 << nId2;

	USHORT nCnt = pMacroTbl ? (USHORT)pMacroTbl->Count() : 0, nMax = nCnt;
	if( nCnt )
	{
		for( SvxMacro* pMac = pMacroTbl->First(); pMac; pMac = pMacroTbl->Next() )
			if( STARBASIC != pMac->GetScriptType() )
				--nCnt;
	}

	rStrm << nCnt;

	if( nCnt )
	{
		// erstmal nur die BasicMacros schreiben, die konnte der 3. noch
		for( SvxMacro* pMac = pMacroTbl->First(); pMac; pMac = pMacroTbl->Next() )
			if( STARBASIC == pMac->GetScriptType() )
			{
				rStrm << (USHORT)pMacroTbl->GetCurKey();
			  	rStrm.WriteByteString( pMac->GetLibName(),
									   rStrm.GetStreamCharSet() );
				rStrm.WriteByteString( pMac->GetMacName(),
									   rStrm.GetStreamCharSet() );
			}
	}

	if( nIVer >= 1 )
		rStrm.WriteByteString( GetName(), rStrm.GetStreamCharSet() );

	if( nIVer >= 2 )
	{
		// ab der 4.0 ( nach Technical Beta ) kennen wir auch JavaScript
		// also noch alle JavaScript-Macros schreiben
		nCnt = nMax - nCnt;
		rStrm << nCnt;

		if( nCnt )
		{
			for( SvxMacro* pMac = pMacroTbl->First(); pMac; pMac = pMacroTbl->Next() )
				if( STARBASIC != pMac->GetScriptType() )
				{
					rStrm << (USHORT)pMacroTbl->GetCurKey();
					rStrm.WriteByteString( pMac->GetLibName(),
										   rStrm.GetStreamCharSet() );
					rStrm.WriteByteString( pMac->GetMacName(),
										   rStrm.GetStreamCharSet() );
					rStrm << (USHORT)pMac->GetScriptType();
				}
		}
	}

	return rStrm;
}

USHORT SwFmtINetFmt::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtINetFmr: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? USHRT_MAX : 2;
}


SfxPoolItem* SwFmtFtn::Create( SvStream& rStrm, USHORT nIVer ) const
{
	String aNumber;
	UINT16 nNumber;
	rStrm >> nNumber;
	rStrm.ReadByteString( aNumber, rStrm.GetStreamCharSet() );

	// Die Section fuer den Text erzeugen
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SwNodes& rNodes = pIo->pDoc->GetNodes();
	SwNodeIndex aStart( rNodes.GetEndOfInserts() );
#if 0
	SwStartNode* pSttNd = rNodes.MakeTextSection( aStart, SwFootnoteStartNode,
										pIo->FindTxtColl( IDX_DFLT_VALUE ) );
	aStart = *pSttNd;
#endif
	SwStartNode* pSttNd = rNodes.MakeEmptySection( aStart,SwFootnoteStartNode );
	aStart = *pSttNd->EndOfSectionNode();

	if( pIo->bInsert )
	{
		if( !pIo->pSectionDepths )
			pIo->pSectionDepths = new SvUShorts;
		pIo->pSectionDepths->Insert( (USHORT)0U, pIo->pSectionDepths->Count() );
	}
//	pIo->InContents( aStart );
	pIo->InContents( aStart, 0, FALSE );
	if( pIo->bInsert )
	{
		ASSERT( pIo->pSectionDepths, "There is the section depth stack?" );
		ASSERT( pIo->pSectionDepths->Count() > 0U,
				"section depth stack is empty" );
		pIo->pSectionDepths->Remove( pIo->pSectionDepths->Count() - 1U );
	}

	// die Seq-Nummer einlesen - fuer die Querverweise auf Fussnoten
	USHORT nSeqNo;
	BOOL bEndNote = FALSE;
	if( 1 <= nIVer )
	{
		rStrm >> nSeqNo;
	}
	if( 2 <= nIVer )
	{
		BYTE nFlags;
		rStrm >> nFlags;
		bEndNote = (nFlags & 0x01) != 0;
	}

	SwFmtFtn aFtn( bEndNote );
	aFtn.SetNumStr( aNumber );
	aFtn.SetNumber( nNumber );

	// Das Fussnoten-Attribut liest seine Section "auf der Wiese" ein.
	// Hier muss also der Start errechnet und eingetragen werden.
	SwFmtFtn& rNew = (SwFmtFtn&)pIo->pDoc->GetAttrPool().Put( aFtn );
	SwTxtFtn* pAttr = new SwTxtFtn( rNew, 0 );
	aStart = *pSttNd;
	pAttr->SetStartNode( &aStart );
	if( 1 <= nIVer )
		pAttr->SetSeqNo( nSeqNo );

	return &rNew;
}

SvStream& SwFmtFtn::Store( SvStream& rStrm, USHORT nIVer ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();

	rStrm << (UINT16) GetNumber();

	if( nIVer < 2 && IsEndNote() )
	{
		// Im SW 4.0 gab es noch keine End-Noten, also
		String aNumStr( '*' );
		if( GetNumStr().Len() )
			aNumStr += GetNumStr();
		else
		{
			if( pIo )
				aNumStr += pIo->pDoc->GetEndNoteInfo().aFmt.
								GetNumStr( GetNumber() );
			else
				aNumStr += String::CreateFromInt32( GetNumber() );
		}
		rStrm.WriteByteString( aNumStr, rStrm.GetStreamCharSet() );
	}
	else
	{
		rStrm.WriteByteString( GetNumStr(), rStrm.GetStreamCharSet() );
	}

	SwNodeIndex* pStart = GetTxtFtn()->GetStartNode();
	if( pStart )
	{
		ASSERT( pIo, "SwFmtFtn: kein Sw3Io" );
		SvStream* p = pIo->pStrm;
		pIo->pStrm = (SvStorageStream*) &rStrm;
		pIo->OutContents( *pStart );
		pIo->pStrm = p;
	}
	if( 1 <= nIVer )
		rStrm << (USHORT)pTxtAttr->GetSeqRefNo();
	if( 2 <= nIVer )
		rStrm << (BYTE)(IsEndNote() ? 0x01 : 0x00);

	return rStrm;
}

USHORT SwFmtFtn::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtINetFmr: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31 == nFFVer ? 0 :
		   (SOFFICE_FILEFORMAT_40 == nFFVer ? 1 : 2);
}


SfxPoolItem* SwFmtFld::Create( SvStream& rStrm, USHORT ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SvStream* p = pIo->pStrm;
	pIo->pStrm = (SvStorageStream*) &rStrm;
	SwField* pFld = pIo->InField();
	pIo->pStrm = p;
	if( !pFld )
		return NULL;

	SwFmtFld* pAttr = new SwFmtFld;
	pAttr->pField = pFld;
	return pAttr;
}

SvStream& SwFmtFld::Store( SvStream& rStrm, USHORT ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SvStream* p = pIo->pStrm;
	pIo->pStrm = (SvStorageStream*) &rStrm;
	pIo->OutField( *this );
	pIo->pStrm = p;
	return rStrm;
}

SfxPoolItem* SwTOXMark::Create( SvStream& rStrm, USHORT nIVer ) const
{
	BYTE cType;
	UINT16 nLevel, nStrIdx = IDX_NO_VALUE;
	String aTypeName, aAltText, aPrimKey, aSecKey;
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	rStrm >> cType
		  >> nLevel;

	if( nIVer < IVER_TOXMARK_STRPOOL )
		rStrm.ReadByteString( aTypeName, rStrm.GetStreamCharSet() );
	else
		rStrm >> nStrIdx;

	rStrm.ReadByteString( aAltText, rStrm.GetStreamCharSet() );
	rStrm.ReadByteString( aPrimKey, rStrm.GetStreamCharSet() );
	rStrm.ReadByteString( aSecKey, rStrm.GetStreamCharSet() );

	BYTE cFlags = 0;
	// With the 5.2, there are new tox types.
	if( nIVer >= IVER_TOXMARK_NEWTOX )
	{
		rStrm >> cType >> nStrIdx >> cFlags;
	}

	TOXTypes eType = (TOXTypes)cType;
	if( nIVer >= IVER_TOXMARK_STRPOOL )
	{
		if( nStrIdx != IDX_NO_VALUE )
			aTypeName = pIo->aStringPool.Find( nStrIdx );
		else
			aTypeName = SwTOXBase::GetTOXName( eType );
	}

	// Search tox type
	const SwTOXType *pType = NULL;
	USHORT n = pIo->pDoc->GetTOXTypeCount( eType );
	for( USHORT i = 0; i < n; i++ )
	{
		const SwTOXType *pTmp = pIo->pDoc->GetTOXType( eType, i );
		if( pTmp && pTmp->GetTypeName() == aTypeName )
		{
			pType = pTmp;
			break;
		}
	}

	// If the tox type is unknown, a new one is created.
	if( !pType )
	{
		pIo->pDoc->InsertTOXType( SwTOXType( eType, aTypeName ) );
		pType = pIo->pDoc->GetTOXType( eType, n );
	}
	ASSERT( pType, "unknown tox type" );
	if( !pType )
	{
		pIo->Error();
		return NULL;
	}

	SwTOXMark* pMark = new SwTOXMark( pType );
	pMark->SetAlternativeText( aAltText );
	switch( eType )
	{
		case TOX_INDEX:
			if( aPrimKey.Len() )
				pMark->SetPrimaryKey( aPrimKey );
			if( aSecKey.Len() )
				pMark->SetSecondaryKey( aSecKey );
			break;
		case TOX_USER:
		case TOX_CONTENT:
		case TOX_ILLUSTRATIONS:
		case TOX_OBJECTS:
		case TOX_TABLES:
		case TOX_AUTHORITIES:
			pMark->SetLevel( nLevel );
			break;
		default:
			pIo->Error();
			delete pMark;
			return 0;
	}

	pMark->SetAutoGenerated( 0 != (cFlags & 0x01) );
	pMark->SetMainEntry( 0 != (cFlags & 0x02) );

	return pMark;
}

SvStream& SwTOXMark::Store( SvStream& rStrm, USHORT nIVer ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();

	// Types greater or equal than TOX_ILLUSTRATIONS are new with versuion
	// 5.2. That for, they must be mapped to a TOX_USER for the 5.1, but their
	// original type has to be written, too. Some attention must be kept to
	// the name as well, because if it is the tox types default name, it
	// must be written for the 5.1 but it has not to be seen by< the 5.2.
	TOXTypes eType = GetTOXType()->GetType();
	TOXTypes eOldType = eType >= TOX_ILLUSTRATIONS ? TOX_USER : eType;
	rStrm << (BYTE)   eOldType
		  << (UINT16) nLevel;

	const String& rTypeName = GetTOXType()->GetTypeName();
	if( nIVer < IVER_TOXMARK_STRPOOL )
	{
		// Nur 3.1/4.0-Export
		ASSERT( SOFFICE_FILEFORMAT_40 >= rStrm.GetVersion(),
				"SwToxMark: FF-Version und Item-Version passen nicht" );
		rStrm.WriteByteString( rTypeName, rStrm.GetStreamCharSet() );
	}
	else
	{
		// Nur 5.0 und folgende
		ASSERT( SOFFICE_FILEFORMAT_40 < rStrm.GetVersion(),
				"SwToxMark: FF-Version und Item-Version passen nicht" );
		UINT16 nStrIdx =
			( eType >= TOX_ILLUSTRATIONS ||
			  rTypeName != SwTOXBase::GetTOXName(eType) )
			? pIo->aStringPool.Find( rTypeName, USHRT_MAX )
			: IDX_NO_VALUE;
		rStrm << nStrIdx;
	}
	rStrm.WriteByteString( GetAlternativeText(), rStrm.GetStreamCharSet() );
	rStrm.WriteByteString( aPrimaryKey, rStrm.GetStreamCharSet() );
	rStrm.WriteByteString( aSecondaryKey, rStrm.GetStreamCharSet() );
	if( nIVer >= IVER_TOXMARK_NEWTOX )
	{
		BYTE cFlags = 0;
		if( IsAutoGenerated() )
			cFlags |= 0x01;
		if( IsMainEntry() )
			cFlags |= 0x02;
		UINT16 nStrIdx = rTypeName != SwTOXBase::GetTOXName(eType)
			? pIo->aStringPool.Find( rTypeName, USHRT_MAX )
			: IDX_NO_VALUE;
		rStrm << (BYTE)eType << nStrIdx << cFlags;
	}

	return rStrm;
}

USHORT SwTOXMark::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwTOXMark: Gibt es ein neues Fileformat?" );
	return ( SOFFICE_FILEFORMAT_31==nFFVer ||
			 SOFFICE_FILEFORMAT_40==nFFVer ) ? 0 : IVER_TOXMARK_NEWTOX;
}

SfxPoolItem* SwFmtRuby::Create(SvStream & rStrm, USHORT nVer) const
{
    String sRubyTxt;
    SwFmtRuby* pRet = new SwFmtRuby( sRubyTxt );

    BOOL bVal;
    rStrm >> bVal;

	return pRet;
}

SvStream& SwFmtRuby::Store( SvStream & rStrm, USHORT nIVer ) const
{
    BOOL bVal = 0;
    rStrm << bVal;

    ASSERT( FALSE, "Ruby atribute stored in old format" )

    return rStrm;
}

USHORT SwFmtRuby::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtRuby: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}


SfxPoolItem* SwTblBoxFormula::Create( SvStream & rStrm, USHORT ) const
{
	String sStr;
	rStrm.ReadByteString( sStr, rStrm.GetStreamCharSet() );
	return new SwTblBoxFormula( sStr );
}

SvStream& SwTblBoxFormula::Store( SvStream & rStrm, USHORT ) const
{
	if( EXTRNL_NAME != GetNameType() && pDefinedIn )
	{
		const SwTableNode* pTblNd;
		const SwTableBox* pBox = (SwTableBox*)GetTableBox();
		if( pBox && pBox->GetSttNd() &&
			0 != ( pTblNd = pBox->GetSttNd()->FindTableNode() ))
		{
			((SwTblBoxFormula*)this)->PtrToBoxNm( &pTblNd->GetTable() );
		}
	}
	return rStrm.WriteByteString( GetFormula(), rStrm.GetStreamCharSet() );
}

USHORT SwTblBoxFormula::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwTblBoxFormula: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? USHRT_MAX : 0;
}

SfxPoolItem* SwFmtChain::Create(SvStream& rStrm, USHORT nIVer) const
{
	SwFmtChain *pChain = new SwFmtChain;

	UINT16 nPrevIdx, nNextIdx;
	if( nIVer>0 )
	{
		rStrm	>> nPrevIdx
				>> nNextIdx;

		Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
		ASSERT( pIo || nPrevIdx != IDX_NO_VALUE || nNextIdx != IDX_NO_VALUE,
				"SwFmtChain: kein sw3io: Verkettung nicht moeglich" );
		if( pIo )
		{
			// Wenn hier ein Format schon gelesen wurde, erfolgt die
			// Verkettung hier in der einen Richtung und in InFormat
			// in der anderen Richtung.
			// Wenn das Format noch nicht gefunden wurde, erfolgt die
			// Verkettung wenn das Ziel-Format gelesen wird.
			if( nPrevIdx != IDX_NO_VALUE )
			{
				SwFlyFrmFmt *pPrevFlyFmt =
					(SwFlyFrmFmt *)pIo->aStringPool.FindCachedFmt( nPrevIdx );
				ASSERT( pIo->bInsert ||
						(SwFlyFrmFmt *)pIo->pDoc->FindSpzFrmFmtByName(
						pIo->aStringPool.Find( nPrevIdx ) ) == pPrevFlyFmt,
						"falsches Prev-Format gechached?" );
				pChain->SetPrev( pPrevFlyFmt );
			}
			if( nNextIdx != IDX_NO_VALUE )
			{
				SwFlyFrmFmt *pNextFlyFmt =
					(SwFlyFrmFmt *)pIo->aStringPool.FindCachedFmt( nNextIdx );
				ASSERT( pIo->bInsert ||
						(SwFlyFrmFmt *)pIo->pDoc->FindSpzFrmFmtByName(
						pIo->aStringPool.Find( nNextIdx ) ) == pNextFlyFmt,
						"falsches Prev-Format gechached?" );
				pChain->SetNext( pNextFlyFmt );
			}
		}
	}

	return pChain;
}

SvStream& SwFmtChain::Store(SvStream &rStrm, USHORT nIVer) const
{
	ASSERT( nIVer != USHRT_MAX,
			"SwFmtChain: Wer faengt da Version USHRT_MAX nicht ab?" );

	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	USHORT nPrevIdx = IDX_NO_VALUE, nNextIdx = IDX_NO_VALUE;
	if( pIo )
	{
		if( GetPrev() )
		{
			nPrevIdx = pIo->aStringPool.Find( GetPrev()->GetName(),
											  GetPrev()->GetPoolFmtId() );
		}
		if( GetNext() )
		{
			nNextIdx = pIo->aStringPool.Find( GetNext()->GetName(),
											  GetNext()->GetPoolFmtId() );
		}
	}

	rStrm 	<< (UINT16)nPrevIdx
			<< (UINT16)nNextIdx;

	return rStrm;
}

USHORT SwFmtChain::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtChain: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_40 < nFFVer ? 1 : USHRT_MAX;
}

SfxPoolItem* SwTextGridItem::Create(SvStream& rStrm, USHORT nIVer) const
{
    SwTextGridItem* pRet = new SwTextGridItem;
    BOOL bVal;
    rStrm >> bVal;

    return pRet;
}

SvStream& SwTextGridItem::Store( SvStream & rStrm, USHORT nIVer ) const
{
    BOOL bVal = 0;
    rStrm << bVal;

    return rStrm;
}

USHORT SwTextGridItem::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
            "SwTextGridItem: Gibt es ein neues Fileformat?" );

    return USHRT_MAX;
}
