/*************************************************************************
 *
 *  $RCSfile: dmpfrm.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _DMPFRM_CXX

#pragma hdrstop

#ifdef ZTC
 #include <fstream.hpp>
#else
 #include <fstream.h>
#endif

 #include <stdio.h>
 #include <solar.h>
 #include "rdr.hxx"
 #include "frmids.hxx"

extern ostream& indent( ostream& );
extern ostream& begin( ostream& );
extern ostream& end( ostream& );

/////////////////////////////////////////////////////////////////////////////

static USHORT nFrmCnt[ 64 ];		// Frame-Counters

struct	FrameText {
		short nId;
		char* pText;
};

static FrameText aTexte[] = {
	{ 'R',	"RootFrm" 		},
	{ 'P',	"PageFrm" 		},
	{ 'B',	"BodyFrm" 		},
	{ 'H',	"HeaderFrm" 	},
	{ 'C',	"ColumnFrm" 	},
	{ 'X',	"TxtFrm" 		},
	{ 'G',	"NoTxtFrm" 		},
	{ 'C',	"FtnContFrm"	},
	{ 'N',	"FtnFrm" 		},
	{ 'F',	"FooterFrm" 	},
	{ 'A',	"FlyAtCntFrm" 	},
	{ 'I',	"FlyInCntFrm"	},
	{ 'F',	"FlyLayFrm" 	},
	{ 'T',	"TabFrm" 		},
	{ 'r',	"RowFrm" 		},
	{ 'c',	"CellFrm" 		},
	{ 0 }};

static BYTE flags;			// Record-Flags

static USHORT nVersion;		// Info-Version

static BOOL DumpFrame( SwgDumper& );

// Node-ID einlesen:

static USHORT _readNodeId( swistream& r, USHORT& nNode )
{
	BYTE cVal;
	USHORT nSect;
	if( flags & FRMF_SECTID1 )
	{
		r >> cVal;
		nSect = cVal;
	} else r >> nSect;
	if( flags & FRMF_NODEID1 )
	{
		r >> cVal;
		nNode = cVal;
	} else r >> nNode;
	return nSect;

}

// Lower-Framekette einlesen:

static void _readlower( SwgDumper& rPar )
{
	if( flags & FRMF_HASLOWER )
	{
		USHORT f = flags;
		USHORT nLower;
		rPar.r >> nLower;
		list << begin << "Lower" << endl;
		while( nLower-- )
			if( !DumpFrame( rPar ) )
				rPar.Error( "Frame ID" );
		list << end;
		flags = f;
	}

}

// Fly-Framekette einlesen:

static void _readfly( SwgDumper& rPar )
{
	if( flags & FRMF_HASFLY )
	{
		USHORT f = flags;
		USHORT nFly;
		rPar.r >> nFly;
		list << begin << "FlyFrames" << endl;
		while( nFly-- )
			if( !DumpFrame( rPar ) )
				rPar.Error( "Frame ID" );
		list << end;
		flags = f;
	}

}

// SRectangle einlesen:

static void _read4values( SwgDumper& rPar, long* val )
{
	BYTE sizes;
	rPar.r >> sizes;
	for( USHORT i = 0; i < 4; i++, sizes <<= 2 )
	{
		switch( ( sizes >> 6 ) & 3 )
		{
			case 0:
				*val++ = 0;
				break;
			case 1: {
				short n;
				rPar.r >> n;
				*val++ = n;
				} break;
			case 2: {
				long3 n;
				rPar.r >> n;
				*val++ = n;
				} break;
			case 3: {
				long n;
				rPar.r.long4();
				rPar.r >> n;
				*val++ = n;
				rPar.r.long3();
				} break;
		}
	}

}

static void _readrect( SwgDumper& rPar, char* pText )
{
	long val[ 4 ];
	_read4values( rPar, val );
	list << pText << ": Pos = "  << val[0] << " - " << val[1]
				  << ", SSize = " << val[2] << " x " << val[3];

}

static void readSwFrm( SwgDumper& rPar )
{
	BYTE cFlags;
	rPar.r >> flags >> cFlags;
	list << indent << hex << "FrmFlags = 0x" << (int) cFlags;
	if( nVersion >= FRMVER_EXTINFO )
		while( cFlags & 0x80 ) {
			rPar.r >> cFlags;
			list << ",0x" << (int) cFlags;
	}
	list << dec << endl << indent;
	_readrect( rPar, "Frame" );
	if( flags & FRMF_PRINT )
	{
		list << endl << indent;
		_readrect( rPar, "Print" );
	}
	if( flags & ( FRMF_HASFOLLOW | FRMF_HASID ) )
	{
		USHORT nOwnId;
		rPar.r >> nOwnId;
		list << endl << indent << "ID = " << nOwnId;
	}
	if( flags & FRMF_ISFOLLOW )
	{
		USHORT nMasterId;
		rPar.r >> nMasterId;
		list << endl << indent << "Master ID = " << nMasterId;
	}
	list << endl;

}

static void readSwLayoutFrm( SwgDumper& rPar )
{
	readSwFrm( rPar );
	USHORT nFmt;
	rPar.r >> nFmt;
	rPar.DumpFmt( "Frame", nFmt );

}

static void readSwRootFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	BYTE cFlags;
	rPar.r >> cFlags;
	list << indent << "Flags = 0x" << hex << (int) cFlags << dec << endl;
	_readlower( rPar );

}

static void readSwPageFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	BYTE   cFlags;
	USHORT nDesc;
	rPar.r >> cFlags >> nDesc;
	list << indent << "Flags = 0x" << hex << (int) cFlags
				   << dec << ", PageDesc = " << nDesc << endl;
	if( nVersion < FRMVER_NEWFLY )
	{
		_readfly( rPar );
		_readlower( rPar );
	}
	else
	{
		_readlower( rPar );
		_readfly( rPar );
	}

}

static void readSwHeaderFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	_readlower( rPar );

}

static void readSwFooterFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	_readlower( rPar );

}

static void readSwBodyFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	_readlower( rPar );

}

static void readSwFtnContFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	_readlower( rPar );

}

static void readSwFtnFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	USHORT nRefId, nOfst;
	rPar.r >> nRefId >> nOfst;
	list << indent << "Cntnt frame ID = " << nRefId
		 << ", FtnHintOffset = " << nOfst << endl;
	_readlower( rPar );

}

static void readSwCntntFrm( SwgDumper& rPar )
{
	readSwFrm( rPar );
	USHORT nSect, nNode;
	nSect = _readNodeId( rPar.r, nNode );
	list << indent << "Index = " << nSect << ":" << nNode << endl;

}

static void readSwTxtFrm( SwgDumper& rPar )
{
	USHORT nOfst = 0;
	readSwCntntFrm( rPar );
	if( flags & FRMF_ISFOLLOW )
	{
		rPar.r >> nOfst;
		list << indent << "FollowOffset = " << nOfst << endl;
	}
	if( flags & FRMF_HASFLY )
	{
		if( nVersion < FRMVER_NEWFLY )
		{
			list << indent << "FlyFrames = ";
			USHORT nFrm;
			rPar.r >> nFrm;
			for( USHORT i = 0; i < nFrm; i++ )
			{
				USHORT nIdx;
				rPar.r >> nIdx;
				if( i ) list << ',';
				list << nIdx;
			}
			list << endl;
		} else list << indent << "(has FlyFrames)" << endl;
	}

}

static void readSwNoTxtFrm( SwgDumper& rPar )
{
	readSwCntntFrm( rPar );
	BYTE cSizeFunc;
	rPar.r >> cSizeFunc;
	list << indent << "SizeFunc = " << (int) cSizeFunc << endl;

}

static void readSwFlyFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	BYTE  cFlags;
	long  nX, nY;
	rPar.r >> cFlags >> nX >> nY;
	list << indent << "Flags = 0x" << hex << (int) cFlags
				   << dec << ", RelOffset = " << nX << " - " << nY << endl;
	if( nVersion >= FRMVER_EXTINFO )
	{
		list << indent;
		_readrect( rPar, "ClipMove" );
		if( cFlags & 0x10 )
			_readrect( rPar, ", ClipStretch" );
		list << endl;
	}
}

static void readSwFlyFreeFrm( SwgDumper& rPar )
{
	readSwFlyFrm( rPar );

}

static void readSwFlyLayFrm( SwgDumper& rPar )
{
	readSwFlyFreeFrm( rPar );
	_readlower( rPar );

}

static void readSwFlyInCntntFrm( SwgDumper& rPar )
{
	readSwFlyFrm( rPar );
	BYTE cFlags;
	long nX, nY;
	rPar.r >> cFlags >> nX >> nY;
	list << indent << "Flags = 0x" << hex << (int) cFlags << dec
				   << "RefPos = " << nX << " - " << nY << endl;
	_readlower( rPar );

}

static void readSwFlyAtCntntFrm( SwgDumper& rPar )
{
	readSwFlyFreeFrm( rPar );
	if( nVersion >= FRMVER_NEWFLY )
	{
		USHORT nCntntId;
		rPar.r >> nCntntId;
		list << indent << "CntntFrmId = " << nCntntId << endl;
	}
	_readlower( rPar );

}

static void readSwTabFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	USHORT nTblId, nRow1;
	rPar.r >> nTblId >> nRow1;
	list << indent << "Index = " << nTblId
				   << ", Row1 = " << nRow1 << endl;
	_readlower( rPar );

}

static void readSwRowFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	_readlower( rPar );

}

static void readSwCellFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	_readlower( rPar );

}

static void readSwColumnFrm( SwgDumper& rPar )
{
	readSwLayoutFrm( rPar );
	long val[ 4 ];
	_read4values( rPar, val );
	list << indent << "Offsets =";
	for( short i = 0; i < 4; i++ )
		list << ' ' << val[ i ];
	list << endl;
	_readlower( rPar );

}

// Einen Frame einlesen:

static BOOL DumpFrame( SwgDumper& rPar )
{
	BYTE id;
	rPar.r >> id;
	if( id >= 'A' && id <= 'z' ) nFrmCnt[ id - 'A' ]++;
	switch( id )
	{
		case FRMID_ROOT:	list << begin << "RootFrm" << endl;
							readSwRootFrm( rPar ); break;
		case FRMID_PAGE:	list << begin << "PageFrm" << endl;
							readSwPageFrm( rPar ); break;
		case FRMID_HEADER:	list << begin << "HeaderFrm" << endl;
							readSwHeaderFrm( rPar ); break;
		case FRMID_FOOTER:	list << begin << "FooterFrm" << endl;
							readSwFooterFrm( rPar ); break;
		case FRMID_BODY:	list << begin << "BodyFrm" << endl;
							readSwBodyFrm( rPar ); break;
		case FRMID_FTNCONT:	list << begin << "FtnContFrm" << endl;
							readSwFtnContFrm( rPar ); break;
		case FRMID_FTN:		list << begin << "FtnFrm" << endl;
							readSwFtnFrm( rPar ); break;
		case FRMID_TEXT:	list << begin << "TextFrm" << endl;
							readSwTxtFrm( rPar ); break;
		case FRMID_GRAPHICS:list << begin << "GraphicFrm" << endl;
							readSwNoTxtFrm( rPar ); break;
		case FRMID_ATCNTNT:	list << begin << "FlyAtCntntFrm" << endl;
							readSwFlyAtCntntFrm( rPar ); break;
		case FRMID_INCNTNT:	list << begin << "FlyInCntntFrm" << endl;
							readSwFlyInCntntFrm( rPar ); break;
		case FRMID_FLYLAY:	list << begin << "FlyLayFrm" << endl;
							readSwFlyLayFrm( rPar ); break;
		case FRMID_COLUMN:	list << begin << "ColumnFrm" << endl;
							readSwColumnFrm( rPar ); break;
		case FRMID_TABLE:	list << begin << "TabFrm" << endl;
							readSwTabFrm( rPar ); break;
		case FRMID_TABROW:	list << begin << "RowFrm" << endl;
							readSwRowFrm( rPar ); break;
		case FRMID_TABCELL:	list << begin << "CellFrm" << endl;
							readSwCellFrm( rPar ); break;
		default:			rPar.r.skip(); return FALSE;
	}
	list << end;
	return TRUE;

}

void SwgDumper::LayoutStatistics()
{
	char buf[ 30 ];
	BOOL bHdr = FALSE;
	long sum = 0;
	list << endl << "Frame-Statistik:" << endl << endl;
	for( FrameText* q = aTexte; q->nId; q++ ) {
		USHORT n = nFrmCnt[ q->nId - 'A' ];
		sum += n;
		if( n ) {
			if( !bHdr )
				bHdr = TRUE, list << "Frametyp            Anzahl"
								  << endl << endl;
			sprintf( buf, "%-20s %5u", q->pText, n );
			list << buf << endl;
		}
	}
	if( bHdr ) {
		list << "                     -----" << endl;
		sprintf( buf, "%-20s%6lu", "", sum );
		list << buf << endl;
	}
}


void SwgDumper::InFrames()
{
	list << begin << "LayoutInfo Version ";
	r >> nVersion;
	list << nVersion << endl;
	DumpFrame( *this );
	list << end;
	r.next();
}

