/*************************************************************************
 *
 *  $RCSfile: dmpstat.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <solar.h>
#include <iostream.h>
#include <stdio.h>
#include "rdr.hxx"

struct Records {
		short nId;
		const char* pText;
};

static Records aTexte[] = {
{ 0x09, "Absatz-Format"	},
{ 0x16, "Absatzvorlage"	},
{ 0x13, "Absatzvorlagen-Block"	},
{ 0x06, "Autoformat-Block"	},
{ 0x31, "Benannte Formate"	},
{ 0x34, "Binre Daten"	},
{ 0x1f, "Bookmark"	},
{ 0x04, "Content-Bereich"	},
{ 0x00, "Dateiende" },
{ 0x05, "Default-Format"	},
{ 0x30, "Dokument"	},
{ 0x27, "Dokumentinfo"	},
{ 0x35, "Dynamische DocInfo"	},
{ 0x33, "Feldtypen"	},
{ 0x0c, "Fly-Format"	},
{ 0x02, "FlyFrame"	},
{ 0x1c, "Formathintblock"	},
{ 0x0b, "Frame-Format"	},
{ 0x0e, "Freies Frame-Format"	},
{ 0x18, "Funoten-Info"	},
{ 0x1d, "Grafik"	},
{ 0x0d, "Grafik-Format"	},
{ 0x10, "Grafik-Node"	},
{ 0x17, "Job-Setup"	},
{ 0x01, "Kommentar"	},
{ 0x19, "Layout-Beschreibung"	},
{ 0x03, "Layout-Frame"	},
{ 0x2f, "Layout-Frames"	},
{ 0x07, "Left-Format"	},
{ 0x21, "Linker Rand"	},
{ 0x2e, "Makro-Tabelle"	},
{ 0x08, "Master-Format"	},
{ 0x2a, "Numerierungs-Format"	},
{ 0x2b, "Numerierungs-Regelwerk"	},
{ 0x29, "Numerierungsregel"	},
{ 0x20, "Oberer Rand"	},
{ 0x11, "OLE-Node"	},
{ 0x1e, "OLE-Objekt"	},
{ 0x28, "Outline-Nuerierung"	},
{ 0x22, "Rechter Rand"	},
{ 0x12, "Seitenvorlage"	},
{ 0x1a, "String"	},
{ 0xa2, "SwAdjust"	},
{ 0xf3, "SwAlignGrf"	},
{ 0xe5, "SwBox"	},
{ 0x87, "SwCaseMap"	},
{ 0xe9, "SwColBreak"	},
{ 0xf4, "SwCropGrf"	},
{ 0xa8, "SwDropCaps"	},
{ 0x86, "SwEscapement"	},
{ 0x88, "SwField"	},
{ 0xd0, "SwFillOrder"	},
{ 0xe3, "SwFlyAnchor"	},
{ 0x89, "SwFlyCnt"	},
{ 0xe2, "SwFlyGeneric"	},
{ 0xe1, "SwFlyHoriOrient"	},
{ 0xdf, "SwFlyMainCntnt"	},
{ 0xdd, "SwFlyOpaque"	},
{ 0xdc, "SwFlyPrint"	},
{ 0xde, "SwFlyProtect"	},
{ 0xe0, "SwFlyVertOrient"	},
{ 0xe4, "SwFmtBackground"	},
{ 0x40, "SwFmtCaseMap"	},
{ 0x41, "SwFmtCharWidth"	},
{ 0xd9, "SwFmtCntnt"	},
{ 0xea, "SwFmtCol"	},
{ 0x42, "SwFmtColor"	},
{ 0x43, "SwFmtContour"	},
{ 0x44, "SwFmtCrossedOut"	},
{ 0x45, "SwFmtEscapement"	},
{ 0x52, "SwFmtField"	},
{ 0x46, "SwFmtFont"	},
{ 0xdb, "SwFmtFooter"	},
{ 0xe8, "SwFmtFrmMacro"	},
{ 0x57, "SwFmtHardBlank"	},
{ 0xda, "SwFmtHeader"	},
{ 0x48, "SwFmtInverted"	},
{ 0x49, "SwFmtKerning"	},
{ 0x4a, "SwFmtLanguage"	},
{ 0x4b, "SwFmtMirrored"	},
{ 0x54, "SwFmtNoHyphenHere"	},
{ 0x53, "SwFmtNoLinebreakHere"	},
{ 0xe7, "SwFmtPageDesc"	},
{ 0x4c, "SwFmtPosture"	},
{ 0x4d, "SwFmtPropSize"	},
{ 0xe6, "SwFmtShadow"	},
{ 0x4e, "SwFmtShadowed"	},
{ 0x47, "SwFmtSize"	},
{ 0x55, "SwFmtSoftHyphen"	},
{ 0x4f, "SwFmtUnderline"	},
{ 0x50, "SwFmtWeight"	},
{ 0x51, "SwFmtWritingDirection"	},
{ 0xd1, "SwFrmSize"	},
{ 0x8c, "SwFtn"	},
{ 0xf2, "SwGrfOffset"	},
{ 0xf0, "SwGrfSize"	},
{ 0x8d, "SwHardBlank"	},
{ 0xa7, "SwHyphenZone"	},
{ 0x81, "SwKerning"	},
{ 0xa0, "SwLineSpacing"	},
{ 0xd7, "SwLRSpace"	},
{ 0xf1, "SwMirrorGrf"	},
{ 0x83, "SwNoHyphenHere"	},
{ 0x82, "SwNoLinebreakHere"	},
{ 0xa5, "SwOrphans"	},
{ 0xd2, "SwPageBreak"	},
{ 0xd4, "SwPaperTray"	},
{ 0x8e, "SwRefMark"	},
{ 0xd5, "SwRndRequest"	},
{ 0xd6, "SwRndSupply"	},
{ 0xd3, "SwSelectPage"	},
{ 0x8b, "SwSoftHyphen"	},
{ 0xa3, "SwSplit"	},
{ 0xa6, "SwTabStop"	},
{ 0x8a, "SwTOXMark"	},
{ 0x6e, "SwTxtCharFmt"	},
{ 0x60, "SwTxtCharWidth"	},
{ 0x61, "SwTxtColor"	},
{ 0x62, "SwTxtContour"	},
{ 0x63, "SwTxtCrossedOut"	},
{ 0x64, "SwTxtFont"	},
{ 0x66, "SwTxtInverted"	},
{ 0x67, "SwTxtLanguage"	},
{ 0x68, "SwTxtMirrored"	},
{ 0x69, "SwTxtPosture"	},
{ 0x6a, "SwTxtPropSize"	},
{ 0x6b, "SwTxtShadowed"	},
{ 0x65, "SwTxtSize"	},
{ 0x6c, "SwTxtUnderline"	},
{ 0x6d, "SwTxtWeight"	},
{ 0xd8, "SwULSpace"	},
{ 0xa4, "SwWidows"	},
{ 0x80, "SwWritingDirection"	},
{ 0x24, "Tabelle"	},
{ 0x26, "Tabellen-Box"	},
{ 0x25, "Tabellenzeile"	},
{ 0x32, "Textbaustein"	},
{ 0x1b, "Texthintblock"	},
{ 0x0f, "TextNode"	},
{ 0x23, "Unterer Rand"	},
{ 0x2c, "Verzeichnis-Deskriptor"	},
{ 0x2d, "Verzeichnis-Gruppe"	},
{ 0x0a, "Zeichenformat"	},
{ 0x100 }
};

void SwgDumper::RecordStatistics()
{
	list << endl << "Statistiken:" << endl << endl;
	BOOL bHdr = FALSE;
	USHORT nrecs = 0; long totsiz = 0;
	char buf[ 80 ];
	for( Records* p = aTexte; p->nId != 0x100; p++ ) {
		USHORT n = r.nCount[ p->nId ];
		long siz = r.nSize[ p->nId ];
		nrecs += n;
		totsiz += siz;
		if( n )
		{
			if( !bHdr ) bHdr = TRUE,
				list << "Name                     Anzahl   Gre"
					 << endl << endl;
			char buf[ 80 ];
			sprintf( buf, "%-25s %5u %7lu",	p->pText, n, siz );
			list << buf << endl;
		}
	}
	if( bHdr ) {
		sprintf( buf, "%-25s %5u %7lu\n", "Gesamt", nrecs, totsiz );
		list << "------------------------- ----- -------\n" << buf;
	}
}

