/*************************************************************************
 *
 *  $RCSfile: dmpstr.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SWGSTR_CXX

// Diese Datei implementiert ints und longs im Big-Endian-Format.
// Sie kann nur funktionieren, wenn die Klasse streampos die Byte-
// position innerhalb der Datei wiedergibt, auch, wenn AT&T von
// Magic Numbers spricht!

#ifndef _LIMITS_H
#include <limits.h>		// fuer USHRT_MAX
#endif
#include <solar.h>
#include "dmpstr.hxx"
#include "swgids.hxx"

#pragma hdrstop

 #include <string.h>

#define BUFSIZE 4096				// Groesse des Datenpuffers

/////////////////////////// class swstream ////////////////////////////////

// Die Basisklasse stellt nur die Passwort-Funktionalitaet zur Verfuegung.

swstream::swstream()
{
	bPasswd = FALSE;
	memset( cPasswd, 0, PASSWDLEN );
}

void swstream::setpasswd( const char* p )
{
	// Dies sind Randomwerte, die konstant zur Verschluesselung
	// des Passworts verwendet werden.
	static const BYTE cEncode[] =
	{ 0xAB, 0x9E, 0x43, 0x05, 0x38, 0x12, 0x4d, 0x44,
	  0xD5, 0x7e, 0xe3, 0x84, 0x98, 0x23, 0x3f, 0xba };

	bPasswd = TRUE;
	short len = strlen( p );
	if( len > PASSWDLEN ) len = PASSWDLEN;
	memcpy( cPasswd, cEncode, PASSWDLEN );
	char cBuf[ PASSWDLEN ];
	memset( cBuf, ' ', PASSWDLEN );
	memcpy( cBuf, p, len );
	encode( cBuf, PASSWDLEN );
	memcpy( cPasswd, cBuf, PASSWDLEN );
}

void swstream::copypasswd( const char* p )
{
	memcpy( cPasswd, p, PASSWDLEN );
	bPasswd = TRUE;
}

void swstream::encode( char* pSrc, USHORT nLen )
{
	USHORT nCryptPtr = 0;
	BYTE cBuf[ PASSWDLEN ];
	memcpy( cBuf, cPasswd, PASSWDLEN );
	BYTE* p = cBuf;

	while( nLen-- )
	{
		*pSrc = *pSrc ^ ( *p ^ (BYTE) ( cBuf[ 0 ] * nCryptPtr ) );
		*p += ( nCryptPtr < (PASSWDLEN-1) ) ? *(p+1) : cBuf[ 0 ];
		if( !*p ) *p += 1;
		p++;
		if( ++nCryptPtr >= PASSWDLEN ) nCryptPtr = 0, p = cBuf;
		pSrc++;
	}
}

////////////////////////// class swiostream ///////////////////////////////

// Diese Klasse enthaelt die Funktionalitaet fuer das systemunabhaengige
// Schreiben und Lesen von Daten. Alle numerischen Werte werden als
// Big Endians (80x86-Format) geschrieben.

swiostream::swiostream( streambuf* s ) : swstream(), sbuf( s )
{
	fbuf = new char[ BUFSIZE ];
	fpos = s->seekoff( streampos( 0L ), ios::cur );
	foff = 0;
	fsiz = 0;
	fdirty = FALSE;
	flonglen = 3;
	setgood();
	seek( 0L );
}

swiostream::~swiostream()
{
	if( fdirty ) flush();
	delete fbuf;
}

void swiostream::setgood()
{
	fstate = sbuf ? 0 : ( ios::badbit | ios::eofbit );
}

void swiostream::setbad()
{
	fstate = ios::badbit | ios::eofbit;
}

void swiostream::seek( long n )
{
	if( sbuf )
	{
		if( n < fpos || n >= ( fpos + fsiz ) )
		{
			if( fdirty ) flush();
			if( good() )
			{
				sbuf->seekpos( streampos( fpos = n ) );
				fsiz = sbuf->sgetn( fbuf, BUFSIZE );
				if( !fsiz )
					fstate |= ios::eofbit;
				else
					setgood();
			}
			foff = 0;
		}
		else
			foff = (short) ( n - fpos );
	}
}

void swiostream::flush()
{
	if( fdirty && good() )
	{
		sbuf->seekpos( streampos( fpos ) );
		short n = sbuf->sputn( fbuf, fsiz );
		sbuf->sync();
		if( n != fsiz ) setbad();
	}
	fdirty = FALSE;
}

long swiostream::filesize()
{
	long cur = tell();
	streampos siz = sbuf->seekoff( streamoff( 0 ), ios::end );
	sbuf->seekpos( streampos( cur ) );
	return (long) siz;
}

BYTE swiostream::get()
{
	if( foff >= fsiz ) seek( fpos + foff );
	return fstate ? 0 : (BYTE) fbuf[ foff++ ];
}

void swiostream::get( void* p, USHORT n )
{
	while( n && !fstate )
	{
		USHORT nx = fsiz - foff;
		if( nx > n ) nx = n;
		memcpy( p, fbuf + foff, nx );
		foff += nx;
		n -= nx;
		p = (void*) ((char*) p + nx);
		if( n ) seek( fpos + foff );
	}
}

void swiostream::put( const void* p, USHORT n )
{
	while( n && good() )
	{
		USHORT nx = BUFSIZE - foff;
		if( nx > n ) nx = n;
		memcpy( fbuf + foff, p, nx );
		fdirty = TRUE;
		foff += nx;
		n -= nx;
		p = (const void*) ((const char*) p + nx);
		if( fsiz < foff ) fsiz = foff, fstate &= ~ios::eofbit;
		if( n ) seek( fpos + foff );
	}
}

void swiostream::put( BYTE c )
{
	if( good() )
	{
		if( foff >= BUFSIZE ) seek( fpos + foff );
		fbuf[ foff++ ] = (char) c;
		if( fsiz < foff ) fsiz = foff, fstate &= ~ios::eofbit;
		fdirty = TRUE;
	}
}

void swiostream::sync()
{
	seek( (long) sbuf->seekoff( streampos( 0L ), ios::cur ) );
}

void swiostream::sync( const swiostream& s )
{
	if( good() )
	{
		if( fdirty ) flush();
		memcpy( fbuf, s.fbuf, s.fsiz );
		fsiz = s.fsiz;
		foff = s.foff;
		fpos = s.fpos;
		fdirty = s.fdirty;
	}
}

swiostream& swiostream::operator<<( long n )
{
	BYTE c[ 4 ];
	c[ 0 ] = (BYTE) n;
	c[ 1 ] = (BYTE) ( n >> 8 );
	c[ 2 ] = (BYTE) ( n >> 16 );
	c[ 3 ] = (BYTE) ( n >> 24 );
	put( c, flonglen );
	return *this;
}

swiostream& swiostream::operator>>( long& n )
{
	BYTE c1, c2, c3;
	c1 = get();
	c2 = get();
	c3 = get();
	n = c1
	  + (long) (USHORT) ( c2 << 8 )
	  + ( (long) c3 << 16 );
	if( flonglen == 4 )
	{
		c1 = get();
		n += (long) c1 << 24;
		if ( ( sizeof( long ) > 4 ) && ( c1 & 0x80 ) )
			// Vorzeichenerweiterung!
			n |= ~0xFFFFFFFFL;
	} else if( c3 & 0x80 )
		// Vorzeichenerweiterung!
		n |= ~0xFFFFFFL;
	return *this;
}

/////////////////////////// class swstreambase /////////////////////////////

// Diese Klasse stellt zusaetzlich zur Basis-I/O noch einen dynamischen
// Puffer zur Verfuegung, der fuer das Einlesen von Texten verwendet wird.

swstreambase::swstreambase( streambuf* s ) : swiostream( s )
{
	buf = new char [128];
	buflen = 128;
}

swstreambase::~swstreambase()
{
	delete buf;
}

void swstreambase::checkbuf( USHORT n )
{
	if( n > buflen ) {
		n = ( ( n + 127 ) / 128 ) * 128;
		if( n == 0 ) n = 0xFFC0;
		delete buf;
		buf = new char[ n ];
		buflen = n;
	}
}

void swstreambase::clear()
{
	if( buflen > 128 )
	{
		delete buf;
		buf = new char [128];
		buflen = 128;
	}
}

//////////////////////////// class swistream ///////////////////////////////

swistream::swistream( istream& r ) : swstreambase( r.rdbuf() ), s( r )
{
	offset = 0;
	cType = SWG_EOF;
	memset( nCount, 0, 256 * sizeof( USHORT ) );
	memset( nSize, 0, 256 * sizeof( long ) );
}

swistream::~swistream()
{
	s.clear( s.rdstate() | fstate );
}

istream& swistream::Strm()
{
	sbuf->seekpos( streampos( tell() ) );
	if( bad() ) s.clear( s.rdstate() | fstate );
	return s;
}

long swistream::size()
{
	return offset - tell();
}

char* swistream::text()
{
	BOOL bSkip = FALSE;
	// der String ohne 0, Laenge ist im Offset (von SWG_TEXT)
	long len = size();
	// Sicherheitshalber kuerzen
	if( len > 0xFFF0L ) len = 0xFFF0L, bSkip = TRUE;
	// Eventuell den Puffer vergroessern
	checkbuf( (USHORT) len + 1 );
	get( buf, (USHORT) len );
	if( bPasswd )
		encode( buf, (USHORT) len );
	buf[ (USHORT) len ] = 0;
	if( bSkip ) skip();
	return buf;
}

BYTE swistream::peek()
{
	BYTE ch = get();
	if( foff ) foff--;
	return ch;
}

BYTE swistream::next()
{
	long pos = tell();
	short n = flonglen; flonglen = 3;
	cType = get();
	*this >> offset;
	nCount[ cType ]++;
	nSize[ cType ] += offset + 4;
	if( good() ) offset += pos;
	flonglen = n;
	return cType;
}

void swistream::undonext()
{
	// der Read-Pointer wird um 4 Bytes zurueckversetzt
	if( tell() >= 4 )
	{
		if( foff >= 4 ) foff -= 4;
		else
			seek( tell() - 4 );
		offset = -1;	// damit skip() klappt
	}
}

void swistream::skip( long posn )
{
	if( posn == -1L ) posn = offset;
	if( posn != -1L ) seek( posn );
}

void swistream::checkpos()
{
	// Test, ob ein Record ganz abgearbeitet ist
	if( tell() != offset )
		setbad();
}

BYTE swistream::skipnext()
{
	seek( offset );
	return next();
}

//////////////////////////// class swostream ///////////////////////////////

swostream::swostream( ostream& w ) : swstreambase( w.rdbuf() ), s( w )
{
	level = 0;
	cTextType = SWG_TEXT;
}

swostream::~swostream()
{
	s.clear( s.rdstate() | fstate );
}

// Synchronisieren des ostreams und Rueckgabe desselben

ostream& swostream::Strm()
{
	if( fdirty ) flush();
	sbuf->seekpos( streampos( tell() ) );
	if( bad() ) s.clear( s.rdstate() | fstate );
	return s;
}

swostream& swostream::operator<<( const char* p )
{
	USHORT len = strlen( p );
	begin( cTextType );
	if( bPasswd )
	{
		checkbuf( len );
		memcpy( buf, p, len );
		encode( buf, len );
		put( buf, len );
	} else
		put( p, len );
	end();
	cTextType = SWG_TEXT;
	return *this;
}

void swostream::begin( BYTE kind )
{
	if( level < MAX_BEGIN ) {
		static BYTE hdr [4];
		hdr [0] = kind;
		offset[ level++ ] = tell() + 1;
		put( hdr, 4 );
	} else setbad();
}

void swostream::end()
{
	if( level > 0 ) {
		long fpos0 = fpos;
		long pos0 = tell();
		long pos1 = offset[ --level ];
		short n = flonglen; flonglen = 3;
		seek( pos1 );
		*this << (long) ( pos0 - pos1 + 1 );
		// Hier keinen seek verwenden, da evtl. an das
		// Dateiende positioniert wird, was einen read
		// ausloesen wurde! Man kann immer davon aus-
		// gehen, dass rueckwaerts geschrieben wurde.
		if( fpos != fpos0 )
			// leider hat end() einen neuen Puffer eingelesen
			seek( pos0 );
		else
			foff = (short) ( pos0 - fpos );
		flonglen = n;
	} else setbad();
}

void swostream::push()
{
	if( level < MAX_BEGIN ) {
		offset[ level++ ] = tell();
		*this << (short) 0;
	} else setbad();
}

void swostream::pop( USHORT n )
{
	if( level > 0 ) {
		long fpos0 = fpos;
		long pos0 = tell();
		seek( offset[ --level ] );
		*this << n;
		// Hier keinen seek verwenden, da evtl. an das
		// Dateiende positioniert wird, was einen read
		// ausloesen wurde! Man kann immer davon aus-
		// gehen, dass rueckwaerts geschrieben wurde.
		if( fpos != fpos0 )
			// leider hat end() einen neuen Puffer eingelesen
			seek( pos0 );
		else
			foff = (short) ( pos0 - fpos );
	} else setbad();
}

