/*************************************************************************
 *
 *  $RCSfile: rdr.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _RDR_CXX

#pragma hdrstop

 #include <stdlib.h>	// fuer sprintf statt itoa
 #include <stdio.h>
 #include <string.h>
 #include <limits.h>

 #include <solar.h>

 #ifdef ZTC
  #include <fstream.hpp>
 #else
  #include <fstream.h>
 #endif

#ifdef UNX
 #include <unistd.h>		// fuer access
#else
// damit werden auch andere Plattformen (MAC!) nicht gluecklich
 #include <io.h>
 #include <sys/stat.h>
#endif

 #include "rdr.hxx"

ostream_withassign list;

BOOL bExtract = FALSE;		// TRUE: Grafiken extrahieren
BOOL bPasswd  = FALSE;		// TRUE: Passwort uebernehmen
char cStartDir[ 80 ];

// Achtung: Jede Routine nimmt an, dass der Record-Header bereits eingelesen
// ist. Sie arbeitet den Record so weit ab wie moeglich und schliesst den
// Vorgang mit end() ab.

/////////////////////////////////////////////////////////////////////////////

// Dateikopf bis Version 0x0010

struct OldHeader {					// Dateikopf:
	long nSignature;				// Signatur: "SWG0"
	USHORT nVersion;				// aktuelle Version
	USHORT nFlags;					// Inhibit-Flags (s.u.)
	BYTE cAttrTab [8];				// Start-IDs der Attribute
	BYTE cAttrSiz [8];				// Laengen der Attribut-Gruppen
	BYTE cCodeSet;					// Zeichensatz des Systems
	BYTE cRes;						// Alignment auf Long
	USHORT nNumRules;				// Anzahl Numerierungs-Regeln
	long nAutoFmtOffset;			// Offset der Auto-Formate
	long nDocInfoOffset;			// Offset der Dokument-Info
	long nNumRulesOffset;			// Offset der Numerierungsregeln
	long nLayoutOffset;				// Offset der Layout-Frames
	long nRes [21];
};

/////////////////////////////////////////////////////////////////////////////

// Indentation:

swistream* pStrm;

static int level = 0;

ostream& indent( ostream& s ) {
	s.width( 6 ); s.fill( '0' );
	s << hex << pStrm->tell() - 4 << dec << ' ';
	s.width( 0 ); s.fill( 0 );
	for( int i = 0; i < level; i++ ) s << "  ";
	return s;
}

ostream& begin( ostream& s ) { s << indent << "begin "; level++; return s; }

ostream& end( ostream& s ) { level--; return s << indent << "end" << endl; }

static void DumpDate( long nDate, long nTime )
{
	list.width( 2 );
	list.fill( '0' );
	list << (short) ( nDate % 100) << "."
		 << (short) ((nDate / 100) % 100) << "."
		 << (short) ( nDate / 10000L) << " "
		 << (short) ((nTime / 1000000) % 100) << ":"
		 << (short) ((nTime / 10000) % 100) << ":"
		 << (short) ((nTime / 100) % 100);
	list.width( 0 );
	list.fill( 0 );
}

void SwgDumper::DumpFmt( const char* p, USHORT n )
{
	if( n == IDX_NO_VALUE ) return;
	list << indent << p << " format = ";
	FmtNumber( n );
	list << endl;
}

void SwgDumper::FmtNumber( USHORT n )
{
	if( n == IDX_NO_VALUE ) list << "(none)";
	else
	if( n == IDX_DFLT_VALUE ) list << "default";
	else
	if( n == IDX_COLUMN ) list << "ColumnCont";
	else
	if( n == IDX_EMPTYPAGE ) list << "EmptyPage";
	else
	{
		USHORT nType = n & IDX_TYPEMASK;
		n &= ~IDX_TYPEMASK;
		switch( nType )
		{
			case IDX_COLLECTION:
				list << "collection " << n; break;
			case IDX_NAMEDFMT:
				list << "named fmt " << n; break;
			case IDX_FLOATFMT:
				list << "floating fmt " << n; break;
			case IDX_FLYFMT:
				list << "flyframe fmt " << n; break;
			case IDX_MASTERFMT:
				list << "master fmt " << n; break;
			case IDX_LEFTFMT:
				list << "left fmt " << n; break;
			case IDX_AUTOFMT:
				list << "autofmt " << n; break;
			default:
				list << "?fmt " << n; break;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////

SwgDumper::SwgDumper( istream& s ) : r( s )
{
	pStrm = &r;	// fuer Fehlerprotokoll
	nDocStart = nNextDoc = 0;
}

// Bedingtes Lesen eines Text-Records

char* SwgDumper::GetText( BOOL bReq )
{
	if( r.peek() == SWG_TEXT )
	{
		r.next();
		return r.text();
	} else if( bReq ) Error( "SWG_TEXT" );
	return "";
}

void SwgDumper::LoadFileHeader()
{
	memset( &aFile, 0, sizeof aFile );
	r.get( &aFile.nSignature, 4 );
	r >> aFile.nVersion;
	if( aFile.nVersion > SWG_VER_OLDHDR )
	{
		r.long4();
		r >> aFile.nFlags
		  >> aFile.nFree1;
		if( aFile.nVersion >= SWG_VER_FMTNAME )
		  r >> aFile.nDocInfo;
		r.get( aFile.cPasswd, 16 );
		r.long3();
		if( bPasswd && ( aFile.nFlags & SWGF_HAS_PASSWD ) )
			r.copypasswd( aFile.cPasswd );
	}
}

// Laden der Header-Informationen
// Ab Version 0x0011 ist der Header Bestandtail eines SWG_DOCUMENT-Records.
// Die Position zeigt auf den Beginn der Infos, also entweder hinter die
// Version (s.o.) oder auf den Beginn des SWG_DOCUMENT-Records.

void SwgDumper::LoadHeader()
{
	memset( &aHdr, 0, sizeof aHdr );
	if( aFile.nVersion > SWG_VER_OLDHDR )
	{
		// Ab Version 0x11:
		r.next();
		nNextDoc = r.getskip();
		r >> aHdr.nFlags
		  >> aHdr.nVersion;
		r.get( aHdr.cAttrTab, 8 );
		r.get( aHdr.cAttrSiz, 8 );
		r.long4();
		r >> aHdr.cCodeSet
		  >> aHdr.nNumRules
		  >> aHdr.nDocVersion
		  >> aHdr.cGUIType
		  >> aHdr.cReserved[ 0 ]
		  >> aHdr.cReserved[ 1 ]
		  >> aHdr.cReserved[ 2 ]
		  >> aHdr.nDocInfoOffset
		  >> aHdr.nLayoutOffset;
		if( aHdr.nVersion >= SWG_VER_STAMP )
		  r >> aHdr.nDate >> aHdr.nTime;
		r.long3();
		if( aHdr.nDocInfoOffset ) aHdr.nDocInfoOffset += nDocStart;
		if( aHdr.nLayoutOffset )  aHdr.nLayoutOffset  += nDocStart;
	} else {
		// Bis Version 0x10:
		BYTE cDummy;
		long nDummy;
		aHdr.nVersion = aFile.nVersion;
		r >> aHdr.nFlags;
		r.get( aHdr.cAttrTab, 8 );
		r.get( aHdr.cAttrSiz, 8 );
		r >> aHdr.cCodeSet
		  >> cDummy
		  >> aHdr.nNumRules
		  >> nDummy
		  >> aHdr.nDocInfoOffset
		  >> nDummy
		  >> aHdr.nLayoutOffset;
		r.seek( sizeof( OldHeader ) );
		nNextDoc = 0;
	}
}

/////////////////////////////////////////////////////////////////////////////

void SwgDumper::Error( const char* p )
{
	list << "Lesefehler bei Offset 0x" << hex << r.tell() << dec << "!" << endl
		 << "Erwarteter Record: " << p << endl;
	exit( 1 );
}

/////////////////////////////////////////////////////////////////////////////

// Formatbeschreibungen

void SwgDumper::InFormat( char* pDesc )
{
	list << begin << pDesc << "format ";
	BYTE bAuto = FALSE;
	BYTE bBreak = FALSE;
	// Flag Bits:
	// 0x01 - Autoformat
	// 0x02 - Breakformat
	// 0x04 - Help ID folgt
	// 0x08 - Pattern-Name fuer Help folgt
	// 0x10 - Pattern-Formatnummer fuer Help folgt
	BYTE cFlags = 0;
	BYTE nHelpId = UCHAR_MAX;
	USHORT nHelpFmt = IDX_NO_VALUE;
	USHORT nDerived, nId = IDX_NO_VALUE, nPoolId = IDX_NO_VALUE;
	if( aHdr.nVersion >= SWG_VER_COMPAT )
	{
		if( r.next() != SWG_DATA ) Error( "SWG_DATA" );
		r >> nDerived >> nId >> nPoolId >> cFlags;
		if( cFlags & 0x01 ) bAuto = TRUE;
		if( cFlags & 0x02 ) bBreak = TRUE;
		if( cFlags & 0x04 ) r >> nHelpId;
		if( cFlags & 0x08 )
		  list << "(Help = " << GetText() << ") ";
		if( cFlags & 0x10 )
			r >> nHelpFmt;
		list << GetText();
	}
	else
	{
		r >> nDerived;
		if( aHdr.nVersion >= SWG_VER_LCLFMT )
			r >> nId;
		if( aHdr.nVersion >= SWG_VER_FMTNAME )
		{
			list << GetText();
			r >> cFlags;
			if( cFlags & 0x01 ) bAuto = TRUE;
			if( cFlags & 0x02 ) bBreak = TRUE;
		}
		else
		{
			if( r.peek() == SWG_TEXT )
				list << GetText();
			else
				bAuto = TRUE;
		}
	}
	list << endl;
	list << indent << "Auto = " << (bAuto ? "TRUE" : "FALSE")
				   << ", Break = " << (bBreak ? "TRUE" : "FALSE");
	if( cFlags & 0x04 ) list << ", Landscape = TRUE";
	if( nId != IDX_NO_VALUE )
		list << ", ID = "; FmtNumber( nId );
	if( nPoolId != IDX_NO_VALUE )
		list << ", PoolID = " << nPoolId;
	if( nHelpId != UCHAR_MAX )
		list << ", HelpID = " << (short) nHelpId;
	if( nHelpFmt != IDX_NO_VALUE )
	{
		list << ", HelpFmt = ";
		FmtNumber( nHelpFmt );
	}
	if( nDerived != IDX_NO_VALUE )
	{
		list << ", Derived = "; FmtNumber( nDerived ); list << endl;
	} else if( nId != IDX_NO_VALUE ) list << endl;
	if( r.next() == SWG_FMTHINTS ) {
		short nHt;
		list << begin << "hints" << endl;
		r >> nHt;
		r.next();
		for( int i = 0; i < nHt; i++ ) {
			list << indent;
			InHint();
			r.next();
		}
		list << end;
	}
	list << end;
}

// Abhaegigkeits-Liste der Collections:

void SwgDumper::InTxtFmtCollParents()
{
	list << begin << "derived list" << endl << indent;
	USHORT nArrLen;
	r >> nArrLen;
	for( int i = 0; i < nArrLen; i++)
	{
		short nIdx;
		r >> nIdx;
		if( i ) list << ", ";
		list << nIdx;
	}
	r.next();
	list << endl << end;
}

// Folgeformat-Liste der Collections:

void SwgDumper::InTxtFmtCollNexts()
{
	list << begin << "next list" << endl << indent;
	USHORT nArrLen;
	r >> nArrLen;
	for( int i = 0; i < nArrLen; i++)
	{
		short nIdx;
		r >> nIdx;
		if( i ) list << ", ";
		list << nIdx;
	}
	r.next();
	list << endl << end;
}

void SwgDumper::InTxtFmtColl( USHORT nIdx )
{
	list << begin << "collection #" << nIdx+1 << " ";
	BYTE nLevel;
	USHORT nDerived = IDX_NO_VALUE, nFollow = IDX_NO_VALUE;
	USHORT nCharRef = IDX_NO_VALUE;
	USHORT nPoolId = 0;
	if( aHdr.nVersion >= SWG_VER_COMPAT )
	{
		if ( r.next() != SWG_DATA ) Error( "SWG_DATA" );
		r >> nLevel >> nDerived >> nFollow >> nCharRef >> nPoolId;
		r.skip();
		list << GetText() << endl;
	} else {
		r >> nLevel;
		list << GetText() << endl;
		if( aHdr.nVersion >= SWG_VER_LCLFMT )
			r >> nDerived >> nFollow;
		if( aHdr.nVersion >= SWG_VER_COLLREF )
			r >> nCharRef;
	}
	list << indent << "OutlineLevel = " << (int) nLevel;
	if( nDerived != IDX_NO_VALUE )
		list << ", Derived = " << nDerived;
	if( nFollow != IDX_NO_VALUE )
		list << ", Next = " << nFollow;
	if( nCharRef != IDX_NO_VALUE )
	{
		list << ", Ref = ";
		FmtNumber( nCharRef );
	}
	if( nPoolId != IDX_NO_VALUE ) list << ", PoolID = " << nPoolId;
	list << endl;
	BOOL bDone = FALSE;
	r.next();
	while( !bDone ) {
		char* p;
		switch( r.cur() ) {
			case SWG_FRAMEFMT:	p = "frame "; goto format;
			case SWG_CHARFMT:	p = "char "; goto format;
			case SWG_PARAFMT:	p = "para ";
			format:				InFormat( p ); break;
			default:			bDone = TRUE;
		}
	}
	list << end;
}

void SwgDumper::InTxtFmtColls()
{
	list << begin << "collections" << endl;
	USHORT nColl;
	r >> nColl;
	if( nColl ) {
		r.next();
		for( USHORT i = 0; i < nColl; i++ )
			InTxtFmtColl( i );
	} else r.next();
	list << end;
}

/////////////////////////////////////////////////////////////////////////////

// Seitenbeschreibungen

// Fussnoten-Info

void SwgDumper::InPageFtnInfo()
{
	list << begin << "footnote info" << endl;
	long nHeight, nTopDist, nBottomDist, nNum, nDenom;
	short nAdjust, nPenWidth;
	r >> nHeight
	  >> nTopDist
	  >> nBottomDist
	  >> nAdjust
	  >> nNum >> nDenom
	  >> nPenWidth;

	list << indent << "Height = " << nHeight
		 << ", Width = " << nNum << "/" << nDenom
		 << endl;
	list << indent << "TopDist = " << nTopDist
		 << ", BottomDist = " << nBottomDist
		 << ", Adjust = " << nAdjust
		 << endl;
	list << indent << "Pen Width = " << nPenWidth
		 << ", Pen color = ";
	InColor();
	list << endl << end;
	r.next();
}

// Seiten-Deskriptor

void SwgDumper::InPageDesc( USHORT nIdx )
{
	short nFollow, nUsedOn;
	USHORT nPoolId = IDX_NO_VALUE;
	char nNumType;
	BYTE bHdrShared, bFtrShared, cFlags = 0;
	long skipit = r.getskip();

	list << begin << "PageDesc ";
	if( r.peek() == SWG_TEXT ) r.next(), list << r.text();
	list << endl;

	if( ( aHdr.nVersion >= SWG_VER_COMPAT ) && ( r.next() != SWG_DATA ) )
	{
		Error( "SWG_DATA" ); return;
	}
	r >> nFollow >> nNumType >> nUsedOn >> bHdrShared >> bFtrShared;
	if( aHdr.nVersion >= SWG_VER_COMPAT )
	{
		r >> cFlags;
		if( aHdr.nVersion >= SWG_VER_POOLIDS )
			r >> nPoolId;
		r.skip();
	}
	if( nFollow != -1) list << indent << "FollowIdx = " << nFollow << endl;
	list << indent << "NumType = " << (int) nNumType
				   << ", UsedOn = " << nUsedOn
				   << ", HdrShared = " << (int) bHdrShared
				   << ", FtrShared = " << (int) bFtrShared
				   << ", Flags = " << (int) cFlags;
	if( nPoolId != IDX_NO_VALUE )
		list << ", PoolId = " << nPoolId;
	list << endl;

	BOOL bDone = FALSE;
	r.next();
	while( !bDone )
	  switch( r.cur() ) {
		case SWG_COMMENT:
		case SWG_JOBSETUP:
			// war mal COLDESC, muss ignoriert werden!
			r.skipnext(); break;
		case SWG_FOOTINFO:
			// Vorsicht: SWG_FOOTINFO kann auch auf dem TopLevel
			// vorkommen!
			if( r.tell() > skipit ) bDone = TRUE;
			else InPageFtnInfo(); break;
		case SWG_MASTERFMT:
			InFormat( "Master" ); break;
		case SWG_LEFTFMT:
			InFormat( "Left" ); break;
		default:
			bDone = TRUE;
	}
	list << end;
}

void SwgDumper::InPageDescs()
{
	list << begin << "page descriptors" << endl;
	USHORT nDesc;
	r >> nDesc;
	r.next();
	for( USHORT i = 0; i < nDesc; i++)
		InPageDesc( i );
	list << end;
}

/////////////////////////////////////////////////////////////////////////

// Eine Table ist eine Section. Daher ist SwTableNode von SwStartNode
// abgeleitet. Jede Zelle enthaelt einen SwIndex auf den StartNode
// des Inhalts.

void SwgDumper::InTableBox()
{
	short nFrmFmt, nLines;
	list << begin << "TableBox" << endl;
	r >> nFrmFmt >> nLines;
	DumpFmt( "frame", nFrmFmt );
	r.next();
	if( aHdr.nVersion >= SWG_VER_LCLFMT )
	{
		while( r.cur() == SWG_FRAMEFMT )
			InFormat( "Frame" );
	}
	if( r.cur() == SWG_CONTENTS )
		InContents();
	// Falls Zeilen vorhanden, diese ausgeben
	while( r.cur() == SWG_COMMENT || r.cur() == SWG_DATA ) r.skipnext();
	for( int i = 0; i < nLines; i++)
	{
		if( r.cur() != SWG_TABLELINE ) Error( "SWG_TABLELINE" );
		InTableLine();
	}
	list << end;
}

void SwgDumper::InTableLine()
{
	list << begin << "TableLine" << endl;
	short nFrmFmt, nBoxes;
	r >> nFrmFmt >> nBoxes;
	DumpFmt( "frame", nFrmFmt );
	r.next();
	if( aHdr.nVersion >= SWG_VER_LCLFMT )
	{
		while( r.cur() == SWG_FRAMEFMT )
			InFormat( "Frame" );
	}
	while( r.cur() == SWG_COMMENT || r.cur() == SWG_DATA ) r.skipnext();
	for (int i = 0; i < nBoxes; i++ )
	{
		if( r.cur() != SWG_TABLEBOX ) Error( "SWG_TABLEBOX" );
		InTableBox();
	}
	list << end;
}

void SwgDumper::InTable()
{
	list << begin << "Table" << endl;
	char cFlags;
	short nLines, nBoxes;
	r >> cFlags >> nLines >> nBoxes;
	list << indent << "Lines = " << nLines
				   << ", Boxes = " << nBoxes << endl;
	list << indent << "Modified = " << ((cFlags & 0x01) ? "TRUE" : "FALSE")
				   << ", HdRepeat = " << ((cFlags & 0x02) ? "TRUE" : "FALSE")
		 << endl;
	// Das Frame-Format der Tabelle einlesen
	if( aHdr.nVersion >= SWG_VER_FRAMES )
	{
		USHORT nFrmFmt;
		r >> nFrmFmt;
		DumpFmt( "frame", nFrmFmt );
		r.next();
		if( aHdr.nVersion >= SWG_VER_LCLFMT )
			while( r.cur() == SWG_FRAMEFMT )
				InFormat( "Frame" );
		if( r.cur() == SWG_FIELDTYPES )
			InFieldType(), r.next();
	}
	else
		if( r.next() == SWG_FRAMEFMT )
			InFormat( "Frame" );
		else
			Error( "SWG_FRAMEFMT" );
	while( r.cur() == SWG_COMMENT || r.cur() == SWG_DATA ) r.skipnext();
	for (int i = 0; i < nLines; i++ )
	{
		if( r.cur() != SWG_TABLELINE ) Error( "SWG_TABLELINE" );
		InTableLine();
	}
	list << end;
}

/////////////////////////////////////////////////////////////////////////////

// Texte:

// Text-Hints:

void SwgDumper::InTextHints()
{
	// Dieser Record kann auch leer sein
	// (bei teilweisem Speichern eines Nodes, z.B.)
	list << begin << "hints" << endl;
	USHORT nHt;
	r >> nHt;
	for( int i = 0; i < nHt; i++ ) {
		USHORT nStart, nEnd;
		r >> nStart >> nEnd;
		r.next();
		list.width( 3 );
		list << indent << nStart << '-' << nEnd << ' ';
		list.width( 0 );
		InHint();
	}
	r.next();
	list << end;
}

// Bookmarks:

void SwgDumper::InNodeBookmark()
{
	list << begin << "Bookmark ";
	BYTE cFlags = 0;
	if( aHdr.nVersion >= SWG_VER_BOOKMAC )
		r >> cFlags;
	list << GetText();
	list << " (" << GetText() << ") " << endl;
	USHORT nOffset, nKey, nModifier;
	r >> nOffset >> nKey >> nModifier;
	list << indent
		 << "Offset = " << nOffset
		 << ", Keycode = " << nKey
		 << ", Mod = " << nModifier
		 << endl;
	if( cFlags & 0x01 ) {
		list << indent << "StartMacro = " << GetText();
		list << ", Lib = " << GetText() << endl;
	}
	if( cFlags & 0x02 ) {
		list << indent << "EndMacro = " << GetText();
		list << ", Lib = " << GetText() << endl;
	}
	list << end;
	r.next();
}

// Text Node

void SwgDumper::InTxtNode()
{
	long next = r.getskip();
	list << begin << "TxtNode" << endl;

	// Flags-Aufbau:
	// Bit 0x01 - hat Collection-Wert
	// Bit 0x02 - hat eigenes Frameformat
	// Bit 0x04 - hat eigenes Zeichenformat
	// Bit 0x08 - hat eigenes Absatzformat
	// Bit 0x10 - hat Numerierung

	BYTE cFlags = 0, cNumLevel = 0;
	USHORT nNumRule = IDX_NO_VALUE;
	USHORT nColl = 0,
		   nAutoFrm  = IDX_NO_VALUE,
		   nAutoChar = IDX_NO_VALUE,
		   nAutoPara = IDX_NO_VALUE;

	if( aHdr.nVersion < SWG_VER_NUM )
		r >> nColl >> nAutoFrm >> nAutoChar >> nAutoPara;
	else
	{
		// ab Version 12: alle Teile einzeln, je nach Flags
		r >> cFlags;
		if( cFlags & 0x01 ) r >> nColl;
		if( cFlags & 0x02 ) r >> nAutoFrm;
		if( cFlags & 0x04 ) r >> nAutoChar;
		if( cFlags & 0x08 ) r >> nAutoPara;
		if( cFlags & 0x10 ) r >> cNumLevel >> nNumRule;
	}

	if( cFlags & 0x10 )
		list << indent << "Numbering: Level = " << (int) cNumLevel
					   << ", Rule = " << nNumRule << endl;
	list << indent << "Collection = " << nColl << endl;
	DumpFmt( "frame", nAutoFrm );
	DumpFmt( "char", nAutoChar );
	DumpFmt( "para", nAutoPara );

	BOOL bDone = FALSE;
	r.next();
	while( !bDone && ( r.tell() < next ) )
	  switch( r.cur() ) {
		case SWG_FRAMEFMT:
			InFormat( "frame " ); break;
		case SWG_CHARFMT:
			InFormat( "char " ); break;
		case SWG_PARAFMT:
			InFormat( "para " ); break;
		case SWG_FLYFMT:
			InFormat( "fly " ); break;
		case SWG_TEXT:
			list << indent << "Text = \"" << r.text() << "\"" << endl;
			r.next(); break;
		case SWG_TEXTHINTS:
			InTextHints(); break;
		case SWG_BOOKMARK:
			InNodeBookmark(); break;
		case SWG_OUTLINE:
			// alter Numerierungs-Record, jetzt nicht mehr da!
			r.skipnext(); break;
		default:
			bDone = TRUE;
	}
	list << end;
}

// Grafik-Node

void SwgDumper::InGrfNode()
{
	list << begin << "GrfNode " << endl;
	USHORT nFrmFmt = IDX_NO_VALUE;
	USHORT nGrfFmt = IDX_NO_VALUE;
	if( aHdr.nVersion >= SWG_VER_LCLFMT )
	{
		r >> nFrmFmt >> nGrfFmt;
		DumpFmt( "Frame", nFrmFmt );
		DumpFmt( "Graphic", nGrfFmt );
	}
	r.next();
	long pos;
	BOOL bDone = FALSE;
	while( !bDone )
	  switch( r.cur() ) {
		case SWG_GRAPHIC:
			pos = r.getskip();
			if( aHdr.nVersion >= SWG_VER_FRAMES )
			{
				char* p = GetText();
				BOOL bHasPic = BOOL( !*p );
				list << indent << "Name = \"" << p << "\"";
				list << ", FltName = \"" << GetText( FALSE ) << "\"";
				if( bHasPic )
					list << ", (Graphics)" << endl;
			} else
				list << ", (Graphics)" << endl;
			if( bExtract )
			{
				static short nPic = 0;
				char cGrf[ 80 ];
				sprintf( cGrf, "%sPIC%05d.SVM", cStartDir, ++nPic );
				long nSize = pos - r.tell();
				char* pBuf = new char[ 16384 ];
				BOOL bFirst = TRUE;
				int fd = creat( cGrf, S_IREAD | S_IWRITE );
				if( fd == -1 )
				{
					cerr << "Kann Datei " << cGrf << " nicht einrichten!" << endl;
					exit( 1 );
				}
				while( nSize && r.good() )
				{
					USHORT n = ( nSize <= 16384 ) ? (USHORT) nSize : 16384;
					r.get( pBuf, n );
					if( bFirst )
					{
						// internen Header entfernen
						bFirst = FALSE;
						for( short i = 0; i < 128; i++ )
						{
							if( !memcmp( pBuf+i, "SVGDI", 5 ) )
							{
								memcpy( pBuf, pBuf+i, n -= i );
								break;
							}
						}
					}
					if( write( fd, pBuf, n ) != n )
					{
						close( fd );
						cerr << "Schreibfehler in Datei " << cGrf << "!" << endl;
						exit( 1 );
					}
					nSize -= n;
				}
				if( close( fd ) == -1 )
				{
					cerr << "Schreibfehler in Datei " << cGrf << "!" << endl;
					exit( 1 );
				}
				delete pBuf;
			}
			r.skip( pos );
			r.next(); break;
		case SWG_FRAMEFMT:
			InFormat( "frame " ); break;
		case SWG_GRFFMT:
			InFormat( "graphics " ); break;
		default:
			bDone = TRUE;
	}
	list << end;
}

// OLE-Node

void SwgDumper::InOLENode()
{
	list << begin << "OLENode" << endl;
	USHORT nFrmFmt = IDX_NO_VALUE;
	USHORT nGrfFmt = IDX_NO_VALUE;
	if( aHdr.nVersion >= SWG_VER_LCLFMT )
	{
		r >> nFrmFmt >> nGrfFmt;
		DumpFmt( "Frame", nFrmFmt );
		DumpFmt( "Graphic", nGrfFmt );
	}

	BOOL bDone = FALSE;
	r.next();
	while( !bDone )
	  switch( r.cur() ) {
		case SWG_OLE:
			list << indent << "(OLE Object)" << endl;
			r.skipnext(); break;
		case SWG_FRAMEFMT:
			InFormat( "frame " ); break;
		case SWG_GRFFMT:
			InFormat( "graphics " ); break;
		default:
			bDone = TRUE;
	}
	list << end;
}

// Verzeichnis-Beschreibung

void SwgDumper::InTOXBase()
{
	list << begin << "TOXdesc" << endl;
	if( aHdr.nVersion >= SWG_VER_TOXDATA ) {
		if( r.next() != SWG_DATA ) {
			Error( "SWG_DATA" ); return;
		}
	}
	// Den TOXtype einlesen
	BYTE eType;
	char* pName;
	r >> eType;
	pName = GetText();
	list << indent << "TOXType = " << (int) eType << endl
		 << indent << "TOXTypeName = \"" << pName << "\"" << endl;
	// Die Variablen einlesen
	USHORT nCreaType;
	char* pTitle;
	r >> nCreaType;
	pTitle = GetText();
	list << indent << "CreaType = " << nCreaType << endl
		 << indent << "Title = \"" << pTitle << "\"" << endl;
	// Die SwForm einlesen
	BYTE nPat, nTmpl;
	r >> nPat >> nTmpl;
	if( nPat )
	{
		list << begin << "Patterns" << endl;
		for( int i = 0; i < nPat; i++ )
		{
			pName = GetText();
			list << indent << i << " = \"" << pName << "\"" << endl;
		}
		list << end;
	}
	if( nTmpl )
	{
		list << begin << "Templates" << endl;
		for( int i = 0; i < nTmpl; i++ )
		{
			pName = GetText();
			list << indent << i << " = \"" << pName << "\"" << endl;
		}
		list << end;
	}
	// Zuletzt noch die Spezial-Variablen
	switch( eType )
	{
		case 0: {
			USHORT nOptions;
			r >> nOptions;
			list << indent << "Options (INDEX) = " << nOptions << endl;
			} break;
		case 2: {
			USHORT nLevel;
			r >> nLevel;
			list << indent << "Level (CONTENT) = " << nLevel << endl;
			} break;
		case 1:
			pName = GetText();
			list << indent << "TemplateText (USER) = \"" << pName << "\"" << endl;
			break;
	}
	BOOL bInLastNode = FALSE;
	USHORT nOff1 = 0, nOff2 = 0;
	if( aHdr.nVersion >= SWG_VER_TOXDATA ) {
		// Neu ab Version 2.06: Anfangs- und Endbereich
		// Des TOX-Bereichs einlesen
		r >> (BYTE) bInLastNode >> nOff1 >> nOff2;
		list << indent << "StartOffset = " << nOff1
			 << ", EndOffset = " << nOff2
			 << ", LastNode = " << (bInLastNode ? "TRUE" : "FALSE" )
			 << endl;
	}
	list << end;
}

// Verzeichnis-Block

void SwgDumper::InTOX()
{
	list << begin << "TOXblock" << endl;
	if( r.next() != SWG_TOXDESC ) Error( "SWG_TOXDESC" );
	InTOXBase();
	r.next();
	InTOXContents();
	list << end;
}

void SwgDumper::InNodes()
{
	USHORT nNodes;
	r >> nNodes;
	r.next();
	for( int i = 0; i < nNodes; i++)
	{
		switch( r.cur() )
		{
			case SWG_TEXTNODE:
				InTxtNode(); break;
			case SWG_GRFNODE:
				InGrfNode(); break;
			case SWG_OLENODE:
				InOLENode(); break;
			case SWG_TABLE:
				InTable(); break;
			case SWG_TOXGROUP:
				InTOX(); break;
			case SWG_TEXTBLOCK:
				InTextBlock(); break;
		}
	}
}

void SwgDumper::InTextBlock()
{
	BYTE cFlag;
	list << begin << "TextBlock ";
	r >> cFlag;
	// Bits: 0x01 - in use, 0x02 - charset follows
	if( !cFlag )
	{
		long nSize, nNext;
		r.long4();
		r >> nSize >> nNext;
		r.long3();
		list << hex << "(free), size = 0x" << nSize
			 << ", next = 0x" << nNext << dec << endl;
		r.skipnext();
	} else {
		if( cFlag & 0x02 )
		{
			BYTE eCharSet;
			r >> eCharSet;
			list << "CharSet = " << (int) eCharSet << ", ";
		}
		list << GetText();
		list << " (" << GetText() << ")" << endl;
		InNodes();
	}
	list << end;
}

// Textteil
// wird auch von diversen Hints benoetigt!

void SwgDumper::InContents()
{
	if( r.cur() == SWG_CONTENTS )
	{
		list << begin << "contents";
		if( aHdr.nVersion >= SWG_VER_BETA3 )
		{
			USHORT nId;
			r >> nId;
			list << " #" << nId;
		}
		list << endl;
		InNodes();
		list << end;
	}
}

// ein TOX-Content hat keinen Section ID

void SwgDumper::InTOXContents()
{
	if( r.cur() == SWG_CONTENTS )
	{
		list << begin << "contents" << endl;
		InNodes();
		list << end;
	}
}

/////////////////////////////////////////////////////////////////////////////

// FlyFrames

void SwgDumper::InFlyFrames()
{
	USHORT nFrm;
	list << begin << "FlyFrames" << endl;
	r >> nFrm;
	r.next();
	for( int i = 0; i < nFrm; i++)
		InFormat( "fly " );
	list << end;
}

/////////////////////////////////////////////////////////////////////////////

// Einlesen der Default- und Auto-Formate

void SwgDumper::InDfltFmts()
{
	list << begin << "DefaultFormats" << endl;

	BOOL bDone = FALSE;
	r.next();
	while( !bDone )
	{
		char* p = NULL;
		switch( r.cur() )
		{
			case SWG_FRAMEFMT:	p = "frame "; break;
			case SWG_CHARFMT:	p = "char "; break;
			case SWG_PARAFMT:	p = "para "; break;
			case SWG_GRFFMT:	p = "graphic "; break;
			default:			bDone = TRUE;
		}
		if( p ) InFormat( p );
	}
	list << end;
}

void SwgDumper::InAutoFmts()
{
	USHORT nFmt;
	list << begin << "AutoFormats" << endl;
	r >> nFmt;
	r.next();
	for( int i = 0; i < nFmt; i++ )
	{
		char buf [40];
		char* p = "???";
		switch( r.cur() )
		{
			case SWG_FRAMEFMT:	p = "frame "; break;
			case SWG_CHARFMT:	p = "char "; break;
			case SWG_PARAFMT:	p = "para "; break;
			case SWG_GRFFMT:	p = "graphic "; break;
			case SWG_FLYFMT:	p = "fly "; break;
		}
		sprintf (buf, "(%d) %s", i, p);
		InFormat( buf );
	}
	list << end;
}

void SwgDumper::InNamedFmts()
{
	USHORT nFmt;
	list << begin << "Named Formats" << endl;
	r >> nFmt;
	r.next();
	for( int i = 0; i < nFmt; i++ )
	{
		char buf [40];
		char* p = "???";
		switch( r.cur() )
		{
			case SWG_FRAMEFMT:	p = "frame "; break;
			case SWG_CHARFMT:	p = "char "; break;
			case SWG_PARAFMT:	p = "para "; break;
			case SWG_GRFFMT:	p = "graphic "; break;
			case SWG_FLYFMT:	p = "fly "; break;
		}
		sprintf (buf, "(%d) %s", i, p);
		InFormat( buf );
	}
	list << end;
}

/////////////////////////////////////////////////////////////////////////////

// Numerierungen

// Numerierungs-Format

void SwgDumper::InNumFmt()
{
	// Flags:
	// 0x01 - Praefix-String vorhanden
	// 0x02 - Postfix-String vorhanden
	// 0x04 - Bullet-Font vorhanden
	char bFlags, eType, cBullet, bInclUpperLevel, eNumAdjust;
	USHORT nFmt, nStart;
	char eFamily, ePitch, eCharSet;
	long nLSpace, nFirstLineOffset;
	list << begin << "Number format" << endl;
	if( aHdr.nVersion >= SWG_VER_COMPAT )
	{
		list << indent << "Prefix = \"" <<  GetText() << "\""  << endl
			 << indent << "PostFix = \"" << GetText() << "\""  << endl
			 << indent << "FontName = \"" << GetText() << "\""  << endl;
		if( r.next() != SWG_DATA ) Error( "SWG_DATA" );
		r >> bFlags
		  >> nFmt
		  >> eType
		  >> cBullet
		  >> bInclUpperLevel
		  >> nStart
		  >> eNumAdjust
		  >> nLSpace
		  >> nFirstLineOffset
		  >> eFamily
		  >> ePitch
		  >> eCharSet;
	} else {
		r >> bFlags
		  >> nFmt
		  >> eType
		  >> cBullet
		  >> bInclUpperLevel
		  >> nStart
		  >> eNumAdjust
		  >> nLSpace
		  >> nFirstLineOffset;
		if( bFlags & 0x01 )
			list << indent << "Prefix = \"" << GetText() << "\"" << endl;
		if( bFlags & 0x02 )
			list << indent << "Postfix = \"" << GetText() << "\"" << endl;
		if( bFlags & 0x04 )
		{
			list << indent << "FontName = \"" << GetText() << "\"" << endl;
			r >> eFamily >> ePitch >> eCharSet;
		}
	}
	list << indent << "Flags = 0x" << hex << (int) bFlags << dec
				   << ", Type = " << (int) eType
				   << ", Bullet = 0x" << hex << (int) cBullet << dec
				   << ", Include = "
				   << (bInclUpperLevel ? "TRUE" : "FALSE") << endl;
	list << indent << "Start = " << nStart
				   << ", NumAdust = " << (int) eNumAdjust
				   << ", LSpace = " << nLSpace
				   << ", Offset = " << nFirstLineOffset << endl;
	DumpFmt( "Char", nFmt );
	list << indent
			 << "Font: Family = " << (int) eFamily
			 << ", Pitch = " << (int) ePitch
			 << ", CharSet = " << (int) eCharSet << endl;
	list << end;
	r.next();
}

// Numerierungs-Regel

void SwgDumper::InNumRules( char* pText )
{
	list << begin << "NumRule " << pText << endl;
	char eType, nFmt;
	r >> eType >> nFmt;
	list << indent << "Type = " << (int) eType << ", Formats = " << (int) nFmt;
	if( nFmt )
	{
		list << " ";
		char* ch = "(";
		for( int i = 0; i < nFmt; i++ )
		{
			char nCurFmt;
			r >> nCurFmt;
			list << ch << (int) nCurFmt;
			ch = ",";
		}
		list << ")";
	}
	list << endl;
	r.next();
	for( int i = 0; i < nFmt; i++ )
	{
		if( r.cur() == SWG_NUMFMT )
			InNumFmt();
		else Error( "SWG_NUMFMT" );
	}
	list << end;
}

void SwgDumper::InNumRulesBlock()
{
	list << begin << "NumRules" << endl;
	short nRules;
	r >> nRules;
	if( nRules )
	{
		r.next();
		for( int i = 0; i < nRules; i++ )
		{
			if( r.cur() != SWG_NUMRULE ) Error( "SWG_NUMRULE" );
			else InNumRules( "doc" );
		}
	}
	list << end;
}

/////////////////////////////////////////////////////////////////////////////

// Makros

// Der naechste Record-Header wird nicht eingelesen,
// da diese Routine auch vom Macro-Hint verwendet wird.

void SwgDumper::InMacroTbl()
{
	short nMacro;
	list << begin << "MacroTbl" << endl;
	r >> nMacro;
	for( short i = 0; i < nMacro; i++ )
	{
		USHORT nEvent;
		r >> nEvent;
		list << indent << "Event = " << nEvent;
		list << ", Lib = " << GetText();
		list << ", Name = " << GetText() << endl;
	}
	list << end;
}

/////////////////////////////////////////////////////////////////////////////

// Job-Setup

void SwgDumper::InJobSetup()
{
	long pos = r.getskip();
	list << begin << "JobSetup" << endl;
	USHORT nLen;
	char cGUIType, bDfltPrn;
	r >> cGUIType >> bDfltPrn >> nLen;
	list << indent << "GUI = " << (int) cGUIType
		 << ", Default = " << (bDfltPrn ? "TRUE" : "FALSE")
		 << ", SSize = " << nLen << endl;
	if( aHdr.nVersion >= SWG_VER_ST )
	{
		list << indent << "Printer = \"" << GetText() << "\"" << endl;
		list << indent << "Device  = \"" << GetText() << "\"" << endl;
		list << indent << "Port    = \"" << GetText() << "\"" << endl;
		list << indent << "Driver  = \"" << GetText() << "\"" << endl;
	}
	list << end;
	r.skip( pos );
	r.next();
}

void SwgDumper::InNewJobSetup()
{
	list << begin << "New JobSetup" << endl;
	char bDfltPrn;
	r >> bDfltPrn;
	list << indent << "Default = " << (bDfltPrn ? "TRUE" : "FALSE") << endl;
	list << indent << "(Binary data)" << endl;
	list << end;
	r.skipnext();
}

/////////////////////////////////////////////////////////////////////////////

// Lesen der Autor-Infos

static void InSwStamp( swistream& r, const char* p )
{
	r.long4();
	long nDate, nTime;
	char buf[ 32 ];
	r >> nDate >> nTime;
	r.get( buf, 32 );
	list << indent << p << " = ";
	DumpDate( nDate, nTime );
	list << ", Author = \"" << buf << "\"" << endl;
	r.long3();
}

static void InSwDocString( swistream& r, const char* p, short nLen )
{
	char buf[ 256 ];
	r.get( buf, nLen );
	list << indent << p << " = \"" << buf << "\"" << endl;
}

// UserKeys:

static void InSwUserKey( swistream& r, short n )
{
	list << begin << "UserKey " << n << endl;
	InSwDocString( r, "Title", 20 );
	InSwDocString( r, "Word", 20 );
	list << end;
}

// Einlesen der statischen Dokument-Infos in das pInfo-Feld

static void ReadDocSaveInfo( swistream& r )
{
	list << begin << "DocSaveInfo" << endl;

	InSwStamp( r, "Created" );
	InSwStamp( r, "Changed" );
	InSwStamp( r, "Printed" );
	// SwgInfo-Felder II: Titel, Autor etc
	InSwDocString( r, "Title", 64 );
	InSwDocString( r, "Theme", 64 );
	InSwDocString( r, "Comment", 256 );
	InSwDocString( r, "Keywords", 128 );
	// SwgInfo-Felder III: User-Keys
	USHORT n;
	r >> n;
	for( USHORT i = 0; i < n; i++ )
		InSwUserKey( r, i );
	list << end;
}

void SwgDumper::InDocInfo()
{
	list << begin << "DocInfo" << endl;

	while( r.good() )
	{
		switch( r.next() )
		{
			case SWGINF_DBNAME:
				list << indent << "DBName = " << r.text() << endl;
				break;
			case SWGINF_LAYOUTPR:
				list << indent << "Layout printer = " << r.text() << endl;
				break;
			case SWGINF_AUTHOR:
				list << indent << "Author = " << r.text() << endl;
			case SWGINF_DOCSTAT: {
				USHORT nTbl, nGrf, nOLE, nPage, nPara;
				ULONG nWord, nChar;
				r >> nTbl >> nGrf >> nOLE >> nPage >> nPara >> nWord >> nChar;
				list << begin << "DocStatus" << endl;
				list << indent << "Tables = " << nTbl << endl
					 << indent << "Graphics = " << nGrf << endl
					 << indent << "Objects = " << nOLE << endl
					 << indent << "Pages = " << nPage << endl
					 << indent << "Paragraphs = " << nPara << endl
					 << indent << "Words = " << nWord << endl
					 << indent << "Characters = " << nChar << endl;
				list << end;
				} break;
			case SWGINF_SAVEINFO:
				ReadDocSaveInfo( r ); break;
			case SWGINF_EXTINFO: {
				BYTE cGUIType, cCharSet;
				r >> cGUIType >> cCharSet;
				list << indent << "GUI = " << (int) cGUIType
							   << ", CharSet = " << (int) cCharSet << endl;
				r.skip();
				} break;
			case SWGINF_END:
				list << end;
				r.next();
				return;
			default:
				list << indent << "RecID = 0x" << hex << r.cur() << dec << endl;
				// wird ignoriert
				r.skip();
		}
	}
}

void SwgDumper::InDynDocInfo()
{
	if( r.next() != SWG_DYNDOCINFO ) return;

	list << begin << "Dynamic DocInfo" << endl;
	long nextrec = r.getskip();
	long d, t;
	BYTE cFlags = 0;
	USHORT n;
	while( r.tell() < nextrec && r.good() )
	{
		switch( r.next() )
		{
			case SWGINF_TEMPLATE:
				list << indent << "Template = " << GetText();
				r.long4();
				r >> d >> t;
				r.long3();
				if( aHdr.nVersion >= SWG_VER_GETEXP )
					r >> cFlags;
				list << ", Date = ";
				DumpDate( d, t );
				list << ", Flags = 0x" << hex << (short) cFlags << dec << endl;
				break;
			case SWGINF_ADDRINFO:
				list << indent << "AddrInfo = " << GetText();
				r >> n;
				list << ", Flags = 0x" << hex << n << dec << endl;
				break;
			default:
				r.skip();
		}
	}
	list << end << endl;
}

/////////////////////////////////////////////////////////////////////////////

// globale Fussnoten-Info

void SwgDumper::InFtnInfo()
{
	char* pQuoVadis;
	char* pErgoSum;
	BYTE ePos, eNum, eType;
	USHORT nDesc, nCollIdx = 0;
	list << begin << "Footnote Info" << endl;
	list << indent << "QuoVadis = " << GetText() << endl;
	list << indent << "ErgoSum  = " << GetText() << endl;
	if( ( aHdr.nVersion >= SWG_VER_COMPAT ) && ( r.next() != SWG_DATA ) )
	{
		Error( "SWG_DATA" ); return;
	}
	r >> ePos >> eNum >> eType >> nDesc;
	if( aHdr.nVersion >= SWG_VER_COMPAT )
	{
		r >> nCollIdx;
		r.skip();
	}
	list << indent << "Pos = " << (int) ePos
				   << ", Num = " << (int) eNum
				   << ", NumType = " << (int) eType
				   << ", PageDescIdx = " << nDesc;
	if( nCollIdx != IDX_NO_VALUE )
	{
		list << ", CollIdx = ";
		FmtNumber( nCollIdx );
	}
	list << endl << end;
	r.next();
}

void SwgDumper::InComment()
{
	BYTE cType;
	USHORT nVal;
	r >> cType;
	list << indent << "Comment Type = " << (short) cType;
	switch( cType ) {
		case SWG_XFTNCOLL:
			// Fussnoten-Erweiterung: Nummer der TxtColl
			r >> nVal;
			list << ", FtnTxtColl = ";
			FmtNumber( nVal );
			list << endl; break;
		default:
			list << ", Text = " << (char) cType << r.text() << endl;

			r.skip();
	}
	r.next();
}

/////////////////////////////////////////////////////////////////////////////

void SwgDumper::DumpHeader()
{
	static char* pAttr[] = {
		"Character",
		"Font",
		"Text",
		"Paragraph",
		"Extra",
		"Frame",
		"Graphics"
	};
	list << indent << "Version: 0x" << hex << aHdr.nVersion << dec << endl;
	list << indent << "GUIType: " << (int) aHdr.cGUIType << endl;
	list << indent << "CodeSet: " << (int) aHdr.cCodeSet << endl;
	list.width( 2 );
	list.fill( '0' );
	list << begin << "Attribute Tbl" << endl;
	for( int i = 0; i < 7; i++ )
	{
		list << indent << "Start: 0x" << hex << (int) aHdr.cAttrTab[ i ]
			 << " SSize: " << dec << (int) aHdr.cAttrSiz[ i ]
			 << endl;
	}
	list << end;
	list.width( 0 );
	list.fill( 0 );
	list << indent << "Document version:     0x" << hex << aHdr.nDocVersion
		 << dec << endl;
	list << indent << "Start of DocInfo:     0x" << hex << aHdr.nDocInfoOffset
		 << dec << endl;
	list << indent << "Start of LayoutInfo:  0x" << hex << aHdr.nLayoutOffset
		 << dec << endl;
	if( aHdr.nDate )
	{
		list << indent << "Saved:                ";
		DumpDate( aHdr.nDate, aHdr.nTime );
		list << endl;
	}
	// Versions-Text?
	char* p = GetText( FALSE );
	if( p && *p )
		list << indent << "Version Text:         " << p << endl;
}

BOOL SwgDumper::Read()
{
	nDocStart = r.tell();
	if( nDocStart == nNextDoc ) return FALSE;
	LoadHeader();
	if( !r ) return FALSE;
	if( aHdr.nVersion > SWG_VER_OLDHDR )
		list << begin << "Document" << endl;
	DumpHeader();
	r.next();
	BOOL bDone = FALSE;
	while( r.good()  && !bDone ) {
		BYTE ch = r.cur();
		switch( ch ) {
			case SWG_EOF:
				if (r.next() == SWG_DOCINFO )
				{
					list << endl;
					InDocInfo();
				} else r.undonext();
				bDone = TRUE; break;
			case SWG_TEXT:
				list << endl << indent << "Text = \"" << r.text() << "\"" << endl;
				r.next();
				break;
			case SWG_COMMENT:
				list << endl;
				InComment();
				break;
			case SWG_DOCINFO:
				list << endl;
				InDocInfo(); break;
			case SWG_JOBSETUP:
				list << endl;
				InJobSetup(); break;
			case SWG_NEWJOBSETUP:
				InNewJobSetup(); break;
			case SWG_OUTLINE:
				if( aHdr.nVersion >= SWG_VER_NUM )
				{
					list << endl;
					InNumRules( "outline" );
				} else r.skipnext();
				break;
			case SWG_NUMRULE:
				if( aHdr.nVersion >= SWG_VER_NUM )
				{
					list << endl;
					InNumRules( "default" );
				} else r.skipnext();
				break;
			case SWG_NUMRULES:
				if( aHdr.nVersion >= SWG_VER_NUM )
				{
					list << endl;
					InNumRulesBlock();
				} else r.skipnext();
				break;
			case SWG_MACROTBL:
				list << endl;
				InMacroTbl (); r.next(); break;
			case SWG_LAYOUT:
				list << endl;
				InPageDescs(); break;
			case SWG_AUTOFMTS:
				list << endl;
				InAutoFmts(); break;
			case SWG_NAMEDFMTS:
				list << endl;
				InNamedFmts(); break;
			case SWG_DFLTFMTS:
				list << endl;
				InDfltFmts(); break;
			case SWG_FLYFRAMES:
				list << endl;
				InFlyFrames(); break;
			case SWG_FIELDTYPES:
				list << endl;
				InFieldTypes(); break;
			case SWG_COLLECTIONS:
				list << endl;
				InTxtFmtColls(); break;
			case SWG_COLLDERIVED:
				list << endl;
				InTxtFmtCollParents(); break;
			case SWG_COLLNEXT:
				list << endl;
				InTxtFmtCollNexts();
				break;
			case SWG_FOOTINFO:
				list << endl;
				InFtnInfo();
				break;
			case SWG_CONTENTS:
				list << endl;
				InContents(); break;
			case SWG_FRAMES:
				list << endl;
				InFrames(); break;
			default:
				list << "Error: Unknown Record " << dec << ch
					 << hex << " (" << ch << ")" << dec << endl;
				exit( 1 );
		}
	}
	if( aHdr.nVersion > SWG_VER_OLDHDR )
		list << end << endl;
	else
		nNextDoc = r.tell();
	return TRUE;
}

int main( int argc, char** argv )
{
	char cName [80];
	BOOL bErr = FALSE;
	list = cout;
	BOOL bStat = FALSE;
	cName[ 0 ] = 0;
	while( --argc )
	{
		char buf[ 80 ];
		strcpy( buf, *++argv );
		if( !strcmp( buf, "-Passwd" ) ) bPasswd = TRUE;
		else
		{
			strlwr( buf );
			if( buf[ 0 ] == '-' )
			  switch( buf[ 1 ] )
			{
				case 's': bStat = TRUE; break;
				case 'x': bExtract = TRUE; break;
				default:  bErr = TRUE;
			}
			else if( cName[ 0 ] ) bErr = TRUE;
			else strcpy( cName, buf );
		}
	}
	if( !cName[ 0 ] ) bErr = TRUE;
	if( bErr ) {
		cerr << "Aufruf: RDR [-s -x] Dateiname" << endl;
		return( 1 );
	}
	char* p = cName + strlen( cName );
	do {
		p--;
		if( *p == '\\' || *p == ':' ) {
			char ch = *++p;
			*p = 0;
			strcpy( cStartDir, cName );
			*p = ch;
			break;
		}
	} while( p != cName );
	p = cName + strlen( cName );
	do {
		p--;
		if( *p == '\\' || *p == ':' ) {
			p = NULL; break;
		}
		if( *p == '.' ) break;
	} while( p != cName );
	if( p == cName ) p = NULL;
	if( p ) {
		// voller Name
		if( access( cName, 0 ) ) {
			cerr << "Kann Datei " << *argv << " nicht finden!" << endl;
			return( 1 );
		}
	} else {
		p = cName + strlen( cName );
		strcpy( p, ".sdw" );
		if( access( cName, 0 ) ) {
			strcpy( p, ".vor" );
			if( access( cName, 0 ) ) {
				strcpy( p, ".bau" );
				if( access( cName, 0 ) ) {
					cerr << "Kann Datei " << *argv << " nicht finden!" << endl;
					return( 1 );
				}
			}
		}
	}
#if defined( __ZTC__ ) || defined( UNX )
		ifstream f( cName, ios::in );
#else
		ifstream f( cName, ios::in | ios::binary );
#endif
	if( !f ) {
		cerr << "Kann Datei " << cName << " nicht oeffnen!" << endl;
		return( 1 );
	}
	SwgDumper aRdr( f );
	aRdr.LoadFileHeader();
	if( strncmp( (const char*) &aRdr.aFile.nSignature, SWG_SIGNATURE, 3 ) )
	{
		cerr << "Datei " << cName << " ist keine SW/G-Datei!" << endl;
		return( 1 );
	}

	ofstream nul( "NUL" );
	if( bStat ) list = nul;
	USHORT v = aRdr.aFile.nVersion;
	aRdr.aFile.nVersion = 0;
	list << "File type : " << (const char*) &aRdr.aFile.nSignature << endl;
	list << "Version   : 0x" << hex << v << endl;
	list << "First free: 0x" << aRdr.aFile.nFree1 << endl;
	list << "DocInfo   : 0x" << aRdr.aFile.nDocInfo << dec << endl;
	list << "File Flags:";
	if( aRdr.aFile.nFlags & SWGF_NO_FRAMES  ) list << " NO_FRAMES";
	if( aRdr.aFile.nFlags & SWGF_HAS_BLOCKS ) list << " HAS_BLOCKS";
	if( aRdr.aFile.nFlags & SWGF_HAS_VERS   ) list << " HAS_VERS";
	if( aRdr.aFile.nFlags & SWGF_HAS_PASSWD ) list << " HAS_PASSWD";
	if( aRdr.aFile.nFlags & SWGF_HAS_GRFLNK ) list << " HAS_GRFLNK";
	if( aRdr.aFile.nFlags & SWGF_HAS_DDELNK ) list << " HAS_DDELNK";
	if( aRdr.aFile.nFlags & SWGF_HAS_OLELNK ) list << " HAS_OLELNK";
	if( aRdr.aFile.nFlags & SWGF_BAD_FILE   ) list << " BAD_FILE";
	if( aRdr.aFile.nFlags & SWGF_FIX_FMTS   ) list << " FIX_FMTS";
	if( !aRdr.aFile.nFlags ) list << " ----";
	list << endl << endl;
	aRdr.aFile.nVersion = v;
	aRdr.Read();
	aRdr.InDynDocInfo();
	list = cout;
	aRdr.RecordStatistics();
	aRdr.FieldStatistics();
	aRdr.LayoutStatistics();
	return 0;
}

