/*************************************************************************
 *
 *  $RCSfile: swgpar.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "core_pch.hxx"
#endif

#pragma hdrstop

#include "swtypes.hxx"
#include "segmentc.hxx"

#include "rdswg.hxx"
#include "swgpar.hxx"

/////////////////////////////////////////////////////////////////////////

SwSwgParser::SwSwgParser( SwDoc *pSwDoc, const SwPaM* pSwPaM,
				 SvStream *pIstream, const String& rFileName, BOOL bNewDoc )
{
	pRdr = new SwSwgReader( pSwDoc, pSwPaM, *pIstream, rFileName, bNewDoc );
	pRdr->LoadFileHeader();
}

SwSwgParser::SwSwgParser( SvStream *pIstream )
{
	pRdr = new SwSwgReader( NULL, NULL, *pIstream, aEmptyStr, TRUE );
	pRdr->LoadFileHeader();
}

SwSwgParser::~SwSwgParser()
{
	delete pRdr;
}


ULONG SwSwgParser::CallParser( USHORT nOptions )
{
	return pRdr->Read( nOptions );
}

BOOL SwSwgParser::NeedsPasswd()
{
	return pRdr->GetError()
		? FALSE
		: BOOL( ( pRdr->aFile.nFlags & SWGF_HAS_PASSWD ) != 0 );
}

BOOL SwSwgParser::CheckPasswd( const String& rStr )
{
	return pRdr->GetError() ? FALSE : pRdr->CheckPasswd( rStr );
}

const SfxDocumentInfo& SwSwgParser::GetDocInfo()
{
	return pRdr->GetDocInfo();
}

/*************************************************************************

		$Log: swgpar.cxx,v $
		Revision 1.1.1.1  2000/09/19 00:08:24  hr
		initial import
		
		Revision 1.35  2000/09/18 16:04:17  willem.vandorp
		OpenOffice header added.
		
		Revision 1.34  2000/09/08 13:25:35  willem.vandorp
		Header and footer replaced
		
		Revision 1.33  2000/04/17 08:08:05  mib
		unicode
		
		Revision 1.32  1997/11/03 12:01:52  MA
		precomp entfernt
		

	  Rev 1.31   03 Nov 1997 13:01:52   MA
   precomp entfernt

	  Rev 1.30   29 Jan 1997 13:20:02   MA
   unbenutzes entfernt

	  Rev 1.29   16 Oct 1996 09:39:26   MIB
   unbenutzte Funktionen entferent

	  Rev 1.28   27 Jun 1996 12:40:06   MA
   includes

	  Rev 1.27   21 Mar 1996 13:58:46   MA
   svhxx entfernt

	  Rev 1.26   14 Dec 1995 23:34:12   JP
   Filter Umstellung: ErrorHandling und Read/Write-Parameter

	  Rev 1.25   24 Nov 1995 17:14:36   OM
   PCH->PRECOMPILED

	  Rev 1.24   06 Nov 1995 16:29:54   JP
   hart segmentiert

	  Rev 1.23   16 Mar 1995 16:55:22   MD
   NeedsPasswd()

	  Rev 1.22   24 Nov 1994 19:16:12   MD
   SfxDocumentInfo eingefuehrt, SwSwginfo entfernt

	  Rev 1.21   25 Oct 1994 12:02:26   MA
   PreHdr.

	  Rev 1.20   09 Sep 1994 18:11:46   MD
   JP_NEWCORE raus

	  Rev 1.19   25 Aug 1994 18:02:40   JP
   Umstellung Attribute (von SwHint -> SfxPoolItem)

	  Rev 1.18   12 Aug 1994 16:39:40   MD
   Umstellung auf SvStreams

	  Rev 1.17   03 Aug 1994 17:07:10   SWG
   Miese Hacks wg. unvollst. SvStream-Umbau.

	  Rev 1.16   01 Aug 1994 17:33:26   PK
   sv-streams

	  Rev 1.15   21 Mar 1994 17:09:24   JP
   SwSwgReader/-Parser: Filenamen vom Stream jetzt als Member.

	  Rev 1.14   03 Mar 1994 18:24:44   MD
   Klasse SwSwgInfo aktiviert, SwgInfo entfernt

	  Rev 1.13   17 Feb 1994 08:23:02   MI
   SEG_FUNCDEFS ausgefuellt

	  Rev 1.12   16 Feb 1994 10:25:12   MI
   Pragmas zurechtgerueckt

*************************************************************************/

#pragma SEG_EOFMODULE

