/*************************************************************************
 *
 *  $RCSfile: optdlg.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jp $ $Date: 2000/10/06 13:32:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop


#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>

#ifndef _SV_PRINT_HXX //autogen
#include <vcl/print.hxx>
#endif
#ifndef _SVX_BACKGRND_HXX //autogen
#include <svx/backgrnd.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC //autogen
#include <svx/dialogs.hrc>
#endif
#ifndef _SVX_OPTGRID_HXX //autogen
#include <svx/optgrid.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _OPTDLG_HXX
#include <optdlg.hxx>
#endif
#ifndef _WVIEW_HXX
#include <wview.hxx>
#endif
#ifndef _PRTOPT_HXX
#include <prtopt.hxx>
#endif
#ifndef _OPTPAGE_HXX
#include <optpage.hxx>
#endif
#ifndef _OPTINS_HXX
#include <optins.hxx>
#endif
#ifndef _OPTLOAD_HXX
#include <optload.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _USRPREF_HXX
#include <usrpref.hxx>
#endif

#ifndef _CONFIG_HRC
#include <config.hrc>
#endif
#ifndef _OPTDLG_HRC
#include <optdlg.hrc>
#endif



/*-----------------31.08.96 14.45-------------------

--------------------------------------------------*/


SwDocEditDialog::SwDocEditDialog(Window* pParent,
					SfxItemPool &rPool,
					const SfxItemSet* pSwItemSet,
					USHORT nDefPage ) :
	SfxTabDialog(pParent, SW_RES(SW_EDIT_OPTIONS_TDLG), pSwItemSet, 0),
	pPool(&rPool)
{
	FreeResource();
	AddTabPage(TP_CONTENT_OPT,		&SwContentOptPage::Create,0);
	AddTabPage(TP_LAYOUT_OPT,		&SwLayoutOptPage::Create,0);
	AddTabPage(RID_SVXPAGE_GRID,	&SvxGridTabPage::Create,0);
	//Sw-Pages
	AddTabPage(TP_STD_FONT,			&SwStdFontTabPage::Create, 0);
	AddTabPage(TP_OPTPRINT_PAGE,	&SwAddPrinterTabPage::Create,0);
	AddTabPage(TP_OPTTABLE_PAGE,	&SwTableOptionsTabPage::Create,0);

	AddTabPage(TP_OPTSHDWCRSR,		&SwShdwCrsrOptionsTabPage::Create,0);
	AddTabPage(TP_REDLINE_OPT,		&SwRedlineOptionsTabPage::Create,0);
	AddTabPage(TP_OPTINSERT_PAGE,	&SwInsertOptPage::Create,0);
	AddTabPage(TP_OPTLOAD_PAGE,		&SwLoadOptPage::Create,0);

#ifndef PRODUCT
	AddTabPage(TP_OPTTEST_PAGE,&SwTestTabPage::Create,0);
#endif

	if (nDefPage)
		SetCurPageId(nDefPage);
}

/*-----------------31.08.96 15.04-------------------

--------------------------------------------------*/

SwDocEditDialog::~SwDocEditDialog()
{
}

/*-----------------31.08.96 15.04-------------------

--------------------------------------------------*/


void __EXPORT SwDocEditDialog::PageCreated(USHORT nPageId, SfxTabPage& rPage)
{
	switch ( nPageId )
	{
		case RID_SVXPAGE_GRID:
			((SvxGridTabPage&)rPage).HideSnapGrid();
		break;
		case TP_OPTPRINT_PAGE:
		{
			SvStringsDtor aFaxList;
			const USHORT nCount = Printer::GetQueueCount();
			for (USHORT i = 0; i < nCount; ++i)
			{
				String* pString = new String( Printer::GetQueueInfo( i ).
												GetPrinterName() );
				String* &rpString = pString;
				aFaxList.Insert( rpString, 0 );
			}
			(( SwAddPrinterTabPage& )rPage).SetFax( aFaxList );
		}
		break;
	}

}
/*-----------------31.08.96 14.40-------------------

--------------------------------------------------*/


SwBrowserOptionsDialog::SwBrowserOptionsDialog(Window* pParent,
									const SfxItemSet* pSwItemSet ) :
	SfxTabDialog(pParent, SW_RES(SW_BROWSER_OPTIONS_TDLG), pSwItemSet, 0)
{
	FreeResource();
#if SUPD<355
	AddTabPage(TP_HTML_OPT,			&OfaHtmlTabPage::Create, 	0);
#endif
	AddTabPage(TP_CONTENT_OPT,		&SwContentOptPage::Create,0);
	AddTabPage(TP_LAYOUT_OPT,		&SwLayoutOptPage::Create,0);
	AddTabPage(RID_SVXPAGE_GRID,	&SvxGridTabPage::Create,0);
	//Sw-Pages
	AddTabPage(TP_OPTPRINT_PAGE,	&SwAddPrinterTabPage::Create,0);
	AddTabPage(TP_OPTTABLE_PAGE,	&SwTableOptionsTabPage::Create,0);
	AddTabPage(TP_OPTINSERT_PAGE,	&SwInsertOptPage::Create,0);
#ifndef PRODUCT
	AddTabPage(TP_OPTTEST_PAGE,&SwTestTabPage::Create,0);
#endif
	AddTabPage(TP_BACKGROUND,		&SvxBackgroundTabPage::Create, 	0);
	AddTabPage(TP_OPTSRCVIEW,		&SwSourceViewOptionsTabPage::Create, 0);
}

/*-----------------31.08.96 15.04-------------------

--------------------------------------------------*/


SwBrowserOptionsDialog::~SwBrowserOptionsDialog()
{
}

/*-----------------01.02.97 11.15-------------------

--------------------------------------------------*/

void __EXPORT SwBrowserOptionsDialog::PageCreated(USHORT nPageId, SfxTabPage& rPage)
{
	switch ( nPageId )
	{
		case RID_SVXPAGE_GRID:
			((SvxGridTabPage&)rPage).HideSnapGrid();
		break;
		case TP_OPTPRINT_PAGE:
		{
			SvStringsDtor aFaxList;
			const USHORT nCount = Printer::GetQueueCount();
			for (USHORT i = 0; i < nCount; ++i)
			{
				String* pString = new String( Printer::GetQueueInfo( i ).
												GetPrinterName() );
				String* &rpString = pString;
				aFaxList.Insert(rpString, 0);
			}
			(( SwAddPrinterTabPage& )rPage).SetFax( aFaxList );

			const String aFax = pPathFinder->GetFaxName();
			if (aFax.Len())
			{
				(( SwAddPrinterTabPage& )rPage).SelectFax( aFax );
			}
		}
		break;
	}

}

/*--------------------------------------------------------------------

	  $Log: optdlg.cxx,v $
	  Revision 1.2  2000/10/06 13:32:22  jp
	  should changes: don't use IniManager
	
	  Revision 1.1.1.1  2000/09/18 17:14:33  hr
	  initial import
	
	  Revision 1.178  2000/09/18 16:05:15  willem.vandorp
	  OpenOffice header added.
	
	  Revision 1.177  2000/09/07 08:26:49  os
	  FaxName now in SwPrintOptions
	
	  Revision 1.176  2000/07/03 08:53:09  jp
	  must changes for VCL
	
	  Revision 1.175  2000/02/11 14:43:55  hr
	  #70473# changes for unicode ( patched by automated patchtool )

	  Revision 1.174  1999/02/17 07:38:16  OS
	  #58158# Einfuegen TabPage auch in HTML-Docs


	  Rev 1.173   17 Feb 1999 08:38:16   OS
   #58158# Einfuegen TabPage auch in HTML-Docs

	  Rev 1.172   20 Nov 1998 17:04:56   OM
   #58216# Aktualisieren von Verknpfungen

	  Rev 1.171   11 Nov 1998 16:47:24   OM
   #58158# Einfuegeoptionen fuer Tabellen

	  Rev 1.170   27 Oct 1998 13:29:44   OM
   #58158# Einfuegeoptionen-TP

	  Rev 1.169   18 Feb 1998 09:10:00   OM
   Redlining-Optionen

	  Rev 1.168   28 Nov 1997 15:07:26   MA
   includes

	  Rev 1.167   24 Nov 1997 17:58:50   MA
   include

	  Rev 1.166   03 Nov 1997 16:12:18   JP
   neu: Optionen/-Page/Basic-Schnittst. fuer ShadowCursor

	  Rev 1.165   09 Sep 1997 11:38:52   OS
   includes

	  Rev 1.164   01 Sep 1997 13:16:58   OS
   DLL-Umstellung

	  Rev 1.163   11 Jun 1997 09:17:20   OS
   Def-Page-Item fuer den Optionsdialog wieder auswerten #40584#

	  Rev 1.162   21 Apr 1997 13:47:18   OS
   Segmentierung raus

	  Rev 1.161   21 Apr 1997 11:01:44   OS
   Quelltextkonfiguration

	  Rev 1.160   20 Feb 1997 11:52:08   OS
   Faxliste wieder fuellen

	  Rev 1.159   03 Feb 1997 12:11:08   OS
   kompletter Einstellungesdialog fuer HTML-Dok

	  Rev 1.158   30 Jan 1997 19:37:08   HJS
   includes

	  Rev 1.157   30 Jan 1997 11:08:24   OS
   UsrPrefs verdoppelt

	  Rev 1.156   18 Jan 1997 15:12:28   OS
   Dialog Tabellenoptionen

	  Rev 1.155   11 Dec 1996 14:10:34   OS
   Optionenumbau - Reste

	  Rev 1.154   10 Dec 1996 16:59:24   OS
   Color- und LinguTabPage nur noch in der OFA

	  Rev 1.153   04 Dec 1996 14:57:12   OS
   Umbau Optionsdialoge

	  Rev 1.152   11 Nov 1996 09:22:10   MA
   ResMgr

	  Rev 1.151   04 Nov 1996 13:37:08   OS
   ohne DocShell immer die App-ColotTable setzen

	  Rev 1.150   23 Oct 1996 13:49:12   JP
   SVMEM -> SVSTDARR Umstellung

	  Rev 1.149   22 Oct 1996 07:30:30   OS
   ColorTable gfs. aus der DocShell holen

	  Rev 1.148   11 Sep 1996 07:53:46   OS
   Raster-Tabpage am richtigen Dialog removen

	  Rev 1.147   07 Sep 1996 13:52:00   OS
   Hintergrundpage auch ohne BrowseView

	  Rev 1.146   03 Sep 1996 16:56:26   OS
   Tabpage Standardfonts

	  Rev 1.145   03 Sep 1996 10:16:28   OS
   neu: Html-Optionen

	  Rev 1.144   31 Aug 1996 17:13:58   OS
   neue Optionendialoge

	  Rev 1.143   29 Aug 1996 19:04:00   OS
   includes gerichtet

	  Rev 1.142   27 Aug 1996 11:51:38   OS
   Pages Ansicht und Raster sowie online-Rechtschreibung nur noch mit SwView

	  Rev 1.141   26 Aug 1996 16:56:08   OS
   neu: Brush fuer BrowseView

	  Rev 1.140   13 Aug 1996 16:14:10   OS
   Optionendialog ohne Mail und Internet

	  Rev 1.139   16 Jul 1996 20:19:52   MA
   includes

	  Rev 1.138   28 Jun 1996 16:32:54   HJS
   includes

	  Rev 1.137   09 May 1996 09:45:22   OS
   neu: MailTabPage

	  Rev 1.136   30 Apr 1996 13:59:10   OS
   OnlineSpelling in Preview ausblenden

	  Rev 1.135   30 Apr 1996 13:44:20   OS
   DocDisplay-Page nicht mehr on demand; ViewOptions mit MakeUsrPref erzeugen

 --------------------------------------------------------------------*/


