/*************************************************************************
 *
 *  $RCSfile: swstbctl.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "hintids.hxx"

#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif

#include "errhdl.hxx"
#include "wrtsh.hxx"
#include "cmdid.h"
#include "swstbctl.hxx"

#define C2S(cChar) UniString::CreateFromAscii(cChar)

// STATIC DATA -----------------------------------------------------------

SFX_IMPL_STATUSBAR_CONTROL(SwHyperlinkControl, SfxBoolItem);

// class SwHyperlinkControl ------------------------------------------------

SwHyperlinkControl::SwHyperlinkControl( USHORT nId,
									StatusBar& rStb, SfxBindings& rBind ) :

	SfxStatusBarControl( nId, rStb, rBind ),
	bState( TRUE )
{
}

// -----------------------------------------------------------------------

void SwHyperlinkControl::StateChanged( USHORT nSID, SfxItemState eState,
									 const SfxPoolItem* pState )
{
	if ( SFX_ITEM_AVAILABLE != eState )
		GetStatusBar().SetItemText( GetId(), aEmptyStr );
	else
	{
		DBG_ASSERT( pState->ISA( SfxBoolItem ), "invalid item type" );
		SfxBoolItem* pItem = (SfxBoolItem*)pState;
		bState = pItem->GetValue();
		DrawItemText_Impl();
	}
}

// -----------------------------------------------------------------------

void SwHyperlinkControl::Paint( const UserDrawEvent& rUsrEvt )
{
	DrawItemText_Impl();
}

// -----------------------------------------------------------------------


void SwHyperlinkControl::DrawItemText_Impl()
{
	String sMode(C2S("SEL"));
	if ( bState )
		sMode = C2S("HYP");
	GetStatusBar().SetItemText( GetId(), sMode );
}

// -----------------------------------------------------------------------


void SwHyperlinkControl::Click()
{
	SfxBoolItem aState( GetId(), !bState );
	SfxViewFrame::Current()->GetDispatcher()->Execute( GetId(), SFX_CALLMODE_RECORD, &aState, 0L );
}

/*************************************************************************

	  $Log: swstbctl.cxx,v $
	  Revision 1.1.1.1  2000/09/18 17:14:50  hr
	  initial import
	
	  Revision 1.14  2000/09/18 16:06:19  willem.vandorp
	  OpenOffice header added.
	
	  Revision 1.13  2000/09/07 15:59:35  os
	  change: SFX_DISPATCHER/SFX_BINDINGS removed
	
	  Revision 1.12  2000/04/18 15:14:09  os
	  UNICODE

	  Revision 1.11  2000/02/11 15:01:03  hr
	  #70473# changes for unicode ( patched by automated patchtool )

	  Revision 1.10  1999/11/11 14:42:56  tl
	  #include 's rearranged

	  Revision 1.9  1997/11/21 11:10:14  MA
	  includes


	  Rev 1.8   21 Nov 1997 12:10:14   MA
   includes

	  Rev 1.7   03 Nov 1997 13:59:24   MA
   precomp entfernt

	  Rev 1.6   01 Sep 1997 13:11:42   OS
   DLL-Umstellung

	  Rev 1.5   08 Aug 1997 17:25:28   OM
   Headerfile-Umstellung

	  Rev 1.4   11 Jul 1997 09:16:20   OS
   kein Hyperlink ausfuehren -> SEL

	  Rev 1.3   14 Nov 1996 15:48:24   TRI
   includes

	  Rev 1.2   02 Sep 1996 17:28:04   JP
   fehlende SEXPORTs zugefuegt

	  Rev 1.1   28 Aug 1996 15:42:42   OS
   includes

	  Rev 1.0   24 Jul 1996 13:39:32   OS
   Initial revision.


*************************************************************************/


