/*************************************************************************
 *
 *  $RCSfile: wizaggo.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: os $ $Date: 2001/09/28 07:21:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif


#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif
#ifndef _WIZGO_HXX
#include <wizgo.hxx>
#endif
#ifndef _WIZAG_HXX
#include <wizag.hxx>
#endif


////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef WINDOCHFILM
#define WIZNOFILM
#endif
#ifndef WINDOCHUNDO
#define WIZNOUNDO
#endif
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL AgenDialog::MakeDoc()
{
	aList.GetArray().Trim();
	BOOL bRet=FALSE;
	String aVorNam;
	if (p1_RBtn_Stil2->IsChecked())
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizagn2" ));
	else if (p1_RBtn_Stil3->IsChecked())
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizagn3"));
	else
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizagn1"));

	if (NewVorlage(aVorNam))
	{
#ifdef WIZNOFILM
		pShell->StartAction();
#endif
#ifdef WIZNOUNDO
		pShell->DoUndo(FALSE); // hat leider noch Seiteneffekte
#endif
		// JP 14.02.97: Bug 36143 - Autoformatierung der Tabelle abschalten
		BOOL bOldUpdateCells = pShell->IsAutoUpdateCells();
		pShell->SetAutoUpdateCells( FALSE );
		//JP 19.02.99: Cursor in Readonly NIE zulassen
		BOOL bCrsrInReadOnly = pShell->IsReadOnlyAvailable();
		pShell->SetReadOnlyAvailable( FALSE );

		SetMarg(aPage1,NULL,NULL);
		DelText();
		InsLogoAgen();
		InsTitl('A');
		InsDatm('A');
		InsElem('A');
		InsAgen();
		InsBmrk('A');
		if (p7_RBtn_PrtJaa->IsChecked())
		{
			InsLogoProt();
			InsTitl('P');
			InsDatm('P');
			InsElem('P');
			InsProt();
			SetMarg(aPage1,NULL,NULL);
			InsBmrk('P');
			GotoBookmark("Umbr"); // damit der Marker verschwindet
		}
		else
			DeleteProtocoll();
// JP 19.02.99: den Text gibt es in der Agenda nicht!
//        MarkText();
		CreateMacro();
		SaveMacro();
		FillDocInfo(*pDoku);

		pShell->SetAutoUpdateCells( bOldUpdateCells );
		pShell->SetReadOnlyAvailable( bCrsrInReadOnly );

#ifdef WIZNOFILM
		pShell->EndAction();
#endif
		if (SaveVorNewDoc(*pDoku)) bRet=TRUE;
	}
	return bRet;
}

void AgenDialog::CreateMacro()
{
	SetCreateMacro( *pDoku );
}

void AgenDialog::SaveMacro()
{
	 SetSaveMacro( *pDoku );
}

void AgenDialog::InsLogoAgen()
{
	if( GotoBookmark("Grf",'A'))
	{
		if( aPage1.aLogo.IsVisible() )
		{
			MovFrame(aPage1.aLogo);
			InsLogoObj(aPage1.aLogo);
		}
		else
			DelFrame();
	}
}

void AgenDialog::InsLogoProt()
{
	BOOL bGotoBookmrk = TRUE;
	if (aPage1.aLogo.IsVisible())
	{
		if (GotoBookmark("Grf",'P'))
		{
			MovFrame(aPage1.aLogo);
			if( aPage1.aLogo.HasGraphic() )
			{
				DelFrame();
				bGotoBookmrk = FALSE;
				if( GotoBookmark( "PDum" ) )  // PDum, damit ich auf der richtigen Seite bin !
					InsLogoObj( aPage1.aLogo );
			}
		}
	}
	else if (GotoBookmark("Grf",'P'))
		DelFrame();

	if( bGotoBookmrk )
		GotoBookmark("PDum");	// Nicht loeschen! (Bug #47692)
}

void AgenDialog::InsTitl(char cAdd)
{
	if (GotoBookmark("Tit",cAdd))
	{
		if (aPage1.aTitl.IsVisible())
		{
			MovFrame(aPage1.aTitl);
			InsLogoObj(aPage1.aTitl);
			if (cAdd=='A') InsDocInfBookmark(0);
		}
		else
			DelFrame();
	}
}

void AgenDialog::InsDatm(char cAdd)
{
	if (aPage1.aDatm.IsVisible()) {
		if (GotoBookmark("Dat",cAdd))
		{
			MovFrame(aPage1.aDatm);
			if( !pShell->IsEndPara() )
				pShell->MovePara( fnParaCurr, fnParaEnd );

			InsString( p2_DFld_MetDat->GetField()->GetText() );

			if (cAdd=='A') InsDocInfBookmark(1);
		}
		if (GotoBookmark("Tim",cAdd))
		{
			if( !pShell->IsEndPara() )
				pShell->MovePara( fnParaCurr, fnParaEnd );

			String aStr;
			GetTimeRange(aStr);
			InsString(aStr);
			if (cAdd=='A') InsDocInfBookmark(2);
		}
		if (GotoBookmark("Ort",cAdd))
		{
			if( !pShell->IsEndPara() )
				pShell->MovePara( fnParaCurr, fnParaEnd );
			InsString(p2_Edit_MetOrt->GetText());
			if (cAdd=='A') InsDocInfBookmark(3);
		}
	} else {
		if (GotoBookmark("Dat",cAdd)) {
			DelFrame();
		}
	}
}

void AgenDialog::InsElem(char cAdd)
{
	if (aPage1.aElem.IsVisible()) {
		if (GotoBookmark("Ein",cAdd)) { if (!p3_CBox_Einber->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark( 8);
		if (GotoBookmark("Anl",cAdd)) { if (!p2_CBox_Anlass->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark( 4);
		if (GotoBookmark("Lei",cAdd)) { if (!p3_CBox_Leitng->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark( 9);
		if (GotoBookmark("Tei",cAdd)) { if (!p3_CBox_Teilnm->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark(11);
		if (GotoBookmark("Vor",cAdd)) { if (!p2_CBox_Vorber->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark( 6);
		if (GotoBookmark("Mit",cAdd)) { if (!p2_CBox_Mitbrn->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark( 5);
		if (GotoBookmark("Pro",cAdd)) { if (!p3_CBox_Protok->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark(10);
		if (GotoBookmark("Nac",cAdd)) { if (!p3_CBox_Nachbe->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark(14);
		MovFrame(aPage1.aElem);
	} else {
		if (GotoBookmark("Ein",cAdd)) {
			DelFrame();
		}
	}
}

void AgenDialog::InsBmrk(char cAdd)
{
	if (GotoBookmark("Gst",cAdd)) { if (!p3_CBox_Gaeste->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark(12);
	if (GotoBookmark("Fch",cAdd)) { if (!p3_CBox_Fachlt->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark(13);
	if (GotoBookmark("Rem",cAdd)) { if (!p2_CBox_Anmerk->IsChecked()) pShell->DelFullPara(); } else if (cAdd=='A') InsDocInfBookmark( 7);
}

void AgenDialog::GetTimeRange(String& rStr, USHORT nNum)
{
	Time aTime;
	long nBeg = 0, nEnd = 0;
	AgendaArray& rArr = aList.GetArray();
	USHORT nAnz=rArr.GetAnz();
	if( nNum >= nAnz )
	{
		AgendaRec aRec;
		for (USHORT i=0; i<nAnz; i++)
		{
			rArr.GetRec( i, aRec );
			nEnd += aRec.nZeit;
		}
	}
	else
	{
		AgendaRec aRec;
		for (USHORT i=0; i<nNum; i++)
		{
			rArr.GetRec(i,aRec);
			nBeg += aRec.nZeit;
		}
		rArr.GetRec( nNum, aRec );
		nEnd= nBeg + aRec.nZeit;
	}

	Time aTimeB(p2_TFld_MetTim->GetTime());
	Time aTimeE(aTimeB);

	aTimeB+=Time(0,nBeg);
	aTimeE+=Time(0,nEnd);

	if( aTimeB.GetHour() >= 24 ) aTimeB.SetHour( aTimeB.GetHour() % 24 );
	if( aTimeE.GetHour() >= 24 ) aTimeE.SetHour( aTimeE.GetHour() % 24 );

	BOOL bSecond = TIMEF_NONE != p2_TFld_MetTim->GetFormat();

	LocaleDataWrapper& rLclData = GetAppLocaleData();
	rStr = rLclData.getTime( aTimeB, bSecond, FALSE );
	rStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " - " ));
	rStr += rLclData.getTime( aTimeE, bSecond, FALSE );
}

void AgenDialog::InsAgen()
{
	AgendaArray& rArr = aList.GetArray();
	USHORT nAnz = rArr.GetAnz();
	if( nAnz && GotoBookmark( "Pkt", 'A' ) )
	{
		pShell->InsertRow( nAnz-1, TRUE );
		for( USHORT i = 0; i < nAnz; ++i )
		{
			AgendaRec aRec;
			rArr.GetRec( i, aRec );
			String aStr( String::CreateFromInt32( i + 1 ) );
			aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM(". "));
			InsString( aStr );
			pShell->GoNextCell();
			InsString( aRec.aThem );
			pShell->GoNextCell();
			InsString( aRec.aName );
			pShell->GoNextCell();
			GetTimeRange( aStr, i );
			InsString( aStr );
			if( i != nAnz-1 )
				pShell->GoNextCell();
		}
	}
}

void AgenDialog::InsProt()
{
	if( GotoBookmark( "Thm", 'P' ) )
	{
		AgendaArray& rArr = aList.GetArray();
		USHORT nAnz = rArr.GetAnz();
		String aStr;

		if( !pShell->IsSttPara() )
			pShell->MovePara( fnParaCurr, fnParaStart );
		pShell->Left( FALSE, 1, TRUE );

		if( !pShell->IsEndPara() )
			pShell->MovePara( fnParaCurr, fnParaEnd );
		pShell->Right( TRUE, 1, TRUE );

		SwDocFac aDocFac;
		SwDoc* pTmpDoc = aDocFac.GetDoc();
		pShell->Copy( pTmpDoc );
		pShell->DelRight();

		for( USHORT i = nAnz; i; )
		{
			AgendaRec aRec;
			rArr.GetRec( --i, aRec );
			pShell->Paste( pTmpDoc );		// Tabelle einfuegen

			// in die erste Zelle der gerade eingefuegten Tabelle
			pShell->MoveTable( fnTablePrev, fnTableStart );

			InsString( aRec.aThem );
			pShell->GoNextCell();
			InsString( aRec.aName );
			pShell->GoNextCell();
			GetTimeRange( aStr, i );
			InsString( aStr );
			pShell->MoveTable( fnTableCurr, fnTableStart );
			pShell->Left( FALSE, 1, TRUE );
		}
	}
}

void AgenDialog::DeleteProtocoll()
{
	if (GotoBookmark("Grf",'P')) DelFrame();
	if (GotoBookmark("Tit",'P')) DelFrame();
	if (GotoBookmark("Dat",'P')) DelFrame();
	if (GotoBookmark("Ein",'P')) DelFrame();
	if (GotoBookmark("Umbr"))
	{
		pShell->SttSelect();
		pShell->EndDoc( TRUE );
		pShell->EndSelect();
		pShell->DelRight();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

void AgenDialog::InsDocInfBookmark(USHORT nElemNum)
{
	if (GetDocInfStrOk(nElemNum)) {   // als DocInf freigegeben ?
		USHORT nIdx=nElemNum;      // nIdx geht von 0..aDoku.GetTxFieldAnz()-1
		USHORT i;
		for (i=0; i<nElemNum; i++) // fuer jeden nicht freigeg. davor, Idx um 1 dec.
			if (!GetDocInfStrOk(i)) nIdx--;
		nIdx+=pDoku->GetTxFieldOfs();
		if (nIdx==pDoku->pD_List_InfTit->GetSelectEntryPos()) {
			if( !pShell->IsSttPara() )
				pShell->MovePara( fnParaCurr, fnParaStart );

			InsertBookmark( "Titel" );
		}
		if (nIdx==pDoku->pD_List_InfTem->GetSelectEntryPos()) {
			if( !pShell->IsSttPara() )
				pShell->MovePara( fnParaCurr, fnParaStart );

			InsertBookmark( "Thema" );
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////


