/*************************************************************************
 *
 *  $RCSfile: wizdoku.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: os $ $Date: 2001/08/29 13:55:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXDOCTEMPL_HXX //autogen
#include <sfx2/doctempl.hxx>
#endif

#ifndef _HELPID_H
#include <helpid.h>
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
#ifndef _WIZMULTI_HXX
#include <wizmulti.hxx>
#endif
#ifndef _WIZARD_HRC
#include <wizard.hrc>
#endif
#ifndef _WIZDOKU_HXX
#include <wizdoku.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <sfx2/filedlghelper.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star;
using namespace ::rtl;
#define C2U(cChar) rtl::OUString::createFromAscii(cChar)

/* -----------------------------23.03.00 15:10--------------------------------

 ---------------------------------------------------------------------------*/
String lcl_CheckForItemIDPath(const String& rPath)
{
	String sRet(rPath);
	sal_Unicode cDelim = SVT_SEARCHPATH_DELIMITER;
	if(sRet.GetTokenCount(cDelim) > 1)
		sRet = sRet.GetToken(0, cDelim);
	return sRet;
}

// ---------------------------------------------------------------------------

WizardDokuDlg::WizardDokuDlg( SwWizardDialog* pDlgWin )
{
	pD_Text_SavOpt=new FixedText (pDlgWin,SW_RES(DLG_Dok_Text_SavOpt));
	pD_Text_InfTit=new FixedText (pDlgWin,SW_RES(DLG_Dok_Text_InfTit));
	pD_List_InfTit=new ListBox   (pDlgWin,SW_RES(DLG_Dok_List_InfTit));
	pD_Text_InfTem=new FixedText (pDlgWin,SW_RES(DLG_Dok_Text_InfTem));
	pD_List_InfTem=new ListBox   (pDlgWin,SW_RES(DLG_Dok_List_InfTem));
    pD_FL_DokInf=new FixedLine   (pDlgWin,SW_RES(DLG_Dok_FL_DokInf));
	pD_CBox_AutoFN=new CheckBox  (pDlgWin,SW_RES(DLG_Dok_CBox_AutoFN));
	pD_Text_AutoFN=new FixedText (pDlgWin,SW_RES(DLG_Dok_Text_AutoFN));
	pD_Edit_AutoFN=new Edit      (pDlgWin,SW_RES(DLG_Dok_Edit_AutoFN));
	pD_PBtn_Folder=new PushButton(pDlgWin,SW_RES(DLG_Dok_PBtn_Folder));
	pD_Text_Folder=new FixedText (pDlgWin,SW_RES(DLG_Dok_Text_Folder));
    pD_FL_DokSav=new FixedLine (pDlgWin,SW_RES(DLG_Dok_FL_DokSav));
	pD_Text_VorNam=new FixedText(pDlgWin,SW_RES(DLG_Dok_Text_VorNam));
	pD_Edit_VorNam=new Edit     (pDlgWin,SW_RES(DLG_Dok_Edit_VorNam));
	pD_Text_VorInf=new FixedText(pDlgWin,SW_RES(DLG_Dok_Text_VorInf));
	pD_Edit_VorInf=new Edit     (pDlgWin,SW_RES(DLG_Dok_Edit_VorInf));
    pD_FL_VorSav=new FixedLine (pDlgWin,SW_RES(DLG_Dok_FL_VorSav));
	pWizDlg = pDlgWin;
	nDBFieldAnz = 0;
	pOkayBtn = NULL;
	SetEventHandler();
	InitUI();
}

WizardDokuDlg::~WizardDokuDlg()
{
	delete pD_Text_SavOpt;
	delete pD_Text_InfTit;
	delete pD_List_InfTit;
	delete pD_Text_InfTem;
	delete pD_List_InfTem;
    delete pD_FL_DokInf;
	delete pD_CBox_AutoFN;
	delete pD_Text_AutoFN;
	delete pD_Edit_AutoFN;
	delete pD_PBtn_Folder;
	delete pD_Text_Folder;
    delete pD_FL_DokSav;
	delete pD_Text_VorNam;
	delete pD_Edit_VorNam;
	delete pD_Text_VorInf;
	delete pD_Edit_VorInf;
    delete pD_FL_VorSav;
}

void WizardDokuDlg::Fill(MultiOne& WinArr)
{
	WinArr.AddWin(pD_Text_SavOpt);
	WinArr.AddWin(pD_Text_InfTit);
	WinArr.AddWin(pD_List_InfTit, TRUE);
	WinArr.AddWin(pD_Text_InfTem);
	WinArr.AddWin(pD_List_InfTem, TRUE);
    WinArr.AddWin(pD_FL_DokInf,FALSE, TRUE);
	WinArr.AddWin(pD_CBox_AutoFN, TRUE);
	WinArr.AddWin(pD_Text_AutoFN);
	WinArr.AddWin(pD_Edit_AutoFN, TRUE);
	WinArr.AddWin(pD_PBtn_Folder, TRUE);
	WinArr.AddWin(pD_Text_Folder);
    WinArr.AddWin(pD_FL_DokSav,FALSE,TRUE);
	WinArr.AddWin(pD_Text_VorNam);
	WinArr.AddWin(pD_Edit_VorNam, TRUE);
	WinArr.AddWin(pD_Text_VorInf);
	WinArr.AddWin(pD_Edit_VorInf, TRUE);
    WinArr.AddWin(pD_FL_VorSav,FALSE,TRUE);
}

void WizardDokuDlg::SetPtr(PushButton* pBtn)
{
	pOkayBtn=pBtn;
	pOkayBtn->SetClickHdl(LINK(this,WizardDokuDlg,OkClckHdl));
	SetOkayDisable();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

void WizardDokuDlg::SetDocInfListEntryOne(USHORT nNum, const String& aNam, ListBox& rLst)
{
	USHORT nAnz=rLst.GetEntryCount();
	if (nNum>=nAnz)
	{
		USHORT nFehl=nNum+1-nAnz;
		for (USHORT i=1; i<nFehl; ++i )
			rLst.InsertEntry(aEmptyStr);
	}
	rLst.RemoveEntry(nNum);
	rLst.InsertEntry(aNam,nNum);
}

void WizardDokuDlg::SetDocInfListEntry(USHORT nNum, const String& aNam)
{
	String sEntry(aNam);
	USHORT nCount = sEntry.GetTokenCount('.');
	if (nCount)	// Nur Spaltenname anzeigen. Da Punkte in DB-Namen moeglich
	{			// sind, letztes Token suchen
		sEntry = sEntry.GetToken(nCount - 1, '.');
	}

	SetDocInfListEntryOne(nNum, sEntry, *pD_List_InfTit);
	SetDocInfListEntryOne(nNum, sEntry, *pD_List_InfTem);
}

void WizardDokuDlg::SetDBFieldAnz(USHORT nAnz)
{
	USHORT nAnz0=GetTxFieldAnz();
	if (nAnz<nAnz0)
	{
		for (USHORT i=0; i<USHORT(nAnz0-nAnz); i++)
		{
			pD_List_InfTit->RemoveEntry(1+nAnz);
			pD_List_InfTem->RemoveEntry(1+nAnz);
		}
	}
	if (nAnz>nDBFieldAnz)
	{
		for (USHORT i=0; i<USHORT(nAnz-nAnz0); i++)
		{
			pD_List_InfTit->InsertEntry(aEmptyStr,1+nAnz0);
			pD_List_InfTem->InsertEntry(aEmptyStr,1+nAnz0);
		}
	}
	nDBFieldAnz=nAnz;
}

void WizardDokuDlg::SetTxFieldAnz(USHORT nAnz)
{
	USHORT nAnz0=GetTxFieldAnz();
	if (nAnz<nAnz0)
	{
		for (USHORT i=0; i<USHORT(nAnz0-nAnz); i++)
		{
			pD_List_InfTit->RemoveEntry(1+nDBFieldAnz+nAnz);
			pD_List_InfTem->RemoveEntry(1+nDBFieldAnz+nAnz);
		}
	}
}

void WizardDokuDlg::SetDBFieldNam(USHORT nNum, const String& aNam)
{
	SetDocInfListEntry(1+nNum,aNam);
}

void WizardDokuDlg::SetTxFieldNam(USHORT nNum, const String& aNam)
{
	SetDocInfListEntry(1+nDBFieldAnz+nNum,aNam);
}

void WizardDokuDlg::MerkDocInfListSel()
{
	aMerk1=pD_List_InfTit->GetSelectEntry();
	aMerk2=pD_List_InfTem->GetSelectEntry();
}

void WizardDokuDlg::RestDocInfListSel()
{
	pD_List_InfTit->SelectEntry(aMerk1);
	pD_List_InfTem->SelectEntry(aMerk2);
	SetDocInfDisable();
}

void WizardDokuDlg::SetDocInfDisable()
{
	if (pD_List_InfTit->GetSelectEntryCount()==0)
		pD_List_InfTit->SelectEntryPos(0);
	if (pD_List_InfTem->GetSelectEntryCount()==0)
		pD_List_InfTem->SelectEntryPos(0);

	const BOOL bEnable = pD_List_InfTit->GetEntryCount() > 1;
	pD_Text_InfTit->Enable(bEnable);
	pD_List_InfTit->Enable(bEnable);
	pD_Text_InfTem->Enable(bEnable);
	pD_List_InfTem->Enable(bEnable);
    pD_FL_DokInf->Enable(bEnable);
}

BOOL WizardDokuDlg::IsDocInfoDBFeldSelected(USHORT nTyp) // 0=Titel 1=Thema
{
	BOOL bRet = FALSE;
	switch( nTyp )
	{
	case 0: bRet = IsDocInfoDBFeld(pD_List_InfTit->GetSelectEntryPos()); break;
	case 1: bRet = IsDocInfoDBFeld(pD_List_InfTem->GetSelectEntryPos()); break;
	}
	return bRet;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

void WizardDokuDlg::InitUI()
{
	pD_List_InfTit->SelectEntryPos(0);
	pD_List_InfTem->SelectEntryPos(0);

	SvtPathOptions aPathOpt;
	String sWorkPath( aPathOpt.GetWorkPath() );
	sWorkPath = lcl_CheckForItemIDPath( sWorkPath );
	pD_Text_Folder->SetText( sWorkPath );

	SetDisable();
}

void WizardDokuDlg::ToUI()
{
	SetDisable();
}

void WizardDokuDlg::SetDisable()
{
	SetDocInfDisable();
	SetAutoFNDisable();
}

void WizardDokuDlg::SetAutoFNDisable()
{
	const BOOL bEnable = pD_CBox_AutoFN->IsChecked();
	pD_Text_AutoFN->Enable(bEnable);
	pD_Edit_AutoFN->Enable(bEnable);
	pD_PBtn_Folder->Enable(bEnable);
	pD_Text_Folder->Enable(bEnable);
}

void WizardDokuDlg::SetEventHandler()
{
	pD_CBox_AutoFN->SetClickHdl (LINK(this,WizardDokuDlg,ClckHdl));
	pD_PBtn_Folder->SetClickHdl (LINK(this,WizardDokuDlg,FldClckHdl));
	pD_Edit_VorNam->SetModifyHdl(LINK(this,WizardDokuDlg,ModifyHdl));
}

IMPL_LINK_INLINE_START( WizardDokuDlg, ClckHdl, CheckBox *, pBtn )
{
	SetDisable();
	return 0;
}
IMPL_LINK_INLINE_END( WizardDokuDlg, ClckHdl, CheckBox *, pBtn )

IMPL_LINK( WizardDokuDlg, FldClckHdl, PushButton *, pBtn )
{
	SvtPathOptions aPathOpt;
	String sPath( pD_Text_Folder->GetText() );
	sPath = lcl_CheckForItemIDPath(sPath);


    rtl::OUString aService( RTL_CONSTASCII_USTRINGPARAM( FOLDER_PICKER_SERVICE_NAME ) );
    Reference < XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
    Reference < XFolderPicker > xFolderPicker( xFactory->createInstance( aService ), UNO_QUERY );
    INetURLObject aURL( sPath, INET_PROT_FILE );
    xFolderPicker->setDisplayDirectory( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
    short nRet = xFolderPicker->execute();

    if ( ExecutableDialogResults::OK != nRet )
        return 0;

    // old path is an URL?
    INetURLObject aObj( sPath );
    FASTBOOL bURL = ( aObj.GetProtocol() != INET_PROT_NOT_VALID );
    String aPathStr = xFolderPicker->getDirectory();

    // then the new path also an URL else system path
    pD_Text_Folder->SetText(aPathStr);
	return 0;
}

void WizardDokuDlg::SetOkayDisable()
{
	if (pOkayBtn!=NULL)
		pOkayBtn->Enable(pD_Edit_VorNam->GetText().Len()!=0);
}

IMPL_LINK_INLINE_START( WizardDokuDlg, ModifyHdl, Edit *, pEdt )
{
	SetOkayDisable();
	return 0;
}
IMPL_LINK_INLINE_END( WizardDokuDlg, ModifyHdl, Edit *, pEdt )

IMPL_LINK( WizardDokuDlg, OkClckHdl, PushButton *, pBtn )
{
	String aVorFN( pD_Edit_VorNam->GetText() );

	if( aVorFN.Len() )
	{
		SfxDocumentTemplates aFac;
		aFac.Construct();

		String aStr1( aVorFN );
		aStr1.ToUpperAscii();
		USHORT nRegion = 0;			// ist das der Standard - Bereich ??
		USHORT nAnz = aFac.GetCount( nRegion );
		USHORT i;
		for( i = 0; i < nAnz; ++i )
		{
			String aStr2( aFac.GetName( nRegion, i ) );
			aStr2.ToUpperAscii();
			if( aStr1 == aStr2 )
			{
				aStr1 = aVorFN;
				aStr1 += '\n';
				aStr1 += SW_RESSTR( STR_Dok_Overwrite1 );
				aStr1 += '\n';
				aStr1 += SW_RESSTR( STR_Dok_Overwrite2 );
				QueryBox aQuery( 0, WinBits( WB_YES_NO | WB_DEF_NO ), aStr1 );

				if( RET_YES == aQuery.Execute() )
					pWizDlg->EndDialog( TRUE );
				else
				{
					USHORT nStepNum;
					if( pWizDlg->FindWin( pD_Edit_VorNam, nStepNum ) )
					{
						pWizDlg->Switch( nStepNum );
						pD_Edit_VorNam->GrabFocus();
					}
				}
				break;
			}
		}
		if( i >= nAnz )			// nicht gefunden -> und schluss
			pWizDlg->EndDialog( TRUE );
	}
	else
	{
		Sound::Beep(SOUND_ERROR);
		InfoBox( NULL, SW_RESSTR( STR_Dok_NoVorNam ) ).Execute();
		USHORT nStepNum;
		if( pWizDlg->FindWin( pD_Edit_VorNam, nStepNum ) )
		{
			pWizDlg->Switch( nStepNum );
			pD_Edit_VorNam->GrabFocus();
		}
	}
	return 0;
}



